import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ClusterAudioSourceID: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterAudioSourceID;
    readonly ClusterAudioSourceLocalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterAudioSourceLocalConfiguration;
    readonly ClusterIPSourceConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterIPSourceConfiguration;
    readonly ClusterIPSourcesGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterIPSourcesGlobalConfiguration;
    readonly ClusterMetadataSourceCC: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterMetadataSourceCC;
    readonly ClusterMetadataSourceID: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterMetadataSourceID;
    readonly ClusterMetadataSourceLocalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterMetadataSourceLocalConfiguration;
    readonly ClusterSourceLabelDual: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterSourceLabelDual;
    readonly ClusterSourcesGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterSourcesGlobalConfiguration;
    readonly ClusterSourcesLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterSourcesLocalRuntime;
    readonly ClusterVideoSourceID: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterVideoSourceID;
    readonly ClusterVideoSourceIDInfo: (_raw: [number, number], _socket: VScript.VSocket) => ClusterVideoSourceIDInfo;
    readonly ClusterVideoSourceLocalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterVideoSourceLocalConfiguration;
    readonly ClusterVideoSourceRuntimeResolutionLevel: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel;
    readonly TimestampedTimecode: (_raw: [null | VScript.TimecodePayload, null | VScript.TimecodePayload, null | VScript.TimecodePayload], _socket: VScript.VSocket) => TimestampedTimecode;
};
export declare const lower: {
    readonly ClusterAudioSourceID: (_x: ClusterAudioSourceID) => string;
    readonly ClusterAudioSourceLocalConfiguration: (_x: ClusterAudioSourceLocalConfiguration) => string;
    readonly ClusterIPSourceConfiguration: (_x: ClusterIPSourceConfiguration) => string;
    readonly ClusterIPSourcesGlobalConfiguration: (_x: ClusterIPSourcesGlobalConfiguration) => string;
    readonly ClusterMetadataSourceCC: (_x: ClusterMetadataSourceCC) => string;
    readonly ClusterMetadataSourceID: (_x: ClusterMetadataSourceID) => string;
    readonly ClusterMetadataSourceLocalConfiguration: (_x: ClusterMetadataSourceLocalConfiguration) => string;
    readonly ClusterSourceLabelDual: (_x: ClusterSourceLabelDual) => string;
    readonly ClusterSourcesGlobalConfiguration: (_x: ClusterSourcesGlobalConfiguration) => string;
    readonly ClusterSourcesLocalRuntime: (_x: ClusterSourcesLocalRuntime) => string;
    readonly ClusterVideoSourceID: (_x: ClusterVideoSourceID) => string;
    readonly ClusterVideoSourceIDInfo: (_x: {
        source_id: VAPI.ClusterSources.VideoSourceID;
        rl_mask: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly ClusterVideoSourceLocalConfiguration: (_x: ClusterVideoSourceLocalConfiguration) => string;
    readonly ClusterVideoSourceRuntimeResolutionLevel: (_x: ClusterVideoSourceRuntimeResolutionLevel) => string;
    readonly TimestampedTimecode: (_x: {
        ltc: null | VScript.TimecodePayload;
        vtc1: null | VScript.TimecodePayload;
        vtc2: null | VScript.TimecodePayload;
    }, _socket: VScript.VSocket) => [null | VScript.TimecodePayload, null | VScript.TimecodePayload, null | VScript.TimecodePayload];
};
export type AudioSourceID = number;
export declare class ClusterAudioSourceID implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceID"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceID";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.AudioSourceID, VAPI.ClusterSources.ClusterAudioSourceID>;
}
export declare class ClusterAudioSourceLocalConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceLocalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceLocalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.AudioSourceID, VAPI.ClusterSources.AudioSourceID, VAPI.ClusterSources.ClusterAudioSourceLocalConfiguration>;
}
export declare class ClusterAudioSourceLocalConfigurationAsNamedTableRow extends ClusterAudioSourceLocalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterIPSourceConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterIPSourceConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterIPSourceConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdp(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.ClusterSources.ClusterIPSourceConfiguration>;
}
export declare class ClusterIPSourceConfigurationAsNamedTableRow extends ClusterIPSourceConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterIPSourcesGlobalConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterIPSourcesGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterIPSourcesGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterIPSourceConfiguration", VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow>;
    get audio(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterIPSourceConfiguration", VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow>;
    get metadata(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterIPSourceConfiguration", VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow>;
}
export declare class ClusterMetadataSourceCC implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceCC"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceCC";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get screen(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ClusterSources.ClusterMetadataSourceCC>;
}
export declare class ClusterMetadataSourceID implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceID"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceID";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.MetadataSourceID, VAPI.ClusterSources.ClusterMetadataSourceID>;
}
export declare class ClusterMetadataSourceLocalConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceLocalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceLocalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.MetadataSourceID, VAPI.ClusterSources.MetadataSourceID, VAPI.ClusterSources.ClusterMetadataSourceLocalConfiguration>;
}
export declare class ClusterMetadataSourceLocalConfigurationAsNamedTableRow extends ClusterMetadataSourceLocalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterSourceLabelDual implements VScript.Referenceable<"ClusterSources::Data::ClusterSourceLabelDual"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterSourceLabelDual";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get string_default(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.ClusterSources.ClusterSourceLabelDual>;
    get string_user(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.ClusterSources.ClusterSourceLabelDual>;
}
export declare class ClusterSourcesGlobalConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterSourcesGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterSourcesGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get ip(): VAPI.ClusterSources.ClusterIPSourcesGlobalConfiguration;
}
export declare class ClusterSourcesLocalRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterSourcesLocalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterSourcesLocalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceLocalConfiguration", VAPI.ClusterSources.ClusterVideoSourceLocalConfigurationAsNamedTableRow>;
    get audio(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterAudioSourceLocalConfiguration", VAPI.ClusterSources.ClusterAudioSourceLocalConfigurationAsNamedTableRow>;
    get metadata(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterMetadataSourceLocalConfiguration", VAPI.ClusterSources.ClusterMetadataSourceLocalConfigurationAsNamedTableRow>;
    get video_full_size(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceLocalConfiguration", VAPI.ClusterSources.ClusterVideoSourceLocalConfigurationAsNamedTableRow>;
}
export declare class ClusterVideoSourceID implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceID"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceID";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get info(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.ClusterSources.ClusterVideoSourceIDInfo, VAPI.ClusterSources.ClusterVideoSourceID>;
}
export interface ClusterVideoSourceIDInfo {
    source_id: VAPI.ClusterSources.VideoSourceID;
    rl_mask: number;
}
export declare class ClusterVideoSourceLocalConfiguration implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceLocalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceLocalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.VideoSourceID, VAPI.ClusterSources.VideoSourceID, VAPI.ClusterSources.ClusterVideoSourceLocalConfiguration>;
}
export declare class ClusterVideoSourceLocalConfigurationAsNamedTableRow extends ClusterVideoSourceLocalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterVideoSourceRuntimeResolutionLevel implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceRuntimeResolutionLevel"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceRuntimeResolutionLevel";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Destination IP address of the mipmap RTP stream
    */
    get dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
    /**
      Destination IP address of the mipmap RTP stream
    */
    get secondary_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
    get width(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
    get height(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
    get bytes_per_second(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
    get sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
}
export type MetadataSourceID = number;
export type Ports = "PORT_1" | "PORT_2" | "PORTS_ALL_SPS" | "PORTS_ALL";
export type SourceTransportFormat = "IP_2022" | "IP_2110" | "SDI" | "INTERNAL" | "EXTERNAL_MIPMAPS";
export type TUnsignedMax = number;
export interface TimestampedTimecode {
    ltc: null | VScript.TimecodePayload;
    vtc1: null | VScript.TimecodePayload;
    vtc2: null | VScript.TimecodePayload;
}
export type VideoSourceID = number;
export declare const Enums: {
    readonly SourceTransportFormat: SourceTransportFormat[];
    readonly Ports: Ports[];
};
