import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    Anchor: (_raw, _socket) => {
        return {
            t: VScript.VAPIHelpers.liftTimestamp(_raw[0], _socket),
            y: _raw[1],
            micro_epoch_index: _raw[2]
        };
    },
    GenlockPosition: (_raw, _socket) => {
        return {
            drift_from_frc: VAPI.Time.lift.TimestampedDrift(_raw[0], _socket),
            offset_from_ptp: VAPI.Time.lift.TimestampedOffset(_raw[1], _socket)
        };
    },
    SingleGenlockSettings: (_raw) => (new SingleGenlockSettings(_raw)),
};
export const lower = {
    Anchor: (_x, _socket) => [
        VScript.VAPIHelpers.lowerTimestamp(_x.t, _socket),
        _x.y,
        _x.micro_epoch_index
    ],
    GenlockPosition: (_x, _socket) => [
        VAPI.Time.lower.TimestampedDrift(_x.drift_from_frc, _socket),
        VAPI.Time.lower.TimestampedOffset(_x.offset_from_ptp, _socket)
    ],
    SingleGenlockSettings: (_x) => _x.raw.kwl,
};
export class SingleGenlockSettings {
    raw;
    type_identifier = "Genlock::Data::SingleGenlockSettings";
    constructor(raw) {
        this.raw = raw;
    }
    get servo() {
        return new VScript.dKeyword(this, "servo", {
            lift: VAPI.Servos.lift.Settings,
            lower: VAPI.Servos.lower.Settings
        }, {
            lift: VAPI.Servos.lift.Settings,
            lower: VAPI.Servos.lower.Settings
        }, null);
    }
    get decalibrate_on_input_change() {
        return new VScript.rwKeyword(this, "decalibrate_on_input_change", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    VideoClockLane: ["f50_ish", "f59_ish"],
    AudioClockLane: ["a48kHz", "a96kHz"]
};
