import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    Audio: (_raw) => (new Audio(_raw)),
    Video: (_raw) => (new Video(_raw)),
    VideoBlackDetect: (_raw) => (new VideoBlackDetect(_raw)),
    AudioLoudnessChannels: (_raw) => (new AudioLoudnessChannels(_raw)),
};
export const lower = {
    Audio: (_x) => _x.raw.kwl,
    Video: (_x) => _x.raw.kwl,
    VideoBlackDetect: (_x) => _x.raw.kwl,
    AudioLoudnessChannels: (_x) => _x.raw.kwl,
};
export class Audio {
    raw;
    type_identifier = "Monitoring::Data::Audio";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.dKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get silence_detect_duration() {
        return new VScript.dKeyword(this, "silence_detect_duration", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    get non_silence_detect_duration() {
        return new VScript.dKeyword(this, "non_silence_detect_duration", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    get detect_level() {
        return new VScript.dKeyword(this, "detect_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class Video {
    raw;
    type_identifier = "Monitoring::Data::Video";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.dKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get freeze_detect_duration() {
        return new VScript.dKeyword(this, "freeze_detect_duration", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    get black_detect() {
        return VAPI.Monitoring.lift.VideoBlackDetect(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "black_detect"));
    }
}
export class VideoBlackDetect {
    raw;
    type_identifier = "Monitoring::Data::Video::BlackDetect";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Luminance threshold for black detect
    */
    get threshold_y() {
        return new VScript.dKeyword(this, "threshold_y", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Chrominance threshold for black detect
    */
    get threshold_c() {
        return new VScript.dKeyword(this, "threshold_c", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      How many pixels can be above the threshold for black to be detected
    */
    get threshold_pixels() {
        return new VScript.dKeyword(this, "threshold_pixels", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      How long the video must be black before it is signaled as black
    */
    get attack() {
        return new VScript.dKeyword(this, "attack", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    /**
      How long the video must be none black before it is signaled as not black
    */
    get release() {
        return new VScript.dKeyword(this, "release", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
}
export class AudioLoudnessChannels {
    raw;
    type_identifier = "Monitoring::Data::AudioLoudness::Channels";
    constructor(raw) {
        this.raw = raw;
    }
    get left() {
        return new VScript.rwKeyword(this, "left", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get right() {
        return new VScript.rwKeyword(this, "right", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get center() {
        return new VScript.rwKeyword(this, "center", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get surround_left() {
        return new VScript.rwKeyword(this, "surround_left", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get surround_right() {
        return new VScript.rwKeyword(this, "surround_right", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rear_surround_left() {
        return new VScript.rwKeyword(this, "rear_surround_left", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rear_surround_right() {
        return new VScript.rwKeyword(this, "rear_surround_right", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    LoudnessMode: ["DISABLED", "MONO", "STEREO", "SURROUND_5_1", "SURROUND_7_1"]
};
