import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly CurrentBridgeConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentBridgeConfiguration;
    readonly CurrentPortConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentPortConfiguration;
    readonly CurrentSyslogConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentSyslogConfiguration;
    readonly CurrentSyslogServer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentSyslogServer;
    readonly CurrentVirtualEthernetConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentVirtualEthernetConfiguration;
    readonly CurrentVirtualInterfaceConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration;
    readonly DesiredBridgeConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredBridgeConfiguration;
    readonly DesiredPortConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredPortConfiguration;
    readonly DesiredSyslogConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredSyslogConfiguration;
    readonly DesiredSyslogServer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredSyslogServer;
    readonly DesiredVirtualEthernetConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration;
    readonly DesiredVirtualInterfaceConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration;
    readonly ErrorWindow: (_raw: [number, number], _socket: VScript.VSocket) => ErrorWindow;
    readonly EyeDiagram: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.EyeDiagram;
    readonly Health: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.Health;
    readonly HostnameConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.HostnameConfiguration;
    readonly LLDPNeighbor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.LLDPNeighbor;
    readonly VirtualInterface: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.VirtualInterface;
    readonly CurrentBridgeConfigurationDevices: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentBridgeConfigurationDevices;
    readonly DesiredBridgeConfigurationDevices: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredBridgeConfigurationDevices;
    readonly CurrentVirtualInterfaceConfigurationIpAddresses: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationIpAddresses;
    readonly DesiredVirtualInterfaceConfigurationIpAddresses: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationIpAddresses;
    readonly MaskedIpAddress: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.MaskedIpAddress;
    readonly CurrentVirtualInterfaceConfigurationRoutes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes;
    readonly DesiredVirtualInterfaceConfigurationRoutes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes;
    readonly CurrentVirtualEthernetConfigurationVeths: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentVirtualEthernetConfigurationVeths;
    readonly DesiredVirtualEthernetConfigurationVeths: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths;
    readonly CurrentPortConfigurationVlans: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.CurrentPortConfigurationVlans;
    readonly DesiredPortConfigurationVlans: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.NetworkInterfaces.DesiredPortConfigurationVlans;
};
export declare const lower: {
    readonly CurrentBridgeConfiguration: (_x: CurrentBridgeConfiguration) => string;
    readonly CurrentPortConfiguration: (_x: CurrentPortConfiguration) => string;
    readonly CurrentSyslogConfiguration: (_x: CurrentSyslogConfiguration) => string;
    readonly CurrentSyslogServer: (_x: CurrentSyslogServer) => string;
    readonly CurrentVirtualEthernetConfiguration: (_x: CurrentVirtualEthernetConfiguration) => string;
    readonly CurrentVirtualInterfaceConfiguration: (_x: CurrentVirtualInterfaceConfiguration) => string;
    readonly DesiredBridgeConfiguration: (_x: DesiredBridgeConfiguration) => string;
    readonly DesiredPortConfiguration: (_x: DesiredPortConfiguration) => string;
    readonly DesiredSyslogConfiguration: (_x: DesiredSyslogConfiguration) => string;
    readonly DesiredSyslogServer: (_x: DesiredSyslogServer) => string;
    readonly DesiredVirtualEthernetConfiguration: (_x: DesiredVirtualEthernetConfiguration) => string;
    readonly DesiredVirtualInterfaceConfiguration: (_x: DesiredVirtualInterfaceConfiguration) => string;
    readonly ErrorWindow: (_x: {
        /**
          Window size over which errors are checked
        */
        window: VScript.Duration;
        /**
          Number of errors in the window before the
          condition is met
        */
        threshold: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly EyeDiagram: (_x: EyeDiagram) => string;
    readonly Health: (_x: Health) => string;
    readonly HostnameConfiguration: (_x: HostnameConfiguration) => string;
    readonly LLDPNeighbor: (_x: LLDPNeighbor) => string;
    readonly VirtualInterface: (_x: VirtualInterface) => string;
    readonly CurrentBridgeConfigurationDevices: (_x: CurrentBridgeConfigurationDevices) => string;
    readonly DesiredBridgeConfigurationDevices: (_x: DesiredBridgeConfigurationDevices) => string;
    readonly CurrentVirtualInterfaceConfigurationIpAddresses: (_x: CurrentVirtualInterfaceConfigurationIpAddresses) => string;
    readonly DesiredVirtualInterfaceConfigurationIpAddresses: (_x: DesiredVirtualInterfaceConfigurationIpAddresses) => string;
    readonly MaskedIpAddress: (_x: MaskedIpAddress) => string;
    readonly CurrentVirtualInterfaceConfigurationRoutes: (_x: CurrentVirtualInterfaceConfigurationRoutes) => string;
    readonly DesiredVirtualInterfaceConfigurationRoutes: (_x: DesiredVirtualInterfaceConfigurationRoutes) => string;
    readonly CurrentVirtualEthernetConfigurationVeths: (_x: CurrentVirtualEthernetConfigurationVeths) => string;
    readonly DesiredVirtualEthernetConfigurationVeths: (_x: DesiredVirtualEthernetConfigurationVeths) => string;
    readonly CurrentPortConfigurationVlans: (_x: CurrentPortConfigurationVlans) => string;
    readonly DesiredPortConfigurationVlans: (_x: DesiredPortConfigurationVlans) => string;
};
export declare class CurrentBridgeConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentBridgeConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentBridgeConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.CurrentBridgeConfiguration>;
    get stp(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.NetworkInterfaces.CurrentBridgeConfiguration>;
    get settings(): VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration;
    get devices(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentBridgeConfiguration::Devices", VAPI.NetworkInterfaces.CurrentBridgeConfigurationDevices>;
}
export declare class CurrentPortConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentPortConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentPortConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get base(): VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration;
    get vlans(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentPortConfiguration::Vlans", VAPI.NetworkInterfaces.CurrentPortConfigurationVlans>;
    get bridges(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentBridgeConfiguration", VAPI.NetworkInterfaces.CurrentBridgeConfiguration>;
    get unknown_commands(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.CurrentPortConfiguration>;
}
export declare class CurrentSyslogConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentSyslogConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentSyslogConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get syslog_servers(): VScript.StronglyTypedArray<VScript.VSocket, "NetworkInterfaces::Data::CurrentSyslogServer", VAPI.NetworkInterfaces.CurrentSyslogServer>;
}
export declare class CurrentSyslogServer implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentSyslogServer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentSyslogServer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.CurrentSyslogServer>;
    get protocol(): VScript.rKeyword<VScript.VSocket, null | VAPI.NetworkInterfaces.Protocol, null | VAPI.NetworkInterfaces.Protocol, VAPI.NetworkInterfaces.CurrentSyslogServer>;
    get rebind_interval(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.CurrentSyslogServer>;
    get keep_alive(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.NetworkInterfaces.CurrentSyslogServer>;
    get format(): VScript.rKeyword<VScript.VSocket, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.CurrentSyslogServer>;
}
export declare class CurrentVirtualEthernetConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get veths(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration::Veths", VAPI.NetworkInterfaces.CurrentVirtualEthernetConfigurationVeths>;
}
export declare class CurrentVirtualInterfaceConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration>;
    get ip_addresses(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::IpAddresses", VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationIpAddresses>;
    get routes(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::Routes", VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes>;
    get dhcp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration>;
    /**
      BusyBox NTP server using current system time as source
    */
    get ntpd(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration>;
    get reverse_path_filter(): VScript.rKeyword<VScript.VSocket, null | VAPI.NetworkInterfaces.ReversePathFilter, null | VAPI.NetworkInterfaces.ReversePathFilter, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration>;
}
export declare class DesiredBridgeConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredBridgeConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredBridgeConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.DesiredBridgeConfiguration>;
    /**
      Enable spanning tree protocol on this bridge
    */
    get stp(): VScript.rwKeyword<VScript.VSocket, null | boolean, null | boolean, null | boolean, null | boolean, VAPI.NetworkInterfaces.DesiredBridgeConfiguration>;
    get settings(): VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration;
    /**
      Delete
    */
    get delete_bridge(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredBridgeConfiguration>;
    get devices(): VScript.StronglyTypedArray<VScript.VSocket, "NetworkInterfaces::Data::DesiredBridgeConfiguration::Devices", VAPI.NetworkInterfaces.DesiredBridgeConfigurationDevices>;
}
export declare class DesiredPortConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredPortConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredPortConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get base(): VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration;
    /**
      Add VLAN
    */
    get add_vlan(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredPortConfiguration>;
    get vlans(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::DesiredPortConfiguration::Vlans", VAPI.NetworkInterfaces.DesiredPortConfigurationVlans>;
    /**
      Add Bridge
    */
    get add_bridge(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredPortConfiguration>;
    get bridges(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::DesiredBridgeConfiguration", VAPI.NetworkInterfaces.DesiredBridgeConfiguration>;
}
export declare class DesiredSyslogConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredSyslogConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredSyslogConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get syslog_servers(): VScript.StronglyTypedArray<VScript.VSocket, "NetworkInterfaces::Data::DesiredSyslogServer", VAPI.NetworkInterfaces.DesiredSyslogServer>;
}
export declare class DesiredSyslogServer implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredSyslogServer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredSyslogServer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get address(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.NetworkInterfaces.DesiredSyslogServer>;
    get protocol(): VScript.rwKeyword<VScript.VSocket, VAPI.NetworkInterfaces.Protocol, VAPI.NetworkInterfaces.Protocol, VAPI.NetworkInterfaces.Protocol, VAPI.NetworkInterfaces.Protocol, VAPI.NetworkInterfaces.DesiredSyslogServer>;
    get rebind_interval(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.NetworkInterfaces.DesiredSyslogServer>;
    get keep_alive(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.NetworkInterfaces.DesiredSyslogServer>;
    get format(): VScript.rwKeyword<VScript.VSocket, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.SyslogFormat, VAPI.NetworkInterfaces.DesiredSyslogServer>;
}
export declare class DesiredVirtualEthernetConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Save veth settings
    */
    get save_veth_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration>;
    /**
      Revert veth settings
    */
    get revert_veth_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration>;
    /**
      Add VETH
    */
    get add_veth(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration>;
    get veths(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration::Veths", VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths>;
}
export declare class DesiredVirtualInterfaceConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
    /**
      Add IP address
    */
    get add_ip_address(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
    get ip_addresses(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::IpAddresses", VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationIpAddresses>;
    /**
      Add route
    */
    get add_route(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
    get routes(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::Routes", VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
    get dhcp(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
    /**
      BusyBox NTP server using current system time as source
    */
    get ntpd(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
    get reverse_path_filter(): VScript.rwKeyword<VScript.VSocket, null | VAPI.NetworkInterfaces.ReversePathFilter, null | VAPI.NetworkInterfaces.ReversePathFilter, null | VAPI.NetworkInterfaces.ReversePathFilter, null | VAPI.NetworkInterfaces.ReversePathFilter, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration>;
}
export interface ErrorWindow {
    /**
      Window size over which errors are checked
    */
    window: VScript.Duration;
    /**
      Number of errors in the window before the condition is met
    */
    threshold: number;
}
export declare class EyeDiagram implements VScript.Referenceable<"NetworkInterfaces::Data::EyeDiagram"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::EyeDiagram";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Generate eye diagram
    */
    get generate(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.EyeDiagram>;
    get progress(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.EyeDiagram>;
    /**
      @brief URL of the eye diagram
      @desc An update to this keyword signals a new eye diagram has been
      generated
    */
    get url(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.EyeDiagram>;
    /**
      @brief Measure eye opening only
      @desc Only measure horizontal eye opening (much faster than a full eye)
    */
    get measure_ui(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.EyeDiagram>;
    get ui(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.EyeDiagram>;
}
export type FaultStatus = "LINK_UP" | "LOCAL_FAULT" | "REMOTE_FAULT";
export declare class Health implements VScript.Referenceable<"NetworkInterfaces::Data::Health"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::Health";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get unreliable(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.NetworkInterfaces.Health>;
    /**
      Include aggregate_traffic_statistics.rx_error and
      aggregate_traffic_statistics.rx_crc_error in addition to the BIP error
      counters (which are only available in 40GbE)
    */
    get include_rx_errors(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.NetworkInterfaces.Health>;
    get set_unreliable(): VScript.dKeyword<VScript.VSocket, [
        number,
        number
    ], [
        number,
        number
    ], VAPI.NetworkInterfaces.ErrorWindow, VAPI.NetworkInterfaces.ErrorWindow, VAPI.NetworkInterfaces.Health>;
    get clear_unreliable(): VScript.dKeyword<VScript.VSocket, [
        number,
        number
    ], [
        number,
        number
    ], VAPI.NetworkInterfaces.ErrorWindow, VAPI.NetworkInterfaces.ErrorWindow, VAPI.NetworkInterfaces.Health>;
}
export declare class HostnameConfiguration implements VScript.Referenceable<"NetworkInterfaces::Data::HostnameConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::HostnameConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Save hostname settings
    */
    get save_hostname_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.HostnameConfiguration>;
    /**
      Revert hostname settings
    */
    get revert_hostname_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.HostnameConfiguration>;
    get current_configuration(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.HostnameConfiguration>;
    /**
      A valid hostname may only contain the following characters: 0-9, a-z,
      A-Z, - and .
    */
    get desired_configuration(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.NetworkInterfaces.HostnameConfiguration>;
}
export declare class LLDPNeighbor implements VScript.Referenceable<"NetworkInterfaces::Data::LLDPNeighbor"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::LLDPNeighbor";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      System runtime since boot
    */
    get last_changed(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get rid(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Signed64, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get system_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get system_description(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get chassis_id(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get interface_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get vlan_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.VlanID, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get mgmt_addr_v4(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.LLDPNeighbor>;
    get mgmt_addr_v6(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.LLDPNeighbor>;
}
/**
  MAC address, stored in big-endian order.
*/
export type MacAddress = Array<VAPI.Primitives.Unsigned8>;
export type Protocol = "UDP" | "TCP";
export type ReversePathFilter = "Disabled" | "Loose" | "Strict";
export type SyslogFormat = "DEFAULT" | "ISO8601";
export declare class VirtualInterface implements VScript.Referenceable<"NetworkInterfaces::Data::VirtualInterface"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::VirtualInterface";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.VirtualInterface>;
    get linux_ifc_index(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.VirtualInterface>;
    /**
      NOTE: the empty string is interpreted as <null>
    */
    get ifname(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.VirtualInterface>;
    get ip_addresses(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::MaskedIpAddress", VAPI.NetworkInterfaces.MaskedIpAddress>;
    get vlan_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.VlanID, VAPI.NetworkInterfaces.VirtualInterface>;
    get supports_ptp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.NetworkInterfaces.VirtualInterface>;
    get supports_rtp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.NetworkInterfaces.VirtualInterface>;
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.NetworkInterfaces.VirtualInterface>;
}
export declare class CurrentBridgeConfigurationDevices implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentBridgeConfiguration::Devices"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentBridgeConfiguration::Devices";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration, VAPI.NetworkInterfaces.CurrentBridgeConfigurationDevices>;
}
export declare class DesiredBridgeConfigurationDevices implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredBridgeConfiguration::Devices"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredBridgeConfiguration::Devices";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get wrapped_reference(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration, null | VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.NetworkInterfaces.DesiredBridgeConfigurationDevices>;
}
export declare class CurrentVirtualInterfaceConfigurationIpAddresses implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::IpAddresses"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::IpAddresses";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationIpAddresses>;
    get prefix(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationIpAddresses>;
}
export declare class DesiredVirtualInterfaceConfigurationIpAddresses implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::IpAddresses"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::IpAddresses";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get ip_address(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationIpAddresses>;
    get prefix(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationIpAddresses>;
    /**
      Delete
    */
    get delete_ip_address(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationIpAddresses>;
}
export declare class MaskedIpAddress implements VScript.Referenceable<"NetworkInterfaces::Data::MaskedIpAddress"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::MaskedIpAddress";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.MaskedIpAddress>;
    get netmask(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.MaskedIpAddress>;
}
export declare class CurrentVirtualInterfaceConfigurationRoutes implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::Routes"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::Routes";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Destination address or subnet for this route. Blank for the default
      route.
    */
    get dst(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes>;
    get dst_prefix(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes>;
    get via(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes>;
    get weight(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfigurationRoutes>;
}
export declare class DesiredVirtualInterfaceConfigurationRoutes implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::Routes"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::Routes";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Destination address or subnet for this route. Leave blank for the default
      route.
    */
    get dst(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
    get dst_prefix(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
    get via(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
    get weight(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
    /**
      Delete
    */
    get delete_route(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfigurationRoutes>;
}
export declare class CurrentVirtualEthernetConfigurationVeths implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration::Veths"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration::Veths";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.CurrentVirtualEthernetConfigurationVeths>;
    get endpoint0(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.CurrentBridgeConfiguration, VAPI.NetworkInterfaces.CurrentVirtualEthernetConfigurationVeths>;
    get endpoint1(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.CurrentBridgeConfiguration, VAPI.NetworkInterfaces.CurrentVirtualEthernetConfigurationVeths>;
}
export declare class DesiredVirtualEthernetConfigurationVeths implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration::Veths"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration::Veths";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths>;
    /**
      Delete this VETH
    */
    get delete_veth(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths>;
    get endpoint0(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.NetworkInterfaces.DesiredBridgeConfiguration, null | VScript.Referenceable<"NetworkInterfaces::Data::DesiredBridgeConfiguration"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths>;
    get endpoint1(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.NetworkInterfaces.DesiredBridgeConfiguration, null | VScript.Referenceable<"NetworkInterfaces::Data::DesiredBridgeConfiguration"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.NetworkInterfaces.DesiredVirtualEthernetConfigurationVeths>;
}
export declare class CurrentPortConfigurationVlans implements VScript.Referenceable<"NetworkInterfaces::Data::CurrentPortConfiguration::Vlans"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::CurrentPortConfiguration::Vlans";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get vlan_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.VlanID, VAPI.NetworkInterfaces.CurrentPortConfigurationVlans>;
    get settings(): VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration;
}
export declare class DesiredPortConfigurationVlans implements VScript.Referenceable<"NetworkInterfaces::Data::DesiredPortConfiguration::Vlans"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "NetworkInterfaces::Data::DesiredPortConfiguration::Vlans";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get vlan_id(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.VlanID, null | VAPI.Primitives.VlanID, VAPI.NetworkInterfaces.DesiredPortConfigurationVlans>;
    /**
      Delete
    */
    get delete_vlan(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.NetworkInterfaces.DesiredPortConfigurationVlans>;
    get settings(): VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration;
}
export declare const Enums: {
    readonly SyslogFormat: SyslogFormat[];
    readonly ReversePathFilter: ReversePathFilter[];
    readonly Protocol: Protocol[];
    readonly FaultStatus: FaultStatus[];
};
