import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly MicroEpoch: (_raw: [number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], _socket: VScript.VSocket) => MicroEpoch;
    readonly MicroEpochs: (_raw: [[number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], [number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], null | number, null | number], _socket: VScript.VSocket) => MicroEpochs;
    readonly AllStatisticsCounters: (_raw: [number, number, number, number, number, number], _socket: VScript.VSocket) => AllStatisticsCounters;
    readonly AllParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPClock.AllParameters;
    readonly AllParametersPllParsCalibrated: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPClock.AllParametersPllParsCalibrated;
    readonly AllStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPClock.AllStatistics;
};
export declare const lower: {
    readonly MicroEpoch: (_x: {
        epoch_index: VAPI.Time.MicroEpochIndex;
        /**
          Most clock control units continuously adjust their target's operating
          frequency until the time and/or frequency offset between source and
          target matches a user-defined value. These units require no data
          beyond frame rate, source type, frequency offset and offset.
          
          However, other clock operations implicitly guarantee synchronicity by
          rigidly linking their target's operating frequency to the source
          frequency. This implicit link may be broken when the timing source
          changes discontinuously. For example, an uncalibrated PTP clock may
          perform arbitrarily large offset and/or frequency jumps, yet after
          reachieving calibration will again report its offset to the internal
          PTP reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
          consumers, every timing source performing discontinuous changes in a
          way that breaks implicit synchronicity has to increase its
          continuity_index (with wraparound behaviour in the unlikely case of
          overflow).
        */
        continuity_index: VAPI.PTP.ContinuityIndex;
        reference_time: VAPI.Primitives.Timestamp;
        reference_counter: VAPI.Time.FreeRunningCounter;
        fpga_drift_to_clock: number;
        /**
          free-running counter value until which this micro epoch is considered
          reliable
        */
        best_before: VAPI.Time.FreeRunningCounter;
        /**
          grain-accurate (24Hz/1.001) offset to micro epoch
        */
        g23_98: VScript.Duration;
        /**
          grain-accurate (24Hz) offset to micro epoch
        */
        g24: VScript.Duration;
        /**
          grain-accurate (25Hz) offset to micro epoch
        */
        g25: VScript.Duration;
        /**
          grain-accurate (30Hz/1.001) offset to micro epoch
        */
        g29_97: VScript.Duration;
        /**
          grain-accurate (30Hz) offset to micro epoch
        */
        g30: VScript.Duration;
        /**
          grain-accurate (50Hz) offset to micro epoch
        */
        g50: VScript.Duration;
        /**
          grain-accurate (60Hz/1.001) offset to micro epoch
        */
        g59_94: VScript.Duration;
        /**
          grain-accurate (60Hz) offset to micro epoch
        */
        g60: VScript.Duration;
        /**
          grain-accurate (48kHz, 32bit RTP counter) media clock offset to micro
          epoch
        */
        grtp_48k: VScript.Duration;
        /**
          grain-accurate (90kHz, 32bit RTP counter) media clock offset to micro
          epoch
        */
        grtp_90k: VScript.Duration;
        /**
          grain-accurate (27MHz, 32bit RTP counter) media clock offset to micro
          epoch
        */
        grtp_27m: VScript.Duration;
        /**
          grain-accurate (96kHz, 32bit RTP counter) media clock offset to micro
          epoch
        */
        grtp_96k: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number];
    readonly MicroEpochs: (_x: {
        current: VAPI.PTPClock.MicroEpoch;
        previous: VAPI.PTPClock.MicroEpoch;
        delta_offset: null | VScript.Duration;
        delta_drift: null | number;
    }, _socket: VScript.VSocket) => [[number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], [number, number, number | string, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], null | number, null | number];
    readonly AllStatisticsCounters: (_x: {
        missing_samples: VAPI.Primitives.SaturatingCounter16;
        bp_overall: VAPI.Primitives.SaturatingSignedCounter16;
        bp_offset: VAPI.Primitives.SaturatingSignedCounter16;
        bp_offset_errors: VAPI.Primitives.SaturatingSignedCounter16;
        bp_drift: VAPI.Primitives.SaturatingSignedCounter16;
        bp_drift_errors: VAPI.Primitives.SaturatingSignedCounter16;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number];
    readonly AllParameters: (_x: AllParameters) => string;
    readonly AllParametersPllParsCalibrated: (_x: AllParametersPllParsCalibrated) => string;
    readonly AllStatistics: (_x: AllStatistics) => string;
};
export interface MicroEpoch {
    epoch_index: VAPI.Time.MicroEpochIndex;
    /**
      Most clock control units continuously adjust their target's operating
      frequency until the time and/or frequency offset between source and
      target matches a user-defined value. These units require no data beyond
      frame rate, source type, frequency offset and offset.
      
      However, other clock operations implicitly guarantee synchronicity by
      rigidly linking their target's operating frequency to the source
      frequency. This implicit link may be broken when the timing source
      changes discontinuously. For example, an uncalibrated PTP clock may
      perform arbitrarily large offset and/or frequency jumps, yet after
      reachieving calibration will again report its offset to the internal PTP
      reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
      consumers, every timing source performing discontinuous changes in a way
      that breaks implicit synchronicity has to increase its continuity_index
      (with wraparound behaviour in the unlikely case of overflow).
    */
    continuity_index: VAPI.PTP.ContinuityIndex;
    reference_time: VAPI.Primitives.Timestamp;
    reference_counter: VAPI.Time.FreeRunningCounter;
    fpga_drift_to_clock: number;
    /**
      free-running counter value until which this micro epoch is considered
      reliable
    */
    best_before: VAPI.Time.FreeRunningCounter;
    /**
      grain-accurate (24Hz/1.001) offset to micro epoch
    */
    g23_98: VScript.Duration;
    /**
      grain-accurate (24Hz) offset to micro epoch
    */
    g24: VScript.Duration;
    /**
      grain-accurate (25Hz) offset to micro epoch
    */
    g25: VScript.Duration;
    /**
      grain-accurate (30Hz/1.001) offset to micro epoch
    */
    g29_97: VScript.Duration;
    /**
      grain-accurate (30Hz) offset to micro epoch
    */
    g30: VScript.Duration;
    /**
      grain-accurate (50Hz) offset to micro epoch
    */
    g50: VScript.Duration;
    /**
      grain-accurate (60Hz/1.001) offset to micro epoch
    */
    g59_94: VScript.Duration;
    /**
      grain-accurate (60Hz) offset to micro epoch
    */
    g60: VScript.Duration;
    /**
      grain-accurate (48kHz, 32bit RTP counter) media clock offset to micro
      epoch
    */
    grtp_48k: VScript.Duration;
    /**
      grain-accurate (90kHz, 32bit RTP counter) media clock offset to micro
      epoch
    */
    grtp_90k: VScript.Duration;
    /**
      grain-accurate (27MHz, 32bit RTP counter) media clock offset to micro
      epoch
    */
    grtp_27m: VScript.Duration;
    /**
      grain-accurate (96kHz, 32bit RTP counter) media clock offset to micro
      epoch
    */
    grtp_96k: VScript.Duration;
}
export interface MicroEpochs {
    current: VAPI.PTPClock.MicroEpoch;
    previous: VAPI.PTPClock.MicroEpoch;
    delta_offset: null | VScript.Duration;
    delta_drift: null | number;
}
/**
  when `mode` is set to `LockToInput`, the PTP clock will attempt to
  synchronize with the external time source designated by `input`. This is
  the default setting and typically the only option suitable for production
  use.
  
  When `mode` is set to `UseInternalOscillator`, the PTP clock will first
  reset its speed to the nominal clock rate generated by its internal
  oscillator, and in the following suspend all clock control operations.
  Likewise, `Disconnect` suspends all clock control operations but in
  contrast to `UseInternalOscillator` continues to run at the current value
  of `relative_clock_speed`
*/
export type Mode = "LockToInput" | "UseInternalOscillator" | "Disconnect";
export type State = "FreeRun" | "Uncalibrated" | "Calibrated" | "CalibratedAndLocked";
/**
  counter values may be negative to indicate deviations beyond the holdover
  threshold
*/
export interface AllStatisticsCounters {
    missing_samples: VAPI.Primitives.SaturatingCounter16;
    bp_overall: VAPI.Primitives.SaturatingSignedCounter16;
    bp_offset: VAPI.Primitives.SaturatingSignedCounter16;
    bp_offset_errors: VAPI.Primitives.SaturatingSignedCounter16;
    bp_drift: VAPI.Primitives.SaturatingSignedCounter16;
    bp_drift_errors: VAPI.Primitives.SaturatingSignedCounter16;
}
/**
  If set to `Reset`, a calibration timeout will reset the clock controller's
  internal state and all estimates currently held by PTP agents. If set to
  `ResetAggressively`, agents will be reinitialized completely, clearing also
  their currently selected best masters and any other transient data they may
  hold
*/
export type AllParametersOnCalibrationTimeout = "Reset" | "ResetAggressively";
export declare class AllParameters implements VScript.Referenceable<"PTPClock::Data::All::Parameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPClock::Data::All::Parameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      use this as the default UTC/TAI offset for time sources that don't supply
      this information on their own (i.e., PTP agents enslaved to a
      sufficiently well-informed Master). Following the PTP standard, this
      denotes the TAI-to-UTC offset and hence should always be positive.
    */
    get default_utc_offset_seconds(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    get locking_policy(): VScript.rwKeyword<VScript.VSocket, VAPI.Servos.LockingPolicy, VAPI.Servos.LockingPolicy, VAPI.Servos.LockingPolicy, VAPI.Servos.LockingPolicy, VAPI.PTPClock.AllParameters>;
    get pll_pars_calibrated(): VAPI.PTPClock.AllParametersPllParsCalibrated;
    get pll_pars_uncalibrated(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Servos.PLLParameters, VAPI.Servos.PLLParameters, VAPI.PTPClock.AllParameters>;
    get max_rel_acceleration(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.PTPClock.AllParameters>;
    get max_allowed_offset(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
    /**
      ignore incoming messages for this long after irregular clock adjustments
      and hard resets
    */
    get timeout_after_reset(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
    get capture_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
    get convergence_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
    /**
      Don't perform jumps unless (i) `|input.offset.value| <
      capture_threshold`, or (ii) `|input.offset.error| <
      relative_accuracy_threshold * |input.offset.value|`. Set to exactly zero
      to disable condition (ii).
    */
    get relative_accuracy_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    get capture_drift_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    get convergence_drift_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    /**
      Don't perform jumps unless (i) `|input.drift.value| <
      capture_drift_threshold`, or (ii) `|input.drift.error| <
      relative_drift_accuracy_threshold * |input.drift.value|`. Set to exactly
      zero to disable condition (ii).
    */
    get relative_drift_accuracy_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    get promotion_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    get demotion_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.PTPClock.AllParameters>;
    /**
      Determines how long the PTP clock may remain uncalibrated before it
      resets itself
    */
    get calibration_timeout(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
    /**
      If set to `Reset`, a calibration timeout will reset the clock
      controller's internal state and all estimates currently held by PTP
      agents. If set to `ResetAggressively`, agents will be reinitialized
      completely, clearing also their currently selected best masters and any
      other transient data they may hold
    */
    get on_calibration_timeout(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPClock.AllParametersOnCalibrationTimeout, VAPI.PTPClock.AllParametersOnCalibrationTimeout, VAPI.PTPClock.AllParametersOnCalibrationTimeout, VAPI.PTPClock.AllParametersOnCalibrationTimeout, VAPI.PTPClock.AllParameters>;
    /**
      use this to override `output.characteristics.offset_type`; may be useful
      to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
      time
    */
    get offset_type_override(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, VAPI.PTPClock.AllParameters>;
    /**
      after discontinuous clock changes, the PTPClock will automatically
      discard newly incoming messages for a short while to avoid locking onto
      obsolete data. In some scenarios (such as redundant analogref-derived
      master setups), it may make sense to further increase this timeout to
      higher constant values; in case of doubt, best leave this setting at its
      default value of 0ns.
    */
    get minimum_timeout_after_jump(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPClock.AllParameters>;
}
export declare class AllParametersPllParsCalibrated implements VScript.Referenceable<"PTPClock::Data::All::Parameters::PllParsCalibrated"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPClock::Data::All::Parameters::PllParsCalibrated";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get inner_corridor(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Servos.PLLParameters, VAPI.Servos.PLLParameters, VAPI.PTPClock.AllParametersPllParsCalibrated>;
    get outer(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Servos.PLLParameters, VAPI.Servos.PLLParameters, VAPI.PTPClock.AllParametersPllParsCalibrated>;
}
export declare class AllStatistics implements VScript.Referenceable<"PTPClock::Data::All::Statistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPClock::Data::All::Statistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      counter values may be negative to indicate deviations beyond the holdover
      threshold
    */
    get counters(): VScript.rKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number,
        number
    ], VAPI.PTPClock.AllStatisticsCounters, VAPI.PTPClock.AllStatistics>;
    get attempting_calibration_for(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.PTPClock.AllStatistics>;
}
export declare const Enums: {
    readonly State: State[];
    readonly Mode: Mode[];
};
