import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ServiceResourceUsage: (_raw) => (new ServiceResourceUsage(_raw)),
    ServicesList: (_raw) => (new ServicesList(_raw)),
};
export const lower = {
    ServiceResourceUsage: (_x) => _x.raw.kwl,
    ServicesList: (_x) => _x.raw.kwl,
};
export class ServiceResourceUsage {
    raw;
    type_identifier = "ServicesList::Data::ServiceResourceUsage";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      CPU usage in percent
    */
    get cpu_usage() {
        return new VScript.rKeyword(this, "cpu_usage", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Memory usage in bytes
    */
    get memory_usage() {
        return new VScript.rKeyword(this, "memory_usage", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ServicesList {
    raw;
    type_identifier = "ServicesList::Data::ServicesList";
    constructor(raw) {
        this.raw = raw;
    }
    get vm_genlock() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "vm_genlock"));
    }
    get vm_i2cserver() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "vm_i2cserver"));
    }
    get vm_j2kdecoder() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "vm_j2kdecoder"));
    }
    get vm_matrix() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "vm_matrix"));
    }
    get vm_metaproc() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "vm_metaproc"));
    }
    get vm_multiviewer() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "vm_multiviewer"));
    }
    get vm_neighborhood_watch() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "vm_neighborhood_watch"));
    }
    get vm_networkmgr() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "vm_networkmgr"));
    }
    get vm_ptp() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "vm_ptp"));
    }
    get vm_rtpreceiver() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "vm_rtpreceiver"));
    }
    get vm_securitymgr() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "vm_securitymgr"));
    }
    get vm_server() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "vm_server"));
    }
    get vm_system() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "vm_system"));
    }
    get vm_timeflows() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "vm_timeflows"));
    }
    get vm_udx() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 14, "vm_udx"));
    }
    get vm_uploadmgr() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 15, "vm_uploadmgr"));
    }
    get vm_webserver() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "vm_webserver"));
    }
    get snmpd() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "snmpd"));
    }
    get rsyslog() {
        return VAPI.ServicesList.lift.ServiceResourceUsage(VScript.VAPIHelpers.subtree_child_checked(this.raw, 18, "rsyslog"));
    }
}
