import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly Action: (_raw: ([0, [boolean, number]] | [1, [number]] | [2, []]), _socket: VScript.VSocket) => Action;
    readonly CounterThresholds: (_raw: [number, number], _socket: VScript.VSocket) => CounterThresholds;
    readonly Counters: (_raw: [number, number, number, number, number, number, number], _socket: VScript.VSocket) => Counters;
    readonly CurrentEstimate: (_raw: [[number, number, number, number], null | [number, number, number, number]], _socket: VScript.VSocket) => CurrentEstimate;
    readonly DriftThresholds: (_raw: [number, number], _socket: VScript.VSocket) => DriftThresholds;
    readonly ModeFreeRun: (_raw: [boolean], _socket: VScript.VSocket) => ModeFreeRun;
    readonly ActionJump: (_raw: [boolean, number], _socket: VScript.VSocket) => ActionJump;
    readonly ModeLockToInput: (_raw: [], _socket: VScript.VSocket) => ModeLockToInput;
    readonly ModeManual: (_raw: [number, number], _socket: VScript.VSocket) => ModeManual;
    readonly Metrics: (_raw: [VAPI.Servos.State, null | number, number, number, null | [[number, number, number, number], null | [number, number, number, number]], [number, number, number, number, number, number, number], number], _socket: VScript.VSocket) => Metrics;
    readonly Mode: (_raw: ([0, []] | [1, [boolean]] | [2, [number, number]]), _socket: VScript.VSocket) => Mode;
    readonly OffsetThresholds: (_raw: [number, number, number, number], _socket: VScript.VSocket) => OffsetThresholds;
    readonly PLLParameters: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => PLLParameters;
    readonly ParameterRegime: (_raw: [[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]], _socket: VScript.VSocket) => ParameterRegime;
    readonly ActionReset: (_raw: [], _socket: VScript.VSocket) => ActionReset;
    readonly Settings: (_raw: [[[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]], [[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]], VAPI.Servos.LockingPolicy, [number, number], number, VAPI.Servos.OnCalibrationTimeout], _socket: VScript.VSocket) => Settings;
    readonly ActionSlew: (_raw: [number], _socket: VScript.VSocket) => ActionSlew;
    readonly ParameterRegimeSpeedLimits: (_raw: [number, number], _socket: VScript.VSocket) => ParameterRegimeSpeedLimits;
};
export declare const lower: {
    readonly Action: (_x: ({
        variant: "Jump";
        value: VAPI.Servos.ActionJump;
    } | {
        variant: "Slew";
        value: VAPI.Servos.ActionSlew;
    } | {
        variant: "Reset";
        value: VAPI.Servos.ActionReset;
    }), _socket: VScript.VSocket) => ([0, [boolean, number]] | [1, [number]] | [2, []]);
    readonly CounterThresholds: (_x: {
        promotion: number;
        demotion: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly Counters: (_x: {
        missing_offset: VAPI.Primitives.SaturatingCounter16;
        missing_drift: VAPI.Primitives.SaturatingCounter16;
        bp_overall: VAPI.Primitives.SaturatingSignedCounter16;
        bp_offset: VAPI.Primitives.SaturatingSignedCounter16;
        bp_offset_errors: VAPI.Primitives.SaturatingSignedCounter16;
        bp_drift: VAPI.Primitives.SaturatingSignedCounter16;
        bp_drift_errors: VAPI.Primitives.SaturatingSignedCounter16;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number, number];
    readonly CurrentEstimate: (_x: {
        offset: VAPI.Time.TimestampedOffset;
        drift: null | VAPI.Time.TimestampedDrift;
    }, _socket: VScript.VSocket) => [[number, number, number, number], null | [number, number, number, number]];
    readonly DriftThresholds: (_x: {
        holdover: number;
        convergence: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly ModeFreeRun: (_x: {
        reset_drift: boolean;
    }, _socket: VScript.VSocket) => [boolean];
    readonly ActionJump: (_x: {
        rough: boolean;
        delta_t: VScript.Duration;
    }, _socket: VScript.VSocket) => [boolean, number];
    readonly ModeLockToInput: (_x: {}, _socket: VScript.VSocket) => [];
    readonly ModeManual: (_x: {
        relative_speed: number;
        offset: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
    readonly Metrics: (_x: {
        state: VAPI.Servos.State;
        /**
          Most clock control units continuously adjust their target's operating
          frequency until the time and/or frequency offset between source and
          target matches a user-defined value. These units require no data beyond
          frame rate, source type, frequency offset and offset.
          
          However, other clock operations implicitly guarantee synchronicity by
          rigidly linking their target's operating frequency to the source
          frequency. This implicit link may be broken when the timing source
          changes discontinuously. For example, an uncalibrated PTP clock may
          perform arbitrarily large offset and/or frequency jumps, yet after
          reachieving calibration will again report its offset to the internal
          PTP reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
          consumers, every timing source performing discontinuous changes in a
          way that breaks implicit synchronicity has to increase its
          continuity_index (with wraparound behaviour in the unlikely case of
          overflow).
        */
        continuity_index: null | VAPI.PTP.ContinuityIndex;
        speed: number;
        max_rel_acceleration: number;
        /**
          Current drift/offset estimates, referring to whatever reference frame
          the corresponding servo controller uses
        */
        current_estimate: null | VAPI.Servos.CurrentEstimate;
        /**
          counter values may be negative to indicate deviations beyond the
          holdover threshold
        */
        counters: VAPI.Servos.Counters;
        attempting_calibration_for: VScript.Duration;
    }, _socket: VScript.VSocket) => [VAPI.Servos.State, null | number, number, number, null | [[number, number, number, number], null | [number, number, number, number]], [number, number, number, number, number, number, number], number];
    readonly Mode: (_x: ({
        variant: "LockToInput";
        value: VAPI.Servos.ModeLockToInput;
    } | {
        variant: "FreeRun";
        value: VAPI.Servos.ModeFreeRun;
    } | {
        variant: "Manual";
        value: VAPI.Servos.ModeManual;
    }), _socket: VScript.VSocket) => ([0, []] | [1, [boolean]] | [2, [number, number]]);
    readonly OffsetThresholds: (_x: {
        rough_jump: VScript.Duration;
        holdover: VScript.Duration;
        convergence: VScript.Duration;
        inner_target_corridor: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly PLLParameters: (_x: {
        /**
          Min. relative clock period change per tick
        */
        min_drift_adjustment_step: number;
        /**
          Max. relative clock period change per tick
        */
        max_drift_adjustment_step: number;
        drift_growth_factor: number;
        stiffness: number;
        damping: number;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly ParameterRegime: (_x: {
        pll: VAPI.Servos.PLLParameters;
        speed_limits: VAPI.Servos.ParameterRegimeSpeedLimits;
        offset_thresholds: VAPI.Servos.OffsetThresholds;
        drift_thresholds: VAPI.Servos.DriftThresholds;
    }, _socket: VScript.VSocket) => [[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]];
    readonly ActionReset: (_x: {}, _socket: VScript.VSocket) => [];
    readonly Settings: (_x: {
        uncalibrated: VAPI.Servos.ParameterRegime;
        calibrated: VAPI.Servos.ParameterRegime;
        locking_policy: VAPI.Servos.LockingPolicy;
        counter_thresholds: VAPI.Servos.CounterThresholds;
        calibration_timeout: VScript.Duration;
        /**
          If set to `ResetAggressively`, clock controllers will not only clear
          their current estimates but reset their inputs as thoroughly as
          possible; e.g., a PTPClock resetting aggressively will cause all PTP
          agents currently running in Slave mode to reset their currently
          selected best masters and any other transient data they may hold
        */
        on_calibration_timeout: VAPI.Servos.OnCalibrationTimeout;
    }, _socket: VScript.VSocket) => [[[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]], [[number, number, number, number, number], [number, number], [number, number, number, number], [number, number]], VAPI.Servos.LockingPolicy, [number, number], number, VAPI.Servos.OnCalibrationTimeout];
    readonly ActionSlew: (_x: {
        target_speed: number;
    }, _socket: VScript.VSocket) => [number];
    readonly ParameterRegimeSpeedLimits: (_x: {
        min: number;
        max: number;
    }, _socket: VScript.VSocket) => [number, number];
};
export type Action = ({
    variant: "Jump";
    value: VAPI.Servos.ActionJump;
} | {
    variant: "Slew";
    value: VAPI.Servos.ActionSlew;
} | {
    variant: "Reset";
    value: VAPI.Servos.ActionReset;
});
export type CalibrationState = "Uncalibrated" | "Calibrated";
export interface CounterThresholds {
    promotion: number;
    demotion: number;
}
/**
  counter values may be negative to indicate deviations beyond the holdover
  threshold
*/
export interface Counters {
    missing_offset: VAPI.Primitives.SaturatingCounter16;
    missing_drift: VAPI.Primitives.SaturatingCounter16;
    bp_overall: VAPI.Primitives.SaturatingSignedCounter16;
    bp_offset: VAPI.Primitives.SaturatingSignedCounter16;
    bp_offset_errors: VAPI.Primitives.SaturatingSignedCounter16;
    bp_drift: VAPI.Primitives.SaturatingSignedCounter16;
    bp_drift_errors: VAPI.Primitives.SaturatingSignedCounter16;
}
/**
  Current drift/offset estimates, referring to whatever reference frame the
  corresponding servo controller uses
*/
export interface CurrentEstimate {
    offset: VAPI.Time.TimestampedOffset;
    drift: null | VAPI.Time.TimestampedDrift;
}
export type Direction = "Upwards" | "Downwards";
export interface DriftThresholds {
    holdover: number;
    convergence: number;
}
export interface ModeFreeRun {
    reset_drift: boolean;
}
export interface ActionJump {
    rough: boolean;
    delta_t: VScript.Duration;
}
export interface ModeLockToInput {
}
export type LockingPolicy = "Locking" | "Dynamic";
export interface ModeManual {
    relative_speed: number;
    offset: VScript.Duration;
}
export interface Metrics {
    state: VAPI.Servos.State;
    /**
      Most clock control units continuously adjust their target's operating
      frequency until the time and/or frequency offset between source and
      target matches a user-defined value. These units require no data beyond
      frame rate, source type, frequency offset and offset.
      
      However, other clock operations implicitly guarantee synchronicity by
      rigidly linking their target's operating frequency to the source
      frequency. This implicit link may be broken when the timing source
      changes discontinuously. For example, an uncalibrated PTP clock may
      perform arbitrarily large offset and/or frequency jumps, yet after
      reachieving calibration will again report its offset to the internal PTP
      reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
      consumers, every timing source performing discontinuous changes in a way
      that breaks implicit synchronicity has to increase its continuity_index
      (with wraparound behaviour in the unlikely case of overflow).
    */
    continuity_index: null | VAPI.PTP.ContinuityIndex;
    speed: number;
    max_rel_acceleration: number;
    /**
      Current drift/offset estimates, referring to whatever reference frame the
      corresponding servo controller uses
    */
    current_estimate: null | VAPI.Servos.CurrentEstimate;
    /**
      counter values may be negative to indicate deviations beyond the holdover
      threshold
    */
    counters: VAPI.Servos.Counters;
    attempting_calibration_for: VScript.Duration;
}
export type Mode = ({
    variant: "LockToInput";
    value: VAPI.Servos.ModeLockToInput;
} | {
    variant: "FreeRun";
    value: VAPI.Servos.ModeFreeRun;
} | {
    variant: "Manual";
    value: VAPI.Servos.ModeManual;
});
export interface OffsetThresholds {
    rough_jump: VScript.Duration;
    holdover: VScript.Duration;
    convergence: VScript.Duration;
    inner_target_corridor: VScript.Duration;
}
/**
  If set to `ResetAggressively`, clock controllers will not only clear their
  current estimates but reset their inputs as thoroughly as possible; e.g., a
  PTPClock resetting aggressively will cause all PTP agents currently running
  in Slave mode to reset their currently selected best masters and any other
  transient data they may hold
*/
export type OnCalibrationTimeout = "Reset" | "ResetAggressively";
export interface PLLParameters {
    /**
      Min. relative clock period change per tick
    */
    min_drift_adjustment_step: number;
    /**
      Max. relative clock period change per tick
    */
    max_drift_adjustment_step: number;
    drift_growth_factor: number;
    stiffness: number;
    damping: number;
}
export interface ParameterRegime {
    pll: VAPI.Servos.PLLParameters;
    speed_limits: VAPI.Servos.ParameterRegimeSpeedLimits;
    offset_thresholds: VAPI.Servos.OffsetThresholds;
    drift_thresholds: VAPI.Servos.DriftThresholds;
}
export type QualityAssessment = "Convergent" | "Normal" | "Divergent";
export interface ActionReset {
}
export interface Settings {
    uncalibrated: VAPI.Servos.ParameterRegime;
    calibrated: VAPI.Servos.ParameterRegime;
    locking_policy: VAPI.Servos.LockingPolicy;
    counter_thresholds: VAPI.Servos.CounterThresholds;
    calibration_timeout: VScript.Duration;
    /**
      If set to `ResetAggressively`, clock controllers will not only clear
      their current estimates but reset their inputs as thoroughly as possible;
      e.g., a PTPClock resetting aggressively will cause all PTP agents
      currently running in Slave mode to reset their currently selected best
      masters and any other transient data they may hold
    */
    on_calibration_timeout: VAPI.Servos.OnCalibrationTimeout;
}
export interface ActionSlew {
    target_speed: number;
}
export type State = "Uncalibrated" | "Calibrated" | "FreeRun";
export interface ParameterRegimeSpeedLimits {
    min: number;
    max: number;
}
export declare const Enums: {
    readonly State: State[];
    readonly QualityAssessment: QualityAssessment[];
    readonly OnCalibrationTimeout: OnCalibrationTimeout[];
    readonly LockingPolicy: LockingPolicy[];
    readonly Direction: Direction[];
    readonly CalibrationState: CalibrationState[];
};
