import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    Action: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Jump", value: VAPI.Servos.lift.ActionJump(_raw[1], _socket) };
            case 1: return { variant: "Slew", value: VAPI.Servos.lift.ActionSlew(_raw[1], _socket) };
            case 2: return { variant: "Reset", value: VAPI.Servos.lift.ActionReset(_raw[1], _socket) };
        }
        ;
    },
    CounterThresholds: (_raw, _socket) => {
        return {
            promotion: _raw[0],
            demotion: _raw[1]
        };
    },
    Counters: (_raw, _socket) => {
        return {
            missing_offset: _raw[0],
            missing_drift: _raw[1],
            bp_overall: _raw[2],
            bp_offset: _raw[3],
            bp_offset_errors: _raw[4],
            bp_drift: _raw[5],
            bp_drift_errors: _raw[6]
        };
    },
    CurrentEstimate: (_raw, _socket) => {
        return {
            offset: VAPI.Time.lift.TimestampedOffset(_raw[0], _socket),
            drift: _raw[1] === null ? null : VAPI.Time.lift.TimestampedDrift(_raw[1], _socket)
        };
    },
    DriftThresholds: (_raw, _socket) => {
        return {
            holdover: _raw[0],
            convergence: _raw[1]
        };
    },
    ModeFreeRun: (_raw, _socket) => {
        return { reset_drift: _raw[0] };
    },
    ActionJump: (_raw, _socket) => {
        return {
            rough: _raw[0],
            delta_t: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket)
        };
    },
    ModeLockToInput: (_raw, _socket) => {
        return {};
    },
    ModeManual: (_raw, _socket) => {
        return {
            relative_speed: _raw[0],
            offset: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket)
        };
    },
    Metrics: (_raw, _socket) => {
        return {
            state: _raw[0],
            continuity_index: _raw[1],
            speed: _raw[2],
            max_rel_acceleration: _raw[3],
            current_estimate: _raw[4] === null ? null : VAPI.Servos.lift.CurrentEstimate(_raw[4], _socket),
            counters: VAPI.Servos.lift.Counters(_raw[5], _socket),
            attempting_calibration_for: VScript.VAPIHelpers.liftNanoseconds(_raw[6], _socket)
        };
    },
    Mode: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "LockToInput", value: VAPI.Servos.lift.ModeLockToInput(_raw[1], _socket) };
            case 1: return { variant: "FreeRun", value: VAPI.Servos.lift.ModeFreeRun(_raw[1], _socket) };
            case 2: return { variant: "Manual", value: VAPI.Servos.lift.ModeManual(_raw[1], _socket) };
        }
        ;
    },
    OffsetThresholds: (_raw, _socket) => {
        return {
            rough_jump: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            holdover: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
            convergence: VScript.VAPIHelpers.liftSeconds(_raw[2], _socket),
            inner_target_corridor: VScript.VAPIHelpers.liftSeconds(_raw[3], _socket)
        };
    },
    PLLParameters: (_raw, _socket) => {
        return {
            min_drift_adjustment_step: _raw[0],
            max_drift_adjustment_step: _raw[1],
            drift_growth_factor: _raw[2],
            stiffness: _raw[3],
            damping: _raw[4]
        };
    },
    ParameterRegime: (_raw, _socket) => {
        return {
            pll: VAPI.Servos.lift.PLLParameters(_raw[0], _socket),
            speed_limits: VAPI.Servos.lift.ParameterRegimeSpeedLimits(_raw[1], _socket),
            offset_thresholds: VAPI.Servos.lift.OffsetThresholds(_raw[2], _socket),
            drift_thresholds: VAPI.Servos.lift.DriftThresholds(_raw[3], _socket)
        };
    },
    ActionReset: (_raw, _socket) => {
        return {};
    },
    Settings: (_raw, _socket) => {
        return {
            uncalibrated: VAPI.Servos.lift.ParameterRegime(_raw[0], _socket),
            calibrated: VAPI.Servos.lift.ParameterRegime(_raw[1], _socket),
            locking_policy: _raw[2],
            counter_thresholds: VAPI.Servos.lift.CounterThresholds(_raw[3], _socket),
            calibration_timeout: VScript.VAPIHelpers.liftNanoseconds(_raw[4], _socket),
            on_calibration_timeout: _raw[5]
        };
    },
    ActionSlew: (_raw, _socket) => {
        return { target_speed: _raw[0] };
    },
    ParameterRegimeSpeedLimits: (_raw, _socket) => {
        return {
            min: _raw[0],
            max: _raw[1]
        };
    },
};
export const lower = {
    Action: (_x, _socket) => {
        switch (_x.variant) {
            case "Jump": return [0, VAPI.Servos.lower.ActionJump(_x.value, _socket)];
            case "Slew": return [1, VAPI.Servos.lower.ActionSlew(_x.value, _socket)];
            case "Reset": return [2, VAPI.Servos.lower.ActionReset(_x.value, _socket)];
        }
    },
    CounterThresholds: (_x, _socket) => [
        _x.promotion,
        _x.demotion
    ],
    Counters: (_x, _socket) => [
        _x.missing_offset,
        _x.missing_drift,
        _x.bp_overall,
        _x.bp_offset,
        _x.bp_offset_errors,
        _x.bp_drift,
        _x.bp_drift_errors
    ],
    CurrentEstimate: (_x, _socket) => [
        VAPI.Time.lower.TimestampedOffset(_x.offset, _socket),
        _x.drift === null ? null : VAPI.Time.lower.TimestampedDrift(_x.drift, _socket)
    ],
    DriftThresholds: (_x, _socket) => [
        _x.holdover,
        _x.convergence
    ],
    ModeFreeRun: (_x, _socket) => [
        _x.reset_drift
    ],
    ActionJump: (_x, _socket) => [
        _x.rough,
        VScript.VAPIHelpers.lowerSeconds(_x.delta_t, _socket)
    ],
    ModeLockToInput: (_x, _socket) => [],
    ModeManual: (_x, _socket) => [
        _x.relative_speed,
        VScript.VAPIHelpers.lowerSeconds(_x.offset, _socket)
    ],
    Metrics: (_x, _socket) => [
        _x.state,
        _x.continuity_index,
        _x.speed,
        _x.max_rel_acceleration,
        _x.current_estimate === null ? null : VAPI.Servos.lower.CurrentEstimate(_x.current_estimate, _socket),
        VAPI.Servos.lower.Counters(_x.counters, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.attempting_calibration_for, _socket)
    ],
    Mode: (_x, _socket) => {
        switch (_x.variant) {
            case "LockToInput": return [0, VAPI.Servos.lower.ModeLockToInput(_x.value, _socket)];
            case "FreeRun": return [1, VAPI.Servos.lower.ModeFreeRun(_x.value, _socket)];
            case "Manual": return [2, VAPI.Servos.lower.ModeManual(_x.value, _socket)];
        }
    },
    OffsetThresholds: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.rough_jump, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.holdover, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.convergence, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.inner_target_corridor, _socket)
    ],
    PLLParameters: (_x, _socket) => [
        _x.min_drift_adjustment_step,
        _x.max_drift_adjustment_step,
        _x.drift_growth_factor,
        _x.stiffness,
        _x.damping
    ],
    ParameterRegime: (_x, _socket) => [
        VAPI.Servos.lower.PLLParameters(_x.pll, _socket),
        VAPI.Servos.lower.ParameterRegimeSpeedLimits(_x.speed_limits, _socket),
        VAPI.Servos.lower.OffsetThresholds(_x.offset_thresholds, _socket),
        VAPI.Servos.lower.DriftThresholds(_x.drift_thresholds, _socket)
    ],
    ActionReset: (_x, _socket) => [],
    Settings: (_x, _socket) => [
        VAPI.Servos.lower.ParameterRegime(_x.uncalibrated, _socket),
        VAPI.Servos.lower.ParameterRegime(_x.calibrated, _socket),
        _x.locking_policy,
        VAPI.Servos.lower.CounterThresholds(_x.counter_thresholds, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.calibration_timeout, _socket),
        _x.on_calibration_timeout
    ],
    ActionSlew: (_x, _socket) => [
        _x.target_speed
    ],
    ParameterRegimeSpeedLimits: (_x, _socket) => [
        _x.min,
        _x.max
    ],
};
export const Enums = {
    State: ["Uncalibrated", "Calibrated", "FreeRun"],
    QualityAssessment: ["Convergent", "Normal", "Divergent"],
    OnCalibrationTimeout: ["Reset", "ResetAggressively"],
    LockingPolicy: ["Locking", "Dynamic"],
    Direction: ["Upwards", "Downwards"],
    CalibrationState: ["Uncalibrated", "Calibrated"]
};
