import * as VAPI from "./index.js";
export type CombinatorType = "AbsoluteTime";
export type PTPSourceTypeFilter = "UseHighest" | "UseAtomicClock" | "UseGPSOrBetter" | "UseTerrestrialRadioOrBetter" | "UsePTPOrBetter" | "UseNTPOrBetter" | "UseHandSetOrBetter" | "UseInternalOscillatorOrBetter";
/**
  ideally, all inputs to a clock combinator should use the same reference
  frame as the clock combinator itself. If this is not the case, mismatching
  inputs will be discarded by default. By setting
  `on_reference_frame_mismatch` to `Convert`, inputs can also be converted to
  the combinator's own reference frame. Note, however, that this generally
  incurs a loss in precision
*/
export type ReferenceFrameMismatchPolicy = "Discard" | "Convert";
export type AlignerIssues = {
    above_warning_threshold: boolean;
    holdover_due_to_frequency_change: boolean;
    holdover_due_to_input_jump: boolean;
};
export declare const Enums: {
    readonly ReferenceFrameMismatchPolicy: ReferenceFrameMismatchPolicy[];
    readonly PTPSourceTypeFilter: PTPSourceTypeFilter[];
    readonly CombinatorType: CombinatorType[];
};
