import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AllocationMode: (_raw: ([0, [number]] | [1, [number]]), _socket: VScript.VSocket) => AllocationMode;
    readonly VideoLimitationBandwidth: (_raw: [VAPI.Definitions.Bandwidth], _socket: VScript.VSocket) => VideoLimitationBandwidth;
    readonly Capabilities: (_raw: [null | ([0, [number]] | [1, [number]]), [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]], _socket: VScript.VSocket) => Capabilities;
    readonly Control: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.Control;
    readonly FramesSettings: (_raw: [number], _socket: VScript.VSocket) => FramesSettings;
    readonly FramesTime: (_raw: [number, number], _socket: VScript.VSocket) => FramesTime;
    readonly GroupSelections: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.GroupSelections;
    readonly Header: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.Header;
    readonly Load: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.Load;
    readonly MemoryCapacity: (_raw: [number, number, [null | number, null | number], null | VAPI.Video.Standard], _socket: VScript.VSocket) => MemoryCapacity;
    readonly OutputDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.OutputDebug;
    readonly Reader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.Reader;
    readonly SingleSettings: (_raw: [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])], _socket: VScript.VSocket) => SingleSettings;
    readonly VideoLimitationStandard: (_raw: [VAPI.Video.Standard], _socket: VScript.VSocket) => VideoLimitationStandard;
    readonly TimeSettings: (_raw: [number], _socket: VScript.VSocket) => TimeSettings;
    readonly Upload: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoPlayer.Upload;
    readonly VideoLimitation: (_raw: ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]]), _socket: VScript.VSocket) => VideoLimitation;
    readonly MemoryCapacityAsRequested: (_raw: [null | number, null | number], _socket: VScript.VSocket) => MemoryCapacityAsRequested;
    readonly HeaderDate: (_raw: [number, number, number], _socket: VScript.VSocket) => HeaderDate;
    readonly HeaderTimeOfDay: (_raw: [number, number, number], _socket: VScript.VSocket) => HeaderTimeOfDay;
};
export declare const lower: {
    readonly AllocationMode: (_x: ({
        variant: "Frames";
        value: VAPI.VideoPlayer.FramesSettings;
    } | {
        variant: "Time";
        value: VAPI.VideoPlayer.TimeSettings;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]]);
    readonly VideoLimitationBandwidth: (_x: {
        max_bandwidth: VAPI.Definitions.Bandwidth;
    }, _socket: VScript.VSocket) => [VAPI.Definitions.Bandwidth];
    readonly Capabilities: (_x: {
        capacity: null | VAPI.VideoPlayer.AllocationMode;
        input_caliber: VAPI.VideoPlayer.SingleSettings;
    }, _socket: VScript.VSocket) => [null | ([0, [number]] | [1, [number]]), [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]];
    readonly Control: (_x: Control) => string;
    readonly FramesSettings: (_x: {
        frames: number;
    }, _socket: VScript.VSocket) => [number];
    readonly FramesTime: (_x: {
        frames: number;
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
    readonly GroupSelections: (_x: GroupSelections) => string;
    readonly Header: (_x: Header) => string;
    readonly Load: (_x: Load) => string;
    readonly MemoryCapacity: (_x: {
        as_pages: VAPI.Primitives.Unsigned16;
        as_bytes: VAPI.Primitives.Unsigned64;
        as_requested: VAPI.VideoPlayer.MemoryCapacityAsRequested;
        /**
          This standard is used to calculate the required memory. It is
          derived from the (add_blanking, video_limitation, Frames, Time)
          settings
        */
        calculation_standard: null | VAPI.Video.Standard;
    }, _socket: VScript.VSocket) => [number, number, [null | number, null | number], null | VAPI.Video.Standard];
    readonly OutputDebug: (_x: OutputDebug) => string;
    readonly Reader: (_x: Reader) => string;
    readonly SingleSettings: (_x: {
        add_blanking: boolean;
        constraints: VAPI.VideoPlayer.VideoLimitation;
    }, _socket: VScript.VSocket) => [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])];
    readonly VideoLimitationStandard: (_x: {
        standard: VAPI.Video.Standard;
    }, _socket: VScript.VSocket) => [VAPI.Video.Standard];
    readonly TimeSettings: (_x: {
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly Upload: (_x: Upload) => string;
    readonly VideoLimitation: (_x: ({
        variant: "Standard";
        value: VAPI.VideoPlayer.VideoLimitationStandard;
    } | {
        variant: "Bandwidth";
        value: VAPI.VideoPlayer.VideoLimitationBandwidth;
    }), _socket: VScript.VSocket) => ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]]);
    readonly MemoryCapacityAsRequested: (_x: {
        frames: null | number;
        time: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly HeaderDate: (_x: {
        year: number;
        month: number;
        day: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly HeaderTimeOfDay: (_x: {
        hours: number;
        minutes: number;
        seconds: number;
    }, _socket: VScript.VSocket) => [number, number, number];
};
export type AllocationMode = ({
    variant: "Frames";
    value: VAPI.VideoPlayer.FramesSettings;
} | {
    variant: "Time";
    value: VAPI.VideoPlayer.TimeSettings;
});
export interface VideoLimitationBandwidth {
    max_bandwidth: VAPI.Definitions.Bandwidth;
}
export type BufferMode = "Frames" | "Time";
export interface Capabilities {
    capacity: null | VAPI.VideoPlayer.AllocationMode;
    input_caliber: VAPI.VideoPlayer.SingleSettings;
}
export declare class Control implements VScript.Referenceable<"VideoPlayer::Data::Control"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::Control";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Stop
    */
    get stop(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Control>;
    /**
      Play
    */
    get play(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Control>;
    /**
      Back
    */
    get step_backward(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Control>;
    /**
      Forward
    */
    get step_forward(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Control>;
    /**
      Jump
    */
    get jump(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Control>;
    get frame(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.VideoPlayer.Control>;
    get motion_status(): VScript.rKeyword<VScript.VSocket, VAPI.VideoPlayer.MotionStatus, VAPI.VideoPlayer.MotionStatus, VAPI.VideoPlayer.Control>;
    get visible_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Control>;
}
export type DelayMode = "FrameSync_Freeze" | "FrameSync_Black" | "FramePhaser";
export interface FramesSettings {
    frames: number;
}
export interface FramesTime {
    frames: number;
    time: VScript.Duration;
}
export declare class GroupSelections implements VScript.Referenceable<"VideoPlayer::Data::GroupSelections"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::GroupSelections";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get group(): VScript.dKeyword<VScript.VSocket, null | VAPI.VideoPlayer.Groups, null | VAPI.VideoPlayer.Groups, null | VAPI.VideoPlayer.Groups, null | VAPI.VideoPlayer.Groups, VAPI.VideoPlayer.GroupSelections>;
}
export type Groups = "Group0" | "Group1" | "Group2" | "Group3";
export declare class Header implements VScript.Referenceable<"VideoPlayer::Data::Header"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::Header";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get date(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number
    ], null | VAPI.VideoPlayer.HeaderDate, VAPI.VideoPlayer.Header>;
    get time_of_day(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number
    ], null | VAPI.VideoPlayer.HeaderTimeOfDay, VAPI.VideoPlayer.Header>;
    get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.VideoPlayer.Header>;
    get interlace(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.VideoPlayer.Header>;
    get frames(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Header>;
    get time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoPlayer.Header>;
    get add_blanking(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.VideoPlayer.Header>;
    get h_active(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Header>;
    get v_active(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Header>;
    get h_total(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Header>;
    get v_total(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Header>;
    get colorspace(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, VAPI.VideoPlayer.Header>;
    get tc(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.TransferCharacteristics, null | VAPI.Video.TransferCharacteristics, VAPI.VideoPlayer.Header>;
}
export type InputMode = "Single" | "Quad" | "UHD";
export declare class Load implements VScript.Referenceable<"VideoPlayer::Data::Load"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::Load";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get file(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.VideoPlayer.Load>;
    /**
      Load Clip
    */
    get load(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoPlayer.Load>;
    get progress(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.Load>;
}
export interface MemoryCapacity {
    as_pages: VAPI.Primitives.Unsigned16;
    as_bytes: VAPI.Primitives.Unsigned64;
    as_requested: VAPI.VideoPlayer.MemoryCapacityAsRequested;
    /**
      This standard is used to calculate the required memory. It is derived
      from the (add_blanking, video_limitation, Frames, Time) settings
    */
    calculation_standard: null | VAPI.Video.Standard;
}
export type MotionStatus = "Stop" | "Play" | "StepBackward" | "StepForward" | "Jump";
export declare class OutputDebug implements VScript.Referenceable<"VideoPlayer::Data::OutputDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::OutputDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get reader_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get reader_v_idx(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_first_active_line_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get end_first_blanking_line_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_first_active_line_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get end_first_blanking_line_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get line_number_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get line_number_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get line_total(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_line_number_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_v_flag_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get horizontal_blanking(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get horizontal_active(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get mode_hanc(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get mode_vanc(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get mode_video(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get mode_en_cnt(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get ce_sel(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get ce_sel_enable(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get length_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get length_line(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get stride_line(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get stride_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get end_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get jump(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get reset(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get start_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get delta_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoPlayer.OutputDebug>;
    get delta_time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoPlayer.OutputDebug>;
    get time_from_start(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoPlayer.OutputDebug>;
    get delta_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get frame_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoPlayer.OutputDebug>;
    get register_panic(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoPlayer.OutputDebug>;
}
export declare class Reader implements VScript.Referenceable<"VideoPlayer::Data::Reader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::Reader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoPlayer.Reader>;
    get debug(): VAPI.VideoPlayer.OutputDebug;
}
export interface SingleSettings {
    add_blanking: boolean;
    constraints: VAPI.VideoPlayer.VideoLimitation;
}
export interface VideoLimitationStandard {
    standard: VAPI.Video.Standard;
}
export interface TimeSettings {
    time: VScript.Duration;
}
export declare class Upload implements VScript.Referenceable<"VideoPlayer::Data::Upload"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoPlayer::Data::Upload";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get load(): VAPI.VideoPlayer.Load;
    get header(): VAPI.VideoPlayer.Header;
}
export type VideoLimitation = ({
    variant: "Standard";
    value: VAPI.VideoPlayer.VideoLimitationStandard;
} | {
    variant: "Bandwidth";
    value: VAPI.VideoPlayer.VideoLimitationBandwidth;
});
export interface MemoryCapacityAsRequested {
    frames: null | number;
    time: null | VScript.Duration;
}
export interface HeaderDate {
    year: number;
    month: number;
    day: number;
}
export type PlayerIssues = {
    load_failed_bad_header: boolean;
    load_failed_no_header: boolean;
    load_failed_read_error: boolean;
    load_pending: boolean;
    missing_latched_standard: boolean;
    missing_timesource: boolean;
    out_of_memory: boolean;
    out_of_readers: boolean;
    out_of_writers: boolean;
    upload_error: boolean;
};
export interface HeaderTimeOfDay {
    hours: number;
    minutes: number;
    seconds: number;
}
export declare const Enums: {
    readonly MotionStatus: MotionStatus[];
    readonly InputMode: InputMode[];
    readonly Groups: Groups[];
    readonly DelayMode: DelayMode[];
    readonly BufferMode: BufferMode[];
};
