import * as VAPI from "../index.js";
export async function set_input(obj, src, pars) {
    const start = pars?.start ?? 0;
    if (!Number.isInteger(start) || start < 0)
        throw new Error("start must be an integer >= 0");
    const max_inputs = 16;
    let update = Array(max_inputs).fill(null);
    if (src instanceof VAPI.AT1130.Audio.Essence) {
        const channels = pars?.channels ?? max_inputs;
        if (!Number.isInteger(channels) || channels <= 0 || channels > max_inputs)
            throw new Error(`channels must be an integer between 1 and ${max_inputs}`);
        if (start > (max_inputs - channels))
            throw new Error("the range start and channels is out of bounds");
        for (let i = 0; i < channels; ++i)
            update[i] = src.channels.reference_to_index(start + i);
    }
    else if (src !== null) {
        if (start >= src.length)
            new Error("start is out of bounds");
        const max_channels = Math.min(max_inputs, src.length - start);
        const channels = pars?.channels ?? max_channels;
        if (!Number.isInteger(channels) || channels <= 0 || channels > max_channels)
            throw new Error("channels is out of bounds");
        for (let i = 0; i < channels; ++i)
            update[i] = src[start + i];
    }
    await obj.inputs.write(update);
}
