import * as VAPI from "../index.js";
import * as VScript from "vscript";
type HardwareModel = "AT1101" | "AT1130";
type Direction = "read" | "write";
type ManagementNamespaceSuffix<Model extends HardwareModel> = Model extends "AT1130" ? "rear" | "front" : "eth1" | "eth3";
type MediaNamespaceSuffix<Model extends HardwareModel> = Model extends "AT1130" ? "p0" | "p1" : "eth0.0" | "eth0.1" | "eth0.2" | "eth0.3" | "eth2.0" | "eth2.1" | "eth2.2" | "eth2.3";
type ManagementNamespace<Model extends HardwareModel> = `ns_${ManagementNamespaceSuffix<Model>}`;
type MediaNamespace<Model extends HardwareModel> = `ns_${MediaNamespaceSuffix<Model>}`;
export interface IPAddressConfig {
    address: string;
    prefix: number;
}
export interface Route {
    dst?: IPAddressConfig;
    via: string;
    weight?: number;
}
export type SyslogServer<dir extends Direction> = {
    address_with_port: string;
    keep_alive: boolean | null;
    rebind_interval: number | null;
    protocol: VAPI.NetworkInterfaces.Protocol | null;
} & (dir extends "write" ? {
    format?: VAPI.NetworkInterfaces.SyslogFormat;
} : {
    format: VAPI.NetworkInterfaces.SyslogFormat;
});
type MaybePartial<dir extends Direction, T> = dir extends "write" ? Partial<T> : T;
export type AT1130PhyConfig<dir extends Direction> = MaybePartial<dir, {
    port_mode: VAPI.AT1130.NetworkInterfaces.PortMode;
    pma_settings: VAPI.AT1130.NetworkInterfaces.PMASettings;
}>;
export interface FullVLANConfig {
    ip_addresses: IPAddressConfig[];
    routes: Route[];
    dhcp: boolean;
    ntpd: boolean;
    reverse_path_filter: null | VAPI.NetworkInterfaces.ReversePathFilter;
}
export type MaybeReset<dir extends Direction, T> = dir extends "write" ? "factory-reset" | T : T;
export type VLANConfig<dir extends Direction> = dir extends "read" ? FullVLANConfig : Partial<FullVLANConfig>;
export type NamespaceConfig<dir extends Direction> = MaybePartial<dir, {
    vlans: MaybeReset<dir, Record<VAPI.Primitives.VlanID, VLANConfig<dir>>>;
    syslog: MaybeReset<dir, Array<SyslogServer<dir>>>;
}>;
export type MediaNamespaceConfig<Model extends HardwareModel, dir extends Direction> = NamespaceConfig<dir> & (Model extends "AT1130" ? MaybePartial<dir, {
    phy: MaybeReset<dir, AT1130PhyConfig<dir>>;
}> : {});
export type LiteralNetworkConfig<Model extends HardwareModel, dir extends Direction> = MaybeReset<dir, {
    [key in ManagementNamespace<Model> | ManagementNamespaceSuffix<Model> | MediaNamespace<Model> | MediaNamespaceSuffix<Model>]?: MaybeReset<dir, key extends MediaNamespace<Model> | MediaNamespaceSuffix<Model> ? MediaNamespaceConfig<Model, dir> : NamespaceConfig<dir>>;
}>;
export declare class NetworkConfig<Model extends HardwareModel, dir extends Direction> {
    private literal;
    constructor(literal: LiteralNetworkConfig<Model, dir>);
    as_literal(): MaybeReset<dir, { [key in ManagementNamespaceSuffix<Model> | `ns_${ManagementNamespaceSuffix<Model>}` | MediaNamespaceSuffix<Model> | `ns_${MediaNamespaceSuffix<Model>}`]?: MaybeReset<dir, key extends MediaNamespaceSuffix<Model> | `ns_${MediaNamespaceSuffix<Model>}` ? MediaNamespaceConfig<Model, dir> : MaybePartial<dir, {
        vlans: MaybeReset<dir, Record<number, VLANConfig<dir>>>;
        syslog: MaybeReset<dir, SyslogServer<dir>[]>;
    }>> | undefined; }>;
    filter_map(f: (x: MediaNamespaceConfig<Model, dir> | NamespaceConfig<dir>) => typeof x | undefined): NetworkConfig<Model, dir>;
}
export declare function do_upload_config(vsocket: VScript.VSocket, config: NetworkConfig<"AT1101", "write"> | NetworkConfig<"AT1130", "write"> | LiteralNetworkConfig<"AT1101", "write"> | LiteralNetworkConfig<"AT1130", "write">): Promise<{
    restart_required: boolean;
}>;
export declare function assemble_config_record(network_interfaces: VAPI.Any.NetworkInterfaces.All): Promise<NetworkConfig<"AT1101", "read"> | NetworkConfig<"AT1130", "read">>;
export {};
