import * as VScript from "vscript";
import * as VAPI from "./index.js";
import * as AE from "./toplevel/audioengine.js";
import { LiteralNetworkConfig, NetworkConfig } from "./toplevel/network_config.js";
export declare namespace Audio {
    const lift: {
        readonly Essence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Essence;
        readonly TimedSource: (_raw: [null | string, null | number | string], _socket: VScript.VSocket) => TimedSource;
    };
    const lower: {
        readonly Essence: (_x: Essence) => string;
        readonly TimedSource: (_x: {
            source: null | VAPI.AT1130.Audio.Essence;
            switch_time: null | VAPI.Primitives.Timestamp;
        }, _socket: VScript.VSocket) => [null | string, null | number | string];
    };
    class Essence implements VScript.Referenceable<"Audio::Data::Essence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Audio::Data::Essence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.Audio.Essence>;
        get sop_dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.Audio.Essence>;
        get channels(): VScript.rKeywordReferenceable<VScript.VSocket, "channels", null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel, Array<null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ]>, Array<null | VAPI.Audio.Channel>, "Audio::Data::Essence", VAPI.AT1130.Audio.Essence>;
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock(): VAPI.AT1130.Time.Source;
    }
    interface TimedSource {
        source: null | VAPI.AT1130.Audio.Essence;
        switch_time: null | VAPI.Primitives.Timestamp;
    }
}
export declare namespace AudioEngine {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Compressor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Compressor;
        readonly Delay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Delay;
        readonly DownMix: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DownMix;
        readonly Filter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Filter;
        readonly InputTrim: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InputTrim;
        readonly InputTrimInputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InputTrimInputs;
        readonly Loudness: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Loudness;
        readonly MidSide: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MidSide;
        readonly MonoMix: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MonoMix;
        readonly NMinus1: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => NMinus1;
        readonly StereoMix: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => StereoMix;
        readonly TruePeak: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => TruePeak;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Compressor: (_x: Compressor) => string;
        readonly Delay: (_x: Delay) => string;
        readonly DownMix: (_x: DownMix) => string;
        readonly Filter: (_x: Filter) => string;
        readonly InputTrim: (_x: InputTrim) => string;
        readonly InputTrimInputs: (_x: InputTrimInputs) => string;
        readonly Loudness: (_x: Loudness) => string;
        readonly MidSide: (_x: MidSide) => string;
        readonly MonoMix: (_x: MonoMix) => string;
        readonly NMinus1: (_x: NMinus1) => string;
        readonly StereoMix: (_x: StereoMix) => string;
        readonly TruePeak: (_x: TruePeak) => string;
    };
    class All implements VScript.Referenceable<"AudioEngine::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::All";
        get runtime_constants(): {
            readonly num_input_stages: number;
            readonly max_nminus1_instances: number;
            readonly max_mixer_instances: number;
            readonly max_delay_instances: number;
            readonly num_output_slices: number;
            readonly max_loudness_instances: number;
            readonly max_truepeak_instances: number;
            readonly max_inputs_per_stage: number;
            readonly max_compressor_instances: number;
            readonly max_filter_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get genlock(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Genlock.AT1130Genlock, null | VScript.Referenceable<"Genlock::Data::AT1130Genlock"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.All>;
        get groups(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::Group", VAPI.AudioEngine.GroupAsNamedTableRow>;
        get nminus1(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::NMinus1", NMinus1AsNamedTableRow>;
        get mono(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::MonoMix", MonoMixAsNamedTableRow>;
        get stereo(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::StereoMix", StereoMixAsNamedTableRow>;
        get filter(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::Filter", FilterAsNamedTableRow>;
        get delay(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::Delay", DelayAsNamedTableRow>;
        get truepeak(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::TruePeak", TruePeakAsNamedTableRow>;
        get loudness(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::Loudness", LoudnessAsNamedTableRow>;
        get compressor(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::Compressor", CompressorAsNamedTableRow>;
        get downmix(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::DownMix", DownMixAsNamedTableRow>;
        get midside(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::MidSide", MidSideAsNamedTableRow>;
        get inputtrim(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioEngine::Data::InputTrim", InputTrimAsNamedTableRow>;
        get info(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            [
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number
            ],
            null | [
                [
                    number,
                    number
                ],
                [
                    number,
                    number
                ]
            ],
            [
                null | [
                    number,
                    number
                ],
                null | [
                    number,
                    number
                ],
                null | [
                    number,
                    number
                ]
            ],
            null | [
                [
                    number,
                    number
                ],
                [
                    number,
                    number
                ],
                [
                    number,
                    number
                ]
            ]
        ], null | VAPI.AudioEngine.Info, VAPI.AT1130.AudioEngine.All>;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        create_stereo_mixer(pars: {
            group?: (VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>) | string;
            name: string;
            channel_strips: {
                capabilities: {
                    format?: "Mono" | "Stereo";
                    hpf?: boolean;
                    gate?: boolean;
                    compressor?: boolean;
                    eq?: "None" | "3-Band" | "4-Band";
                };
                count: number;
            }[];
        }): Promise<StereoMixAsNamedTableRow>;
        find_audio_source(dst: AE.AudioRef1130): {
            src: NMinus1AsNamedTableRow | MonoMixAsNamedTableRow | StereoMixAsNamedTableRow | FilterAsNamedTableRow | DelayAsNamedTableRow | CompressorAsNamedTableRow;
            ch: number;
        } | null;
    }
    class Compressor implements VScript.Referenceable<"AudioEngine::Data::Compressor"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::Compressor";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.Compressor>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            ([0, [boolean]] | [
                1,
                []
            ]),
            boolean
        ], null | [
            number,
            ([0, [boolean]] | [
                1,
                []
            ]),
            boolean
        ], null | VAPI.AudioEngine.CompressorCapabilities, null | VAPI.AudioEngine.CompressorCapabilities, VAPI.AT1130.AudioEngine.Compressor>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.Compressor>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.Compressor>;
        get control(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.CompressorSource, null | VScript.Referenceable<"AudioEngine::Data::CompressorSource"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.Compressor>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.CompressorIssues, VAPI.AT1130.AudioEngine.Compressor>;
        get curve(): VScript.rwKeyword<VScript.VSocket, ([
            0,
            [
                number,
                number,
                number
            ]
        ] | [
            1,
            [
                number,
                number
            ]
        ] | [
            2,
            [
                number,
                number,
                number
            ]
        ] | [
            3,
            [
                number,
                number
            ]
        ] | [
            4,
            [
                number,
                number,
                number,
                number
            ]
        ]), ([
            0,
            [
                number,
                number,
                number
            ]
        ] | [
            1,
            [
                number,
                number
            ]
        ] | [
            2,
            [
                number,
                number,
                number
            ]
        ] | [
            3,
            [
                number,
                number
            ]
        ] | [
            4,
            [
                number,
                number,
                number,
                number
            ]
        ]), VAPI.AudioEngine.CompressorCurve, VAPI.AudioEngine.CompressorCurve, VAPI.AT1130.AudioEngine.Compressor>;
        get curve_points(): VScript.rKeyword<VScript.VSocket, Array<[
            number,
            number,
            null | number
        ]>, Array<VAPI.AudioEngine.CompressorCurvePoint>, VAPI.AT1130.AudioEngine.Compressor>;
        get params(): VScript.rwKeyword<VScript.VSocket, [
            ([0, [number]] | [
                1,
                [number]
            ]),
            ([0, [number]] | [
                1,
                [number]
            ]),
            ([0, [number]] | [
                1,
                [number]
            ]),
            number
        ], [
            ([0, [number]] | [
                1,
                [number]
            ]),
            ([0, [number]] | [
                1,
                [number]
            ]),
            ([0, [number]] | [
                1,
                [number]
            ]),
            number
        ], VAPI.AudioEngine.CompressorParameter, VAPI.AudioEngine.CompressorParameter, VAPI.AT1130.AudioEngine.Compressor>;
        get bandpass(): VScript.rwKeyword<VScript.VSocket, [
            boolean,
            [
                number,
                number
            ],
            [
                number,
                number
            ]
        ], [
            boolean,
            [
                number,
                number
            ],
            [
                number,
                number
            ]
        ], VAPI.AudioEngine.CompressorBandpass, VAPI.AudioEngine.CompressorBandpass, VAPI.AT1130.AudioEngine.Compressor>;
        get lookahead(): VScript.rwKeyword<VScript.VSocket, [
            boolean,
            ([0, [number]] | [
                1,
                [number]
            ])
        ], [
            boolean,
            ([0, [number]] | [
                1,
                [number]
            ])
        ], VAPI.AudioEngine.CompressorLookahead, VAPI.AudioEngine.CompressorLookahead, VAPI.AT1130.AudioEngine.Compressor>;
        get current_gain(): VScript.rKeyword<VScript.VSocket, number, VAPI.Audio.PeakMeter, VAPI.AT1130.AudioEngine.Compressor>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class CompressorAsNamedTableRow extends Compressor {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Delay implements VScript.Referenceable<"AudioEngine::Data::Delay"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::Delay";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.Delay>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            number
        ], null | [
            number,
            number
        ], null | VAPI.AudioEngine.DelayCapabilities, null | VAPI.AudioEngine.DelayCapabilities, VAPI.AT1130.AudioEngine.Delay>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.Delay>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.Delay>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.DelayIssues, VAPI.AT1130.AudioEngine.Delay>;
        get delay(): VScript.rwKeyword<VScript.VSocket, Array<([0, [number]] | [
            1,
            [number]
        ])>, VScript.MaybeSparseArray<([0, [number]] | [1, [number]])>, Array<VAPI.AudioEngine.DelayParameter>, VScript.MaybeSparseArray<VAPI.AudioEngine.DelayParameter>, VAPI.AT1130.AudioEngine.Delay>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class DelayAsNamedTableRow extends Delay {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DownMix implements VScript.Referenceable<"AudioEngine::Data::DownMix"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::DownMix";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.DownMix>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [VAPI.AudioEngine.DownMixCapabilitiesChannels], null | [VAPI.AudioEngine.DownMixCapabilitiesChannels], null | VAPI.AudioEngine.DownMixCapabilities, null | VAPI.AudioEngine.DownMixCapabilities, VAPI.AT1130.AudioEngine.DownMix>;
        /**
          Channel order:
          
          0: Left
          
          1: Right
          
          2: Center
          
          3: LFE
          
          4: Surround Left
          
          5: Surround Right
          
          6: Surround Back Left
          
          7: Surround Back Right
          
          8: Top Left
          
          9: Top Right
          
          10: Top Back Left
          
          11: Top Back Right
        */
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.DownMix>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioEngine.DownMix>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.DownMix>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.DownMixIssues, VAPI.AT1130.AudioEngine.DownMix>;
        get levels(): VScript.rwKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number
        ], [
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number
        ], VAPI.AudioEngine.DownMixLevels, VAPI.AudioEngine.DownMixLevels, VAPI.AT1130.AudioEngine.DownMix>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class DownMixAsNamedTableRow extends DownMix {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Filter implements VScript.Referenceable<"AudioEngine::Data::Filter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::Filter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.Filter>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            number
        ], null | [
            number,
            number
        ], null | VAPI.AudioEngine.FilterCapabilities, null | VAPI.AudioEngine.FilterCapabilities, VAPI.AT1130.AudioEngine.Filter>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.Filter>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.Filter>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.FilterIssues, VAPI.AT1130.AudioEngine.Filter>;
        get bands(): VScript.StronglyTypedTable<VScript.VSocket, "AudioEngine::Data::Filter::Bands", VAPI.AudioEngine.FilterBands>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class FilterAsNamedTableRow extends Filter {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class InputTrim implements VScript.Referenceable<"AudioEngine::Data::InputTrim"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::InputTrim";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.InputTrim>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [number], null | [number], null | VAPI.AudioEngine.InputTrimCapabilities, null | VAPI.AudioEngine.InputTrimCapabilities, VAPI.AT1130.AudioEngine.InputTrim>;
        get a(): InputTrimInputs;
        get b(): InputTrimInputs;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.InputTrimIssues, VAPI.AT1130.AudioEngine.InputTrim>;
        get src(): VScript.rwKeyword<VScript.VSocket, VAPI.AudioEngine.InputTrimSrc, VAPI.AudioEngine.InputTrimSrc, VAPI.AudioEngine.InputTrimSrc, VAPI.AudioEngine.InputTrimSrc, VAPI.AT1130.AudioEngine.InputTrim>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.AudioEngine.InputTrim>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(inp: "A" | "B", src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class InputTrimAsNamedTableRow extends InputTrim {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class InputTrimInputs implements VScript.Referenceable<"AudioEngine::Data::InputTrimInputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::InputTrimInputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.InputTrimInputs>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioEngine.InputTrimInputs>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.InputTrimInputs>;
        get gain(): VScript.rwKeyword<VScript.VSocket, Array<number>, VScript.MaybeSparseArray<number>, Array<VAPI.AudioEngine.FaderGain>, VScript.MaybeSparseArray<VAPI.AudioEngine.FaderGain>, VAPI.AT1130.AudioEngine.InputTrimInputs>;
        get master(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.AudioEngine.FaderGain, VAPI.AudioEngine.FaderGain, VAPI.AT1130.AudioEngine.InputTrimInputs>;
    }
    class Loudness implements VScript.Referenceable<"AudioEngine::Data::Loudness"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::Loudness";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.Loudness>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            number,
            boolean
        ], null | [
            number,
            number,
            boolean
        ], null | VAPI.AudioEngine.LoudnessCapabilities, null | VAPI.AudioEngine.LoudnessCapabilities, VAPI.AT1130.AudioEngine.Loudness>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.Loudness>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.Loudness>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.LoudnessIssues, VAPI.AT1130.AudioEngine.Loudness>;
        get measurement(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.AudioEngine.LoudnessMeasurement, VAPI.AT1130.AudioEngine.Loudness>;
        get active(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioEngine.Loudness>;
        /**
          Reset
        */
        get reset(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioEngine.Loudness>;
        get compressor_control(): VAPI.AudioEngine.CompressorSource;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class LoudnessAsNamedTableRow extends Loudness {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class MidSide implements VScript.Referenceable<"AudioEngine::Data::MidSide"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::MidSide";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.MidSide>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [VAPI.AudioEngine.MidSideCapabilitiesInputMode], null | [VAPI.AudioEngine.MidSideCapabilitiesInputMode], null | VAPI.AudioEngine.MidSideCapabilities, null | VAPI.AudioEngine.MidSideCapabilities, VAPI.AT1130.AudioEngine.MidSide>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.MidSide>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioEngine.MidSide>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.MidSide>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.MidSideIssues, VAPI.AT1130.AudioEngine.MidSide>;
        get params(): VScript.rwKeyword<VScript.VSocket, [
            number,
            number,
            number
        ], [
            number,
            number,
            number
        ], VAPI.AudioEngine.MidSideParams, VAPI.AudioEngine.MidSideParams, VAPI.AT1130.AudioEngine.MidSide>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class MidSideAsNamedTableRow extends MidSide {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class MonoMix implements VScript.Referenceable<"AudioEngine::Data::MonoMix"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::MonoMix";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.MonoMix>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            boolean
        ], null | [
            number,
            boolean
        ], null | VAPI.AudioEngine.MonoMixCapabilities, null | VAPI.AudioEngine.MonoMixCapabilities, VAPI.AT1130.AudioEngine.MonoMix>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.MonoMix>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioEngine.MonoMix>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.MonoMix>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.MonoMixIssues, VAPI.AT1130.AudioEngine.MonoMix>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.AudioEngine.MonoMix>;
        get faders(): VScript.StronglyTypedTable<VScript.VSocket, "AudioEngine::Data::Fader", VAPI.AudioEngine.Fader>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class MonoMixAsNamedTableRow extends MonoMix {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class NMinus1 implements VScript.Referenceable<"AudioEngine::Data::NMinus1"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::NMinus1";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.NMinus1>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [number], null | [number], null | VAPI.AudioEngine.NMinus1Capabilities, null | VAPI.AudioEngine.NMinus1Capabilities, VAPI.AT1130.AudioEngine.NMinus1>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.NMinus1>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioEngine.NMinus1>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.NMinus1>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.NMinus1Issues, VAPI.AT1130.AudioEngine.NMinus1>;
        get faders(): VScript.StronglyTypedTable<VScript.VSocket, "AudioEngine::Data::Fader", VAPI.AudioEngine.Fader>;
        get output(): VScript.StronglyTypedTable<VScript.VSocket, "Audio::Data::Essence", VAPI.AT1130.Audio.Essence>;
    }
    class NMinus1AsNamedTableRow extends NMinus1 {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class StereoMix implements VScript.Referenceable<"AudioEngine::Data::StereoMix"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::StereoMix";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.StereoMix>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            boolean
        ], null | [
            number,
            boolean
        ], null | VAPI.AudioEngine.StereoMixCapabilities, null | VAPI.AudioEngine.StereoMixCapabilities, VAPI.AT1130.AudioEngine.StereoMix>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<Array<null | string>>, VScript.MaybeSparseArray<Array<null | string>>, Array<Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>>, VScript.MaybeSparseArray<Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>>, VAPI.AT1130.AudioEngine.StereoMix>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<Array<boolean>>, VScript.MaybeSparseArray<Array<boolean>>, Array<Array<boolean>>, VScript.MaybeSparseArray<Array<boolean>>, VAPI.AT1130.AudioEngine.StereoMix>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<Array<[number]>>, Array<Array<VAPI.AudioEngine.HWInputAssignment>>, VAPI.AT1130.AudioEngine.StereoMix>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.StereoMixIssues, VAPI.AT1130.AudioEngine.StereoMix>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<Array<number>>, Array<Array<VAPI.Audio.PeakMeter>>, VAPI.AT1130.AudioEngine.StereoMix>;
        get faders(): VScript.StronglyTypedTable<VScript.VSocket, "AudioEngine::Data::Fader", VAPI.AudioEngine.Fader>;
        get pan(): VScript.rwKeyword<VScript.VSocket, Array<([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [number]
        ] | [
            3,
            [number]
        ])>, VScript.MaybeSparseArray<([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [number]
        ] | [
            3,
            [number]
        ])>, Array<VAPI.AudioEngine.StereoPanBalance>, VScript.MaybeSparseArray<VAPI.AudioEngine.StereoPanBalance>, VAPI.AT1130.AudioEngine.StereoMix>;
        get output(): VAPI.AT1130.Audio.Essence;
        set_input(input: number, sources: (null | AE.AudioRef1130)[]): Promise<void>;
    }
    class StereoMixAsNamedTableRow extends StereoMix {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class TruePeak implements VScript.Referenceable<"AudioEngine::Data::TruePeak"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioEngine::Data::TruePeak";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioEngine.TruePeak>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [number], null | [number], null | VAPI.AudioEngine.TruePeakCapabilities, null | VAPI.AudioEngine.TruePeakCapabilities, VAPI.AT1130.AudioEngine.TruePeak>;
        get inputs(): VScript.rwKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioEngine.TruePeak>;
        get hw_inputs(): VScript.rKeyword<VScript.VSocket, Array<[number]>, Array<VAPI.AudioEngine.HWInputAssignment>, VAPI.AT1130.AudioEngine.TruePeak>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioEngine.TruePeakIssues, VAPI.AT1130.AudioEngine.TruePeak>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.AudioEngine.TruePeak>;
        get peak_hold(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.AudioEngine.TruePeak>;
        get peak_hold_time(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VScript.Duration, null | VScript.Duration, VAPI.AT1130.AudioEngine.TruePeak>;
        /**
          Reset
        */
        get reset(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioEngine.TruePeak>;
        get compressor_control(): VAPI.AudioEngine.CompressorSource;
        set_input(src: null | VAPI.AT1130.Audio.Essence | (null | AE.AudioRef1130)[], pars?: {
            start?: number;
            channels?: number;
        }): Promise<void>;
    }
    class TruePeakAsNamedTableRow extends TruePeak {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace AudioGain {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Levels: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Levels;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Levels: (_x: Levels) => string;
    };
    class All implements VScript.Referenceable<"AudioGain::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioGain::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioGain::Data::Levels", LevelsAsNamedTableRow>;
    }
    class Levels implements VScript.Referenceable<"AudioGain::Data::Levels"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioGain::Data::Levels";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioGain.Levels>;
        get levels(): VScript.rwKeyword<VScript.VSocket, Array<number>, VScript.MaybeSparseArray<number>, Array<number>, VScript.MaybeSparseArray<number>, VAPI.AT1130.AudioGain.Levels>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.AudioGain.Levels>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class LevelsAsNamedTableRow extends Levels {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace AudioMixer {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly ChannelMono: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelMono;
        readonly ChannelSelection: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelSelection;
        readonly ChannelStereo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelStereo;
        readonly Downmixes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Downmixes;
        readonly Mode51: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Mode51;
        readonly Mode71: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Mode71;
        readonly Monos: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Monos;
        readonly Source: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Source;
        readonly SourceStereo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SourceStereo;
        readonly Stereos: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Stereos;
        readonly StereosOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => StereosOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly ChannelMono: (_x: ChannelMono) => string;
        readonly ChannelSelection: (_x: ChannelSelection) => string;
        readonly ChannelStereo: (_x: ChannelStereo) => string;
        readonly Downmixes: (_x: Downmixes) => string;
        readonly Mode51: (_x: Mode51) => string;
        readonly Mode71: (_x: Mode71) => string;
        readonly Monos: (_x: Monos) => string;
        readonly Source: (_x: Source) => string;
        readonly SourceStereo: (_x: SourceStereo) => string;
        readonly Stereos: (_x: Stereos) => string;
        readonly StereosOutput: (_x: StereosOutput) => string;
    };
    class All implements VScript.Referenceable<"AudioMixer::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::All";
        get runtime_constants(): {
            readonly num_audio_mixer_fader: number;
            readonly num_audio_mixer_outputs: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          @brief Defragment
          @desc Repeated allocation and deallocation of differently sized mixers
          can cause fader fragmentation. Press this button to defragment, but
          please note that _this will temporarily interrupt all outputs currently
          in use_.
        */
        get reorder_output(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioMixer.All>;
        get mono_mixes(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Monos", MonosAsNamedTableRow>;
        get stereo_mixes(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Stereos", StereosAsNamedTableRow>;
        get down_mixes(): Downmixes;
        get resource_status(): VAPI.AudioMixer.ResourceStatus;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class ChannelMono implements VScript.Referenceable<"AudioMixer::Data::ChannelMono"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelMono";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.ChannelMono>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelMono>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelMono>;
        get pan(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.ChannelMono>;
        get source(): Source;
    }
    class ChannelMonoAsNamedTableRow extends ChannelMono {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class ChannelSelection implements VScript.Referenceable<"AudioMixer::Data::ChannelSelection"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelSelection";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.ChannelSelection>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelSelection>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelSelection>;
        get source(): Source;
    }
    class ChannelSelectionAsNamedTableRow extends ChannelSelection {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class ChannelStereo implements VScript.Referenceable<"AudioMixer::Data::ChannelStereo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelStereo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.ChannelStereo>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelStereo>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.ChannelStereo>;
        get balance(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.ChannelStereo>;
        get source(): SourceStereo;
    }
    class ChannelStereoAsNamedTableRow extends ChannelStereo {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Downmixes implements VScript.Referenceable<"AudioMixer::Data::Downmixes"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Downmixes";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode_5_1(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Mode51", Mode51AsNamedTableRow>;
        get mode_7_1(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Mode71", Mode71AsNamedTableRow>;
    }
    class Mode51 implements VScript.Referenceable<"AudioMixer::Data::Mode51"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Mode51";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get front_left(): ChannelSelection;
        get front_right(): ChannelSelection;
        get center(): ChannelSelection;
        get lfe(): ChannelSelection;
        get rear_surround_left(): ChannelSelection;
        get rear_surround_right(): ChannelSelection;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class Mode51AsNamedTableRow extends Mode51 {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Mode71 implements VScript.Referenceable<"AudioMixer::Data::Mode71"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Mode71";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get front_left(): ChannelSelection;
        get front_right(): ChannelSelection;
        get center(): ChannelSelection;
        get surround_left(): ChannelSelection;
        get surround_right(): ChannelSelection;
        get lfe(): ChannelSelection;
        get rear_surround_left(): ChannelSelection;
        get rear_surround_right(): ChannelSelection;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class Mode71AsNamedTableRow extends Mode71 {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Monos implements VScript.Referenceable<"AudioMixer::Data::Monos"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Monos";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channels(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelSelection", ChannelSelectionAsNamedTableRow>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class MonosAsNamedTableRow extends Monos {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Source implements VScript.Referenceable<"AudioMixer::Data::Source"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Source";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.Source>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioMixer.Source>;
    }
    class SourceStereo implements VScript.Referenceable<"AudioMixer::Data::SourceStereo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::SourceStereo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel_left(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.SourceStereo>;
        get channel_right(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.SourceStereo>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioMixer.SourceStereo>;
    }
    class Stereos implements VScript.Referenceable<"AudioMixer::Data::Stereos"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Stereos";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mono_channels(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelMono", ChannelMonoAsNamedTableRow>;
        get stereo_pairs(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelStereo", ChannelStereoAsNamedTableRow>;
        get output(): StereosOutput;
    }
    class StereosAsNamedTableRow extends Stereos {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class StereosOutput implements VScript.Referenceable<"AudioMixer::Data::Stereos::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Stereos::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Reset to default
        */
        get reset_to_default(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioMixer.StereosOutput>;
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioMixer.StereosOutput>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioMixer.StereosOutput>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
}
export declare namespace AudioRePlay {
    const lift: {
        readonly Audio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Audio;
        readonly Buffer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Buffer;
        readonly Delay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Delay;
        readonly DelayOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayOutput;
        readonly Player: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Player;
        readonly PlayerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PlayerOutput;
        readonly RelationAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudio;
        readonly RelationVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideo;
        readonly Relations: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Relations;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly RelationAudioFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudioFollowers;
        readonly RelationVideoFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideoFollowers;
        readonly DelayInputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayInputs;
    };
    const lower: {
        readonly Audio: (_x: Audio) => string;
        readonly Buffer: (_x: Buffer) => string;
        readonly Delay: (_x: Delay) => string;
        readonly DelayOutput: (_x: DelayOutput) => string;
        readonly Player: (_x: Player) => string;
        readonly PlayerOutput: (_x: PlayerOutput) => string;
        readonly RelationAudio: (_x: RelationAudio) => string;
        readonly RelationVideo: (_x: RelationVideo) => string;
        readonly Relations: (_x: Relations) => string;
        readonly Time: (_x: Time) => string;
        readonly RelationAudioFollowers: (_x: RelationAudioFollowers) => string;
        readonly RelationVideoFollowers: (_x: RelationVideoFollowers) => string;
        readonly DelayInputs: (_x: DelayInputs) => string;
    };
    class Audio implements VScript.Referenceable<"AudioRePlay::Data::Audio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Audio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.DataRePlay.MemoryInfo;
        get players(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioRePlay::Data::Player", PlayerAsNamedTableRow>;
        get delays(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioRePlay::Data::Delay", DelayAsNamedTableRow>;
        get statistics(): VAPI.DataRePlay.Statistic;
        get ecc(): VAPI.Memory.ECCMuxStatistics;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class Buffer implements VScript.Referenceable<"AudioRePlay::Data::Buffer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Buffer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get offset(): VScript.dKeyword<VScript.VSocket, null | ([0, [number]] | [
            1,
            [number]
        ]), null | ([0, [number]] | [
            1,
            [number]
        ]), null | VAPI.AudioRePlay.AllocationMode, null | VAPI.AudioRePlay.AllocationMode, VAPI.AT1130.AudioRePlay.Buffer>;
        get audio_follow_video(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioRePlay.Buffer>;
        get auto_dolby_e_aligner(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.AudioRePlay.Buffer>;
        get measurement_reference(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioRePlay.Buffer>;
        get current_delay(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.AudioRePlay.BufferCurrentDelay, VAPI.AT1130.AudioRePlay.Buffer>;
    }
    class Delay implements VScript.Referenceable<"AudioRePlay::Data::Delay"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Delay";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioRePlay.DelayIssues, VAPI.AT1130.AudioRePlay.Delay>;
        get capabilities(): VAPI.AudioRePlay.BufferInput;
        get num_outputs(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.AudioRePlay.Delay>;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioRePlay.Delay>;
        get dolby_e(): VAPI.AudioRePlay.DolbyE;
        get inputs(): DelayInputs;
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::DelayOutput", DelayOutput>;
    }
    class DelayAsNamedTableRow extends Delay {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DelayOutput implements VScript.Referenceable<"AudioRePlay::Data::DelayOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::DelayOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.AudioRePlay.DelayOutput>;
        get time(): Time;
        get delay(): Buffer;
        get afv(): VAPI.AudioRePlay.AFVRef;
        get dolby_e(): VAPI.AudioRePlay.DolbyERef;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Reader", VAPI.AudioRePlay.Reader>;
        get audio(): VAPI.AT1130.Audio.Essence;
    }
    class Player implements VScript.Referenceable<"AudioRePlay::Data::Player"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Player";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioRePlay.PlayerIssues, VAPI.AT1130.AudioRePlay.Player>;
        get upload_header(): VAPI.AudioRePlay.UploadHeader;
        get capabilities(): VAPI.AudioRePlay.BufferInput;
        get gang(): Relations;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.AudioRePlay.Player>;
        get output(): PlayerOutput;
    }
    class PlayerAsNamedTableRow extends Player {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class PlayerOutput implements VScript.Referenceable<"AudioRePlay::Data::PlayerOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::PlayerOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.AudioRePlay.PlayerOutput>;
        get time(): Time;
        get control(): VAPI.AudioRePlay.Control;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Reader", VAPI.AudioRePlay.Reader>;
        get audio(): VAPI.AT1130.Audio.Essence;
    }
    class RelationAudio implements VScript.Referenceable<"AudioRePlay::Data::RelationAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.AudioRePlay.Player, null | VScript.Referenceable<"AudioRePlay::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioRePlay.RelationAudio>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::RelationAudio::Followers", RelationAudioFollowers>;
    }
    class RelationVideo implements VScript.Referenceable<"AudioRePlay::Data::RelationVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.VideoPlayer.Player, null | VScript.Referenceable<"VideoPlayer::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioRePlay.RelationVideo>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::RelationVideo::Followers", RelationVideoFollowers>;
    }
    class Relations implements VScript.Referenceable<"AudioRePlay::Data::Relations"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Relations";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): RelationVideo;
        get audio(): RelationAudio;
    }
    class Time implements VScript.Referenceable<"AudioRePlay::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioRePlay.Time>;
    }
    class RelationAudioFollowers implements VScript.Referenceable<"AudioRePlay::Data::RelationAudio::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationAudio::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.AudioRePlay.Player, VAPI.AT1130.AudioRePlay.RelationAudioFollowers>;
    }
    class RelationVideoFollowers implements VScript.Referenceable<"AudioRePlay::Data::RelationVideo::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationVideo::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.VideoPlayer.Player, VAPI.AT1130.AudioRePlay.RelationVideoFollowers>;
    }
    class DelayInputs implements VScript.Referenceable<"AudioRePlay::Data::Delay::Inputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Delay::Inputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.AudioRePlay.DelayInputs>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioRePlay.DelayInputs>;
        get writer(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Writer", VAPI.AudioRePlay.Writer>;
    }
}
export declare namespace AudioShuffler {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Shuffler: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Shuffler;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Shuffler: (_x: Shuffler) => string;
    };
    class All implements VScript.Referenceable<"AudioShuffler::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioShuffler::Data::All";
        get runtime_constants(): {
            readonly num_shuffler_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_cross_fade(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VScript.Duration, null | VScript.Duration, VAPI.AT1130.AudioShuffler.All>;
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioShuffler::Data::Shuffler", ShufflerAsNamedTableRow>;
    }
    class Shuffler implements VScript.Referenceable<"AudioShuffler::Data::Shuffler"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioShuffler::Data::Shuffler";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get genlock(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Genlock.AT1130Genlock, null | VScript.Referenceable<"Genlock::Data::AT1130Genlock"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioShuffler.Shuffler>;
        get a_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1130.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1130.AudioShuffler.Shuffler>;
        get cross_fade(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VScript.Duration, null | VScript.Duration, VAPI.AT1130.AudioShuffler.Shuffler>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class ShufflerAsNamedTableRow extends Shuffler {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace AudioSignalGenerator {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly OUT: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => OUT;
        readonly OUTS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => OUTS;
        readonly AllAlsa: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllAlsa;
        readonly AllGenlock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllGenlock;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly OUT: (_x: OUT) => string;
        readonly OUTS: (_x: OUTS) => string;
        readonly AllAlsa: (_x: AllAlsa) => string;
        readonly AllGenlock: (_x: AllGenlock) => string;
    };
    class All implements VScript.Referenceable<"AudioSignalGenerator::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::All";
        get runtime_constants(): {
            readonly num_alsa_interfaces: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get genlock(): VScript.StronglyTypedArray<VScript.VSocket, "AudioSignalGenerator::Data::All::Genlock", AllGenlock>;
        get alsa(): VScript.StronglyTypedArray<VScript.VSocket, "AudioSignalGenerator::Data::All::Alsa", AllAlsa>;
    }
    class OUT implements VScript.Referenceable<"AudioSignalGenerator::Data::OUT"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::OUT";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get level(): VScript.dKeyword<VScript.VSocket, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.AT1130.AudioSignalGenerator.OUT>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class OUTS implements VScript.Referenceable<"AudioSignalGenerator::Data::OUTS"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::OUTS";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get signal_silence(): VAPI.AT1130.Audio.Essence;
        get signal_400hz(): OUT;
        get signal_440hz(): OUT;
        get signal_1000hz(): OUT;
        get source_slice(): VAPI.Audio.SignalSourceSlice;
    }
    class AllAlsa implements VScript.Referenceable<"AudioSignalGenerator::Data::All::Alsa"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::All::Alsa";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get output(): VAPI.AT1130.Audio.Essence;
        get source_slice(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.AudioSignalGenerator.AllAlsa>;
    }
    class AllGenlock implements VScript.Referenceable<"AudioSignalGenerator::Data::All::Genlock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::All::Genlock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get f48000(): OUTS;
        get f96000(): OUTS;
    }
}
export declare namespace Cluster {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly ClusterGlobal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterGlobal;
        readonly ClusterGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterGlobalRuntime;
        readonly ClusterLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterLocal;
        readonly ClusterLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterLocalRuntime;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly ClusterGlobal: (_x: ClusterGlobal) => string;
        readonly ClusterGlobalRuntime: (_x: ClusterGlobalRuntime) => string;
        readonly ClusterLocal: (_x: ClusterLocal) => string;
        readonly ClusterLocalRuntime: (_x: ClusterLocalRuntime) => string;
    };
    class All implements VScript.Referenceable<"Cluster::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global(): ClusterGlobal;
        get local(): ClusterLocal;
    }
    class ClusterGlobal implements VScript.Referenceable<"Cluster::Data::ClusterGlobal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterGlobal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get configuration(): VAPI.Cluster.ClusterGlobalConfiguration;
        get runtime(): ClusterGlobalRuntime;
    }
    class ClusterGlobalRuntime implements VScript.Referenceable<"Cluster::Data::ClusterGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get connected_to_myself(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.Cluster.ClusterGlobalRuntime>;
        get nodes(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterNodes::Data::ClusterNodeGlobalRuntime", VAPI.ClusterNodes.ClusterNodeGlobalRuntime>;
        get sources(): VAPI.AT1130.ClusterSources.ClusterSourcesGlobalRuntime;
        get outputs(): VAPI.ClusterOutputs.ClusterOutputsGlobalRuntime;
        get monitoring_objects(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime", VAPI.AT1130.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
    }
    class ClusterLocal implements VScript.Referenceable<"Cluster::Data::ClusterLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get runtime(): ClusterLocalRuntime;
    }
    class ClusterLocalRuntime implements VScript.Referenceable<"Cluster::Data::ClusterLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get processors(): VAPI.AT1130.ClusterProcessors.ClusterProcessorsLocalRuntime;
        get statistics(): VAPI.Cluster.ClusterStatistics;
    }
}
export declare namespace ClusterMonitoringObjects {
    const lift: {
        readonly ClusterAudioMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioMonitoringObjectRuntime;
        readonly ClusterMetadataMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataMonitoringObjectRuntime;
        readonly ClusterMonitoringObjectGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMonitoringObjectGlobalRuntime;
        readonly ClusterVideoMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoMonitoringObjectRuntime;
    };
    const lower: {
        readonly ClusterAudioMonitoringObjectRuntime: (_x: ClusterAudioMonitoringObjectRuntime) => string;
        readonly ClusterMetadataMonitoringObjectRuntime: (_x: ClusterMetadataMonitoringObjectRuntime) => string;
        readonly ClusterMonitoringObjectGlobalRuntime: (_x: ClusterMonitoringObjectGlobalRuntime) => string;
        readonly ClusterVideoMonitoringObjectRuntime: (_x: ClusterVideoMonitoringObjectRuntime) => string;
    };
    class ClusterAudioMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime, VAPI.AT1130.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntimeAlarms, VAPI.AT1130.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime>;
    }
    class ClusterMetadataMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime, VAPI.AT1130.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntimeAlarms, VAPI.AT1130.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime>;
    }
    class ClusterMonitoringObjectGlobalRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get alarm(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
        get alarm_severity_level(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterMonitoringObjects.SeverityLevel, VAPI.AT1130.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
        get video(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime", ClusterVideoMonitoringObjectRuntime>;
        get audio(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime", ClusterAudioMonitoringObjectRuntime>;
        get metadata(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime", ClusterMetadataMonitoringObjectRuntime>;
        get user_labels(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterSources::Data::ClusterSourceLabelDual", VAPI.ClusterSources.ClusterSourceLabelDual>;
        get configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration, VAPI.AT1130.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
    }
    class ClusterVideoMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime, VAPI.AT1130.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntimeAlarms, VAPI.AT1130.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.TUnsignedMax, VAPI.ClusterMonitoringObjects.TUnsignedMax, VAPI.AT1130.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
    }
}
export declare namespace ClusterProcessors {
    const lift: {
        readonly ClusterProcessorMipMapsDualOutputRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorMipMapsDualOutputRuntime;
        readonly ClusterProcessorMipMapsDualOutputRuntimeSource: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorMipMapsDualOutputRuntimeSource;
        readonly ClusterProcessorsLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsLocalRuntime;
        readonly ClusterProcessorsMetadataRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsMetadataRuntime;
        readonly ClusterProcessorsMipMapsRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsMipMapsRuntime;
    };
    const lower: {
        readonly ClusterProcessorMipMapsDualOutputRuntime: (_x: ClusterProcessorMipMapsDualOutputRuntime) => string;
        readonly ClusterProcessorMipMapsDualOutputRuntimeSource: (_x: ClusterProcessorMipMapsDualOutputRuntimeSource) => string;
        readonly ClusterProcessorsLocalRuntime: (_x: ClusterProcessorsLocalRuntime) => string;
        readonly ClusterProcessorsMetadataRuntime: (_x: ClusterProcessorsMetadataRuntime) => string;
        readonly ClusterProcessorsMipMapsRuntime: (_x: ClusterProcessorsMipMapsRuntime) => string;
    };
    class ClusterProcessorMipMapsDualOutputRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get local_sources(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource", ClusterProcessorMipMapsDualOutputRuntimeSource>;
    }
    class ClusterProcessorMipMapsDualOutputRuntimeSource implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get full_size(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get source_sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get input_primary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get input_secondary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get output_primary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get output_secondary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        /**
          IP address of the mipmap RTP stream
        */
        get output_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        /**
          IP address of the secondary mipmap RTP stream
        */
        get output_secondary_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get crossbar_select(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
    }
    class ClusterProcessorsLocalRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mipmaps(): ClusterProcessorsMipMapsRuntime;
        get metadata(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime", ClusterProcessorsMetadataRuntime>;
        get ppms(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorsPPMSRuntime", VAPI.ClusterProcessors.ClusterProcessorsPPMSRuntime>;
    }
    class ClusterProcessorsMetadataRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsMetadataRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime, VAPI.AT1130.ClusterProcessors.ClusterProcessorsMetadataRuntime>;
    }
    class ClusterProcessorsMipMapsRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime", ClusterProcessorMipMapsDualOutputRuntime>;
        get inputs(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsInputRuntime", VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
    }
}
export declare namespace ClusterSources {
    const lift: {
        readonly ClusterAudioSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioSourceRuntime;
        readonly ClusterAudioSourceRuntimeLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioSourceRuntimeLocal;
        readonly ClusterMetadataSourceLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataSourceLocalRuntime;
        readonly ClusterMetadataSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataSourceRuntime;
        readonly ClusterSourcesGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterSourcesGlobalRuntime;
        readonly ClusterVideoSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoSourceRuntime;
        readonly ClusterVideoSourceRuntimeLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoSourceRuntimeLocal;
    };
    const lower: {
        readonly ClusterAudioSourceRuntime: (_x: ClusterAudioSourceRuntime) => string;
        readonly ClusterAudioSourceRuntimeLocal: (_x: ClusterAudioSourceRuntimeLocal) => string;
        readonly ClusterMetadataSourceLocalRuntime: (_x: ClusterMetadataSourceLocalRuntime) => string;
        readonly ClusterMetadataSourceRuntime: (_x: ClusterMetadataSourceRuntime) => string;
        readonly ClusterSourcesGlobalRuntime: (_x: ClusterSourcesGlobalRuntime) => string;
        readonly ClusterVideoSourceRuntime: (_x: ClusterVideoSourceRuntime) => string;
        readonly ClusterVideoSourceRuntimeLocal: (_x: ClusterVideoSourceRuntimeLocal) => string;
    };
    class ClusterAudioSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get num_channels(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get peak_meters(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get local(): ClusterAudioSourceRuntimeLocal;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterSources.TUnsignedMax, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
        get bytes_per_second(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime>;
    }
    class ClusterAudioSourceRuntimeLocal implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceRuntimeLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceRuntimeLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio_essence(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Audio.Essence, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get used_channel_id_start(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get used_channels_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntimeLocal>;
    }
    class ClusterMetadataSourceLocalRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.ClusterSources.ClusterMetadataSourceLocalRuntime>;
        get time_source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Time.Source, VAPI.AT1130.ClusterSources.ClusterMetadataSourceLocalRuntime>;
        get closed_caption(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.Video.ClosedCaption, VAPI.AT1130.ClusterSources.ClusterMetadataSourceLocalRuntime>;
    }
    class ClusterMetadataSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.MetadataSourceID, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Source IP address of the metadata RTP stream
        */
        get src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Source IP address of the metadata RTP stream
        */
        get secondary_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Destination IP address of the metadata RTP stream
        */
        get dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Destination IP address of the metadata RTP stream
        */
        get secondary_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get local(): ClusterMetadataSourceLocalRuntime;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get time_code(): VScript.rKeyword<VScript.VSocket, [
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload
        ], VAPI.ClusterSources.TimestampedTimecode, VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime>;
        get closed_caption(): VAPI.ClusterSources.ClusterMetadataSourceCC;
    }
    class ClusterSourcesGlobalRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterSourcesGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterSourcesGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceRuntime", ClusterVideoSourceRuntime>;
        get audio(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterAudioSourceRuntime", ClusterAudioSourceRuntime>;
        get metadata(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterMetadataSourceRuntime", ClusterMetadataSourceRuntime>;
    }
    class ClusterVideoSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.VideoSourceID, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get video_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        /**
          Source IP address of the mipmap RTP stream
        */
        get resolution_levels_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        /**
          Source IP address of the mipmap RTP stream
        */
        get secondary_resolution_levels_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get resolution_levels(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceRuntimeResolutionLevel", VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
        get local(): ClusterVideoSourceRuntimeLocal;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterSources.TUnsignedMax, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime>;
    }
    class ClusterVideoSourceRuntimeLocal implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceRuntimeLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceRuntimeLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_essence(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Video.Essence, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntimeLocal>;
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntimeLocal>;
    }
}
export declare namespace ColorCorrection {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly CC1D: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => CC1D;
        readonly CC3D: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => CC3D;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly CC1D: (_x: CC1D) => string;
        readonly CC3D: (_x: CC3D) => string;
    };
    class All implements VScript.Referenceable<"ColorCorrection::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::All";
        get runtime_constants(): {
            readonly num_color_correction: number;
            readonly num_3d_color_correction: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get cc1d(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ColorCorrection::Data::CC1D", CC1DAsNamedTableRow>;
        get cc3d(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ColorCorrection::Data::CC3D", CC3DAsNamedTableRow>;
    }
    class CC1D implements VScript.Referenceable<"ColorCorrection::Data::CC1D"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::CC1D";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.ColorCorrection.CC1D>;
        get output(): VAPI.AT1130.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.ColorCorrection.CC1D>;
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema(): VScript.rwKeyword<VScript.VSocket, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.AT1130.ColorCorrection.CC1D>;
        /**
          When set changes the output color space to the specified one
        */
        get output_cs(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, VAPI.AT1130.ColorCorrection.CC1D>;
        get yuv(): VAPI.ColorCorrection.YUV;
        get rgb(): VAPI.ColorCorrection.CC1DRgb;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.ColorCorrection.CC1DIssues, VAPI.AT1130.ColorCorrection.CC1D>;
    }
    class CC1DAsNamedTableRow extends CC1D {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class CC3D implements VScript.Referenceable<"ColorCorrection::Data::CC3D"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::CC3D";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.ColorCorrection.CC3D>;
        get output(): VAPI.AT1130.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.ColorCorrection.CC3D>;
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema(): VScript.rwKeyword<VScript.VSocket, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.AT1130.ColorCorrection.CC3D>;
        get yuv(): VAPI.ColorCorrection.YUV;
        get lut_name(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.ColorCorrection.CC3D>;
        get lut_info(): VAPI.ColorCorrection.CC3DLutInfo;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.ColorCorrection.CC3DIssues, VAPI.AT1130.ColorCorrection.CC3D>;
    }
    class CC3DAsNamedTableRow extends CC3D {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace Definitions {
    const lift: {
        readonly AudioControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioControl;
        readonly TimecodeInserterBlank: (_raw: [], _socket: VScript.VSocket) => TimecodeInserterBlank;
        readonly TimecodeInserterFreerun: (_raw: [[boolean, boolean], [number, number, number, number]], _socket: VScript.VSocket) => TimecodeInserterFreerun;
        readonly TimecodeInserterGenerator: (_raw: [[boolean, boolean], null | string], _socket: VScript.VSocket) => TimecodeInserterGenerator;
        readonly TimecodeInserterPassthrough: (_raw: [], _socket: VScript.VSocket) => TimecodeInserterPassthrough;
        readonly TimecodeInserter: (_raw: ([0, []] | [1, []] | [2, [[boolean, boolean], [number, number, number, number]]] | [3, [[boolean, boolean], null | string]]), _socket: VScript.VSocket) => TimecodeInserter;
        readonly VancControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VancControl;
        readonly TimecodeInserterFreerunEnable: (_raw: [boolean, boolean], _socket: VScript.VSocket) => TimecodeInserterFreerunEnable;
        readonly TimecodeInserterGeneratorEnable: (_raw: [boolean, boolean], _socket: VScript.VSocket) => TimecodeInserterGeneratorEnable;
        readonly TimecodeInserterFreerunInitialTimecode: (_raw: [number, number, number, number], _socket: VScript.VSocket) => TimecodeInserterFreerunInitialTimecode;
    };
    const lower: {
        readonly AudioControl: (_x: AudioControl) => string;
        readonly TimecodeInserterBlank: (_x: {}, _socket: VScript.VSocket) => [];
        readonly TimecodeInserterFreerun: (_x: {
            enable: VAPI.AT1130.Definitions.TimecodeInserterFreerunEnable;
            initial_timecode: VAPI.AT1130.Definitions.TimecodeInserterFreerunInitialTimecode;
        }, _socket: VScript.VSocket) => [[boolean, boolean], [number, number, number, number]];
        readonly TimecodeInserterGenerator: (_x: {
            enable: VAPI.AT1130.Definitions.TimecodeInserterGeneratorEnable;
            t_src: null | VAPI.AT1130.Time.Source;
        }, _socket: VScript.VSocket) => [[boolean, boolean], null | string];
        readonly TimecodeInserterPassthrough: (_x: {}, _socket: VScript.VSocket) => [];
        readonly TimecodeInserter: (_x: ({
            variant: "Passthrough";
            value: VAPI.AT1130.Definitions.TimecodeInserterPassthrough;
        } | {
            variant: "Blank";
            value: VAPI.AT1130.Definitions.TimecodeInserterBlank;
        } | {
            variant: "Freerun";
            value: VAPI.AT1130.Definitions.TimecodeInserterFreerun;
        } | {
            variant: "Generator";
            value: VAPI.AT1130.Definitions.TimecodeInserterGenerator;
        }), _socket: VScript.VSocket) => ([0, []] | [1, []] | [2, [[boolean, boolean], [number, number, number, number]]] | [3, [[boolean, boolean], null | string]]);
        readonly VancControl: (_x: VancControl) => string;
        readonly TimecodeInserterFreerunEnable: (_x: {
            ltc: boolean;
            vitc: boolean;
        }, _socket: VScript.VSocket) => [boolean, boolean];
        readonly TimecodeInserterGeneratorEnable: (_x: {
            ltc: boolean;
            vitc: boolean;
        }, _socket: VScript.VSocket) => [boolean, boolean];
        readonly TimecodeInserterFreerunInitialTimecode: (_x: {
            hours: number;
            minutes: number;
            seconds: number;
            frames: number;
        }, _socket: VScript.VSocket) => [number, number, number, number];
    };
    class AudioControl implements VScript.Referenceable<"Definitions::Data::AudioControl"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Definitions::Data::AudioControl";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group_enable(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1130.Definitions.AudioControl>;
        get source(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.Definitions.AudioControl>;
    }
    interface TimecodeInserterBlank {
    }
    interface TimecodeInserterFreerun {
        enable: VAPI.AT1130.Definitions.TimecodeInserterFreerunEnable;
        initial_timecode: VAPI.AT1130.Definitions.TimecodeInserterFreerunInitialTimecode;
    }
    interface TimecodeInserterGenerator {
        enable: VAPI.AT1130.Definitions.TimecodeInserterGeneratorEnable;
        t_src: null | VAPI.AT1130.Time.Source;
    }
    interface TimecodeInserterPassthrough {
    }
    type TimecodeInserter = ({
        variant: "Passthrough";
        value: VAPI.AT1130.Definitions.TimecodeInserterPassthrough;
    } | {
        variant: "Blank";
        value: VAPI.AT1130.Definitions.TimecodeInserterBlank;
    } | {
        variant: "Freerun";
        value: VAPI.AT1130.Definitions.TimecodeInserterFreerun;
    } | {
        variant: "Generator";
        value: VAPI.AT1130.Definitions.TimecodeInserterGenerator;
    });
    class VancControl implements VScript.Referenceable<"Definitions::Data::VancControl"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Definitions::Data::VancControl";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get passthrough_c_y_0(): VScript.dKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.Definitions.BypassReplaceFlags, VAPI.Definitions.BypassReplaceFlags, VAPI.AT1130.Definitions.VancControl>;
        get timecode_inserter(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ] | [
            2,
            [
                [
                    boolean,
                    boolean
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ] | [
            3,
            [
                [
                    boolean,
                    boolean
                ],
                null | string
            ]
        ]), ([0, []] | [
            1,
            []
        ] | [
            2,
            [
                [
                    boolean,
                    boolean
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ] | [
            3,
            [
                [
                    boolean,
                    boolean
                ],
                null | string
            ]
        ]), VAPI.AT1130.Definitions.TimecodeInserter, VAPI.AT1130.Definitions.TimecodeInserter, VAPI.AT1130.Definitions.VancControl>;
        get afd_inserter(): VScript.rwKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ] | [
            2,
            [null | VAPI.Definitions.VANCAfdCode]
        ]), ([0, []] | [
            1,
            []
        ] | [
            2,
            [null | VAPI.Definitions.VANCAfdCode]
        ]), VAPI.Definitions.VANCAfdInserter, VAPI.Definitions.VANCAfdInserter, VAPI.AT1130.Definitions.VancControl>;
        get override_smpte_352_payload(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.Unsigned32, null | VAPI.Primitives.Unsigned32, VAPI.AT1130.Definitions.VancControl>;
    }
    interface TimecodeInserterFreerunEnable {
        ltc: boolean;
        vitc: boolean;
    }
    interface TimecodeInserterGeneratorEnable {
        ltc: boolean;
        vitc: boolean;
    }
    interface TimecodeInserterFreerunInitialTimecode {
        hours: number;
        minutes: number;
        seconds: number;
        frames: number;
    }
}
export declare namespace EthernetStats {
    const lift: {
        readonly PortStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatistics;
    };
    const lower: {
        readonly PortStatistics: (_x: PortStatistics) => string;
    };
    class PortStatistics implements VScript.Referenceable<"EthernetStats::Data::PortStatistics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "EthernetStats::Data::PortStatistics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Number of received frames less than 64 bytes and reporting a CRC error
        */
        get rx_fragments(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received oversized frames reporting a CRC error
        */
        get rx_jabbers(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received packets with FCS errors
        */
        get rx_fcserr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames with a frame of length at least 64, with CRC
          error
        */
        get rx_crcerr_okpkt(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored multicast frames received, excluding control frames
        */
        get rx_mcast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored broadcast frames received, excluding control frames
        */
        get rx_bcast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored unicast frames received, excluding control frames
        */
        get rx_ucast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored multicast control frames received
        */
        get rx_mcast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored broadcast control frames received
        */
        get rx_bcast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored unicast control frames received
        */
        get rx_ucast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored pause frames received
        */
        get rx_pause_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of 64-byte received frames, including the CRC field but excluding
          the preamble and SFD bytes
        */
        get rx_64b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 65-127 bytes
        */
        get rx_65to127b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 128-255 bytes
        */
        get rx_128to255b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 256-511 bytes
        */
        get rx_256to511b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 512 –1023 bytes
        */
        get rx_512to1023b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 1024–1518 bytes
        */
        get rx_1024to1518b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received frames between 1519-1536 bytes
        */
        get rx_1519to1536b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of oversized frames received
        */
        get rx_oversize(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid multicast frames received, excluding control frames
        */
        get rx_mcast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid broadcast frames received, excluding control frames
        */
        get rx_bcast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid unicast frames received, excluding control frames
        */
        get rx_ucast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid multicast frames received, excluding data frames
        */
        get rx_mcast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid broadcast frames received, excluding data frames
        */
        get rx_bcast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid unicast frames received, excluding data frames
        */
        get rx_ucast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received pause frames, with or without error
        */
        get rx_pause(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received runt packets
        */
        get rx_runt(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of RX frame starts
        */
        get rx_st(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of RX length errors
        */
        get rx_lenerr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of RX PFC frame with CRC error
        */
        get rx_pfc_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of RX PFC frames without error
        */
        get rx_pfc(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received payload bytes in frames with no FCS, undersized,
          oversized, or payload length errors, VLAN/SVLAN header bytes are removed
          from the count
        */
        get rx_payload_octetsok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.BytesCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of received bytes in frames with no FCS, undersized, oversized, or
          payload length errors
        */
        get rx_frame_octetsok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.BytesCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of corrected FEC errors
        */
        get rx_rsfec_corr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.EventsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of uncorrected FEC errors
        */
        get rx_rsfec_uncorr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.EventsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of IP frames received with errors in the IP header
        */
        get rx_ip_hdr_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of IPv4 frames received with wrong header checksum
        */
        get rx_ipv4_chksum_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of fragmented IP received
        */
        get rx_fragmented(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of IP frames received with wrong total length
        */
        get rx_ip_totlen_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of UDP frames received with wrong total length
        */
        get rx_udp_totlen_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of UDP frames received with wrong checksum
        */
        get rx_udp_chksum_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of truncated UDP frames received
        */
        get rx_udp_length_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames less than 64 bytes and reporting a CRC error
        */
        get tx_fragments(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted oversized frames reporting a CRC error
        */
        get tx_jabbers(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted packets with FCS errors
        */
        get tx_fcserr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames with a frame of length at least 64, with CRC
          error
        */
        get tx_crcerr_okpkt(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored multicast frames transmitted, excluding control frames
        */
        get tx_mcast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored broadcast frames transmitted, excluding control frames
        */
        get tx_bcast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored unicast frames transmitted, excluding control frames
        */
        get tx_ucast_data_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored multicast control frames transmitted
        */
        get tx_mcast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored broadcast control frames transmitted
        */
        get tx_bcast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored unicast control frames transmitted
        */
        get tx_ucast_ctrl_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of errored pause frames transmitted
        */
        get tx_pause_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of 64-byte transmitted frames, including the CRC field but
          excluding the preamble and SFD bytes
        */
        get tx_64b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 65-127 bytes
        */
        get tx_65to127b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 128-255 bytes
        */
        get tx_128to255b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 256-511 bytes
        */
        get tx_256to511b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 512 –1023 bytes
        */
        get tx_512to1023b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 1024–1518 bytes
        */
        get tx_1024to1518b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted frames between 1519-1536 bytes
        */
        get tx_1519to1536b(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of oversized frames transmitted
        */
        get tx_oversize(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid multicast frames transmitted, excluding control frames
        */
        get tx_mcast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid broadcast frames transmitted, excluding control frames
        */
        get tx_bcast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid unicast frames transmitted, excluding control frames
        */
        get tx_ucast_data_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid multicast frames transmitted, excluding data frames
        */
        get tx_mcast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid broadcast frames transmitted, excluding data frames
        */
        get tx_bcast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of valid unicast frames transmitted, excluding data frames
        */
        get tx_ucast_ctrl_ok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted pause frames, with or without error
        */
        get tx_pause(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted runt packets
        */
        get tx_runt(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of TX frame starts
        */
        get tx_st(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of TX length errors
        */
        get tx_lenerr(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of TX PFC frame with CRC error
        */
        get tx_pfc_err(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of TX PFC frames without error
        */
        get tx_pfc(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.PacketsCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted payload bytes in frames with no FCS, undersized,
          oversized, or payload length errors, VLAN/SVLAN header bytes are removed
          from the count
        */
        get tx_payload_octetsok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.BytesCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
        /**
          Number of transmitted bytes in frames with no FCS, undersized, oversized,
          or payload length errors
        */
        get tx_frame_octetsok(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.EthernetStats.BytesCounter, VAPI.AT1130.EthernetStats.PortStatistics>;
    }
}
export declare namespace Genlock {
    const lift: {
        readonly AT1130Genlock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AT1130Genlock;
        readonly AT1130GenlockBackend: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AT1130GenlockBackend;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly SingleGenlockState: (_raw: [VAPI.Servos.State, [number, number, number, number, number, number, number], null | [number | string, number, number], null | [[number, number, number, number], [number, number, number, number]], number], _socket: VScript.VSocket) => SingleGenlockState;
        readonly AT1130GenlockBackendDtNodes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AT1130GenlockBackendDtNodes;
        readonly AT1130GenlockBackendLanes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AT1130GenlockBackendLanes;
        readonly AT1130GenlockSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AT1130GenlockSettings;
    };
    const lower: {
        readonly AT1130Genlock: (_x: AT1130Genlock) => string;
        readonly AT1130GenlockBackend: (_x: AT1130GenlockBackend) => string;
        readonly All: (_x: All) => string;
        readonly SingleGenlockState: (_x: {
            state: VAPI.Servos.State;
            /**
              counter values may be negative to indicate deviations beyond
              the holdover threshold
            */
            counters: VAPI.Servos.Counters;
            anchor: null | VAPI.Genlock.Anchor;
            position: null | VAPI.Genlock.GenlockPosition;
            slew_rate: number;
        }, _socket: VScript.VSocket) => [VAPI.Servos.State, [number, number, number, number, number, number, number], null | [number | string, number, number], null | [[number, number, number, number], [number, number, number, number]], number];
        readonly AT1130GenlockBackendDtNodes: (_x: AT1130GenlockBackendDtNodes) => string;
        readonly AT1130GenlockBackendLanes: (_x: AT1130GenlockBackendLanes) => string;
        readonly AT1130GenlockSettings: (_x: AT1130GenlockSettings) => string;
    };
    class AT1130Genlock implements VScript.Referenceable<"Genlock::Data::AT1130Genlock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::AT1130Genlock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.Genlock.AT1130Genlock>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.Genlock.AT1130Genlock>;
        get settings(): AT1130GenlockSettings;
        get backend(): AT1130GenlockBackend;
    }
    class AT1130GenlockBackend implements VScript.Referenceable<"Genlock::Data::AT1130GenlockBackend"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::AT1130GenlockBackend";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get lanes(): AT1130GenlockBackendLanes;
        get dt_nodes(): AT1130GenlockBackendDtNodes;
        get ptp_traits(): VAPI.PTP.Traits;
        /**
          Most clock control units continuously adjust their target's operating
          frequency until the time and/or frequency offset between source and
          target matches a user-defined value. These units require no data beyond
          frame rate, source type, frequency offset and offset.
          
          However, other clock operations implicitly guarantee synchronicity by
          rigidly linking their target's operating frequency to the source
          frequency. This implicit link may be broken when the timing source
          changes discontinuously. For example, an uncalibrated PTP clock may
          perform arbitrarily large offset and/or frequency jumps, yet after
          reachieving calibration will again report its offset to the internal PTP
          reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
          consumers, every timing source performing discontinuous changes in a way
          that breaks implicit synchronicity has to increase its continuity_index
          (with wraparound behaviour in the unlikely case of overflow).
        */
        get continuity_index(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.PTP.ContinuityIndex, VAPI.AT1130.Genlock.AT1130GenlockBackend>;
        get output(): VAPI.AT1130.Time.Source;
    }
    class All implements VScript.Referenceable<"Genlock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::All";
        get runtime_constants(): {
            readonly num_physical_audio_genlocks: number;
            readonly num_physical_video_genlocks: number;
            readonly num_video_genlocks: number;
            readonly num_audio_genlocks: number;
            readonly num_genlocks: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedArray<VScript.VSocket, "Genlock::Data::AT1130Genlock", AT1130Genlock>;
        get analog_ref_mgmt(): VAPI.AT1130.Time.AnalogReference;
    }
    interface SingleGenlockState {
        state: VAPI.Servos.State;
        /**
          counter values may be negative to indicate deviations beyond the holdover
          threshold
        */
        counters: VAPI.Servos.Counters;
        anchor: null | VAPI.Genlock.Anchor;
        position: null | VAPI.Genlock.GenlockPosition;
        slew_rate: number;
    }
    class AT1130GenlockBackendDtNodes implements VScript.Referenceable<"Genlock::Data::AT1130GenlockBackend::DtNodes"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::AT1130GenlockBackend::DtNodes";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.Genlock.AT1130GenlockBackendDtNodes>;
        get video(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.Genlock.AT1130GenlockBackendDtNodes>;
    }
    class AT1130GenlockBackendLanes implements VScript.Referenceable<"Genlock::Data::AT1130GenlockBackend::Lanes"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::AT1130GenlockBackend::Lanes";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Servos.State,
            [
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            null | [
                number | string,
                number,
                number
            ],
            null | [
                [
                    number,
                    number,
                    number,
                    number
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ],
            number
        ], null | VAPI.AT1130.Genlock.SingleGenlockState, VAPI.AT1130.Genlock.AT1130GenlockBackendLanes>;
        get video_f50_ish(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Servos.State,
            [
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            null | [
                number | string,
                number,
                number
            ],
            null | [
                [
                    number,
                    number,
                    number,
                    number
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ],
            number
        ], null | VAPI.AT1130.Genlock.SingleGenlockState, VAPI.AT1130.Genlock.AT1130GenlockBackendLanes>;
        get video_f59_ish(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Servos.State,
            [
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            null | [
                number | string,
                number,
                number
            ],
            null | [
                [
                    number,
                    number,
                    number,
                    number
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ],
            number
        ], null | VAPI.AT1130.Genlock.SingleGenlockState, VAPI.AT1130.Genlock.AT1130GenlockBackendLanes>;
    }
    class AT1130GenlockSettings implements VScript.Referenceable<"Genlock::Data::AT1130Genlock::Settings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::AT1130Genlock::Settings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VAPI.Genlock.SingleGenlockSettings;
        get video(): VAPI.Genlock.SingleGenlockSettings;
    }
}
export declare namespace IOModule {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly TimingAsynchronous: (_raw: [VAPI.Audio.Frequency], _socket: VScript.VSocket) => TimingAsynchronous;
        readonly HwStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HwStatus;
        readonly MADIInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MADIInput;
        readonly SDIPayload: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIPayload;
        readonly SDITxPll: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDITxPll;
        readonly SDIInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIInput;
        readonly SDIOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIOutput;
        readonly TimingSynchronousOrSyntonous: (_raw: [null | string, VAPI.Audio.Frequency], _socket: VScript.VSocket) => TimingSynchronousOrSyntonous;
        readonly Timing: (_raw: ([0, [null | string, VAPI.Audio.Frequency]] | [1, [VAPI.Audio.Frequency]]), _socket: VScript.VSocket) => Timing;
        readonly HwStatusEye: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HwStatusEye;
        readonly Input: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Input;
        readonly Merger: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Merger;
        readonly Output: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Output;
        readonly MergerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MergerOutput;
        readonly SyncOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SyncOutput;
        readonly TxClock: (_raw: [VAPI.AT1130.IOModule.TxClockRole, null | string], _socket: VScript.VSocket) => TxClock;
        readonly WclkOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => WclkOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly TimingAsynchronous: (_x: {
            frequency: VAPI.Audio.Frequency;
        }, _socket: VScript.VSocket) => [VAPI.Audio.Frequency];
        readonly HwStatus: (_x: HwStatus) => string;
        readonly MADIInput: (_x: MADIInput) => string;
        readonly SDIPayload: (_x: SDIPayload) => string;
        readonly SDITxPll: (_x: SDITxPll) => string;
        readonly SDIInput: (_x: SDIInput) => string;
        readonly SDIOutput: (_x: SDIOutput) => string;
        readonly TimingSynchronousOrSyntonous: (_x: {
            genlock: null | VAPI.AT1130.Genlock.AT1130Genlock;
            frequency: VAPI.Audio.Frequency;
        }, _socket: VScript.VSocket) => [null | string, VAPI.Audio.Frequency];
        readonly Timing: (_x: ({
            variant: "SynchronousOrSyntonous";
            value: VAPI.AT1130.IOModule.TimingSynchronousOrSyntonous;
        } | {
            variant: "Asynchronous";
            value: VAPI.AT1130.IOModule.TimingAsynchronous;
        }), _socket: VScript.VSocket) => ([0, [null | string, VAPI.Audio.Frequency]] | [1, [VAPI.Audio.Frequency]]);
        readonly HwStatusEye: (_x: HwStatusEye) => string;
        readonly Input: (_x: Input) => string;
        readonly Merger: (_x: Merger) => string;
        readonly Output: (_x: Output) => string;
        readonly MergerOutput: (_x: MergerOutput) => string;
        readonly SyncOutput: (_x: SyncOutput) => string;
        readonly TxClock: (_x: {
            role: VAPI.AT1130.IOModule.TxClockRole;
            pll: null | VAPI.AT1130.IOModule.SDITxPll;
        }, _socket: VScript.VSocket) => [VAPI.AT1130.IOModule.TxClockRole, null | string];
        readonly WclkOutput: (_x: WclkOutput) => string;
    };
    class All implements VScript.Referenceable<"IOModule::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::All";
        get runtime_constants(): {
            readonly should_deembed_all_metadata: boolean;
            readonly num_sdi_tx_plls: number;
            readonly num_metadata_extractors_per_sdi_input: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.IOModule.BncMode;
        get analog_ref(): VScript.StronglyTypedTable<VScript.VSocket, "Time::Data::Source", VAPI.AT1130.Time.Source>;
        get analog_ref_traits(): VAPI.PTP.Traits;
        get configuration(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Configuration", VAPI.IOModule.Configuration>;
        get merger(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Merger", Merger>;
        get output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Output", Output>;
        get input(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Input", Input>;
        get sync_output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::SyncOutput", SyncOutput>;
        get wclk_output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::WclkOutput", WclkOutput>;
        get sdi_tx_plls(): VScript.StronglyTypedArray<VScript.VSocket, "IOModule::Data::SDITxPll", SDITxPll>;
    }
    interface TimingAsynchronous {
        frequency: VAPI.Audio.Frequency;
    }
    class HwStatus implements VScript.Referenceable<"IOModule::Data::HwStatus"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::HwStatus";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1130.IOModule.HwStatus>;
        get irq_index(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.IOModule.HwStatus>;
        get deemb_read_overflow(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.IOModule.HwStatus>;
        get deemb_read_underflow(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.IOModule.HwStatus>;
        get deemb_read_running(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.IOModule.HwStatus>;
        get phy_rx_locked_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.IOModule.DecoderGroupPhyRxLockedStatus, null | VAPI.IOModule.DecoderGroupPhyRxLockedStatus, VAPI.AT1130.IOModule.HwStatus>;
        get phy_rx_calibrate_busy(): VScript.rKeyword<VScript.VSocket, null | VAPI.IOModule.DecoderGroupPhyRxCalibrateBusy, null | VAPI.IOModule.DecoderGroupPhyRxCalibrateBusy, VAPI.AT1130.IOModule.HwStatus>;
        get phy_rx_locked_status_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1130.IOModule.HwStatus>;
        get smpte_352_c(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AT1130.IOModule.HwStatus>;
        get smpte_352_y(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AT1130.IOModule.HwStatus>;
        get h_blank(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.IOModule.HwStatus>;
        get h_blank_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1130.IOModule.HwStatus>;
        get h_active(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.IOModule.HwStatus>;
        get h_active_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1130.IOModule.HwStatus>;
        get f_period(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.IOModule.HwStatus>;
        get interlace(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.IOModule.HwStatus>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.IOModule.HwStatus>;
        get substream_2_s_i(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream2SI, null | VAPI.Video.SubStream2SI, VAPI.AT1130.IOModule.HwStatus>;
        get input_substream(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1130.IOModule.HwStatus>;
        get eye(): HwStatusEye;
    }
    class MADIInput implements VScript.Referenceable<"IOModule::Data::MADIInput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::MADIInput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.IOModule.MADIInput>;
        get fifo_underflow_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter16, VAPI.AT1130.IOModule.MADIInput>;
        get fifo_overflow_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter16, VAPI.AT1130.IOModule.MADIInput>;
        get clear_fifo_error_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.IOModule.MADIInput>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class SDIPayload implements VScript.Referenceable<"IOModule::Data::SDIPayload"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIPayload";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1130.Video.Essence;
        get audio(): VAPI.AT1130.Audio.Essence;
        get afd(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Video.AspectRatio,
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.Video.AFD, VAPI.AT1130.IOModule.SDIPayload>;
        get cc(): VAPI.Video.ClosedCaption;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class SDITxPll implements VScript.Referenceable<"IOModule::Data::SDITxPll"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDITxPll";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.IOModule.SDITxPll>;
        get servo(): VScript.rKeyword<VScript.VSocket, [
            VAPI.Servos.State,
            null | number,
            number,
            number,
            null | [
                [
                    number,
                    number,
                    number,
                    number
                ],
                null | [
                    number,
                    number,
                    number,
                    number
                ]
            ],
            [
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            number
        ], VAPI.Servos.Metrics, VAPI.AT1130.IOModule.SDITxPll>;
        get num_resets(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1130.IOModule.SDITxPll>;
    }
    class SDIInput implements VScript.Referenceable<"IOModule::Data::SDIInput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIInput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get override_pixel_format(): VScript.rwKeyword<VScript.VSocket, [
            VAPI.Video.OverrideColorSpace,
            VAPI.Video.OverrideBitDepth,
            VAPI.Video.OverrideTransferCharacteristics
        ], [
            VAPI.Video.OverrideColorSpace,
            VAPI.Video.OverrideBitDepth,
            VAPI.Video.OverrideTransferCharacteristics
        ], VAPI.Video.OverridePixelFormat, VAPI.Video.OverridePixelFormat, VAPI.AT1130.IOModule.SDIInput>;
        get sub_stream(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1130.IOModule.SDIInput>;
        /**
          How to deembed audio from 12G SDI inputs
        */
        get audio_12g_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.AT1130.IOModule.SDIInput>;
        /**
          Which closed caption format to decode on input
        */
        get cc_mode(): VScript.rwKeyword<VScript.VSocket, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, VAPI.AT1130.IOModule.SDIInput>;
        /**
          Which line 21 field to decode in CEA708 mode
        */
        get cc_field(): VScript.rwKeyword<VScript.VSocket, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.AT1130.IOModule.SDIInput>;
        get cc_channel(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, VAPI.AT1130.IOModule.SDIInput>;
        get hw_status(): HwStatus;
        get output(): SDIPayload;
        get mode(): VScript.rKeyword<VScript.VSocket, VAPI.Video.BNCInputFreq, VAPI.Video.BNCInputFreq, VAPI.AT1130.IOModule.SDIInput>;
        get supports_12g(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.IOModule.SDIInput>;
        /**
          All audio groups which are part of the gang mode are started / stopped
          together. This ensures consistent audio phase for all these groups. All
          enabled groups must be present before de-embedding starts, and when one
          group encounters errors all are reset.
        */
        get deembedder_gang(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1130.IOModule.SDIInput>;
        /**
          @brief restart deembedder
          @desc Restart audio deembedder to synchronize the groups
        */
        get restart_deembedder(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.IOModule.SDIInput>;
        get metadata_extractor(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::MetadataExtractor", VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
    }
    class SDIOutput implements VScript.Referenceable<"IOModule::Data::SDIOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get constraints(): VAPI.IOModule.Constraints;
        get sub_stream(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1130.IOModule.SDIOutput>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.IOModule.SDIOutput>;
        get supports_12g(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.IOModule.SDIOutput>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.IOModule.SDIOutput>;
        get v_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Video.TimedSource, VAPI.AT1130.Video.TimedSource, VAPI.AT1130.IOModule.SDIOutput>;
        get phase_target(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.IOModule.SDIOutput>;
        get in_phase(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.IOModule.SDIOutput>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1130.IOModule.SDIOutput>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.IOModule.SDIOutputIssues, VAPI.AT1130.IOModule.SDIOutput>;
        get vanc_control(): VAPI.AT1130.Definitions.VancControl;
        get embedded_audio(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1130.IOModule.SDIOutput>;
        /**
          Time when the SDI output was last enabled. Changing the standards or
          disconnecting the video source counts as disabling.
        */
        get last_enable_time(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1130.IOModule.SDIOutput>;
        set_video_source(x: VAPI.AT1130.Video.Essence | VAPI.AT1130.Video.TimedSource | null, pars?: {
            timeout?: VScript.Duration;
        }): Promise<void>;
    }
    interface TimingSynchronousOrSyntonous {
        genlock: null | VAPI.AT1130.Genlock.AT1130Genlock;
        frequency: VAPI.Audio.Frequency;
    }
    type Timing = ({
        variant: "SynchronousOrSyntonous";
        value: VAPI.AT1130.IOModule.TimingSynchronousOrSyntonous;
    } | {
        variant: "Asynchronous";
        value: VAPI.AT1130.IOModule.TimingAsynchronous;
    });
    class HwStatusEye implements VScript.Referenceable<"IOModule::Data::HwStatus::Eye"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::HwStatus::Eye";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get eye_measure_time(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.IOModule.HwStatusEye>;
        /**
          Generate eye diagram
        */
        get generate(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.IOModule.HwStatusEye>;
        get progress(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.IOModule.HwStatusEye>;
        /**
          @brief URL of the eye diagram
          @desc An update to this keyword signals a new eye diagram has been
          generated
        */
        get url(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.IOModule.HwStatusEye>;
        /**
          @brief Measure eye opening only
          @desc Only measure horizontal eye opening (much faster than a full eye)
        */
        get measure_ui(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.IOModule.HwStatusEye>;
        get ui_measure_time(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.IOModule.HwStatusEye>;
        get ui(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.IOModule.EyeShape, VAPI.AT1130.IOModule.HwStatusEye>;
    }
    class Input implements VScript.Referenceable<"IOModule::Data::Input"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Input";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.AT1130.IOModule.Input>;
        get audio_timing(): VScript.dKeyword<VScript.VSocket, ([
            0,
            [
                null | string,
                VAPI.Audio.Frequency
            ]
        ] | [
            1,
            [VAPI.Audio.Frequency]
        ]), ([
            0,
            [
                null | string,
                VAPI.Audio.Frequency
            ]
        ] | [
            1,
            [VAPI.Audio.Frequency]
        ]), VAPI.AT1130.IOModule.Timing, VAPI.AT1130.IOModule.Timing, VAPI.AT1130.IOModule.Input>;
        get sdi(): SDIInput;
        get madi(): MADIInput;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    type SDIOutputIssues = {
        different_genlocks: boolean;
        input_out_of_linephaser_range: boolean;
        missing_t_src: boolean;
        no_12g_support: boolean;
        std_mismatch: boolean;
    };
    type SyncOutputIssues = {
        missing_t_src: boolean;
    };
    class Merger implements VScript.Referenceable<"IOModule::Data::Merger"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Merger";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Merger: combines quad-link-2si signals to a single-link UHD signal. The
          corresponding SDI inputs are declared in `connected_to`. The order of the
          substream is adjusted by the information of the payload identifier. To
          set or reorder the substream, use the `sub_stream` parameter
        */
        get substream_2_s_i(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.IOModule.Merger>;
        get connected_to(): VAPI.IOModule.MergerConnectedTo;
        get output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Merger::Output", MergerOutput>;
    }
    class Output implements VScript.Referenceable<"IOModule::Data::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.AT1130.IOModule.Output>;
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1130.IOModule.Output>;
        get sdi(): SDIOutput;
        get madi(): VAPI.IOModule.MADIOutput;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.IOModule.Output>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.IOModule.Output>;
        get tx_pll_group(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.IOModule.Output>;
        get tx_clock(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.AT1130.IOModule.TxClockRole,
            null | string
        ], null | VAPI.AT1130.IOModule.TxClock, VAPI.AT1130.IOModule.Output>;
    }
    class MergerOutput implements VScript.Referenceable<"IOModule::Data::Merger::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Merger::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1130.Video.Essence;
        get audio(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::Essence", VAPI.AT1130.Audio.Essence>;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    type TxClockRole = "Master" | "Slave";
    class SyncOutput implements VScript.Referenceable<"IOModule::Data::SyncOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SyncOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get standard(): VScript.rwKeyword<VScript.VSocket, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, VAPI.AT1130.IOModule.SyncOutput>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.IOModule.SyncOutput>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1130.IOModule.SyncOutput>;
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1130.IOModule.SyncOutput>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.IOModule.SyncOutputIssues, VAPI.AT1130.IOModule.SyncOutput>;
        get tx_pll_group(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.IOModule.SyncOutput>;
        get tx_clock(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.AT1130.IOModule.TxClockRole,
            null | string
        ], null | VAPI.AT1130.IOModule.TxClock, VAPI.AT1130.IOModule.SyncOutput>;
    }
    interface TxClock {
        role: VAPI.AT1130.IOModule.TxClockRole;
        pll: null | VAPI.AT1130.IOModule.SDITxPll;
    }
    class WclkOutput implements VScript.Referenceable<"IOModule::Data::WclkOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::WclkOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Genlock.AT1130Genlock, null | VScript.Referenceable<"Genlock::Data::AT1130Genlock"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.IOModule.WclkOutput>;
    }
}
export declare namespace J2KDecoder {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly J2KDecoderChannel: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderChannel;
        readonly J2KDecoderRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderRuntime;
        readonly J2KDecoderVideoRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderVideoRuntime;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly J2KDecoderChannel: (_x: J2KDecoderChannel) => string;
        readonly J2KDecoderRuntime: (_x: J2KDecoderRuntime) => string;
        readonly J2KDecoderVideoRuntime: (_x: J2KDecoderVideoRuntime) => string;
    };
    class All implements VScript.Referenceable<"J2KDecoder::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get decoders(): VScript.StronglyTypedNamedTable<VScript.VSocket, "J2KDecoder::Data::J2KDecoderChannel", J2KDecoderChannelAsNamedTableRow>;
        get statistics(): VAPI.J2KDecoder.J2KDecoderStatistics;
    }
    class J2KDecoderChannel implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderChannel"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderChannel";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get configuration(): VAPI.J2KDecoder.J2KDecoderConfiguration;
        get runtime(): J2KDecoderRuntime;
    }
    class J2KDecoderChannelAsNamedTableRow extends J2KDecoderChannel {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class J2KDecoderRuntime implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get rtp(): VAPI.J2KDecoder.J2KDecoderRTPRuntime;
        get mpt2(): VAPI.J2KDecoder.J2KDecoderMPT2Runtime;
        get j2k(): VAPI.J2KDecoder.J2KDecoderJ2KRuntime;
        get video(): J2KDecoderVideoRuntime;
        get audio(): VAPI.J2KDecoder.J2KDecoderAudioRuntime;
        get metadata(): VAPI.J2KDecoder.J2KDecoderMetadataRuntime;
    }
    class J2KDecoderVideoRuntime implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderVideoRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderVideoRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_standard(): VScript.rKeyword<VScript.VSocket, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.AT1130.J2KDecoder.J2KDecoderVideoRuntime>;
        get signal(): VAPI.AT1130.Video.Essence;
    }
}
export declare namespace MasterClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly GPSReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => GPSReceiver;
        readonly LTCGenerator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LTCGenerator;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly GPSReceiver: (_x: GPSReceiver) => string;
        readonly LTCGenerator: (_x: LTCGenerator) => string;
    };
    class All implements VScript.Referenceable<"MasterClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::All";
        get runtime_constants(): {
            readonly num_ltc_slices: number;
            readonly num_ltc_generators: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gps_receivers(): VScript.StronglyTypedTable<VScript.VSocket, "MasterClock::Data::GPSReceiver", GPSReceiver>;
        get ltc_generators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "MasterClock::Data::LTCGenerator", LTCGeneratorAsNamedTableRow>;
        get ltc_slice(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class GPSReceiver implements VScript.Referenceable<"MasterClock::Data::GPSReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::GPSReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get date(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number
        ], null | VAPI.MasterClock.GPSReceiverDate, VAPI.AT1130.MasterClock.GPSReceiver>;
        get time_of_day(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number
        ], null | VAPI.MasterClock.GPSReceiverTimeOfDay, VAPI.AT1130.MasterClock.GPSReceiver>;
        get num_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.MasterClock.GPSReceiver>;
        get used_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.MasterClock.GPSReceiver>;
        get removed_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.MasterClock.GPSReceiver>;
        get ptp_traits(): VAPI.PTP.Traits;
        get output(): VAPI.AT1130.Time.Source;
    }
    class LTCGenerator implements VScript.Referenceable<"MasterClock::Data::LTCGenerator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::LTCGenerator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get timezone(): VScript.dKeyword<VScript.VSocket, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.AT1130.MasterClock.LTCGenerator>;
        get custom_timezone_offset(): VScript.dKeyword<VScript.VSocket, [
            number,
            number
        ], [
            number,
            number
        ], VAPI.MasterClock.TimezoneOffset, VAPI.MasterClock.TimezoneOffset, VAPI.AT1130.MasterClock.LTCGenerator>;
        get frame_rate(): VScript.dKeyword<VScript.VSocket, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.AT1130.MasterClock.LTCGenerator>;
        /**
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard(): VScript.dKeyword<VScript.VSocket, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.AT1130.MasterClock.LTCGenerator>;
        get reset_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.MasterClock.LTCGenerator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.MasterClock.LTCGenerator>;
        get output(): VAPI.AT1130.Audio.Essence;
    }
    class LTCGeneratorAsNamedTableRow extends LTCGenerator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace MetadataProcessor {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly MetadataExtractor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MetadataExtractor;
        readonly MetadataInserter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MetadataInserter;
        readonly Request: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Request;
        readonly Response: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Response;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly MetadataExtractor: (_x: MetadataExtractor) => string;
        readonly MetadataInserter: (_x: MetadataInserter) => string;
        readonly Request: (_x: Request) => string;
        readonly Response: (_x: Response) => string;
    };
    class All implements VScript.Referenceable<"MetadataProcessor::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::All";
        get runtime_constants(): {
            readonly num_metadata_inserters: number;
            readonly num_metadata_extractors: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get rtp_channel(): VScript.rKeyword<VScript.VSocket, VAPI.MetadataProcessor.ChannelState, VAPI.MetadataProcessor.ChannelState, VAPI.AT1130.MetadataProcessor.All>;
        get responses(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::Response", Response>;
    }
    class MetadataExtractor implements VScript.Referenceable<"MetadataProcessor::Data::MetadataExtractor"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::MetadataExtractor";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get extractor_type(): VScript.rKeyword<VScript.VSocket, null | VAPI.MetadataProcessor.MetadataExtractorExtractorType, null | VAPI.MetadataProcessor.MetadataExtractorExtractorType, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get bnc_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get media_clock(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Time.Source, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get rtp_requested(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        get rtp_index(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.MetadataProcessor.RTPIndex, VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
    }
    class MetadataInserter implements VScript.Referenceable<"MetadataProcessor::Data::MetadataInserter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::MetadataInserter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
        get media_clock(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Time.Source, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
        get src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.MetadataProcessor.MetadataExtractor, null | VScript.Referenceable<"MetadataProcessor::Data::MetadataExtractor"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
        get filter(): VScript.dKeyword<VScript.VSocket, [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], VAPI.MetadataProcessor.Filter, VAPI.MetadataProcessor.Filter, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
        get vanc_locations(): VScript.dKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
        get fine_print(): VScript.dKeyword<VScript.VSocket, [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], VAPI.MetadataProcessor.FinePrint, VAPI.MetadataProcessor.FinePrint, VAPI.AT1130.MetadataProcessor.MetadataInserter>;
    }
    class Request implements VScript.Referenceable<"MetadataProcessor::Data::Request"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::Request";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get inserter_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.MetadataProcessor.Request>;
        get src(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.MetadataProcessor.MetadataExtractor, VAPI.AT1130.MetadataProcessor.Request>;
        get dst(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.MetadataProcessor.MetadataInserter, VAPI.AT1130.MetadataProcessor.Request>;
        get filter(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], null | VAPI.MetadataProcessor.Filter, VAPI.AT1130.MetadataProcessor.Request>;
        get vanc_locations(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1130.MetadataProcessor.Request>;
        get fine_print(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], null | VAPI.MetadataProcessor.FinePrint, VAPI.AT1130.MetadataProcessor.Request>;
    }
    class Response implements VScript.Referenceable<"MetadataProcessor::Data::Response"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::Response";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get extractor_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.MetadataProcessor.Response>;
        get inserter_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.MetadataProcessor.Response>;
        get src(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.MetadataProcessor.MetadataExtractor, VAPI.AT1130.MetadataProcessor.Response>;
        get dst(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.MetadataProcessor.MetadataInserter, VAPI.AT1130.MetadataProcessor.Response>;
        get filter(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], null | VAPI.MetadataProcessor.Filter, VAPI.AT1130.MetadataProcessor.Response>;
        get vanc_locations(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1130.MetadataProcessor.Response>;
        get fine_print(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], null | VAPI.MetadataProcessor.FinePrint, VAPI.AT1130.MetadataProcessor.Response>;
        get statistics(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number
        ], VAPI.MetadataProcessor.ResponseStatistics, VAPI.AT1130.MetadataProcessor.Response>;
        /**
          Metadata inserters generally attempt to match their video stream's
          underlying media clock by delaying the supplied ANC streams accordingly.
          If the desired media clock offset cannot be met because, e.g., the ANC
          stream is already coming in too late, or Timecode/AFD continuity
          requirements force the inserter to soften its mediaclock criterion,
          packets may either be discarded or embedded out-of-phase. In the latter
          case, the mismatch between the embedded ANC stream's de-facto mediaclock
          and its target value is represented by `phase_mismatch`, with negative
          values corresponding to late ANC streams.
        */
        get phase_mismatch(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedOffset, VAPI.AT1130.MetadataProcessor.Response>;
    }
}
export declare namespace Monitoring {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AudioLoudness: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioLoudness;
        readonly AudioPhaseCorrelation: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioPhaseCorrelation;
        readonly LiveView: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LiveView;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly AudioLoudness: (_x: AudioLoudness) => string;
        readonly AudioPhaseCorrelation: (_x: AudioPhaseCorrelation) => string;
        readonly LiveView: (_x: LiveView) => string;
    };
    class All implements VScript.Referenceable<"Monitoring::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::All";
        get runtime_constants(): {
            readonly num_audio_phase_correlation: number;
            readonly num_audio_loudness_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VAPI.Monitoring.Audio;
        get video(): VAPI.Monitoring.Video;
        get live_view(): LiveView;
        get correlation(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Monitoring::Data::AudioPhaseCorrelation", AudioPhaseCorrelationAsNamedTableRow>;
        get loudness(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Monitoring::Data::AudioLoudness", AudioLoudnessAsNamedTableRow>;
    }
    class AudioLoudness implements VScript.Referenceable<"Monitoring::Data::AudioLoudness"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::AudioLoudness";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.Monitoring.AudioLoudness>;
        get channels(): VAPI.Monitoring.AudioLoudnessChannels;
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          Set to false to pause gated_loudness measurement and back to true to
          resume
        */
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          True peak meters
          
          Order: left, right, center, surround_left, surround_right,
          rear_surround_left, rear_surround_right
        */
        get true_peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          Measured over the last 400 ms
        */
        get momentary_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          Measured over the last 3 s
        */
        get short_term_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.Monitoring.AudioLoudness>;
        get gated_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          How much data has been recorded for the gated loudness measurement so far
        */
        get gated_loudness_recorded(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1130.Monitoring.AudioLoudness>;
        /**
          Reset
        */
        get reset(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.Monitoring.AudioLoudness>;
    }
    class AudioLoudnessAsNamedTableRow extends AudioLoudness {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class AudioPhaseCorrelation implements VScript.Referenceable<"Monitoring::Data::AudioPhaseCorrelation"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::AudioPhaseCorrelation";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.Monitoring.AudioPhaseCorrelation>;
        get pairs(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.Monitoring.AudioPhaseCorrelation>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1130.Monitoring.AudioPhaseCorrelation>;
        get correlation(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<number>, VAPI.AT1130.Monitoring.AudioPhaseCorrelation>;
    }
    class AudioPhaseCorrelationAsNamedTableRow extends AudioPhaseCorrelation {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class LiveView implements VScript.Referenceable<"Monitoring::Data::LiveView"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::LiveView";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.Monitoring.LiveView>;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.Monitoring.LiveView>;
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1130.Monitoring.LiveView>;
    }
}
export declare namespace MultiviewerIO {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"MultiviewerIO::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MultiviewerIO::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get distributed(): VAPI.MultiviewerIO.DistributedMultiviewer;
        get cores(): VScript.StronglyTypedArray<VScript.VSocket, "MultiviewerIO::Data::ManifoldCore", VAPI.MultiviewerIO.ManifoldCore>;
        get outputs(): VScript.StronglyTypedArray<VScript.VSocket, "Video::Data::Essence", VAPI.AT1130.Video.Essence>;
    }
}
export declare namespace NetworkInterfaces {
    const lift: {
        readonly PMASettingsManualRxAdaptive: (_raw: [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean], _socket: VScript.VSocket) => PMASettingsManualRxAdaptive;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly PMASettingsDisabled: (_raw: [], _socket: VScript.VSocket) => PMASettingsDisabled;
        readonly PMASettingsManualRxDisabled: (_raw: [], _socket: VScript.VSocket) => PMASettingsManualRxDisabled;
        readonly LaneStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LaneStatistics;
        readonly PMASettingsManual: (_raw: [([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]), [number, number, number, number, number]], _socket: VScript.VSocket) => PMASettingsManual;
        readonly PMASettings: (_raw: ([0, []] | [1, []] | [2, []] | [3, [([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]), [number, number, number, number, number]]]), _socket: VScript.VSocket) => PMASettings;
        readonly PTPCalibration: (_raw: [VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus, VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus, null | number, null | number], _socket: VScript.VSocket) => PTPCalibration;
        readonly Port: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Port;
        readonly RXPMAStatus: (_raw: [VAPI.AT1130.NetworkInterfaces.RXPMAStatusState, Array<[null | [number, number], null | boolean, null | number, null | [number, number, number, number, number, number]]>], _socket: VScript.VSocket) => RXPMAStatus;
        readonly PMASettingsRecommendedCopper: (_raw: [], _socket: VScript.VSocket) => PMASettingsRecommendedCopper;
        readonly PMASettingsRecommendedOptical: (_raw: [], _socket: VScript.VSocket) => PMASettingsRecommendedOptical;
        readonly RXPMAStatusLanesAdaptationTimes: (_raw: [number, number], _socket: VScript.VSocket) => RXPMAStatusLanesAdaptationTimes;
        readonly RXPMAStatusLanes: (_raw: [null | [number, number], null | boolean, null | number, null | [number, number, number, number, number, number]], _socket: VScript.VSocket) => RXPMAStatusLanes;
        readonly PMASettingsManualRx: (_raw: ([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]), _socket: VScript.VSocket) => PMASettingsManualRx;
        readonly RXPMAStatusLanesRxEq: (_raw: [number, number, number, number, number, number], _socket: VScript.VSocket) => RXPMAStatusLanesRxEq;
        readonly PMASettingsManualTx: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => PMASettingsManualTx;
    };
    const lower: {
        readonly PMASettingsManualRxAdaptive: (_x: {
            profile: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile;
            effort: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort;
            continuous: boolean;
        }, _socket: VScript.VSocket) => [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean];
        readonly All: (_x: All) => string;
        readonly PMASettingsDisabled: (_x: {}, _socket: VScript.VSocket) => [];
        readonly PMASettingsManualRxDisabled: (_x: {}, _socket: VScript.VSocket) => [];
        readonly LaneStatistics: (_x: LaneStatistics) => string;
        readonly PMASettingsManual: (_x: {
            rx: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRx;
            tx: VAPI.AT1130.NetworkInterfaces.PMASettingsManualTx;
        }, _socket: VScript.VSocket) => [([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]), [number, number, number, number, number]];
        readonly PMASettings: (_x: ({
            variant: "Disabled";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsDisabled;
        } | {
            variant: "RecommendedOptical";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsRecommendedOptical;
        } | {
            variant: "RecommendedCopper";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsRecommendedCopper;
        } | {
            variant: "Manual";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsManual;
        }), _socket: VScript.VSocket) => ([0, []] | [1, []] | [2, []] | [3, [([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]), [number, number, number, number, number]]]);
        readonly PTPCalibration: (_x: {
            rx: VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus;
            tx: VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus;
            rx_ppm: null | number;
            tx_ppm: null | number;
        }, _socket: VScript.VSocket) => [VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus, VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus, null | number, null | number];
        readonly Port: (_x: Port) => string;
        readonly RXPMAStatus: (_x: {
            state: VAPI.AT1130.NetworkInterfaces.RXPMAStatusState;
            lanes: Array<VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanes>;
        }, _socket: VScript.VSocket) => [VAPI.AT1130.NetworkInterfaces.RXPMAStatusState, Array<[null | [number, number], null | boolean, null | number, null | [number, number, number, number, number, number]]>];
        readonly PMASettingsRecommendedCopper: (_x: {}, _socket: VScript.VSocket) => [];
        readonly PMASettingsRecommendedOptical: (_x: {}, _socket: VScript.VSocket) => [];
        readonly RXPMAStatusLanesAdaptationTimes: (_x: {
            initial: VScript.Duration;
            external: VScript.Duration;
        }, _socket: VScript.VSocket) => [number, number];
        readonly RXPMAStatusLanes: (_x: {
            adaptation_times: null | VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanesAdaptationTimes;
            freq_locked: null | boolean;
            eye_opening: null | VAPI.Primitives.Unsigned16;
            rx_eq: null | VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanesRxEq;
        }, _socket: VScript.VSocket) => [null | [number, number], null | boolean, null | number, null | [number, number, number, number, number, number]];
        readonly PMASettingsManualRx: (_x: ({
            variant: "Disabled";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxDisabled;
        } | {
            variant: "Adaptive";
            value: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptive;
        }), _socket: VScript.VSocket) => ([0, []] | [1, [VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile, VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort, boolean]]);
        readonly RXPMAStatusLanesRxEq: (_x: {
            gain_lf: VAPI.Primitives.Signed16;
            gain_hf: VAPI.Primitives.Signed16;
            rf_b0: VAPI.Primitives.Signed16;
            rf_b1: VAPI.Primitives.Signed16;
            rf_p1: VAPI.Primitives.Signed16;
            rf_p2: VAPI.Primitives.Signed16;
        }, _socket: VScript.VSocket) => [number, number, number, number, number, number];
        readonly PMASettingsManualTx: (_x: {
            pre3: number;
            pre2: number;
            pre1: number;
            main: number;
            post: number;
        }, _socket: VScript.VSocket) => [number, number, number, number, number];
    };
    interface PMASettingsManualRxAdaptive {
        profile: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile;
        effort: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort;
        continuous: boolean;
    }
    class All implements VScript.Referenceable<"NetworkInterfaces::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::All";
        get runtime_constants(): {
            readonly max_rx_streams: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Save all interfaces
        */
        get save_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.All>;
        /**
          Revert all interfaces
        */
        get revert_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.All>;
        /**
          Save all syslog settings
        */
        get save_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.All>;
        /**
          Revert all syslog settings
        */
        get revert_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.All>;
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::Port", Port>;
        get hostname(): VAPI.NetworkInterfaces.HostnameConfiguration;
        get current_veth_configuration(): VAPI.NetworkInterfaces.CurrentVirtualEthernetConfiguration;
        get desired_veth_configuration(): VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration;
        download_config(): Promise<NetworkConfig<"AT1101", "read"> | NetworkConfig<"AT1130", "read">>;
        upload_config(nc: NetworkConfig<"AT1130", "write"> | LiteralNetworkConfig<"AT1130", "write">): Promise<{
            restart_required: boolean;
        }>;
    }
    interface PMASettingsDisabled {
    }
    interface PMASettingsManualRxDisabled {
    }
    type Lane = "P0" | "P1";
    class LaneStatistics implements VScript.Referenceable<"NetworkInterfaces::Data::LaneStatistics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::LaneStatistics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get lane(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1130.NetworkInterfaces.Lane, null | VAPI.AT1130.NetworkInterfaces.Lane, VAPI.AT1130.NetworkInterfaces.LaneStatistics>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.NetworkInterfaces.LaneStatistics>;
        /**
          maximum throughput (per direction)
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.NetworkInterfaces.LaneStatistics>;
        get tx_streams(): VScript.rKeywordReferenceable<VScript.VSocket, "tx_streams", [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, Array<[
            number,
            number,
            number,
            number
        ]>, Array<VAPI.EthernetStats.Counter>, "NetworkInterfaces::Data::LaneStatistics", VAPI.AT1130.NetworkInterfaces.LaneStatistics>;
        get tx_all_streams(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1130.NetworkInterfaces.LaneStatistics>;
    }
    interface PMASettingsManual {
        rx: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRx;
        tx: VAPI.AT1130.NetworkInterfaces.PMASettingsManualTx;
    }
    type PMASettings = ({
        variant: "Disabled";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsDisabled;
    } | {
        variant: "RecommendedOptical";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsRecommendedOptical;
    } | {
        variant: "RecommendedCopper";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsRecommendedCopper;
    } | {
        variant: "Manual";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsManual;
    });
    interface PTPCalibration {
        rx: VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus;
        tx: VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus;
        rx_ppm: null | number;
        tx_ppm: null | number;
    }
    type PTPCalibrationStatus = "COLLECTING_INITIAL_HW_PARAMETERS" | "INITIAL_CALIBRATION_DONE" | "STARTING_PTP_UI_TRACKING" | "PTP_UI_TRACKING_ACTIVE" | "NO_CALIBRATION_NEEDED";
    class Port implements VScript.Referenceable<"NetworkInterfaces::Data::Port"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::Port";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.NetworkInterfaces.Port>;
        get port_id(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1130.Primitives.NetworkPortID, null | VAPI.AT1130.Primitives.NetworkPortID, VAPI.AT1130.NetworkInterfaces.Port>;
        get device_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          maximum throughput (per direction)
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.NetworkInterfaces.Port>;
        get port_mode(): VScript.dKeyword<VScript.VSocket, null | VAPI.AT1130.NetworkInterfaces.PortMode, null | VAPI.AT1130.NetworkInterfaces.PortMode, null | VAPI.AT1130.NetworkInterfaces.PortMode, null | VAPI.AT1130.NetworkInterfaces.PortMode, VAPI.AT1130.NetworkInterfaces.Port>;
        get fault_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.NetworkInterfaces.FaultStatus, null | VAPI.NetworkInterfaces.FaultStatus, VAPI.AT1130.NetworkInterfaces.Port>;
        get health(): VAPI.NetworkInterfaces.Health;
        get phy_link_up(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.NetworkInterfaces.Port>;
        get link_up(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          System runtime since boot
        */
        get link_up_last_changed(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          How often link_up has changed since boot
        */
        get link_up_changed_count(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          MAC address, stored in big-endian order.
        */
        get mac_address(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.NetworkInterfaces.MacAddress, VAPI.AT1130.NetworkInterfaces.Port>;
        get supports_ptp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.NetworkInterfaces.Port>;
        get supports_rtp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.NetworkInterfaces.Port>;
        get ptp_status(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus,
            VAPI.AT1130.NetworkInterfaces.PTPCalibrationStatus,
            null | number,
            null | number
        ], null | VAPI.AT1130.NetworkInterfaces.PTPCalibration, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          How often PTP calibration had to be restarted
        */
        get ptp_watchdog_count(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          @brief Reset ethernet interface
          @desc Enter /eio_sys_rst/ to reset interface and start adaption again
        */
        get eio_sys_rst(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.NetworkInterfaces.Port>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.NetworkInterfaces.PortIssues, VAPI.AT1130.NetworkInterfaces.Port>;
        get pma_settings(): VScript.rwKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ] | [
            2,
            []
        ] | [
            3,
            [
                ([0, []] | [
                    1,
                    [
                        VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile,
                        VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort,
                        boolean
                    ]
                ]),
                [
                    number,
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ]), ([0, []] | [
            1,
            []
        ] | [
            2,
            []
        ] | [
            3,
            [
                ([0, []] | [
                    1,
                    [
                        VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveProfile,
                        VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptiveEffort,
                        boolean
                    ]
                ]),
                [
                    number,
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ]), VAPI.AT1130.NetworkInterfaces.PMASettings, VAPI.AT1130.NetworkInterfaces.PMASettings, VAPI.AT1130.NetworkInterfaces.Port>;
        get rx_pma_status(): VScript.rKeyword<VScript.VSocket, [
            VAPI.AT1130.NetworkInterfaces.RXPMAStatusState,
            Array<[
                null | [
                    number,
                    number
                ],
                null | boolean,
                null | number,
                null | [
                    number,
                    number,
                    number,
                    number,
                    number,
                    number
                ]
            ]>
        ], VAPI.AT1130.NetworkInterfaces.RXPMAStatus, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          To execute shell commands on this interface, you will first need to enter
          its hosting network namespace. E.g., if `network_namespace` reads
          `ns_eth0.2`, the following command lists its IP addresses: `ip netns exec
          ns_eth0.2 ip addr show`
        */
        get network_namespace(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.NetworkInterfaces.Port>;
        get current_configuration(): VAPI.NetworkInterfaces.CurrentPortConfiguration;
        /**
          Save interface
        */
        get save_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          Revert interface
        */
        get revert_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.Port>;
        get desired_configuration(): VAPI.NetworkInterfaces.DesiredPortConfiguration;
        /**
          Save syslog settings
        */
        get save_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.Port>;
        /**
          Revert syslog settings
        */
        get revert_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.NetworkInterfaces.Port>;
        get current_syslog_configuration(): VAPI.NetworkInterfaces.CurrentSyslogConfiguration;
        get desired_syslog_configuration(): VAPI.NetworkInterfaces.DesiredSyslogConfiguration;
        get virtual_interfaces(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::VirtualInterface", VAPI.NetworkInterfaces.VirtualInterface>;
        /**
          Updated every time a virtual interface is added, removed, or has its list
          of ip addresses changed (not necessarily monotonic, since PTP-derived).
        */
        get last_vifc_change(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1130.NetworkInterfaces.Port>;
        get fpga_lane_statistics(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::LaneStatistics", LaneStatistics>;
        /**
          aggregate statistics as obtained by summing over all of a
          (FPGA-connected) port's internal lanes. Note that management ports never
          report traffic statistics, regardless of their actual activity
        */
        get aggregate_traffic_statistics(): VAPI.AT1130.EthernetStats.PortStatistics;
        get lldp_neighbors(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::LLDPNeighbor", VAPI.NetworkInterfaces.LLDPNeighbor>;
    }
    type PortMode = "eth1g" | "eth100g" | "eth100g_nofec" | "eth100g_aui2";
    interface RXPMAStatus {
        state: VAPI.AT1130.NetworkInterfaces.RXPMAStatusState;
        lanes: Array<VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanes>;
    }
    interface PMASettingsRecommendedCopper {
    }
    interface PMASettingsRecommendedOptical {
    }
    interface RXPMAStatusLanesAdaptationTimes {
        initial: VScript.Duration;
        external: VScript.Duration;
    }
    type PMASettingsManualRxAdaptiveEffort = "LOW" | "HIGH";
    type PortIssues = {
        pma_settings_change_require_port_reset: boolean;
        use_adaptive_pma_settings: boolean;
    };
    interface RXPMAStatusLanes {
        adaptation_times: null | VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanesAdaptationTimes;
        freq_locked: null | boolean;
        eye_opening: null | VAPI.Primitives.Unsigned16;
        rx_eq: null | VAPI.AT1130.NetworkInterfaces.RXPMAStatusLanesRxEq;
    }
    type PMASettingsManualRxAdaptiveProfile = "LR" | "VSR";
    type PMASettingsManualRx = ({
        variant: "Disabled";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxDisabled;
    } | {
        variant: "Adaptive";
        value: VAPI.AT1130.NetworkInterfaces.PMASettingsManualRxAdaptive;
    });
    interface RXPMAStatusLanesRxEq {
        gain_lf: VAPI.Primitives.Signed16;
        gain_hf: VAPI.Primitives.Signed16;
        rf_b0: VAPI.Primitives.Signed16;
        rf_b1: VAPI.Primitives.Signed16;
        rf_p1: VAPI.Primitives.Signed16;
        rf_p2: VAPI.Primitives.Signed16;
    }
    type RXPMAStatusState = "NO_QSFP" | "NO_ADAPTATION" | "CONFIGURING" | "SEARCHING_FOR_SIGNAL" | "ADAPTATION" | "MONITORING" | "ONE_TIME_ADAPTATION_COMPLETED" | "RESETTING_INTERFACE" | "IO_ERROR";
    interface PMASettingsManualTx {
        pre3: number;
        pre2: number;
        pre1: number;
        main: number;
        post: number;
    }
    const Enums: {
        readonly PortMode: PortMode[];
        readonly PTPCalibrationStatus: PTPCalibrationStatus[];
        readonly Lane: Lane[];
    };
}
export declare namespace PCap {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly InternalStateAwaitingReplayStartTime: (_raw: [], _socket: VScript.VSocket) => InternalStateAwaitingReplayStartTime;
        readonly Instance: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Instance;
        readonly InternalState: (_raw: ([0, ([0, []] | [1, [number, number, number]] | [2, [null | number, null | number | string]])] | [1, []]), _socket: VScript.VSocket) => InternalState;
        readonly Mode: (_raw: ([0, []] | [1, [number, number, number]] | [2, [null | number, null | number | string]]), _socket: VScript.VSocket) => Mode;
        readonly ModeReplay: (_raw: [null | number, null | number | string], _socket: VScript.VSocket) => ModeReplay;
        readonly ModeStore: (_raw: [], _socket: VScript.VSocket) => ModeStore;
        readonly ModeStoreAndForward: (_raw: [number, number, number], _socket: VScript.VSocket) => ModeStoreAndForward;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly InternalStateAwaitingReplayStartTime: (_x: {}, _socket: VScript.VSocket) => [];
        readonly Instance: (_x: Instance) => string;
        readonly InternalState: (_x: ({
            variant: "Established";
            value: VAPI.AT1130.PCap.Mode;
        } | {
            variant: "AwaitingReplayStartTime";
            value: VAPI.AT1130.PCap.InternalStateAwaitingReplayStartTime;
        }), _socket: VScript.VSocket) => ([0, ([0, []] | [1, [number, number, number]] | [2, [null | number, null | number | string]])] | [1, []]);
        readonly Mode: (_x: ({
            variant: "Store";
            value: VAPI.AT1130.PCap.ModeStore;
        } | {
            variant: "StoreAndForward";
            value: VAPI.AT1130.PCap.ModeStoreAndForward;
        } | {
            variant: "Replay";
            value: VAPI.AT1130.PCap.ModeReplay;
        }), _socket: VScript.VSocket) => ([0, []] | [1, [number, number, number]] | [2, [null | number, null | number | string]]);
        readonly ModeReplay: (_x: {
            /**
              Set this to null to disable looping
            */
            pause_between_loops: null | VAPI.PCap.Delay;
            /**
              Start readout at this PTP timestamp
            */
            start_time: null | VAPI.Primitives.Timestamp;
        }, _socket: VScript.VSocket) => [null | number, null | number | string];
        readonly ModeStore: (_x: {}, _socket: VScript.VSocket) => [];
        readonly ModeStoreAndForward: (_x: {
            min_delay: VAPI.PCap.Delay;
            jitter: VScript.Duration;
            /**
              fraction of packets to be randomly excluded from retransmission,
              adjustable between 0.0 (inclusive) and 1.0 (exclusive) in steps
              of 2^(-32).
            */
            packet_loss_rate: number;
        }, _socket: VScript.VSocket) => [number, number, number];
    };
    class All implements VScript.Referenceable<"PCap::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PCap::Data::All";
        get runtime_constants(): {
            readonly num_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedArray<VScript.VSocket, "PCap::Data::Instance", Instance>;
    }
    interface InternalStateAwaitingReplayStartTime {
    }
    class Instance implements VScript.Referenceable<"PCap::Data::Instance"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PCap::Data::Instance";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ingress(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.NetworkInterfaces.Port, VAPI.AT1130.PCap.Instance>;
        get egress(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.NetworkInterfaces.Port, VAPI.AT1130.PCap.Instance>;
        get mode(): VScript.dKeyword<VScript.VSocket, null | ([0, []] | [
            1,
            [
                number,
                number,
                number
            ]
        ] | [
            2,
            [
                null | number,
                null | number | string
            ]
        ]), null | ([0, []] | [
            1,
            [
                number,
                number,
                number
            ]
        ] | [
            2,
            [
                null | number,
                null | number | string
            ]
        ]), null | VAPI.AT1130.PCap.Mode, null | VAPI.AT1130.PCap.Mode, VAPI.AT1130.PCap.Instance>;
        /**
          Memory area currently holding valid pcap data
        */
        get cur_range(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number
        ], VAPI.PCap.MemoryRange, VAPI.AT1130.PCap.Instance>;
        get pending_dma_transfers(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.PCap.InstancePendingDmaTransfers, VAPI.AT1130.PCap.Instance>;
        get capacity_at_cur_rate(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.PCap.Instance>;
        get uploaded_file(): VAPI.PCap.FileInfo;
        get igmp_memberships(): VScript.StronglyTypedNamedTable<VScript.VSocket, "PCap::Data::IGMPMembership", VAPI.PCap.IGMPMembershipAsNamedTableRow>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.PCap.InstanceIssues, VAPI.AT1130.PCap.Instance>;
    }
    type InternalState = ({
        variant: "Established";
        value: VAPI.AT1130.PCap.Mode;
    } | {
        variant: "AwaitingReplayStartTime";
        value: VAPI.AT1130.PCap.InternalStateAwaitingReplayStartTime;
    });
    type Mode = ({
        variant: "Store";
        value: VAPI.AT1130.PCap.ModeStore;
    } | {
        variant: "StoreAndForward";
        value: VAPI.AT1130.PCap.ModeStoreAndForward;
    } | {
        variant: "Replay";
        value: VAPI.AT1130.PCap.ModeReplay;
    });
    interface ModeReplay {
        /**
          Set this to null to disable looping
        */
        pause_between_loops: null | VAPI.PCap.Delay;
        /**
          Start readout at this PTP timestamp
        */
        start_time: null | VAPI.Primitives.Timestamp;
    }
    interface ModeStore {
    }
    interface ModeStoreAndForward {
        min_delay: VAPI.PCap.Delay;
        jitter: VScript.Duration;
        /**
          fraction of packets to be randomly excluded from retransmission,
          adjustable between 0.0 (inclusive) and 1.0 (exclusive) in steps of
          2^(-32).
        */
        packet_loss_rate: number;
    }
    type InstanceIssues = {
        missing_pcap_file: boolean;
        pending_dma_requests: boolean;
    };
}
export declare namespace PTPClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"PTPClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPClock::Data::All";
        get runtime_constants(): {
            readonly allows_clock_randomization: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.PTPClock.All>;
        get state(): VScript.rKeyword<VScript.VSocket, VAPI.PTPClock.State, VAPI.PTPClock.State, VAPI.AT1130.PTPClock.All>;
        /**
          when `mode` is set to `LockToInput`, the PTP clock will attempt to
          synchronize with the external time source designated by `input`. This is
          the default setting and typically the only option suitable for production
          use.
          
          When `mode` is set to `UseInternalOscillator`, the PTP clock will first
          reset its speed to the nominal clock rate generated by its internal
          oscillator, and in the following suspend all clock control operations.
          Likewise, `Disconnect` suspends all clock control operations but in
          contrast to `UseInternalOscillator` continues to run at the current value
          of `relative_clock_speed`
        */
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.AT1130.PTPClock.All>;
        get statistics(): VAPI.PTPClock.AllStatistics;
        get relative_clock_speed(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.PTPClock.All>;
        get parameters(): VAPI.PTPClock.AllParameters;
        get micro_epochs(): VScript.rKeyword<VScript.VSocket, [
            [
                number,
                number,
                number | string,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number,
                number | string,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            null | number,
            null | number
        ], VAPI.PTPClock.MicroEpochs, VAPI.AT1130.PTPClock.All>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
        /**
          @brief Randomize clock
          @desc Do not push this button
        */
        get randomize_clock(): VScript.rwKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.PTPClock.All>;
    }
}
export declare namespace PTPFlows {
    const lift: {
        readonly Agent: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Agent;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Master: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Master;
        readonly MasterSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MasterSettings;
        readonly Port: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Port;
        readonly PortBestMasters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortBestMasters;
        readonly AgentLatchedVifc: (_raw: [null | number, VAPI.AT1130.NetworkInterfaces.Lane], _socket: VScript.VSocket) => AgentLatchedVifc;
        readonly MasterVisibleVia: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MasterVisibleVia;
    };
    const lower: {
        readonly Agent: (_x: Agent) => string;
        readonly All: (_x: All) => string;
        readonly Master: (_x: Master) => string;
        readonly MasterSettings: (_x: MasterSettings) => string;
        readonly Port: (_x: Port) => string;
        readonly PortBestMasters: (_x: PortBestMasters) => string;
        readonly AgentLatchedVifc: (_x: {
            vlan_id: null | VAPI.Primitives.VlanID;
            lane: VAPI.AT1130.NetworkInterfaces.Lane;
        }, _socket: VScript.VSocket) => [null | number, VAPI.AT1130.NetworkInterfaces.Lane];
        readonly MasterVisibleVia: (_x: MasterVisibleVia) => string;
    };
    class Agent implements VScript.Referenceable<"PTPFlows::Data::Agent"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Agent";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.AT1130.PTPFlows.Agent>;
        get state(): VScript.rKeyword<VScript.VSocket, VAPI.PTPFlows.AgentState, VAPI.PTPFlows.AgentState, VAPI.AT1130.PTPFlows.Agent>;
        get domain(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTP.Domain, VAPI.PTP.Domain, VAPI.AT1130.PTPFlows.Agent>;
        get hosting_port(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.PTPFlows.Port, null | VScript.Referenceable<"PTPFlows::Data::Port"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.PTPFlows.Agent>;
        /**
          Because port references may be invalidated on changes to the network
          configuration, PTP agents store their lane and VLAN ids instead, and use
          those to either recover hosting port information on startup, or reject
          their configuration as invalid if the previously selected PTP port is no
          longer available
        */
        get latched_vifc(): VScript.rKeyword<VScript.VSocket, null | [
            null | number,
            VAPI.AT1130.NetworkInterfaces.Lane
        ], null | VAPI.AT1130.PTPFlows.AgentLatchedVifc, VAPI.AT1130.PTPFlows.Agent>;
        /**
          best (as defined by the Best Master Clock algorithm) PTP master visible
          on this interface and within this PTP domain, excluding this agent
          itself.
        */
        get best_foreign_master(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.PTPFlows.Master, VAPI.AT1130.PTPFlows.Agent>;
        get slave_settings(): VAPI.PTPFlows.SlaveSettings;
        get master_settings(): MasterSettings;
        get slave_statistics(): VAPI.PTPFlows.AgentSlaveStatistics;
        get master_statistics(): VAPI.PTPFlows.AgentMasterStatistics;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.PTPFlows.AgentIssues, VAPI.AT1130.PTPFlows.Agent>;
        get output(): VAPI.AT1130.Time.Source;
    }
    class AgentAsNamedTableRow extends Agent {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class All implements VScript.Referenceable<"PTPFlows::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::All";
        get runtime_constants(): {
            readonly supports_delayresp_in_hardware: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get general_settings(): VAPI.PTPFlows.AllGeneralSettings;
        get agents(): VScript.StronglyTypedNamedTable<VScript.VSocket, "PTPFlows::Data::Agent", AgentAsNamedTableRow>;
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Port", Port>;
        get visible_masters(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Master", Master>;
    }
    class Master implements VScript.Referenceable<"PTPFlows::Data::Master"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Master";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gen_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.PTPFlows.Master>;
        get evt_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1130.PTPFlows.Master>;
        get visible_via(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Master::VisibleVia", MasterVisibleVia>;
        /**
          PTP traits as extracted from the most recently received announce message
        */
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class MasterSettings implements VScript.Referenceable<"PTPFlows::Data::MasterSettings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::MasterSettings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          base-2 logarithm of the announce interval in seconds. E.g., a setting of
          -2 will cause this agent to emit announce messages 4 times a second; 2
          times a second if this is set to -1.
        */
        get log2_announce_interval(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.MasterSettingsLog2AnnounceInterval, VAPI.PTPFlows.MasterSettingsLog2AnnounceInterval, VAPI.AT1130.PTPFlows.MasterSettings>;
        /**
          base-2 logarithm of the sync interval in seconds. E.g., a setting of -3
          will cause this agent to emit sync and followup messages 8 times a
          second; 4 times a second if this is set to -2.
        */
        get log2_sync_interval(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.MasterSettingsLog2SyncInterval, VAPI.PTPFlows.MasterSettingsLog2SyncInterval, VAPI.AT1130.PTPFlows.MasterSettings>;
        get delay_decimation_factor(): VScript.rKeyword<VScript.VSocket, number, VAPI.PTPFlows.MasterSettingsDelayDecimationFactor, VAPI.AT1130.PTPFlows.MasterSettings>;
        get grandmaster(): VAPI.PTPFlows.MasterSettingsGrandmaster;
        /**
          unlike sync and follow-up messages, which contain no client-dependent
          information and are thus useful to all clients within their PTP domain,
          delay request/response messages are useful only to the inquiring client
          (and perhaps to the master if it wishes to monitor its clients' timing
          properties). Exchanging these messages via unicast reduces both network
          traffic and local workload but yields otherwise identical results (this
          mode may also be called `Hybrid` on other products). If
          `delay_resp_routing` is set to `Multicast`, all delay responses emitted
          by this agent will be sent to the PTP multicast address `224.0.1.129`
        */
        get delay_resp_routing(): VScript.dKeyword<VScript.VSocket, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.AT1130.PTPFlows.MasterSettings>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.PTPFlows.MasterSettings>;
    }
    class Port implements VScript.Referenceable<"PTPFlows::Data::Port"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Port";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.PTPFlows.Port>;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.PTPFlows.Port>;
        get hosting_interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.AT1130.PTPFlows.Port>;
        get lane(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1130.NetworkInterfaces.Lane, null | VAPI.AT1130.NetworkInterfaces.Lane, VAPI.AT1130.PTPFlows.Port>;
        get port_identity(): VScript.rKeyword<VScript.VSocket, [
            Array<number>,
            number
        ], VAPI.PTP.PortIdentity, VAPI.AT1130.PTPFlows.Port>;
        get best_masters(): VScript.StronglyTypedArray<VScript.VSocket, "PTPFlows::Data::Port::BestMasters", PortBestMasters>;
        /**
          use this TTL value for all multicast event messages (UDP port 319) sent
          out from this PTP port
        */
        get multicast_event_ttl(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.PTPFlows.Port>;
        /**
          use this DSCP for all event messages (UDP port 319) sent out from this
          PTP port
        */
        get event_dscp(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.DiffServCodePoint, VAPI.PTPFlows.DiffServCodePoint, VAPI.AT1130.PTPFlows.Port>;
        /**
          use this TTL value for all general multicast messages (UDP port 320) sent
          out from this PTP port
        */
        get multicast_general_ttl(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.PTPFlows.Port>;
        /**
          use this DSCP for all general messages (UDP port 320) sent out from this
          PTP port
        */
        get general_dscp(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.DiffServCodePoint, VAPI.PTPFlows.DiffServCodePoint, VAPI.AT1130.PTPFlows.Port>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.PTPFlows.PortIssues, VAPI.AT1130.PTPFlows.Port>;
    }
    class PortBestMasters implements VScript.Referenceable<"PTPFlows::Data::Port::BestMasters"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Port::BestMasters";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.PTPFlows.Master, VAPI.AT1130.PTPFlows.PortBestMasters>;
    }
    type PortIssues = {
        denied_general_dscp_request: boolean;
        denied_general_ttl_request: boolean;
        unresolved_dscp_request: boolean;
        unresolved_ttl_request: boolean;
        waiting_for_rx_calibration: boolean;
        waiting_for_tx_calibration: boolean;
    };
    /**
      Because port references may be invalidated on changes to the network
      configuration, PTP agents store their lane and VLAN ids instead, and use
      those to either recover hosting port information on startup, or reject
      their configuration as invalid if the previously selected PTP port is no
      longer available
    */
    interface AgentLatchedVifc {
        vlan_id: null | VAPI.Primitives.VlanID;
        lane: VAPI.AT1130.NetworkInterfaces.Lane;
    }
    class MasterVisibleVia implements VScript.Referenceable<"PTPFlows::Data::Master::VisibleVia"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Master::VisibleVia";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get port(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.PTPFlows.Port, VAPI.AT1130.PTPFlows.MasterVisibleVia>;
        /**
          time at which an announce message from this master had last been received
          via the referenced port, measured relative to process initialization time
        */
        get announced_at(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.PTPFlows.MasterVisibleVia>;
    }
}
export declare namespace Primitives {
    type NetworkPortID = "FRONT_MANAGEMENT" | "REAR_MANAGEMENT" | "PORT0" | "PORT1";
    type StreamNetworkPortID = "PORT0" | "PORT1";
    const Enums: {
        readonly StreamNetworkPortID: StreamNetworkPortID[];
        readonly NetworkPortID: NetworkPortID[];
    };
}
export declare namespace RTPReceiver {
    const lift: {
        readonly ReadSpeedAdaptive: (_raw: [], _socket: VScript.VSocket) => ReadSpeedAdaptive;
        readonly AffineNetworkSource: (_raw: [null | string, number], _socket: VScript.VSocket) => AffineNetworkSource;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AncBurstReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AncBurstReceiver;
        readonly AssociatedStream: (_raw: [null | string, number, null | [number, number, number, number]], _socket: VScript.VSocket) => AssociatedStream;
        readonly AudioBackend: (_raw: [number, number, null | string, Array<null | number>, number, [number, null | number], Array<null | number>], _socket: VScript.VSocket) => AudioBackend;
        readonly AudioCapabilities: (_raw: [number, VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit, boolean, ([0, [null | string]] | [1, []])], _socket: VScript.VSocket) => AudioCapabilities;
        readonly AudioFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioFlowPartition;
        readonly AudioReadIndices: (_raw: [number, null | number], _socket: VScript.VSocket) => AudioReadIndices;
        readonly AudioReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiver;
        readonly TimingTargetBufferMidpoint: (_raw: [], _socket: VScript.VSocket) => TimingTargetBufferMidpoint;
        readonly BufferProfile: (_raw: [number, number, number], _socket: VScript.VSocket) => BufferProfile;
        readonly BufferSizes: (_raw: [VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize], _socket: VScript.VSocket) => BufferSizes;
        readonly TimingTargetEgressPlusX: (_raw: [number], _socket: VScript.VSocket) => TimingTargetEgressPlusX;
        readonly TimingTargetForeignMediaClock: (_raw: [null | string, number, VAPI.RTPReceiver.BackpressurePolicy], _socket: VScript.VSocket) => TimingTargetForeignMediaClock;
        readonly TimingTargetForeignReadDelay: (_raw: [null | string, number, VAPI.RTPReceiver.BackpressurePolicy], _socket: VScript.VSocket) => TimingTargetForeignReadDelay;
        readonly TimingTargetIngressPlusX: (_raw: [number], _socket: VScript.VSocket) => TimingTargetIngressPlusX;
        readonly JpegXsVideoBackend: (_raw: [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], _socket: VScript.VSocket) => JpegXsVideoBackend;
        readonly ReadSpeedLockToGenlock: (_raw: [null | string], _socket: VScript.VSocket) => ReadSpeedLockToGenlock;
        readonly MediaReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaReceiver;
        readonly MemoryChannelInfo: (_raw: [number, number, [Array<null | number>, Array<null | number>, Array<null | [number, number]>], number], _socket: VScript.VSocket) => MemoryChannelInfo;
        readonly MetadataBackend: (_raw: [number, number, [number, number], number, number], _socket: VScript.VSocket) => MetadataBackend;
        readonly NativeVideoBackend: (_raw: [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], _socket: VScript.VSocket) => NativeVideoBackend;
        readonly NetworkSource: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => NetworkSource;
        readonly PacketStream: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PacketStream;
        readonly PacketTracer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PacketTracer;
        readonly PassthroughEssence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughEssence;
        readonly PassthroughFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughFlowPartition;
        readonly PassthroughReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughReceiver;
        readonly ReadSpeed: (_raw: ([0, [null | string]] | [1, []]), _socket: VScript.VSocket) => ReadSpeed;
        readonly ReserveAudioBackend: (_raw: [number, number, Array<null | number>, number, [number, null | number], Array<null | number>, null | number], _socket: VScript.VSocket) => ReserveAudioBackend;
        readonly Session: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Session;
        readonly TimingTargetTimeSource: (_raw: [null | string, boolean], _socket: VScript.VSocket) => TimingTargetTimeSource;
        readonly Timing: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Timing;
        readonly TimingTarget: (_raw: ([0, [number]] | [1, [number]] | [2, [null | string, boolean]] | [3, []] | [4, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]] | [5, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]]), _socket: VScript.VSocket) => TimingTarget;
        readonly VideoBackend: (_raw: [null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | string], _socket: VScript.VSocket) => VideoBackend;
        readonly VideoCapabilities: (_raw: [boolean, boolean, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber, boolean, boolean, ([0, [null | string]] | [1, []])], _socket: VScript.VSocket) => VideoCapabilities;
        readonly VideoFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoFlowPartition;
        readonly VideoReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiver;
        readonly MemoryChannelInfoConnectedToAudio: (_raw: [number, number], _socket: VScript.VSocket) => MemoryChannelInfoConnectedToAudio;
        readonly MemoryChannelInfoConnectedTo: (_raw: [Array<null | number>, Array<null | number>, Array<null | [number, number]>], _socket: VScript.VSocket) => MemoryChannelInfoConnectedTo;
        readonly AllDiagnostics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllDiagnostics;
        readonly AllDiagnosticsRtpInputFillLevel: (_raw: [number, number], _socket: VScript.VSocket) => AllDiagnosticsRtpInputFillLevel;
        readonly PassthroughReceiverFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => PassthroughReceiverFlowPartitions;
        readonly AudioReceiverMediaSpecificFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => AudioReceiverMediaSpecificFlowPartitions;
        readonly VideoReceiverMediaSpecificFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => VideoReceiverMediaSpecificFlowPartitions;
        readonly AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_raw: [null | VAPI.AT1130.Primitives.NetworkPortID, null | string, null | string, null | number, null | number, null | number, null | number], _socket: VScript.VSocket) => AllDiagnosticsIgmpPerformanceMetricsIgmpLatency;
        readonly AllDiagnosticsIgmpPerformanceMetrics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllDiagnosticsIgmpPerformanceMetrics;
        readonly AncBurstReceiverMediaClock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AncBurstReceiverMediaClock;
        readonly AudioReceiverMediaSpecific: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiverMediaSpecific;
        readonly VideoReceiverMediaSpecific: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiverMediaSpecific;
        readonly PassthroughEssenceMemoryBlocks: (_raw: [number, Array<null | number>], _socket: VScript.VSocket) => PassthroughEssenceMemoryBlocks;
        readonly AudioReceiverMediaSpecificOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiverMediaSpecificOutput;
        readonly VideoReceiverMediaSpecificOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiverMediaSpecificOutput;
        readonly MediaReceiverPacketStreams: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaReceiverPacketStreams;
        readonly AllDiagnosticsRtpInputPacketsDiscarded: (_raw: [number, number, number, number], _socket: VScript.VSocket) => AllDiagnosticsRtpInputPacketsDiscarded;
        readonly AllDiagnosticsRtpInput: (_raw: [number, [number, number, number, number], [number, number]], _socket: VScript.VSocket) => AllDiagnosticsRtpInput;
        readonly AllSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllSettings;
        readonly PacketStreamStreamParameters: (_raw: [number, null | string, null | string, null | string, VAPI.RTPReceiver.PacketStreamType, number, VAPI.AT1130.RTPReceiver.PacketStreamStreamParametersIrqRate], _socket: VScript.VSocket) => PacketStreamStreamParameters;
    };
    const lower: {
        readonly ReadSpeedAdaptive: (_x: {}, _socket: VScript.VSocket) => [];
        readonly AffineNetworkSource: (_x: {
            source: null | VAPI.AT1130.RTPReceiver.NetworkSource;
            seqnr_offset: VAPI.Primitives.Unsigned16;
        }, _socket: VScript.VSocket) => [null | string, number];
        readonly All: (_x: All) => string;
        readonly AncBurstReceiver: (_x: AncBurstReceiver) => string;
        readonly AssociatedStream: (_x: {
            stream: null | VAPI.AT1130.RTPReceiver.PacketStream;
            /**
              used to distinguish between a video flow's underlying video streams
              (subflows 0 to 3 for a quad-link flow, 0 otherwise), and its
              2110-40 sidecar (4), if any
            */
            subflow_index: VAPI.RTPReceiver.SubflowIndex;
            read_delay: null | VAPI.Time.TimestampedOffset;
        }, _socket: VScript.VSocket) => [null | string, number, null | [number, number, number, number]];
        readonly AudioBackend: (_x: {
            group: VAPI.RTPReceiver.AudioBlockIndex;
            instance: VAPI.RTPReceiver.AudioInstanceIndex;
            servo: null | VAPI.RTPReceiver.AudioServo;
            slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            read_indices: VAPI.AT1130.RTPReceiver.AudioReadIndices;
            fifo_blocks: Array<null | VAPI.AT1130.RTPReceiver.AudioDecoderFIFOBlock>;
        }, _socket: VScript.VSocket) => [number, number, null | string, Array<null | number>, number, [number, null | number], Array<null | number>];
        readonly AudioCapabilities: (_x: {
            channel_capacity: VAPI.RTPReceiver.ChannelCapacity;
            payload_limit: VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit;
            supports_clean_switching: boolean;
            read_speed: VAPI.AT1130.RTPReceiver.ReadSpeed;
        }, _socket: VScript.VSocket) => [number, VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit, boolean, ([0, [null | string]] | [1, []])];
        readonly AudioFlowPartition: (_x: AudioFlowPartition) => string;
        readonly AudioReadIndices: (_x: {
            primary: number;
            secondary: null | number;
        }, _socket: VScript.VSocket) => [number, null | number];
        readonly AudioReceiver: (_x: AudioReceiver) => string;
        readonly TimingTargetBufferMidpoint: (_x: {}, _socket: VScript.VSocket) => [];
        readonly BufferProfile: (_x: {
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
            blockcount: VAPI.RTPReceiver.BlockCount;
        }, _socket: VScript.VSocket) => [number, number, number];
        readonly BufferSizes: (_x: {
            for_audio: VAPI.AT1130.RTPReceiver.BufferSize;
            for_2022_6: VAPI.AT1130.RTPReceiver.BufferSize;
            for_2110_20_uhd_singlelink: VAPI.AT1130.RTPReceiver.BufferSize;
            for_2110_20_other: VAPI.AT1130.RTPReceiver.BufferSize;
            for_2042_2: VAPI.AT1130.RTPReceiver.BufferSize;
            for_jpeg_xs: VAPI.AT1130.RTPReceiver.BufferSize;
            for_passthrough: VAPI.AT1130.RTPReceiver.BufferSize;
        }, _socket: VScript.VSocket) => [VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize, VAPI.AT1130.RTPReceiver.BufferSize];
        readonly TimingTargetEgressPlusX: (_x: {
            /**
              Read out every packet this late after egress at the sender (if
              sender and receiver are in sync, and RTP timestamps are not
              modified via `rtp_timestamp_override`)
            */
            read_delay: VScript.Duration;
        }, _socket: VScript.VSocket) => [number];
        readonly TimingTargetForeignMediaClock: (_x: {
            foreign_receiver: null | VAPI.AT1130.RTPReceiver.MediaReceiver;
            extra_delay: VScript.Duration;
            on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
        }, _socket: VScript.VSocket) => [null | string, number, VAPI.RTPReceiver.BackpressurePolicy];
        readonly TimingTargetForeignReadDelay: (_x: {
            foreign_receiver: null | VAPI.AT1130.RTPReceiver.MediaReceiver;
            extra_delay: VScript.Duration;
            on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
        }, _socket: VScript.VSocket) => [null | string, number, VAPI.RTPReceiver.BackpressurePolicy];
        readonly TimingTargetIngressPlusX: (_x: {
            /**
              Read out every packet this late after arrival at the receiving
              network interface (if `use_rtp_timestamp` is set to `false`) or
              after egress at the sender (if `use_rtp_timestamp` is set to
              `true`, sender and receiver are in sync, and RTP timestamps are
              not modified via `rtp_timestamp_override`)
            */
            read_delay: VScript.Duration;
        }, _socket: VScript.VSocket) => [number];
        readonly JpegXsVideoBackend: (_x: {
            group: VAPI.RTPReceiver.JpegXsBlockIndex;
            instances: Array<null | VAPI.RTPReceiver.JpegXsDecoderInstance>;
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            metadata: null | VAPI.AT1130.RTPReceiver.MetadataBackend;
        }, _socket: VScript.VSocket) => [number, Array<null | number>, number, null | [number, number, [number, number], number, number]];
        readonly ReadSpeedLockToGenlock: (_x: {
            genlock: null | VAPI.AT1130.Genlock.AT1130Genlock;
        }, _socket: VScript.VSocket) => [null | string];
        readonly MediaReceiver: (_x: MediaReceiver) => string;
        readonly MemoryChannelInfo: (_x: {
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
            connected_to: VAPI.AT1130.RTPReceiver.MemoryChannelInfoConnectedTo;
            blocks_left: number;
        }, _socket: VScript.VSocket) => [number, number, [Array<null | number>, Array<null | number>, Array<null | [number, number]>], number];
        readonly MetadataBackend: (_x: {
            group: VAPI.AT1130.RTPReceiver.MetadataBackendGroup;
            instance: VAPI.AT1130.RTPReceiver.MetadataBackendInstance;
            stats_id: VAPI.RTPReceiver.StatsID;
            read_id: VAPI.RTPReceiver.MMUReadIndex;
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        }, _socket: VScript.VSocket) => [number, number, [number, number], number, number];
        readonly NativeVideoBackend: (_x: {
            group: VAPI.RTPReceiver.NativeVideoBlockIndex;
            instances: Array<null | VAPI.RTPReceiver.NativeVideoDecoderInstance>;
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            metadata: null | VAPI.AT1130.RTPReceiver.MetadataBackend;
        }, _socket: VScript.VSocket) => [number, Array<null | number>, number, null | [number, number, [number, number], number, number]];
        readonly NetworkSource: (_x: NetworkSource) => string;
        readonly PacketStream: (_x: PacketStream) => string;
        readonly PacketTracer: (_x: PacketTracer) => string;
        readonly PassthroughEssence: (_x: PassthroughEssence) => string;
        readonly PassthroughFlowPartition: (_x: PassthroughFlowPartition) => string;
        readonly PassthroughReceiver: (_x: PassthroughReceiver) => string;
        readonly ReadSpeed: (_x: ({
            variant: "LockToGenlock";
            value: VAPI.AT1130.RTPReceiver.ReadSpeedLockToGenlock;
        } | {
            variant: "Adaptive";
            value: VAPI.AT1130.RTPReceiver.ReadSpeedAdaptive;
        }), _socket: VScript.VSocket) => ([0, [null | string]] | [1, []]);
        readonly ReserveAudioBackend: (_x: {
            group: VAPI.RTPReceiver.AudioBlockIndex;
            instance: VAPI.RTPReceiver.AudioInstanceIndex;
            slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            read_indices: VAPI.AT1130.RTPReceiver.AudioReadIndices;
            fifo_blocks: Array<null | VAPI.AT1130.RTPReceiver.AudioDecoderFIFOBlock>;
            fence: null | VAPI.Time.FreeRunningCounter;
        }, _socket: VScript.VSocket) => [number, number, Array<null | number>, number, [number, null | number], Array<null | number>, null | number];
        readonly Session: (_x: Session) => string;
        readonly TimingTargetTimeSource: (_x: {
            t_src: null | VAPI.AT1130.Time.Source;
            use_rtp_timestamp: boolean;
        }, _socket: VScript.VSocket) => [null | string, boolean];
        readonly Timing: (_x: Timing) => string;
        readonly TimingTarget: (_x: ({
            variant: "IngressPlusX";
            value: VAPI.AT1130.RTPReceiver.TimingTargetIngressPlusX;
        } | {
            variant: "EgressPlusX";
            value: VAPI.AT1130.RTPReceiver.TimingTargetEgressPlusX;
        } | {
            variant: "TimeSource";
            value: VAPI.AT1130.RTPReceiver.TimingTargetTimeSource;
        } | {
            variant: "BufferMidpoint";
            value: VAPI.AT1130.RTPReceiver.TimingTargetBufferMidpoint;
        } | {
            variant: "ForeignReadDelay";
            value: VAPI.AT1130.RTPReceiver.TimingTargetForeignReadDelay;
        } | {
            variant: "ForeignMediaClock";
            value: VAPI.AT1130.RTPReceiver.TimingTargetForeignMediaClock;
        }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]] | [2, [null | string, boolean]] | [3, []] | [4, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]] | [5, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]]);
        readonly VideoBackend: (_x: {
            native: null | VAPI.AT1130.RTPReceiver.NativeVideoBackend;
            jpeg_xs: null | VAPI.AT1130.RTPReceiver.JpegXsVideoBackend;
            servo: null | VAPI.RTPReceiver.VideoServo;
        }, _socket: VScript.VSocket) => [null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | string];
        readonly VideoCapabilities: (_x: {
            supports_2022_6: boolean;
            supports_uhd_sample_interleaved: boolean;
            st2110_20_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber;
            st2042_2_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber;
            jpeg_xs_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber;
            supports_2110_40: boolean;
            supports_clean_switching: boolean;
            read_speed: VAPI.AT1130.RTPReceiver.ReadSpeed;
        }, _socket: VScript.VSocket) => [boolean, boolean, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber, null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber, boolean, boolean, ([0, [null | string]] | [1, []])];
        readonly VideoFlowPartition: (_x: VideoFlowPartition) => string;
        readonly VideoReceiver: (_x: VideoReceiver) => string;
        readonly MemoryChannelInfoConnectedToAudio: (_x: {
            block: VAPI.RTPReceiver.AudioBlockIndex;
            fifo_blocks_left: number;
        }, _socket: VScript.VSocket) => [number, number];
        readonly MemoryChannelInfoConnectedTo: (_x: {
            video_native: Array<null | VAPI.RTPReceiver.NativeVideoBlockIndex>;
            video_jpegxs: Array<null | VAPI.RTPReceiver.JpegXsBlockIndex>;
            audio: Array<null | VAPI.AT1130.RTPReceiver.MemoryChannelInfoConnectedToAudio>;
        }, _socket: VScript.VSocket) => [Array<null | number>, Array<null | number>, Array<null | [number, number]>];
        readonly AllDiagnostics: (_x: AllDiagnostics) => string;
        readonly AllDiagnosticsRtpInputFillLevel: (_x: {
            min: VAPI.Primitives.Unsigned8;
            max: VAPI.Primitives.Unsigned8;
        }, _socket: VScript.VSocket) => [number, number];
        readonly PassthroughReceiverFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1130.RTPReceiver.PassthroughFlowPartition;
            sdp_b: null | VAPI.AT1130.RTPReceiver.PassthroughFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly AudioReceiverMediaSpecificFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1130.RTPReceiver.AudioFlowPartition;
            sdp_b: null | VAPI.AT1130.RTPReceiver.AudioFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly VideoReceiverMediaSpecificFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1130.RTPReceiver.VideoFlowPartition;
            sdp_b: null | VAPI.AT1130.RTPReceiver.VideoFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_x: {
            port: null | VAPI.AT1130.Primitives.NetworkPortID;
            src: null | string;
            dst: null | string;
            time_to_first_mpacket: null | VScript.Duration;
            first_rtp_timestamp: null | VAPI.Time.RTPTimestamp;
            first_rtp_seqnr: null | VAPI.RTPReceiver.Seqnr;
            /**
              time between two m-packets. This
              defines the latency measurement's
              uncertainty and depends on video
              standards, transport formats and (for
              audio streams) on the currently
              configured IRQ rate
            */
            mpacket_interval: null | VScript.Duration;
        }, _socket: VScript.VSocket) => [null | VAPI.AT1130.Primitives.NetworkPortID, null | string, null | string, null | number, null | number, null | number, null | number];
        readonly AllDiagnosticsIgmpPerformanceMetrics: (_x: AllDiagnosticsIgmpPerformanceMetrics) => string;
        readonly AncBurstReceiverMediaClock: (_x: AncBurstReceiverMediaClock) => string;
        readonly AudioReceiverMediaSpecific: (_x: AudioReceiverMediaSpecific) => string;
        readonly VideoReceiverMediaSpecific: (_x: VideoReceiverMediaSpecific) => string;
        readonly PassthroughEssenceMemoryBlocks: (_x: {
            channel: VAPI.AT1130.RTPReceiver.RAMChannel;
            blocks: Array<null | VAPI.AT1130.RTPReceiver.RAMBlock>;
        }, _socket: VScript.VSocket) => [number, Array<null | number>];
        readonly AudioReceiverMediaSpecificOutput: (_x: AudioReceiverMediaSpecificOutput) => string;
        readonly VideoReceiverMediaSpecificOutput: (_x: VideoReceiverMediaSpecificOutput) => string;
        readonly MediaReceiverPacketStreams: (_x: MediaReceiverPacketStreams) => string;
        readonly AllDiagnosticsRtpInputPacketsDiscarded: (_x: {
            input_errors: VAPI.Primitives.CyclicCounter32;
            oversized: VAPI.Primitives.CyclicCounter32;
            data_fifo_full: VAPI.Primitives.CyclicCounter32;
            info_fifo_full: VAPI.Primitives.CyclicCounter32;
        }, _socket: VScript.VSocket) => [number, number, number, number];
        readonly AllDiagnosticsRtpInput: (_x: {
            packets_written: VAPI.Primitives.CyclicCounter32;
            packets_discarded: VAPI.AT1130.RTPReceiver.AllDiagnosticsRtpInputPacketsDiscarded;
            fill_level: VAPI.AT1130.RTPReceiver.AllDiagnosticsRtpInputFillLevel;
        }, _socket: VScript.VSocket) => [number, [number, number, number, number], [number, number]];
        readonly AllSettings: (_x: AllSettings) => string;
        readonly PacketStreamStreamParameters: (_x: {
            /**
              Seqnr offset relative
              to other packet streams
              mapped to the same
              memory region. N packet
              streams hence define
              N-1 meaningful offsets.
            */
            seqnr_offset: VAPI.RTPReceiver.SeqnrDifference;
            /**
              IP (unicast) address of
              the RTP stream sender
            */
            src_address: null | string;
            /**
              IP (multicast)
              destination address of
              the RTP stream
            */
            dst_address: null | string;
            interface: null | VAPI.NetworkInterfaces.VirtualInterface;
            type: VAPI.RTPReceiver.PacketStreamType;
            pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
            irq_rate: VAPI.AT1130.RTPReceiver.PacketStreamStreamParametersIrqRate;
        }, _socket: VScript.VSocket) => [number, null | string, null | string, null | string, VAPI.RTPReceiver.PacketStreamType, number, VAPI.AT1130.RTPReceiver.PacketStreamStreamParametersIrqRate];
    };
    interface ReadSpeedAdaptive {
    }
    interface AffineNetworkSource {
        source: null | VAPI.AT1130.RTPReceiver.NetworkSource;
        seqnr_offset: VAPI.Primitives.Unsigned16;
    }
    class All implements VScript.Referenceable<"RTPReceiver::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All";
        get runtime_constants(): {
            readonly total_2022_6_audio_slices: number;
            readonly supports_2110_40_in_software: boolean;
            readonly max_audio_receivers: number;
            readonly uhd_packsize_2042_2: number;
            readonly uhd_packsize_2110_20: number;
            readonly supports_2110_40_in_hardware: boolean;
            readonly max_metadata_receivers: number;
            readonly video_memory_channels: number;
            readonly num_native_video_receiver_blocks: number;
            readonly audio_memory_channels: number;
            readonly total_2110_30_audio_slices: number;
            readonly max_audio_flow_partitions: number;
            readonly max_network_sources: number;
            readonly num_metadata_extractors_per_video_receiver: number;
            readonly blocks_per_memory_channel: number;
            readonly audio_fifo_blocks_per_memory_channel: number;
            readonly max_st2042_2_uhd_video_receivers: number;
            readonly max_sessions: number;
            readonly num_jpeg_xs_video_receiver_blocks: number;
            readonly max_passthrough_receivers: number;
            readonly max_video_buffers: number;
            readonly num_packet_tracers: number;
            readonly audio_fifo_blocks_per_memory_interface: number;
            readonly max_anc_burst_receivers: number;
            readonly max_metadata_streams: number;
            readonly max_video_flow_partitions: number;
            readonly max_st2110_20_uhd_video_receivers: number;
            readonly max_passthrough_flow_partitions: number;
            readonly has_fixed_audio_pseudo_channel: boolean;
            readonly max_native_video_receivers: number;
            readonly num_audio_receiver_blocks: number;
            readonly max_video_receivers: number;
            readonly max_metadata_buffers: number;
            readonly max_jpeg_xs_video_receivers: number;
            readonly num_metadata_receiver_blocks: number;
            readonly num_audio_servos: number;
            readonly num_video_servos: number;
            readonly max_st2042_2_video_receivers: number;
            readonly uhd_packsize_2si: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get license_information(): VAPI.RTPReceiver.AllLicenseInformation;
        get diagnostics(): AllDiagnostics;
        get settings(): AllSettings;
        get latest_allocation_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.CapabilityRequestID, VAPI.AT1130.RTPReceiver.All>;
        get sessions(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::Session", SessionAsNamedTableRow>;
        get audio_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::AudioReceiver", AudioReceiverAsNamedTableRow>;
        get passthrough_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::PassthroughReceiver", PassthroughReceiverAsNamedTableRow>;
        get video_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::VideoReceiver", VideoReceiverAsNamedTableRow>;
        get anc_burst_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::AncBurstReceiver", AncBurstReceiverAsNamedTableRow>;
        get signal_slices_2110_30(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        get signal_slices_2022_6(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        get packet_streams(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::PacketStream", PacketStream>;
        get network_sources(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::NetworkSource", NetworkSource>;
        get audio_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::AudioFlowPartition", AudioFlowPartition>;
        get passthrough_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::PassthroughFlowPartition", PassthroughFlowPartition>;
        get video_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::VideoFlowPartition", VideoFlowPartition>;
        get derived_ptp_traits(): VAPI.RTPReceiver.AllDerivedPtpTraits;
        get audio_servos(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::AudioServo", VAPI.RTPReceiver.AudioServo>;
        get video_servos(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::VideoServo", VAPI.RTPReceiver.VideoServo>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.AllIssues, VAPI.AT1130.RTPReceiver.All>;
    }
    class AncBurstReceiver implements VScript.Referenceable<"RTPReceiver::Data::AncBurstReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AncBurstReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_clock(): AncBurstReceiverMediaClock;
    }
    class AncBurstReceiverAsNamedTableRow extends AncBurstReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    /**
      for every subflow index, the first entry to appear in this list represents
      its rear guard
    */
    interface AssociatedStream {
        stream: null | VAPI.AT1130.RTPReceiver.PacketStream;
        /**
          used to distinguish between a video flow's underlying video streams
          (subflows 0 to 3 for a quad-link flow, 0 otherwise), and its 2110-40
          sidecar (4), if any
        */
        subflow_index: VAPI.RTPReceiver.SubflowIndex;
        read_delay: null | VAPI.Time.TimestampedOffset;
    }
    interface AudioBackend {
        group: VAPI.RTPReceiver.AudioBlockIndex;
        instance: VAPI.RTPReceiver.AudioInstanceIndex;
        servo: null | VAPI.RTPReceiver.AudioServo;
        slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        read_indices: VAPI.AT1130.RTPReceiver.AudioReadIndices;
        fifo_blocks: Array<null | VAPI.AT1130.RTPReceiver.AudioDecoderFIFOBlock>;
    }
    interface AudioCapabilities {
        channel_capacity: VAPI.RTPReceiver.ChannelCapacity;
        payload_limit: VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit;
        supports_clean_switching: boolean;
        read_speed: VAPI.AT1130.RTPReceiver.ReadSpeed;
    }
    type AudioDecoderFIFOBlock = number;
    class AudioFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::AudioFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
        get format(): VScript.rKeyword<VScript.VSocket, null | VAPI.Audio.Format, null | VAPI.Audio.Format, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
        get frequency(): VScript.rKeyword<VScript.VSocket, null | VAPI.Audio.Frequency, null | VAPI.Audio.Frequency, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
        get channelcount(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
        get samplecount(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1130.RTPReceiver.AffineNetworkSource>, VAPI.AT1130.RTPReceiver.AudioFlowPartition>;
    }
    interface AudioReadIndices {
        primary: number;
        secondary: null | number;
    }
    class AudioReceiver implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_specific(): AudioReceiverMediaSpecific;
    }
    class AudioReceiverAsNamedTableRow extends AudioReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface TimingTargetBufferMidpoint {
    }
    interface BufferProfile {
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
        blockcount: VAPI.RTPReceiver.BlockCount;
    }
    type BufferSize = "UpTo4MB" | "UpTo8MB" | "UpTo12MB" | "UpTo16MB" | "UpTo24MB" | "UpTo32MB" | "UpTo48MB" | "UpTo96MB";
    interface BufferSizes {
        for_audio: VAPI.AT1130.RTPReceiver.BufferSize;
        for_2022_6: VAPI.AT1130.RTPReceiver.BufferSize;
        for_2110_20_uhd_singlelink: VAPI.AT1130.RTPReceiver.BufferSize;
        for_2110_20_other: VAPI.AT1130.RTPReceiver.BufferSize;
        for_2042_2: VAPI.AT1130.RTPReceiver.BufferSize;
        for_jpeg_xs: VAPI.AT1130.RTPReceiver.BufferSize;
        for_passthrough: VAPI.AT1130.RTPReceiver.BufferSize;
    }
    interface TimingTargetEgressPlusX {
        /**
          Read out every packet this late after egress at the sender (if sender and
          receiver are in sync, and RTP timestamps are not modified via
          `rtp_timestamp_override`)
        */
        read_delay: VScript.Duration;
    }
    interface TimingTargetForeignMediaClock {
        foreign_receiver: null | VAPI.AT1130.RTPReceiver.MediaReceiver;
        extra_delay: VScript.Duration;
        on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
    }
    interface TimingTargetForeignReadDelay {
        foreign_receiver: null | VAPI.AT1130.RTPReceiver.MediaReceiver;
        extra_delay: VScript.Duration;
        on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
    }
    interface TimingTargetIngressPlusX {
        /**
          Read out every packet this late after arrival at the receiving network
          interface (if `use_rtp_timestamp` is set to `false`) or after egress at
          the sender (if `use_rtp_timestamp` is set to `true`, sender and receiver
          are in sync, and RTP timestamps are not modified via
          `rtp_timestamp_override`)
        */
        read_delay: VScript.Duration;
    }
    interface JpegXsVideoBackend {
        group: VAPI.RTPReceiver.JpegXsBlockIndex;
        instances: Array<null | VAPI.RTPReceiver.JpegXsDecoderInstance>;
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        metadata: null | VAPI.AT1130.RTPReceiver.MetadataBackend;
    }
    interface ReadSpeedLockToGenlock {
        genlock: null | VAPI.AT1130.Genlock.AT1130Genlock;
    }
    class MediaReceiver implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::MediaReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.OrderedTrackSet,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track
        ], VAPI.RTPReceiver.UsedReceiverTracks, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get main_region_holds(): VScript.rKeyword<VScript.VSocket, VAPI.RTPReceiver.Track, VAPI.RTPReceiver.Track, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.RTPReceiver.Session, null | VScript.Referenceable<"RTPReceiver::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get ingress(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.IngressTrackState,
            VAPI.RTPReceiver.IngressTrackState
        ], VAPI.RTPReceiver.Ingress, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get egress(): VScript.rKeyword<VScript.VSocket, [
            Array<null | [
                boolean,
                null | number
            ]>
        ], VAPI.RTPReceiver.Egress, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get expecting(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            [
                boolean,
                boolean
            ]
        ], VAPI.RTPReceiver.Expectations, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        /**
          Clear error counters
        */
        get clear_error_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        /**
          Clear event counters
        */
        get clear_event_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.MediaReceiverIssues, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.RTPReceiver.CapabilityRequestIDs, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get flight_permit(): VAPI.RTPReceiver.MediaReceiverFlightPermit;
        get error_counters(): VAPI.RTPReceiver.MediaReceiverErrorCounters;
        get event_counters(): VAPI.RTPReceiver.MediaReceiverEventCounters;
        get preparation_time(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get cooldown_time(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get timing(): Timing;
        get packet_streams(): MediaReceiverPacketStreams;
        get required_redundancy_level(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.RTPReceiver.MediaReceiverRequiredRedundancyLevel, VAPI.AT1130.RTPReceiver.MediaReceiver>;
        get redundancy_levels(): VAPI.RTPReceiver.MediaReceiverRedundancyLevels;
        get latency_spread(): VAPI.RTPReceiver.MediaReceiverLatencySpread;
        /**
          when set to `FirstStreamPresent`, the first packet stream to provide this
          receiver with valid format and timing characteristics will be used as the
          basis for the ensuing readout attempt. When set to `AllStreamsPresent`,
          the receiver will stall until all packet streams have been registered at
          their respective network interfaces. Whereas `FirstStreamPresent` may
          slightly reduce the time to readout, `AllStreamsPresent` is safer as it
          ensures immediate SPS protection (if so configured), and allows the
          receiver to correctly pick a rearguard stream if different network paths
          exhibit different transmission delays. In both cases, the set of packet
          streams considered encompasses only those flows directly referenced by
          this receiver's media description, not the auxiliary flows that may be
          routed to the receiver through stream sharing.
        */
        get initiate_readout_on(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.AT1130.RTPReceiver.MediaReceiver>;
    }
    interface MemoryChannelInfo {
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
        connected_to: VAPI.AT1130.RTPReceiver.MemoryChannelInfoConnectedTo;
        blocks_left: number;
    }
    interface MetadataBackend {
        group: VAPI.AT1130.RTPReceiver.MetadataBackendGroup;
        instance: VAPI.AT1130.RTPReceiver.MetadataBackendInstance;
        stats_id: VAPI.RTPReceiver.StatsID;
        read_id: VAPI.RTPReceiver.MMUReadIndex;
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
    }
    interface NativeVideoBackend {
        group: VAPI.RTPReceiver.NativeVideoBlockIndex;
        instances: Array<null | VAPI.RTPReceiver.NativeVideoDecoderInstance>;
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        metadata: null | VAPI.AT1130.RTPReceiver.MetadataBackend;
    }
    class NetworkSource implements VScript.Referenceable<"RTPReceiver::Data::NetworkSource"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::NetworkSource";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get packet_stream(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPReceiver.PacketStream, VAPI.AT1130.RTPReceiver.NetworkSource>;
    }
    class PacketStream implements VScript.Referenceable<"RTPReceiver::Data::PacketStream"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PacketStream";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get stream_parameters(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            null | string,
            null | string,
            null | string,
            VAPI.RTPReceiver.PacketStreamType,
            number,
            VAPI.AT1130.RTPReceiver.PacketStreamStreamParametersIrqRate
        ], null | VAPI.AT1130.RTPReceiver.PacketStreamStreamParameters, VAPI.AT1130.RTPReceiver.PacketStream>;
        /**
          no. of m-packets received since the last stream start (for audio streams,
          this refers to virtual m-packets). Note that for interlaced video
          streams, this number only includes lower field m-packets, i.e., a 50i
          2110 stream should report 25 m-packets per second.
        */
        get mpackets_received(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned64, VAPI.AT1130.RTPReceiver.PacketStream>;
        get traffic_stats(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1130.RTPReceiver.PacketStream>;
        get media_clock(): VAPI.AT1130.Time.Source;
    }
    class PacketTracer implements VScript.Referenceable<"RTPReceiver::Data::PacketTracer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PacketTracer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Set to true to enable realtime packet tracing in one of various modes.
          Note that packet tracing is CPU-intensive, and hence will always come up
          disabled after reboots.
        */
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.AT1130.RTPReceiver.PacketTracer>;
        /**
          Set this to `Store` to have the packet tracer store packet details (up to
          some limited maximum log file size) that can later be downloaded via
          HTTP.
        */
        get packet_details(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get filters(): VAPI.RTPReceiver.PacketTracerFilters;
        /**
          Reorder up to this many consecutive RTP packets before trying to check
          for missing sequence numbers
        */
        get reordering_depth(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get port(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.NetworkInterfaces.Port, null | VScript.Referenceable<"NetworkInterfaces::Data::Port"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PacketTracerIssues, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get cur_run(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number | string,
            number | string,
            number,
            number,
            number,
            number,
            number,
            number,
            VAPI.RTPReceiver.PacketTracerRunPacketDetails,
            VAPI.RTPReceiver.PacketTracerMode
        ], null | VAPI.RTPReceiver.PacketTracerRun, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get prev_run(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number | string,
            number | string,
            number,
            number,
            number,
            number,
            number,
            number,
            VAPI.RTPReceiver.PacketTracerRunPacketDetails,
            VAPI.RTPReceiver.PacketTracerMode
        ], null | VAPI.RTPReceiver.PacketTracerRun, VAPI.AT1130.RTPReceiver.PacketTracer>;
        get num_pending_downloads(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.NumDownloads, VAPI.AT1130.RTPReceiver.PacketTracer>;
    }
    class PassthroughEssence implements VScript.Referenceable<"RTPReceiver::Data::PassthroughEssence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughEssence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.RTPReceiver.PassthroughEssence>;
        get stream_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.RTPReceiver.PacketStreamIndex, VAPI.AT1130.RTPReceiver.PassthroughEssence>;
        get memory_blocks(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<null | number>
        ], null | VAPI.AT1130.RTPReceiver.PassthroughEssenceMemoryBlocks, VAPI.AT1130.RTPReceiver.PassthroughEssence>;
        get sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.RTPReceiver.PassthroughEssence>;
    }
    class PassthroughFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::PassthroughFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1130.RTPReceiver.PassthroughFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1130.RTPReceiver.AffineNetworkSource>, VAPI.AT1130.RTPReceiver.PassthroughFlowPartition>;
    }
    class PassthroughReceiver implements VScript.Referenceable<"RTPReceiver::Data::PassthroughReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.OrderedTrackSet,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track
        ], VAPI.RTPReceiver.UsedReceiverTracks, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.RTPReceiver.Session, null | VScript.Referenceable<"RTPReceiver::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        get ingress(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.IngressTrackState,
            VAPI.RTPReceiver.IngressTrackState
        ], VAPI.RTPReceiver.Ingress, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PassthroughReceiverIssues, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        get output(): PassthroughEssence;
        get reserved_buffer_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.RTPReceiver.BufferID, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.RTPReceiver.CapabilityRequestIDs, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1130.RTPReceiver.PassthroughReceiverFlowPartitions, VAPI.AT1130.RTPReceiver.PassthroughReceiver>;
    }
    class PassthroughReceiverAsNamedTableRow extends PassthroughReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    type RAMBlock = number;
    type RAMChannel = number;
    type RAMPseudoChannel = number;
    type ReadSpeed = ({
        variant: "LockToGenlock";
        value: VAPI.AT1130.RTPReceiver.ReadSpeedLockToGenlock;
    } | {
        variant: "Adaptive";
        value: VAPI.AT1130.RTPReceiver.ReadSpeedAdaptive;
    });
    interface ReserveAudioBackend {
        group: VAPI.RTPReceiver.AudioBlockIndex;
        instance: VAPI.RTPReceiver.AudioInstanceIndex;
        slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        read_indices: VAPI.AT1130.RTPReceiver.AudioReadIndices;
        fifo_blocks: Array<null | VAPI.AT1130.RTPReceiver.AudioDecoderFIFOBlock>;
        fence: null | VAPI.Time.FreeRunningCounter;
    }
    class Session implements VScript.Referenceable<"RTPReceiver::Data::Session"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::Session";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          A session only supports clean switching if all of its media receivers do
          (see
          `{audio,video}_receivers[*].media_specific.capabilities.supports_clean_switching`)
        */
        get supports_clean_switching(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.RTPReceiver.Session>;
        get switch_type(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            [number | string]
        ] | [
            2,
            [number | string]
        ]), ([0, []] | [
            1,
            [number | string]
        ] | [
            2,
            [number | string]
        ]), VAPI.RTPReceiver.SwitchType, VAPI.RTPReceiver.SwitchType, VAPI.AT1130.RTPReceiver.Session>;
        get video_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPReceiver.VideoReceiver>, VAPI.AT1130.RTPReceiver.Session>;
        get audio_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPReceiver.AudioReceiver>, VAPI.AT1130.RTPReceiver.Session>;
        get anc_burst_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPReceiver.AncBurstReceiver>, VAPI.AT1130.RTPReceiver.Session>;
        get passthrough_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPReceiver.PassthroughReceiver>, VAPI.AT1130.RTPReceiver.Session>;
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.Session>;
        get sdp_a(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.RTPReceiver.Session>;
        get sdp_b(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.RTPReceiver.Session>;
        get interfaces(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], [
            null | string,
            null | string
        ], VAPI.RTPReceiver.SessionInterfaces, VAPI.RTPReceiver.SessionInterfaces, VAPI.AT1130.RTPReceiver.Session>;
        get used_tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet
        ], VAPI.RTPReceiver.UsedSessionTracks, VAPI.AT1130.RTPReceiver.Session>;
        get last_accepted_track(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.RTPReceiver.Track,
            number,
            number,
            Array<number>
        ], null | VAPI.RTPReceiver.SessionLastAcceptedTrack, VAPI.AT1130.RTPReceiver.Session>;
        get event_counters(): VAPI.RTPReceiver.SessionEventCounters;
        get version_window(): VAPI.RTPReceiver.SessionVersionWindow;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.SessionIssues, VAPI.AT1130.RTPReceiver.Session>;
        set_sdp(track: VAPI.RTPReceiver.Track, sdp: string | null, pars?: {
            timeout?: VScript.Duration;
            retry_interval?: VScript.Duration;
        }): Promise<void>;
    }
    class SessionAsNamedTableRow extends Session {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface TimingTargetTimeSource {
        t_src: null | VAPI.AT1130.Time.Source;
        use_rtp_timestamp: boolean;
    }
    class Timing implements VScript.Referenceable<"RTPReceiver::Data::Timing"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::Timing";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          If possible, maintain at least this much distance from both buffer ends.
          Note that, to ensure a safe readout, the driver may decide to
          unilaterally increase the minimum safety margin, e.g., to at least 1.5ms
          when running in JPEG-XS mode
        */
        get safety_margin(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.Timing>;
        /**
          Capacity of the receive buffer, as dictated by buffer settings, packet
          rates and limitations of the statistics engine
        */
        get buffer_capacity(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.RTPReceiver.Timing>;
        get target(): VScript.dKeyword<VScript.VSocket, ([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [
                null | string,
                boolean
            ]
        ] | [
            3,
            []
        ] | [
            4,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ] | [
            5,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ]), ([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [
                null | string,
                boolean
            ]
        ] | [
            3,
            []
        ] | [
            4,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ] | [
            5,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ]), VAPI.AT1130.RTPReceiver.TimingTarget, VAPI.AT1130.RTPReceiver.TimingTarget, VAPI.AT1130.RTPReceiver.Timing>;
        /**
          estimated time until |distance to buffer boundary| < 0.5 *
          `safety_margin`
        */
        get expected_time_to_collision(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.RTPReceiver.Timing>;
        get read_delay(): VAPI.RTPReceiver.TimingReadDelay;
        get read_delay_bounds(): VScript.dKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], [
            null | number,
            null | number
        ], VAPI.RTPReceiver.TimingReadDelayBounds, VAPI.RTPReceiver.TimingReadDelayBounds, VAPI.AT1130.RTPReceiver.Timing>;
        get current_phase(): VAPI.AT1130.Time.Source;
        get safety_mismatch(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.RTPReceiver.Timing>;
        get phase_control(): VAPI.RTPReceiver.TimingPhaseControl;
        /**
          delay readout of newly incoming streams until at least this many mpackets
          have been received. While this increases readout latency, this may also
          improve robustness if there is reason to believe that stream setup may
          sometimes be 'dirty' (e.g., with gaps within the first few received video
          frames)
        */
        get mpackets_warmup(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Unsigned32, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPReceiver.Timing>;
    }
    type TimingTarget = ({
        variant: "IngressPlusX";
        value: VAPI.AT1130.RTPReceiver.TimingTargetIngressPlusX;
    } | {
        variant: "EgressPlusX";
        value: VAPI.AT1130.RTPReceiver.TimingTargetEgressPlusX;
    } | {
        variant: "TimeSource";
        value: VAPI.AT1130.RTPReceiver.TimingTargetTimeSource;
    } | {
        variant: "BufferMidpoint";
        value: VAPI.AT1130.RTPReceiver.TimingTargetBufferMidpoint;
    } | {
        variant: "ForeignReadDelay";
        value: VAPI.AT1130.RTPReceiver.TimingTargetForeignReadDelay;
    } | {
        variant: "ForeignMediaClock";
        value: VAPI.AT1130.RTPReceiver.TimingTargetForeignMediaClock;
    });
    interface VideoBackend {
        native: null | VAPI.AT1130.RTPReceiver.NativeVideoBackend;
        jpeg_xs: null | VAPI.AT1130.RTPReceiver.JpegXsVideoBackend;
        servo: null | VAPI.RTPReceiver.VideoServo;
    }
    interface VideoCapabilities {
        supports_2022_6: boolean;
        supports_uhd_sample_interleaved: boolean;
        st2110_20_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber;
        st2042_2_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber;
        jpeg_xs_caliber: null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber;
        supports_2110_40: boolean;
        supports_clean_switching: boolean;
        read_speed: VAPI.AT1130.RTPReceiver.ReadSpeed;
    }
    class VideoFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::VideoFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1130.RTPReceiver.VideoFlowPartition>;
        get sdp_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.RTPReceiver.VideoFlowPartition>;
        get fmt_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.RTPReceiver.VideoFlowPartition>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.TransportFormat, null | VAPI.Video.TransportFormat, VAPI.AT1130.RTPReceiver.VideoFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1130.RTPReceiver.AffineNetworkSource>, VAPI.AT1130.RTPReceiver.VideoFlowPartition>;
    }
    class VideoReceiver implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_specific(): VideoReceiverMediaSpecific;
    }
    class VideoReceiverAsNamedTableRow extends VideoReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface MemoryChannelInfoConnectedToAudio {
        block: VAPI.RTPReceiver.AudioBlockIndex;
        fifo_blocks_left: number;
    }
    interface MemoryChannelInfoConnectedTo {
        video_native: Array<null | VAPI.RTPReceiver.NativeVideoBlockIndex>;
        video_jpegxs: Array<null | VAPI.RTPReceiver.JpegXsBlockIndex>;
        audio: Array<null | VAPI.AT1130.RTPReceiver.MemoryChannelInfoConnectedToAudio>;
    }
    class AllDiagnostics implements VScript.Referenceable<"RTPReceiver::Data::All::Diagnostics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Diagnostics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Clear traffic statistics
        */
        get clear_traffic_stats(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        /**
          Clear input stage statistics
        */
        get clear_input_statistics(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        get aggregate_traffic_stats(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        get memory_channels(): VScript.rKeyword<VScript.VSocket, Array<[
            number,
            number,
            [
                Array<null | number>,
                Array<null | number>,
                Array<null | [
                    number,
                    number
                ]>
            ],
            number
        ]>, Array<VAPI.AT1130.RTPReceiver.MemoryChannelInfo>, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        get rtp_input(): VScript.rKeyword<VScript.VSocket, Array<Array<null | [
            number,
            [
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ]
        ]>>, Array<Array<null | VAPI.AT1130.RTPReceiver.AllDiagnosticsRtpInput>>, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        get mpacket_tracer(): VAPI.RTPReceiver.AllDiagnosticsMpacketTracer;
        get packet_tracers(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::PacketTracer", PacketTracer>;
        get igmp_performance_metrics(): AllDiagnosticsIgmpPerformanceMetrics;
        /**
          Enable this option to have the receiver log every readout attempt to
          syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_readout_requests(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
        /**
          Enable this option to have the receiver log every IGMP join/leave request
          to syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_igmp_requests(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.AllDiagnostics>;
    }
    interface AllDiagnosticsRtpInputFillLevel {
        min: VAPI.Primitives.Unsigned8;
        max: VAPI.Primitives.Unsigned8;
    }
    interface PassthroughReceiverFlowPartitions {
        sdp_a: null | VAPI.AT1130.RTPReceiver.PassthroughFlowPartition;
        sdp_b: null | VAPI.AT1130.RTPReceiver.PassthroughFlowPartition;
    }
    interface AudioReceiverMediaSpecificFlowPartitions {
        sdp_a: null | VAPI.AT1130.RTPReceiver.AudioFlowPartition;
        sdp_b: null | VAPI.AT1130.RTPReceiver.AudioFlowPartition;
    }
    interface VideoReceiverMediaSpecificFlowPartitions {
        sdp_a: null | VAPI.AT1130.RTPReceiver.VideoFlowPartition;
        sdp_b: null | VAPI.AT1130.RTPReceiver.VideoFlowPartition;
    }
    type MetadataBackendGroup = number;
    interface AllDiagnosticsIgmpPerformanceMetricsIgmpLatency {
        port: null | VAPI.AT1130.Primitives.NetworkPortID;
        src: null | string;
        dst: null | string;
        time_to_first_mpacket: null | VScript.Duration;
        first_rtp_timestamp: null | VAPI.Time.RTPTimestamp;
        first_rtp_seqnr: null | VAPI.RTPReceiver.Seqnr;
        /**
          time between two m-packets. This defines the latency measurement's
          uncertainty and depends on video standards, transport formats and (for
          audio streams) on the currently configured IRQ rate
        */
        mpacket_interval: null | VScript.Duration;
    }
    class AllDiagnosticsIgmpPerformanceMetrics implements VScript.Referenceable<"RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          emit warning message if the time elapsed between an outgoing IGMP join
          request and the arrival of the first corresponding packet (estimated
          conservatively as `time_to_first_mpacket - mpacket_interval`) exceeds
          `warning_threshold`. Note that for interlaced 2110/2042 streams,
          upper-field mpackets are not considered.
        */
        get warning_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics>;
        get igmp_latency(): VScript.rKeyword<VScript.VSocket, [
            null | VAPI.AT1130.Primitives.NetworkPortID,
            null | string,
            null | string,
            null | number,
            null | number,
            null | number,
            null | number
        ], VAPI.AT1130.RTPReceiver.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency, VAPI.AT1130.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics>;
    }
    type MetadataBackendInstance = number;
    type PacketStreamStreamParametersIrqRate = "Standard" | "Increased";
    type VideoCapabilitiesJpegXsCaliber = "JPEG_XS_upto_3G" | "JPEG_XS_singlelink_uhd";
    class AncBurstReceiverMediaClock implements VScript.Referenceable<"RTPReceiver::Data::AncBurstReceiver::MediaClock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AncBurstReceiver::MediaClock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ingress(): VAPI.AT1130.Time.Source;
        get egress(): VAPI.AT1130.Time.Source;
    }
    class AudioReceiverMediaSpecific implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver::MediaSpecific"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver::MediaSpecific";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit,
            boolean,
            ([0, [null | string]] | [
                1,
                []
            ])
        ], null | [
            number,
            VAPI.AT1130.RTPReceiver.AudioCapabilitiesPayloadLimit,
            boolean,
            ([0, [null | string]] | [
                1,
                []
            ])
        ], null | VAPI.AT1130.RTPReceiver.AudioCapabilities, null | VAPI.AT1130.RTPReceiver.AudioCapabilities, VAPI.AT1130.RTPReceiver.AudioReceiverMediaSpecific>;
        get backend(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            null | string,
            Array<null | number>,
            number,
            [
                number,
                null | number
            ],
            Array<null | number>
        ], null | VAPI.AT1130.RTPReceiver.AudioBackend, VAPI.AT1130.RTPReceiver.AudioReceiverMediaSpecific>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1130.RTPReceiver.AudioReceiverMediaSpecificFlowPartitions, VAPI.AT1130.RTPReceiver.AudioReceiverMediaSpecific>;
        get output(): AudioReceiverMediaSpecificOutput;
    }
    class VideoReceiverMediaSpecific implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            boolean,
            boolean,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber,
            boolean,
            boolean,
            ([0, [null | string]] | [
                1,
                []
            ])
        ], null | [
            boolean,
            boolean,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt211020Caliber,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesSt20422Caliber,
            null | VAPI.AT1130.RTPReceiver.VideoCapabilitiesJpegXsCaliber,
            boolean,
            boolean,
            ([0, [null | string]] | [
                1,
                []
            ])
        ], null | VAPI.AT1130.RTPReceiver.VideoCapabilities, null | VAPI.AT1130.RTPReceiver.VideoCapabilities, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get backend(): VScript.rKeyword<VScript.VSocket, null | [
            null | [
                number,
                Array<null | number>,
                number,
                null | [
                    number,
                    number,
                    [
                        number,
                        number
                    ],
                    number,
                    number
                ]
            ],
            null | [
                number,
                Array<null | number>,
                number,
                null | [
                    number,
                    number,
                    [
                        number,
                        number
                    ],
                    number,
                    number
                ]
            ],
            null | string
        ], null | VAPI.AT1130.RTPReceiver.VideoBackend, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.VideoReceiverMediaSpecificIssues, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get error_counters(): VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters;
        get event_counters(): VAPI.RTPReceiver.VideoReceiverMediaSpecificEventCounters;
        /**
          Reset 2022-6 audio deembedder
        */
        get reset_audio_deembedder(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecificFlowPartitions, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get output(): VideoReceiverMediaSpecificOutput;
        /**
          when this is set to true, a timestamped CRC32 signature of every emitted
          video frame will be published via `signature`
        */
        get publish_signature(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        get hard_metadata_decoder(): VAPI.RTPReceiver.VideoReceiverMediaSpecificHardMetadataDecoder;
        get soft_metadata_decoder(): VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoder;
        get soft_metadata_extractor(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::MetadataExtractor", VAPI.AT1130.MetadataProcessor.MetadataExtractor>;
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream(): VScript.dKeyword<VScript.VSocket, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
        /**
          When non-null, this keyword holds decoder state as inferred from
          currently received streams, or as obtained from the underlying hardware
          decoder at runtime.
        */
        get cur_decoder_ws(): VScript.rKeyword<VScript.VSocket, null | ([0, []] | [
            1,
            [
                ([0, []] | [
                    1,
                    []
                ] | [
                    2,
                    [Array<number>]
                ]),
                number
            ]
        ]), null | VAPI.RTPReceiver.SingleVideoDecoderWorkingSet, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecific>;
    }
    interface PassthroughEssenceMemoryBlocks {
        channel: VAPI.AT1130.RTPReceiver.RAMChannel;
        blocks: Array<null | VAPI.AT1130.RTPReceiver.RAMBlock>;
    }
    class AudioReceiverMediaSpecificOutput implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver::MediaSpecific::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver::MediaSpecific::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VAPI.AT1130.Audio.Essence;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class VideoReceiverMediaSpecificOutput implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get cc_channel(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, VAPI.AT1130.RTPReceiver.VideoReceiverMediaSpecificOutput>;
        get video(): VAPI.AT1130.Video.Essence;
        get start_of_frame(): VAPI.AT1130.Time.Source;
        get cc(): VAPI.Video.ClosedCaption;
        get deembedded_audio(): VScript.StronglyTypedTable<VScript.VSocket, "Audio::Data::Essence", VAPI.AT1130.Audio.Essence>;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class MediaReceiverPacketStreams implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::PacketStreams"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::MediaReceiver::PacketStreams";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_a(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number,
            null | [
                number,
                number,
                number,
                number
            ]
        ]>, Array<VAPI.AT1130.RTPReceiver.AssociatedStream>, VAPI.AT1130.RTPReceiver.MediaReceiverPacketStreams>;
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_b(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number,
            null | [
                number,
                number,
                number,
                number
            ]
        ]>, Array<VAPI.AT1130.RTPReceiver.AssociatedStream>, VAPI.AT1130.RTPReceiver.MediaReceiverPacketStreams>;
    }
    interface AllDiagnosticsRtpInputPacketsDiscarded {
        input_errors: VAPI.Primitives.CyclicCounter32;
        oversized: VAPI.Primitives.CyclicCounter32;
        data_fifo_full: VAPI.Primitives.CyclicCounter32;
        info_fifo_full: VAPI.Primitives.CyclicCounter32;
    }
    type AudioCapabilitiesPayloadLimit = "AtMost448Bytes" | "AtMost960Bytes" | "AtMost1984Bytes";
    interface AllDiagnosticsRtpInput {
        packets_written: VAPI.Primitives.CyclicCounter32;
        packets_discarded: VAPI.AT1130.RTPReceiver.AllDiagnosticsRtpInputPacketsDiscarded;
        fill_level: VAPI.AT1130.RTPReceiver.AllDiagnosticsRtpInputFillLevel;
    }
    class AllSettings implements VScript.Referenceable<"RTPReceiver::Data::All::Settings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Settings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          if `clean_switching_policy` is set to `Tolerant`, packet rates and ST2042
          compression ratios may change across switching boundaries. This ensures
          interoperability between a wider range of transmitters but comes at a
          slight performance penalty, as the receiver first has to determine the
          current packet rate before a switch can be effected. When set to
          `Whatever`, impossible clean switching requests will silently be
          converted into patching operations. Please only use this option as a
          measure of last resort, if at all.
        */
        get clean_switching_policy(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          limits IGMP stream subscriptions such that there remains an esimated
          `reserved_bandwidth` % of headroom on every RTP port (non-media traffic
          such as PTP or JSON/WS is not taken into account)
        */
        get reserved_bandwidth(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.AT1130.RTPReceiver.AllSettings>;
        get max_concurrent_mpacket_irq_boosts(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Unsigned16, VAPI.Primitives.Unsigned16, VAPI.AT1130.RTPReceiver.AllSettings>;
        get concurrent_mpacket_irq_boosts(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          set this to modern to have generated 2042-raw/2022-6 streams state their
          respective rtp clock rates
        */
        get sdp_format(): VScript.rwKeyword<VScript.VSocket, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          determines how SDP files entered into `sdp_a_command` or `sdp_b_command`
          translate into their respective `status` counterparts. If
          `sdp_generation` is set to `Verbatim`, accepted SDP files are copied to
          `status` unmodified, even if some or all of the media descriptions within
          could not be serviced due to resource exhaustion. If `sdp_generation` is
          set to `Semantic`, only operationally effective parts of the SDP will be
          emitted.
        */
        get sdp_generation(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.AT1130.RTPReceiver.AllSettings>;
        get num_audio_reserve_receivers(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.RTPReceiver.AllSettings>;
        get rx_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get mpacket_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get offset_2110_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get linenr_2110_error(): VAPI.RTPReceiver.CountableErrorHandler;
        /**
          time after which countable error events (such as RX errors or m-packet
          errors) are automatically cleared. Error accumulators are left unchanged
          until cleared explicitly by the user
        */
        get error_signalling_timeout(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.AllSettings>;
        get flight_permit_timeout(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          when in clean-switching mode (i.e., if `switch_time` is neither 0 nor 1),
          SDP writes to `current_target` are rejected, followed by an informational
          error message. Set `on_sdp_collision` to `RejectSilently` to suppress
          this error message.
        */
        get on_sdp_collision(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          some configuration attempts cannot be executed completely. For example, a
          session containing 3 audio receivers will not be able to service a
          connection request if the corresponding SDP contains 4 or more audio
          essences. In these cases, the receiver may either set up as many
          connections as possible and discard the rest (`BestEffort`), or refuse
          the configuration attempt and raise an error message instead (`Refuse`).
        */
        get exhaustion_policy(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.AT1130.RTPReceiver.AllSettings>;
        get backend_liveness(): VAPI.RTPReceiver.CountableErrorHandler;
        get premature_read(): VAPI.RTPReceiver.CountableErrorHandler;
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.AT1130.RTPReceiver.AllSettings>;
        get buffer_sizes(): VScript.dKeyword<VScript.VSocket, [
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize
        ], [
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize,
            VAPI.AT1130.RTPReceiver.BufferSize
        ], VAPI.AT1130.RTPReceiver.BufferSizes, VAPI.AT1130.RTPReceiver.BufferSizes, VAPI.AT1130.RTPReceiver.AllSettings>;
        /**
          enable this to have panicking 2110-20 receivers freeze all flow of data
          into their respective HBM channels. While this feature can be very useful
          for a post-mortem analysis in case of network-related errors, please keep
          in mind that other receivers sharing the same HBM channel will be
          affected as well. Also, this option should best be used with disabled
          backend liveness error handlers as liveness timeouts may otherwise fire
          too soon for you to retrieve the previously frozen memory contents
        */
        get freeze_memory_on_2110_20_panic(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPReceiver.AllSettings>;
    }
    type VideoCapabilitiesSt20422Caliber = "ST2042_2_upto_3G" | "ST2042_2_singlelink_uhd";
    type VideoCapabilitiesSt211020Caliber = "ST2110_upto_3G" | "ST2110_singlelink_uhd";
    interface PacketStreamStreamParameters {
        /**
          Seqnr offset relative to other packet streams mapped to the same memory
          region. N packet streams hence define N-1 meaningful offsets.
        */
        seqnr_offset: VAPI.RTPReceiver.SeqnrDifference;
        /**
          IP (unicast) address of the RTP stream sender
        */
        src_address: null | string;
        /**
          IP (multicast) destination address of the RTP stream
        */
        dst_address: null | string;
        interface: null | VAPI.NetworkInterfaces.VirtualInterface;
        type: VAPI.RTPReceiver.PacketStreamType;
        pseudo_channel: VAPI.AT1130.RTPReceiver.RAMPseudoChannel;
        irq_rate: VAPI.AT1130.RTPReceiver.PacketStreamStreamParametersIrqRate;
    }
    const Enums: {
        readonly BufferSize: BufferSize[];
    };
}
export declare namespace RTPTransmitter {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AudioEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoder;
        readonly AudioFlowReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioFlowReference;
        readonly AudioStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamHardware;
        readonly AudioStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamer;
        readonly EncoderHWDataEncoderClassic: (_raw: [boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number], _socket: VScript.VSocket) => EncoderHWDataEncoderClassic;
        readonly EncoderHWData: (_raw: ([0, [boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number]] | [1, [boolean, boolean, boolean, number, number]] | [2, [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number]]), _socket: VScript.VSocket) => EncoderHWData;
        readonly EncoderHWDataEncoderJxsCodec: (_raw: [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number], _socket: VScript.VSocket) => EncoderHWDataEncoderJxsCodec;
        readonly EncoderHWDataEncoderVC2: (_raw: [boolean, boolean, boolean, number, number], _socket: VScript.VSocket) => EncoderHWDataEncoderVC2;
        readonly FlowReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => FlowReference;
        readonly HDRINSMUX: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRINSMUX;
        readonly HDRAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRAudio;
        readonly HDRGeneral: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRGeneral;
        readonly HDRMipmap: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRMipmap;
        readonly HDRVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRVideo;
        readonly HardwareStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HardwareStatus;
        readonly HeaderReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HeaderReference;
        readonly LaneHeader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LaneHeader;
        readonly LaneStatistic: (_raw: [number, number, number, number, null | string], _socket: VScript.VSocket) => LaneStatistic;
        readonly MediaClock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaClock;
        readonly MediaClockControl: (_raw: ([0, [null | string]] | [1, []]), _socket: VScript.VSocket) => MediaClockControl;
        readonly MediaStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaStreamer;
        readonly MediaStreamerVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaStreamerVideo;
        readonly MipMapStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamHardware;
        readonly MipMapStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamer;
        readonly MultiplexerScheduler: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MultiplexerScheduler;
        readonly PortStatistic: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatistic;
        readonly MediaClockControlPropagate: (_raw: [], _socket: VScript.VSocket) => MediaClockControlPropagate;
        readonly ReStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ReStreamer;
        readonly RouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterEncoder;
        readonly RouterOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterOutput;
        readonly ST2110Settings: (_raw: [VAPI.RTPTransmitter.PackingMode, boolean, boolean], _socket: VScript.VSocket) => ST2110Settings;
        readonly Session: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Session;
        readonly MediaClockControlTimesource: (_raw: [null | string], _socket: VScript.VSocket) => MediaClockControlTimesource;
        readonly VideoConfigurationContainer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoConfigurationContainer;
        readonly VideoFormat: (_raw: ([0, []] | [1, [VAPI.RTPTransmitter.PackingMode, boolean, boolean]] | [2, [VAPI.Video.DiracCompression, boolean]] | [3, [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean]]), _socket: VScript.VSocket) => VideoFormat;
        readonly VideoStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardware;
        readonly VideoStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamer;
        readonly XbarEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => XbarEncoder;
        readonly HDRINSMUXFlowsAlternate: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRINSMUXFlowsAlternate;
        readonly MultiplexerSchedulerFlowsAlternate: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MultiplexerSchedulerFlowsAlternate;
        readonly AudioStreamHardwareAudioEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamHardwareAudioEncoder;
        readonly VideoStreamHardwareEncoderMux: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareEncoderMux;
        readonly AudioEncoderError: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoderError;
        readonly AudioEncoderFlows: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoderFlows;
        readonly HDRINSMUXFlows: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRINSMUXFlows;
        readonly MultiplexerSchedulerFlows: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MultiplexerSchedulerFlows;
        readonly RouterOutputHwCapability: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterOutputHwCapability;
        readonly PortStatisticInterfaces: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatisticInterfaces;
        readonly HDRINSMUXFlowsMain: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRINSMUXFlowsMain;
        readonly MultiplexerSchedulerFlowsMain: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MultiplexerSchedulerFlowsMain;
        readonly VideoStreamHardwareMuxScheduler: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareMuxScheduler;
        readonly AudioEncoderRegData: (_raw: [number, number, number], _socket: VScript.VSocket) => AudioEncoderRegData;
        readonly HDRINSMUXRegData: (_raw: [Array<boolean>, boolean, number, number, number, number, number, number, number, number, boolean], _socket: VScript.VSocket) => HDRINSMUXRegData;
        readonly MultiplexerSchedulerRegData: (_raw: [Array<boolean>], _socket: VScript.VSocket) => MultiplexerSchedulerRegData;
        readonly MipMapStreamHardwareRouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamHardwareRouterEncoder;
        readonly VideoStreamHardwareRouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareRouterEncoder;
        readonly VideoStreamHardwareXbarEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareXbarEncoder;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly AudioEncoder: (_x: AudioEncoder) => string;
        readonly AudioFlowReference: (_x: AudioFlowReference) => string;
        readonly AudioStreamHardware: (_x: AudioStreamHardware) => string;
        readonly AudioStreamer: (_x: AudioStreamer) => string;
        readonly EncoderHWDataEncoderClassic: (_x: {
            enabled: boolean;
            st2110: boolean;
            interlaced: boolean;
            /**
              false = start at line nr 0; true = start at line nr 1 (for
              2nd half of UHD)
            */
            vstart: boolean;
            /**
              false = increment by 1; true = increment by 2 (for UHD)
            */
            vincrement: boolean;
            /**
              Last line number for field 0
            */
            vend0: VAPI.Primitives.Unsigned32;
            /**
              Last line number for field 1
            */
            vend1: VAPI.Primitives.Unsigned32;
            /**
              Delay in pixels from vend to the SMPTE 2059 alignment point
              - used for sampling RTP timestamp
            */
            ts_sample_delay: VAPI.Primitives.Unsigned32;
            /**
              Timestamp increment from field 0 to field 1
            */
            ts_increment: VAPI.Primitives.Unsigned32;
            h_active: VAPI.Primitives.Unsigned32;
            pixels_per_packet: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number];
        readonly EncoderHWData: (_x: ({
            variant: "EncoderClassic";
            value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderClassic;
        } | {
            variant: "EncoderVC2";
            value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderVC2;
        } | {
            variant: "EncoderJxsCodec";
            value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderJxsCodec;
        }), _socket: VScript.VSocket) => ([0, [boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number]] | [1, [boolean, boolean, boolean, number, number]] | [2, [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number]]);
        readonly EncoderHWDataEncoderJxsCodec: (_x: {
            /**
              Width of the input encoded image, in pixels. Must be a
              multiple of 2. Up to 4096 for UHD IP-core flavor
            */
            width: null | VAPI.Primitives.Unsigned32;
            /**
              Height of the input encoded image, in pixels. Must be a
              multiple of 2, and greater than or equal to 4
            */
            height: null | VAPI.Primitives.Unsigned32;
            /**
              Contains input mode configuration fields: bit 3-0: color
              and sub-sampling mode
            */
            mode: null | VAPI.RTPTransmitter.ColorSampleMode;
            /**
              Budget in bytes per compressed frame, which is allocated to
              the picture header and the compressed data. Note: To
              compute this value according to a bit per pixel rate:
              budget = bpp x width x height / 8 Complementary header (ie.
              boxes) is not included in the budget
            */
            budget_per_frame: null | VAPI.Primitives.Unsigned32;
            /**
              VALIDATE It validates the given configuration. Set to '1'
              to start the IP-core, after setting mode and images
              parameters. This signal must be activated to validate any
              change in configuration (width, height, ...). Set to '0' to
              stop the IP-core. bit 1: (R) CFG_READY ‘1’ indicates
              that the TICO-XS is ready to receive a new configuration,
              when this bit is ‘0’ configuration registers shouldn't
              be modified
            */
            vld: null | VAPI.RTPTransmitter.ValidateMode;
            /**
              Number of images to play when the IP-core is in command
              mode. (when PLAY_MODE register = 0)
            */
            number_of_images: null | VAPI.Primitives.Unsigned32;
            /**
              Bit depth of the video content, mapped on the MSBs of the
              port interface. The valid bit depths are 8, 10 and 12 bits
              per component
            */
            video_depth: null | VAPI.RTPTransmitter.VideoDepth;
            /**
              It allows to choose between two running modes: set to '1'
              to run in play mode, in which the IP-core processes frames
              continuously. or set to '0' to run in command mode, in
              which the IP-core processes n frames, n defined by NBR
            */
            play_mode: null | boolean;
            /**
              This register is used to program the image quality
              optimization parameters (visual or PSNR). Each pre-computed
              weights value must be written to this register sequentially
              to ensure proper encoder behavior.
            */
            level_weights: null | Array<VAPI.Primitives.Unsigned32>;
            profile: null | VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number];
        readonly EncoderHWDataEncoderVC2: (_x: {
            interlace: boolean;
            enabled: boolean;
            is_uhd: boolean;
            target_bytes_per_slice: VAPI.Primitives.Unsigned32;
            last_slice: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [boolean, boolean, boolean, number, number];
        readonly FlowReference: (_x: FlowReference) => string;
        readonly HDRINSMUX: (_x: HDRINSMUX) => string;
        readonly HDRAudio: (_x: HDRAudio) => string;
        readonly HDRGeneral: (_x: HDRGeneral) => string;
        readonly HDRMipmap: (_x: HDRMipmap) => string;
        readonly HDRVideo: (_x: HDRVideo) => string;
        readonly HardwareStatus: (_x: HardwareStatus) => string;
        readonly HeaderReference: (_x: HeaderReference) => string;
        readonly LaneHeader: (_x: LaneHeader) => string;
        readonly LaneStatistic: (_x: {
            /**
              maximum throughput, measured in
              bits/second
            */
            reserved_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            max_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            reserved_bus_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            maxbus_bandwidth: VAPI.Primitives.NetworkBandwidth;
            fpga_lane_statistic: null | VAPI.AT1130.NetworkInterfaces.LaneStatistics;
        }, _socket: VScript.VSocket) => [number, number, number, number, null | string];
        readonly MediaClock: (_x: MediaClock) => string;
        readonly MediaClockControl: (_x: ({
            variant: "Timesource";
            value: VAPI.AT1130.RTPTransmitter.MediaClockControlTimesource;
        } | {
            variant: "Propagate";
            value: VAPI.AT1130.RTPTransmitter.MediaClockControlPropagate;
        }), _socket: VScript.VSocket) => ([0, [null | string]] | [1, []]);
        readonly MediaStreamer: (_x: MediaStreamer) => string;
        readonly MediaStreamerVideo: (_x: MediaStreamerVideo) => string;
        readonly MipMapStreamHardware: (_x: MipMapStreamHardware) => string;
        readonly MipMapStreamer: (_x: MipMapStreamer) => string;
        readonly MultiplexerScheduler: (_x: MultiplexerScheduler) => string;
        readonly PortStatistic: (_x: PortStatistic) => string;
        readonly MediaClockControlPropagate: (_x: {}, _socket: VScript.VSocket) => [];
        readonly ReStreamer: (_x: ReStreamer) => string;
        readonly RouterEncoder: (_x: RouterEncoder) => string;
        readonly RouterOutput: (_x: RouterOutput) => string;
        readonly ST2110Settings: (_x: {
            packing_mode: VAPI.RTPTransmitter.PackingMode;
            transmit_scheduler_uhd: boolean;
            add_st2110_40: boolean;
        }, _socket: VScript.VSocket) => [VAPI.RTPTransmitter.PackingMode, boolean, boolean];
        readonly Session: (_x: Session) => string;
        readonly MediaClockControlTimesource: (_x: {
            t_src: null | VAPI.AT1130.Time.Source;
        }, _socket: VScript.VSocket) => [null | string];
        readonly VideoConfigurationContainer: (_x: VideoConfigurationContainer) => string;
        readonly VideoFormat: (_x: ({
            variant: "ST2022_6";
            value: VAPI.RTPTransmitter.ST20226Settings;
        } | {
            variant: "ST2110_20";
            value: VAPI.AT1130.RTPTransmitter.ST2110Settings;
        } | {
            variant: "ST2042";
            value: VAPI.RTPTransmitter.ST2042Settings;
        } | {
            variant: "JPEG_XS";
            value: VAPI.RTPTransmitter.JpegXsSettings;
        }), _socket: VScript.VSocket) => ([0, []] | [1, [VAPI.RTPTransmitter.PackingMode, boolean, boolean]] | [2, [VAPI.Video.DiracCompression, boolean]] | [3, [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean]]);
        readonly VideoStreamHardware: (_x: VideoStreamHardware) => string;
        readonly VideoStreamer: (_x: VideoStreamer) => string;
        readonly XbarEncoder: (_x: XbarEncoder) => string;
        readonly HDRINSMUXFlowsAlternate: (_x: HDRINSMUXFlowsAlternate) => string;
        readonly MultiplexerSchedulerFlowsAlternate: (_x: MultiplexerSchedulerFlowsAlternate) => string;
        readonly AudioStreamHardwareAudioEncoder: (_x: AudioStreamHardwareAudioEncoder) => string;
        readonly VideoStreamHardwareEncoderMux: (_x: VideoStreamHardwareEncoderMux) => string;
        readonly AudioEncoderError: (_x: AudioEncoderError) => string;
        readonly AudioEncoderFlows: (_x: AudioEncoderFlows) => string;
        readonly HDRINSMUXFlows: (_x: HDRINSMUXFlows) => string;
        readonly MultiplexerSchedulerFlows: (_x: MultiplexerSchedulerFlows) => string;
        readonly RouterOutputHwCapability: (_x: RouterOutputHwCapability) => string;
        readonly PortStatisticInterfaces: (_x: PortStatisticInterfaces) => string;
        readonly HDRINSMUXFlowsMain: (_x: HDRINSMUXFlowsMain) => string;
        readonly MultiplexerSchedulerFlowsMain: (_x: MultiplexerSchedulerFlowsMain) => string;
        readonly VideoStreamHardwareMuxScheduler: (_x: VideoStreamHardwareMuxScheduler) => string;
        readonly AudioEncoderRegData: (_x: {
            last_sample: VAPI.Primitives.Unsigned32;
            mode: VAPI.Primitives.Unsigned32;
            sequence_number: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [number, number, number];
        readonly HDRINSMUXRegData: (_x: {
            enable_port: Array<boolean>;
            is_2022_6: boolean;
            sequence_eol: VAPI.Primitives.Unsigned32;
            sample_2022_6: VAPI.Primitives.Unsigned32;
            frame_2022_6: VAPI.Primitives.Unsigned32;
            rate_2022_6: VAPI.Primitives.Unsigned32;
            frame_number_2022_6: VAPI.Primitives.Unsigned32;
            sequence_number: VAPI.Primitives.Unsigned32;
            scheduler_subslot_2110: VAPI.Primitives.Unsigned32;
            scheduler_slot_2110: VAPI.Primitives.Unsigned32;
            scheduler_enable_2110: boolean;
        }, _socket: VScript.VSocket) => [Array<boolean>, boolean, number, number, number, number, number, number, number, number, boolean];
        readonly MultiplexerSchedulerRegData: (_x: {
            enable_port: Array<boolean>;
        }, _socket: VScript.VSocket) => [Array<boolean>];
        readonly MipMapStreamHardwareRouterEncoder: (_x: MipMapStreamHardwareRouterEncoder) => string;
        readonly VideoStreamHardwareRouterEncoder: (_x: VideoStreamHardwareRouterEncoder) => string;
        readonly VideoStreamHardwareXbarEncoder: (_x: VideoStreamHardwareXbarEncoder) => string;
    };
    class All implements VScript.Referenceable<"RTPTransmitter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::All";
        get runtime_constants(): {
            readonly num_mipmaptransmitters: number;
            readonly num_transmitter_video_lane: number;
            readonly has_2042_uhd: boolean;
            readonly num_hdr_flows: number;
            readonly num_xbar_encoder: number;
            readonly num_ports: number;
            readonly num_audio_group_control: number;
            readonly max_st2110_20_uhd_transmitters: number;
            readonly max_2042: number;
            readonly has_2042: boolean;
            readonly num_encoder_mux: number;
            readonly num_videotransmitters: number;
            readonly num_audiotransmitters: number;
            readonly max_2042_uhd: number;
            readonly num_jpegxs: number;
            readonly num_transmitter_mipmap_lane: number;
            readonly num_transmitter_audio_lane: number;
            readonly num_hdr_flows_port: number;
            readonly num_transmitters: number;
            readonly num_passthroughtransmitters: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get license_information(): VAPI.RTPTransmitter.AllLicenseInformation;
        get hardware_status(): HardwareStatus;
        get settings(): VAPI.RTPTransmitter.AllSettings;
        get sessions(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::Session", SessionAsNamedTableRow>;
        get video_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamer", VideoStreamerAsNamedTableRow>;
        get audio_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::AudioStreamer", AudioStreamerAsNamedTableRow>;
        get passthrough_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::ReStreamer", ReStreamerAsNamedTableRow>;
        get mipmap_transmitters(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::MipMapStreamer", MipMapStreamer>;
    }
    class AudioEncoder implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get reg_data(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number
        ], VAPI.AT1130.RTPTransmitter.AudioEncoderRegData, VAPI.AT1130.RTPTransmitter.AudioEncoder>;
        get flows(): AudioEncoderFlows;
        get error(): AudioEncoderError;
    }
    class AudioFlowReference implements VScript.Referenceable<"RTPTransmitter::Data::AudioFlowReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioFlowReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hdr_ref(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.HDRAudio, VAPI.AT1130.RTPTransmitter.AudioFlowReference>;
        get hdr_index(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPTransmitter.AudioFlowReference>;
        get hdr_port(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPTransmitter.AudioFlowReference>;
    }
    class AudioStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio_encoder(): AudioStreamHardwareAudioEncoder;
    }
    class AudioStreamer implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaStreamer;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.RTPTransmitter.AudioStreamer>;
        get configuration(): VAPI.RTPTransmitter.AudioConfigurationContainer;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): AudioStreamHardware;
    }
    class AudioStreamerAsNamedTableRow extends AudioStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface EncoderHWDataEncoderClassic {
        enabled: boolean;
        st2110: boolean;
        interlaced: boolean;
        /**
          false = start at line nr 0; true = start at line nr 1 (for 2nd half of
          UHD)
        */
        vstart: boolean;
        /**
          false = increment by 1; true = increment by 2 (for UHD)
        */
        vincrement: boolean;
        /**
          Last line number for field 0
        */
        vend0: VAPI.Primitives.Unsigned32;
        /**
          Last line number for field 1
        */
        vend1: VAPI.Primitives.Unsigned32;
        /**
          Delay in pixels from vend to the SMPTE 2059 alignment point - used for
          sampling RTP timestamp
        */
        ts_sample_delay: VAPI.Primitives.Unsigned32;
        /**
          Timestamp increment from field 0 to field 1
        */
        ts_increment: VAPI.Primitives.Unsigned32;
        h_active: VAPI.Primitives.Unsigned32;
        pixels_per_packet: VAPI.Primitives.Unsigned32;
    }
    type EncoderHWData = ({
        variant: "EncoderClassic";
        value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderClassic;
    } | {
        variant: "EncoderVC2";
        value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderVC2;
    } | {
        variant: "EncoderJxsCodec";
        value: VAPI.AT1130.RTPTransmitter.EncoderHWDataEncoderJxsCodec;
    });
    interface EncoderHWDataEncoderJxsCodec {
        /**
          Width of the input encoded image, in pixels. Must be a multiple of 2. Up
          to 4096 for UHD IP-core flavor
        */
        width: null | VAPI.Primitives.Unsigned32;
        /**
          Height of the input encoded image, in pixels. Must be a multiple of 2,
          and greater than or equal to 4
        */
        height: null | VAPI.Primitives.Unsigned32;
        /**
          Contains input mode configuration fields: bit 3-0: color and sub-sampling
          mode
        */
        mode: null | VAPI.RTPTransmitter.ColorSampleMode;
        /**
          Budget in bytes per compressed frame, which is allocated to the picture
          header and the compressed data. Note: To compute this value according to
          a bit per pixel rate: budget = bpp x width x height / 8 Complementary
          header (ie. boxes) is not included in the budget
        */
        budget_per_frame: null | VAPI.Primitives.Unsigned32;
        /**
          VALIDATE It validates the given configuration. Set to '1' to start the
          IP-core, after setting mode and images parameters. This signal must be
          activated to validate any change in configuration (width, height, ...).
          Set to '0' to stop the IP-core. bit 1: (R) CFG_READY ‘1’ indicates
          that the TICO-XS is ready to receive a new configuration, when this bit
          is ‘0’ configuration registers shouldn't be modified
        */
        vld: null | VAPI.RTPTransmitter.ValidateMode;
        /**
          Number of images to play when the IP-core is in command mode. (when
          PLAY_MODE register = 0)
        */
        number_of_images: null | VAPI.Primitives.Unsigned32;
        /**
          Bit depth of the video content, mapped on the MSBs of the port interface.
          The valid bit depths are 8, 10 and 12 bits per component
        */
        video_depth: null | VAPI.RTPTransmitter.VideoDepth;
        /**
          It allows to choose between two running modes: set to '1' to run in play
          mode, in which the IP-core processes frames continuously. or set to '0'
          to run in command mode, in which the IP-core processes n frames, n
          defined by NBR
        */
        play_mode: null | boolean;
        /**
          This register is used to program the image quality optimization
          parameters (visual or PSNR). Each pre-computed weights value must be
          written to this register sequentially to ensure proper encoder behavior.
        */
        level_weights: null | Array<VAPI.Primitives.Unsigned32>;
        profile: null | VAPI.Primitives.Unsigned32;
    }
    interface EncoderHWDataEncoderVC2 {
        interlace: boolean;
        enabled: boolean;
        is_uhd: boolean;
        target_bytes_per_slice: VAPI.Primitives.Unsigned32;
        last_slice: VAPI.Primitives.Unsigned32;
    }
    class FlowReference implements VScript.Referenceable<"RTPTransmitter::Data::FlowReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::FlowReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hdr_ref(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.HDRVideo, VAPI.AT1130.RTPTransmitter.FlowReference>;
        get hdr_index(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPTransmitter.FlowReference>;
    }
    class HDRINSMUX implements VScript.Referenceable<"RTPTransmitter::Data::HDRINSMUX"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRINSMUX";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get flows(): HDRINSMUXFlows;
        get reg_data(): VScript.rKeyword<VScript.VSocket, [
            Array<boolean>,
            boolean,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            boolean
        ], VAPI.AT1130.RTPTransmitter.HDRINSMUXRegData, VAPI.AT1130.RTPTransmitter.HDRINSMUX>;
    }
    class HDRAudio implements VScript.Referenceable<"RTPTransmitter::Data::HDRAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.HDRAudio>;
        get related_references(): HeaderReference;
        /**
          reference to encoder mux
        */
        get audio_encoder_hw(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.AudioEncoder, VAPI.AT1130.RTPTransmitter.HDRAudio>;
    }
    class HDRGeneral implements VScript.Referenceable<"RTPTransmitter::Data::HDRGeneral"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRGeneral";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): HDRAudio;
        get video(): HDRVideo;
        get mipmap(): HDRMipmap;
    }
    class HDRMipmap implements VScript.Referenceable<"RTPTransmitter::Data::HDRMipmap"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRMipmap";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.HDRMipmap>;
        get related_references(): HeaderReference;
        get mipmap_encoder_hw(): VAPI.RTPTransmitter.MipMapEncoder;
    }
    class HDRVideo implements VScript.Referenceable<"RTPTransmitter::Data::HDRVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.HDRVideo>;
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.HDRVideo>;
        get related_references(): HeaderReference;
        /**
          reference to encoder mux
        */
        get router_encoder_hw(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.RouterEncoder, VAPI.AT1130.RTPTransmitter.HDRVideo>;
    }
    class HardwareStatus implements VScript.Referenceable<"RTPTransmitter::Data::HardwareStatus"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HardwareStatus";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::PortStatistic", PortStatistic>;
        get xbar_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::XbarEncoder", XbarEncoder>;
        get encoder_mux(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::RouterOutput", RouterOutput>;
        get mux_scheduler(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::MultiplexerScheduler", MultiplexerScheduler>;
        get audio_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::AudioEncoder", AudioEncoder>;
        get mux_statistics(): VScript.StronglyTypedArray<VScript.VSocket, "RTPTransmitter::Data::MuxStatistics", VAPI.RTPTransmitter.MuxStatistics>;
        get audio_tx_group_control(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::AudioGroupControl", VAPI.RTPTransmitter.AudioGroupControl>;
    }
    class HeaderReference implements VScript.Referenceable<"RTPTransmitter::Data::HeaderReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HeaderReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get tx_stream_counter(): VScript.rKeyword<VScript.VSocket, null | string, null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "tx_streams", "NetworkInterfaces::Data::LaneStatistics", VScript.Referenceable<"NetworkInterfaces::Data::LaneStatistics"> & VAPI.AT1130.NetworkInterfaces.LaneStatistics, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter>, VAPI.AT1130.RTPTransmitter.HeaderReference>;
    }
    class LaneHeader implements VScript.Referenceable<"RTPTransmitter::Data::LaneHeader"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::LaneHeader";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get statistic(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number,
            null | string
        ], VAPI.AT1130.RTPTransmitter.LaneStatistic, VAPI.AT1130.RTPTransmitter.LaneHeader>;
        get video(): RouterOutput;
    }
    interface LaneStatistic {
        /**
          maximum throughput, measured in bits/second
        */
        reserved_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        max_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        reserved_bus_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        maxbus_bandwidth: VAPI.Primitives.NetworkBandwidth;
        fpga_lane_statistic: null | VAPI.AT1130.NetworkInterfaces.LaneStatistics;
    }
    class MediaClock implements VScript.Referenceable<"RTPTransmitter::Data::MediaClock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaClock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get clock_mode(): VScript.dKeyword<VScript.VSocket, ([0, [null | string]] | [
            1,
            []
        ]), ([0, [null | string]] | [
            1,
            []
        ]), VAPI.AT1130.RTPTransmitter.MediaClockControl, VAPI.AT1130.RTPTransmitter.MediaClockControl, VAPI.AT1130.RTPTransmitter.MediaClock>;
        get offset(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.RTPTransmitter.MediaClock>;
        get latch_control(): VAPI.Definitions.LatchControl;
        get latched_timestamp(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1130.RTPTransmitter.MediaClock>;
        get hw_latched_timestamp(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPTransmitter.MediaClock>;
    }
    type MediaClockControl = ({
        variant: "Timesource";
        value: VAPI.AT1130.RTPTransmitter.MediaClockControlTimesource;
    } | {
        variant: "Propagate";
        value: VAPI.AT1130.RTPTransmitter.MediaClockControlPropagate;
    });
    class MediaStreamer implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.RTPTransmitter.Session, null | VScript.Referenceable<"RTPTransmitter::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.RTPTransmitter.MediaStreamer>;
        get mediaclock(): MediaClock;
        get ip_configuration(): VAPI.RTPTransmitter.MediaStreamerIpConfiguration;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPTransmitter.MediaStreamerIssues, VAPI.AT1130.RTPTransmitter.MediaStreamer>;
    }
    class MediaStreamerVideo implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamerVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaStreamerVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.RTPTransmitter.Session, null | VScript.Referenceable<"RTPTransmitter::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.RTPTransmitter.MediaStreamerVideo>;
        get mediaclock(): MediaClock;
        get ip_configuration(): VAPI.RTPTransmitter.MediaStreamerVideoIpConfiguration;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPTransmitter.MediaStreamerVideoIssues, VAPI.AT1130.RTPTransmitter.MediaStreamerVideo>;
    }
    class MipMapStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get router_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder", MipMapStreamHardwareRouterEncoder>;
    }
    class MipMapStreamer implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ip_configuration(): VAPI.RTPTransmitter.MipMapStreamerIpConfiguration;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): MipMapStreamHardware;
    }
    class MultiplexerScheduler implements VScript.Referenceable<"RTPTransmitter::Data::MultiplexerScheduler"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MultiplexerScheduler";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get flows(): MultiplexerSchedulerFlows;
        get reg_data(): VScript.rKeyword<VScript.VSocket, [
            Array<boolean>
        ], VAPI.AT1130.RTPTransmitter.MultiplexerSchedulerRegData, VAPI.AT1130.RTPTransmitter.MultiplexerScheduler>;
    }
    class PortStatistic implements VScript.Referenceable<"RTPTransmitter::Data::PortStatistic"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::PortStatistic";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_output_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.PortStatistic>;
        /**
          maximum throughput (per direction), measured in bits/second
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.RTPTransmitter.PortStatistic>;
        get interfaces(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::PortStatistic::Interfaces", PortStatisticInterfaces>;
        get hdr_general(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::HDRGeneral", HDRGeneral>;
    }
    interface MediaClockControlPropagate {
    }
    class ReStreamer implements VScript.Referenceable<"RTPTransmitter::Data::ReStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::ReStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get fill_it_up(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPTransmitter.ReStreamer>;
        get generic(): MediaStreamer;
    }
    class ReStreamerAsNamedTableRow extends ReStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class RouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.RouterEncoder>;
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1130.RTPTransmitter.RouterEncoder>;
        /**
          reference to scheduler. The scheduler serializes the packets to ensure
          that the outgoing sequence numbers are in continuous ascending order.
        */
        get scheduler_hw(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.MultiplexerScheduler, VAPI.AT1130.RTPTransmitter.RouterEncoder>;
        get meta_hdr_ins_mux(): HDRINSMUX;
        get video_hdr_ins_mux(): HDRINSMUX;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.RTPTransmitter.RouterEncoderIssues, VAPI.AT1130.RTPTransmitter.RouterEncoder>;
    }
    class RouterOutput implements VScript.Referenceable<"RTPTransmitter::Data::RouterOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_capability(): RouterOutputHwCapability;
        get router_encoder_hw(): RouterEncoder;
    }
    interface ST2110Settings {
        packing_mode: VAPI.RTPTransmitter.PackingMode;
        transmit_scheduler_uhd: boolean;
        add_st2110_40: boolean;
    }
    class Session implements VScript.Referenceable<"RTPTransmitter::Data::Session"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::Session";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPTransmitter.Session>;
        get reserve_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.RTPTransmitter.Session>;
        get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.RTPTransmitter.Session>;
        get session_name(): VAPI.Definitions.NAME;
        get video_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPTransmitter.VideoStreamer>, VAPI.AT1130.RTPTransmitter.Session>;
        get audio_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPTransmitter.AudioStreamer>, VAPI.AT1130.RTPTransmitter.Session>;
        get passthrough_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPTransmitter.ReStreamer>, VAPI.AT1130.RTPTransmitter.Session>;
        get mipmap_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.RTPTransmitter.MipMapStreamer>, VAPI.AT1130.RTPTransmitter.Session>;
        get interfaces(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], [
            null | string,
            null | string
        ], VAPI.RTPTransmitter.SessionInterfaces, VAPI.RTPTransmitter.SessionInterfaces, VAPI.AT1130.RTPTransmitter.Session>;
    }
    class SessionAsNamedTableRow extends Session {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface MediaClockControlTimesource {
        t_src: null | VAPI.AT1130.Time.Source;
    }
    class VideoConfigurationContainer implements VScript.Referenceable<"RTPTransmitter::Data::VideoConfigurationContainer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoConfigurationContainer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get transport_format(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            [
                VAPI.RTPTransmitter.PackingMode,
                boolean,
                boolean
            ]
        ] | [
            2,
            [
                VAPI.Video.DiracCompression,
                boolean
            ]
        ] | [
            3,
            [
                ([0, [number]] | [
                    1,
                    [number]
                ]),
                VAPI.RTPTransmitter.LVLMODE,
                boolean,
                boolean
            ]
        ]), ([0, []] | [
            1,
            [
                VAPI.RTPTransmitter.PackingMode,
                boolean,
                boolean
            ]
        ] | [
            2,
            [
                VAPI.Video.DiracCompression,
                boolean
            ]
        ] | [
            3,
            [
                ([0, [number]] | [
                    1,
                    [number]
                ]),
                VAPI.RTPTransmitter.LVLMODE,
                boolean,
                boolean
            ]
        ]), VAPI.AT1130.RTPTransmitter.VideoFormat, VAPI.AT1130.RTPTransmitter.VideoFormat, VAPI.AT1130.RTPTransmitter.VideoConfigurationContainer>;
        get vanc(): VAPI.AT1130.Definitions.VancControl;
        get embedded_audio(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1130.RTPTransmitter.VideoConfigurationContainer>;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.Audio.TimedSource, VAPI.AT1130.RTPTransmitter.VideoConfigurationContainer>;
    }
    type VideoFormat = ({
        variant: "ST2022_6";
        value: VAPI.RTPTransmitter.ST20226Settings;
    } | {
        variant: "ST2110_20";
        value: VAPI.AT1130.RTPTransmitter.ST2110Settings;
    } | {
        variant: "ST2042";
        value: VAPI.RTPTransmitter.ST2042Settings;
    } | {
        variant: "JPEG_XS";
        value: VAPI.RTPTransmitter.JpegXsSettings;
    });
    class VideoStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get xbar_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder", VideoStreamHardwareXbarEncoder>;
        get encoder_mux(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::EncoderMux", VideoStreamHardwareEncoderMux>;
        get mux_scheduler(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::MuxScheduler", VideoStreamHardwareMuxScheduler>;
        get router_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder", VideoStreamHardwareRouterEncoder>;
    }
    class VideoStreamer implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaStreamerVideo;
        get constraints(): VAPI.RTPTransmitter.Constraints;
        get v_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1130.Video.TimedSource, VAPI.AT1130.Video.TimedSource, VAPI.AT1130.RTPTransmitter.VideoStreamer>;
        get configuration(): VideoConfigurationContainer;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): VideoStreamHardware;
    }
    class VideoStreamerAsNamedTableRow extends VideoStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class XbarEncoder implements VScript.Referenceable<"RTPTransmitter::Data::XbarEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::XbarEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get debug(): VScript.rKeyword<VScript.VSocket, ([
            0,
            [
                boolean,
                boolean,
                boolean,
                boolean,
                boolean,
                number,
                number,
                number,
                number,
                number,
                number
            ]
        ] | [
            1,
            [
                boolean,
                boolean,
                boolean,
                number,
                number
            ]
        ] | [
            2,
            [
                null | number,
                null | number,
                null | VAPI.RTPTransmitter.ColorSampleMode,
                null | number,
                null | VAPI.RTPTransmitter.ValidateMode,
                null | number,
                null | VAPI.RTPTransmitter.VideoDepth,
                null | boolean,
                null | Array<number>,
                null | number
            ]
        ]), VAPI.AT1130.RTPTransmitter.EncoderHWData, VAPI.AT1130.RTPTransmitter.XbarEncoder>;
    }
    class HDRINSMUXFlowsAlternate implements VScript.Referenceable<"RTPTransmitter::Data::HDRINSMUX::Flows::Alternate"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRINSMUX::Flows::Alternate";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): FlowReference;
        get secondary(): FlowReference;
    }
    class MultiplexerSchedulerFlowsAlternate implements VScript.Referenceable<"RTPTransmitter::Data::MultiplexerScheduler::Flows::Alternate"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MultiplexerScheduler::Flows::Alternate";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): FlowReference;
        get secondary(): FlowReference;
    }
    class AudioStreamHardwareAudioEncoder implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamHardware::AudioEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamHardware::AudioEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference_encoder(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.AudioEncoder, VAPI.AT1130.RTPTransmitter.AudioStreamHardwareAudioEncoder>;
    }
    class VideoStreamHardwareEncoderMux implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::EncoderMux"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::EncoderMux";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.RouterEncoder, VAPI.AT1130.RTPTransmitter.VideoStreamHardwareEncoderMux>;
    }
    class AudioEncoderError implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoder::Error"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoder::Error";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get queue_overflow(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPTransmitter.AudioEncoderError>;
        get queue_full(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPTransmitter.AudioEncoderError>;
    }
    class AudioEncoderFlows implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoder::Flows"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoder::Flows";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): AudioFlowReference;
        get secondary(): AudioFlowReference;
    }
    class HDRINSMUXFlows implements VScript.Referenceable<"RTPTransmitter::Data::HDRINSMUX::Flows"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRINSMUX::Flows";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get main(): HDRINSMUXFlowsMain;
        get alternate(): HDRINSMUXFlowsAlternate;
    }
    class MultiplexerSchedulerFlows implements VScript.Referenceable<"RTPTransmitter::Data::MultiplexerScheduler::Flows"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MultiplexerScheduler::Flows";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get main(): MultiplexerSchedulerFlowsMain;
        get alternate(): MultiplexerSchedulerFlowsAlternate;
    }
    class RouterOutputHwCapability implements VScript.Referenceable<"RTPTransmitter::Data::RouterOutput::HwCapability"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterOutput::HwCapability";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get num_encoder(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.RTPTransmitter.RouterOutputHwCapability>;
    }
    class PortStatisticInterfaces implements VScript.Referenceable<"RTPTransmitter::Data::PortStatistic::Interfaces"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::PortStatistic::Interfaces";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.AT1130.RTPTransmitter.PortStatisticInterfaces>;
    }
    type RouterEncoderIssues = {
        missing_video_multiplex_resource: boolean;
    };
    class HDRINSMUXFlowsMain implements VScript.Referenceable<"RTPTransmitter::Data::HDRINSMUX::Flows::Main"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRINSMUX::Flows::Main";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): FlowReference;
        get secondary(): FlowReference;
    }
    class MultiplexerSchedulerFlowsMain implements VScript.Referenceable<"RTPTransmitter::Data::MultiplexerScheduler::Flows::Main"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MultiplexerScheduler::Flows::Main";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): FlowReference;
        get secondary(): FlowReference;
    }
    class VideoStreamHardwareMuxScheduler implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::MuxScheduler"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::MuxScheduler";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to scheduler. The scheduler serializes the packets to ensure
          that the outgoing sequence numbers are in continuous ascending order.
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.MultiplexerScheduler, VAPI.AT1130.RTPTransmitter.VideoStreamHardwareMuxScheduler>;
    }
    interface AudioEncoderRegData {
        last_sample: VAPI.Primitives.Unsigned32;
        mode: VAPI.Primitives.Unsigned32;
        sequence_number: VAPI.Primitives.Unsigned32;
    }
    interface HDRINSMUXRegData {
        enable_port: Array<boolean>;
        is_2022_6: boolean;
        sequence_eol: VAPI.Primitives.Unsigned32;
        sample_2022_6: VAPI.Primitives.Unsigned32;
        frame_2022_6: VAPI.Primitives.Unsigned32;
        rate_2022_6: VAPI.Primitives.Unsigned32;
        frame_number_2022_6: VAPI.Primitives.Unsigned32;
        sequence_number: VAPI.Primitives.Unsigned32;
        scheduler_subslot_2110: VAPI.Primitives.Unsigned32;
        scheduler_slot_2110: VAPI.Primitives.Unsigned32;
        scheduler_enable_2110: boolean;
    }
    interface MultiplexerSchedulerRegData {
        enable_port: Array<boolean>;
    }
    class MipMapStreamHardwareRouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.HDRMipmap, VAPI.AT1130.RTPTransmitter.MipMapStreamHardwareRouterEncoder>;
    }
    class VideoStreamHardwareRouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.HDRVideo, VAPI.AT1130.RTPTransmitter.VideoStreamHardwareRouterEncoder>;
    }
    class VideoStreamHardwareXbarEncoder implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::XbarEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.RTPTransmitter.XbarEncoder, VAPI.AT1130.RTPTransmitter.VideoStreamHardwareXbarEncoder>;
    }
}
export declare namespace RePlay {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"RePlay::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RePlay::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1130.VideoRePlay.Video;
        get audio(): VAPI.AT1130.AudioRePlay.Audio;
    }
}
export declare namespace SampleRateConverter {
    const lift: {
        readonly AUDIOSRCSTATUS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AUDIOSRCSTATUS;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly INPUTSTATUS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => INPUTSTATUS;
        readonly RESOURCE: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RESOURCE;
        readonly RESOURCES: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RESOURCES;
        readonly SRC: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRC;
        readonly SRCHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRCHardware;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly AUDIOSRCSTATUSHwSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AUDIOSRCSTATUSHwSettings;
        readonly SRCSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRCSettings;
    };
    const lower: {
        readonly AUDIOSRCSTATUS: (_x: AUDIOSRCSTATUS) => string;
        readonly All: (_x: All) => string;
        readonly INPUTSTATUS: (_x: INPUTSTATUS) => string;
        readonly RESOURCE: (_x: RESOURCE) => string;
        readonly RESOURCES: (_x: RESOURCES) => string;
        readonly SRC: (_x: SRC) => string;
        readonly SRCHardware: (_x: SRCHardware) => string;
        readonly Time: (_x: Time) => string;
        readonly AUDIOSRCSTATUSHwSettings: (_x: AUDIOSRCSTATUSHwSettings) => string;
        readonly SRCSettings: (_x: SRCSettings) => string;
    };
    class AUDIOSRCSTATUS implements VScript.Referenceable<"SampleRateConverter::Data::AUDIOSRCSTATUS"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::AUDIOSRCSTATUS";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_settings(): AUDIOSRCSTATUSHwSettings;
        get t_src(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Time.Source, VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUS>;
        get hw_resource_mux(): VScript.StronglyTypedTable<VScript.VSocket, "SampleRateConverter::Data::RESOURCE", RESOURCE>;
    }
    class All implements VScript.Referenceable<"SampleRateConverter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::All";
        get runtime_constants(): {
            readonly num_srcs: number;
            readonly num_src_inputs: number;
            readonly num_srcs_x24: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "SampleRateConverter::Data::SRC", SRCAsNamedTableRow>;
        get hardware_resources(): RESOURCES;
    }
    class INPUTSTATUS implements VScript.Referenceable<"SampleRateConverter::Data::INPUTSTATUS"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::INPUTSTATUS";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_value(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
        get audio_src(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
        get sop_src(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
        get input_bus_selection(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
        get mpx_bus(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
        get enable(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.SampleRateConverter.INPUTSTATUS>;
    }
    class RESOURCE implements VScript.Referenceable<"SampleRateConverter::Data::RESOURCE"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::RESOURCE";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mux(): INPUTSTATUS;
        get read_status(): VAPI.SampleRateConverter.READSTATUS;
        get audio_source_slices(): VAPI.Audio.SignalSourceSlice;
        get related_mux(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.SampleRateConverter.RESOURCE>, VAPI.AT1130.SampleRateConverter.RESOURCE>;
    }
    class RESOURCES implements VScript.Referenceable<"SampleRateConverter::Data::RESOURCES"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::RESOURCES";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_resource_x24(): VScript.StronglyTypedTable<VScript.VSocket, "SampleRateConverter::Data::AUDIOSRCSTATUS", AUDIOSRCSTATUS>;
    }
    class SRC implements VScript.Referenceable<"SampleRateConverter::Data::SRC"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRC";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.SampleRateConverter.SRC>;
        get settings(): SRCSettings;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.SampleRateConverter.SRC>;
        get output(): VAPI.AT1130.Audio.Essence;
        get connected_hardware(): SRCHardware;
    }
    class SRCAsNamedTableRow extends SRC {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class SRCHardware implements VScript.Referenceable<"SampleRateConverter::Data::SRCHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRCHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUS, VAPI.AT1130.SampleRateConverter.SRCHardware>;
        get hw_mux(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1130.SampleRateConverter.INPUTSTATUS>, VAPI.AT1130.SampleRateConverter.SRCHardware>;
    }
    class Time implements VScript.Referenceable<"SampleRateConverter::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.SampleRateConverter.Time>;
    }
    class AUDIOSRCSTATUSHwSettings implements VScript.Referenceable<"SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_value(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUSHwSettings>;
        /**
          index of the selected genlock 1...6, 0 = disabled
        */
        get genlock_sel(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUSHwSettings>;
        /**
          0 = no reset; 1 = reset
        */
        get reset(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUSHwSettings>;
    }
    class SRCSettings implements VScript.Referenceable<"SampleRateConverter::Data::SRC::Settings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRC::Settings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel_capacity(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.SampleRateConverter.SRCSettings>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.SampleRateConverter.SRCSettings>;
    }
}
export declare namespace Splitter {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly SP: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SP;
        readonly SPOutputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SPOutputs;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly SP: (_x: SP) => string;
        readonly SPOutputs: (_x: SPOutputs) => string;
    };
    class All implements VScript.Referenceable<"Splitter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Splitter::Data::SP", SPAsNamedTableRow>;
    }
    class SP implements VScript.Referenceable<"Splitter::Data::SP"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::SP";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.Splitter.SP>;
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "Splitter::Data::SP::Outputs", SPOutputs>;
    }
    class SPAsNamedTableRow extends SP {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class SPOutputs implements VScript.Referenceable<"Splitter::Data::SP::Outputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::SP::Outputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get output(): VAPI.AT1130.Video.Essence;
    }
}
export declare namespace System {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly InternalHW: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InternalHW;
        readonly MEMORY: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MEMORY;
        readonly Partitions: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Partitions;
        readonly Power: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Power;
        readonly Temperature: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Temperature;
        readonly PartitionsEmmc: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PartitionsEmmc;
        readonly AllSysinfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllSysinfo;
        readonly InternalHWXfi: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InternalHWXfi;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly InternalHW: (_x: InternalHW) => string;
        readonly MEMORY: (_x: MEMORY) => string;
        readonly Partitions: (_x: Partitions) => string;
        readonly Power: (_x: Power) => string;
        readonly Temperature: (_x: Temperature) => string;
        readonly PartitionsEmmc: (_x: PartitionsEmmc) => string;
        readonly AllSysinfo: (_x: AllSysinfo) => string;
        readonly InternalHWXfi: (_x: InternalHWXfi) => string;
    };
    class All implements VScript.Referenceable<"System::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::All";
        get runtime_constants(): {
            readonly is_udx: boolean;
            readonly is_no_pcap: boolean;
            readonly is_multiviewer: boolean;
            readonly is_j2kdecoder: boolean;
            readonly has_replay: boolean;
            readonly has_audio_mixer: boolean;
            readonly has_color_correction: boolean;
            readonly has_video_mixer: boolean;
            readonly has_audio_gain: boolean;
            readonly supports_metadata_extraction: boolean;
            readonly is_pcap: boolean;
            readonly has_passthrough_transmitters: boolean;
            readonly is_jpegxs: boolean;
            readonly has_audio_engine: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get temperature(): Temperature;
        get power(): Power;
        get fan_speed(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::FanSpeed", VAPI.System.FanSpeed>;
        get barebox_version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        get barebox_state(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        get booted_partition(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        get partitions(): Partitions;
        get watchdog_version(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number
        ], null | VAPI.System.Revision, VAPI.AT1130.System.All>;
        get sysinfo(): AllSysinfo;
        get usrinfo(): VAPI.System.AllUsrinfo;
        get neighborhood_watch(): VAPI.System.NeighborhoodWatch;
        get psu(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::PSU", VAPI.System.PSU>;
        get qsfp(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::QSFP", VAPI.System.QSFP>;
        get ecc(): VAPI.System.AllEcc;
        get unique_id(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        get fpga(): VAPI.System.CompileInfo;
        get device(): VAPI.System.Device;
        get io_board(): VAPI.System.AllIoBoard;
        get fan_board(): VAPI.System.Device;
        get frame(): VAPI.System.Device;
        get memory(): MEMORY;
        get internal_hw(): InternalHW;
        /**
          FPGA debug bus at last reboot
        */
        get previous_dbg_bus(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        /**
          Watchdog event log - contains boot reason and times
        */
        get watchdog_event_log(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.All>;
        get board_location(): VScript.rKeyword<VScript.VSocket, VAPI.System.BOARDPOS, VAPI.System.BOARDPOS, VAPI.AT1130.System.All>;
        get frontpanel_led_brightness(): VScript.rwKeyword<VScript.VSocket, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.AT1130.System.All>;
        /**
          Blink the front panel LED in blue to help locating this blade
        */
        get frontpanel_blink_blue(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.System.All>;
        get slots(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::SlotInformation", VAPI.System.SlotInformation>;
        get services(): VAPI.System.AllServices;
        /**
          Currently loaded FPGA
        */
        get selected_fpga(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1130.System.FPGA, null | VAPI.AT1130.System.FPGA, VAPI.AT1130.System.All>;
        /**
          Change which FPGA to load on next reboot
        */
        get select_fpga(): VScript.dKeyword<VScript.VSocket, null | VAPI.AT1130.System.FPGASelection, null | VAPI.AT1130.System.FPGASelection, null | VAPI.AT1130.System.FPGASelection, null | VAPI.AT1130.System.FPGASelection, VAPI.AT1130.System.All>;
        /**
          @brief Perform a reboot of the blade
          @desc Type in `reboot` to reboot the current partition. Type in `system0`
          or `system1` to reboot to the respective partition.
        */
        get reboot(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.System.All>;
        /**
          @brief Perform a power cycle
          @desc Enter `powercycle` to interrupt blade power for 3 seconds
        */
        get powercycle(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.System.All>;
        /**
          @brief Reset NVRAM
          @desc Enter `reset` to clear all settings and reboot
        */
        get reset(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1130.System.All>;
        get command_logging(): VAPI.System.AllCommandLogging;
        get nmos(): VAPI.System.AllNmos;
    }
    type FPGA = "AVP_100GbE" | "DMV_100GbE" | "JPEGXS_RX_100GbE" | "JPEGXS_TX_100GbE" | "PCAP_100GbE" | "AUDIO_100GbE";
    type FPGASelection = "AUDIO_100GbE" | "AVP_100GbE" | "JPEGXS_RX_100GbE" | "JPEGXS_TX_100GbE" | "PCAP_100GbE";
    type FaultStatus = "LINK_UP" | "LOCAL_FAULT" | "REMOTE_FAULT";
    class InternalHW implements VScript.Referenceable<"System::Data::InternalHW"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::InternalHW";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Active PCIe lanes - should be 4
        */
        get pcie_lanes(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.InternalHW>;
        /**
          Active PCIe speed - should be GT_8_0
        */
        get pcie_speed(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.PCIESPEED, null | VAPI.System.PCIESPEED, VAPI.AT1130.System.InternalHW>;
        get xfi(): VScript.StronglyTypedArray<VScript.VSocket, "System::Data::InternalHW::Xfi", InternalHWXfi>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.System.InternalHWIssues, VAPI.AT1130.System.InternalHW>;
    }
    class MEMORY implements VScript.Referenceable<"System::Data::MEMORY"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::MEMORY";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm(): VScript.rKeyword<VScript.VSocket, VAPI.System.RAMCALIBRATION, VAPI.System.RAMCALIBRATION, VAPI.AT1130.System.MEMORY>;
        /**
          J20
        */
        get spd_sodimm(): VAPI.System.SPD;
    }
    class Partitions implements VScript.Referenceable<"System::Data::Partitions"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Partitions";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get booted(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.System.SWVersion, VAPI.AT1130.System.Partitions>;
        get recovery(): VAPI.System.SWVersion;
        get system0(): VAPI.System.SWVersion;
        get system1(): VAPI.System.SWVersion;
        get emmc(): PartitionsEmmc;
    }
    class Power implements VScript.Referenceable<"System::Data::Power"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Power";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Power usage for P0V9_B
        */
        get p0v9_b(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Power>;
        /**
          Power usage for P1V2 (HBM)
        */
        get p1v2_hbm(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Power>;
        /**
          Power usage for P1V8
        */
        get p1v8(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Power>;
        /**
          Power usage for P1V8
        */
        get p5v0(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Power>;
    }
    class Temperature implements VScript.Referenceable<"System::Data::Temperature"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Temperature";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get fpga_ext_core(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_ext_htile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_ext_etile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_int_core(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_int_htile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_int_etile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_int_hbm_top(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get fpga_int_hbm_bot(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get cpu(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get cpu_module(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of IO-Board
        */
        get ioboard(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of FPGA-SODIMM (J20)
        */
        get fpga_sodimm(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Air intake temperature (frontview right)
        */
        get fan1_in(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Air intake temperature (frontview left)
        */
        get fan2_in(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of U15
        */
        get u15(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of U18
        */
        get u18(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of U21
        */
        get u21(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Temperature of U23
        */
        get u23(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        /**
          Total minutes spent at overtemperature, where overtemperature is defined
          as follows:
          
          TBD
        */
        get accumulated_overtemperature_time(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get current_fanspeed_profile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.Temperature>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1130.System.TemperatureIssues, VAPI.AT1130.System.Temperature>;
    }
    class PartitionsEmmc implements VScript.Referenceable<"System::Data::Partitions::Emmc"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Partitions::Emmc";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get firmware_version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.System.PartitionsEmmc>;
        get life_time_estimation(): VScript.rKeyword<VScript.VSocket, null | Array<number>, null | Array<VAPI.Primitives.Unsigned8>, VAPI.AT1130.System.PartitionsEmmc>;
        get pre_eol_information(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned8, VAPI.AT1130.System.PartitionsEmmc>;
    }
    type InternalHWIssues = {
        wrong_pcie_speed_or_lanecount: boolean;
    };
    type TemperatureIssues = {
        cpu_temperature_above_critical: boolean;
        cpu_temperature_high: boolean;
        fpga_ext_core_temperature_above_critical: boolean;
        fpga_ext_core_temperature_high: boolean;
        fpga_ext_etile_temperature_above_critical: boolean;
        fpga_ext_etile_temperature_high: boolean;
        fpga_ext_htile_temperature_above_critical: boolean;
        fpga_ext_htile_temperature_high: boolean;
        fpga_int_core_temperature_above_critical: boolean;
        fpga_int_core_temperature_high: boolean;
        fpga_int_etile_temperature_above_critical: boolean;
        fpga_int_etile_temperature_high: boolean;
        fpga_int_hbm_bot_temperature_above_critical: boolean;
        fpga_int_hbm_bot_temperature_high: boolean;
        fpga_int_hbm_top_temperature_above_critical: boolean;
        fpga_int_hbm_top_temperature_high: boolean;
        fpga_int_htile_temperature_above_critical: boolean;
        fpga_int_htile_temperature_high: boolean;
        fpga_sodimm_temperature_above_critical: boolean;
        fpga_sodimm_temperature_high: boolean;
        ioboard_temperature_above_critical: boolean;
        ioboard_temperature_high: boolean;
        missing_data: boolean;
    };
    class AllSysinfo implements VScript.Referenceable<"System::Data::All::Sysinfo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::All::Sysinfo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          System runtime since boot
        */
        get uptime(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1130.System.AllSysinfo>;
        /**
          Load average for 1, 5 and 15 minutes
        */
        get load_avg(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<number>, VAPI.AT1130.System.AllSysinfo>;
        /**
          Free memory
        */
        get freeram(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.System.AllSysinfo>;
        /**
          Number of running processes
        */
        get procs(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.System.AllSysinfo>;
        /**
          Number of currently active CPU cores
        */
        get num_cores(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1130.System.AllSysinfo>;
        get services(): VAPI.ServicesList.ServicesList;
    }
    class InternalHWXfi implements VScript.Referenceable<"System::Data::InternalHW::Xfi"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::InternalHW::Xfi";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get link_up(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.System.InternalHWXfi>;
        get fault_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1130.System.FaultStatus, null | VAPI.AT1130.System.FaultStatus, VAPI.AT1130.System.InternalHWXfi>;
        get crc_errors(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter32, VAPI.AT1130.System.InternalHWXfi>;
        get oversize_errors(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter32, VAPI.AT1130.System.InternalHWXfi>;
        get runt_errors(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter32, VAPI.AT1130.System.InternalHWXfi>;
    }
    const Enums: {
        readonly FaultStatus: FaultStatus[];
        readonly FPGASelection: FPGASelection[];
        readonly FPGA: FPGA[];
    };
}
export declare namespace SystemClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"SystemClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SystemClock::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.SystemClock.All>;
        /**
          Determines the time standard the SystemClock will be set to.
          
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard(): VScript.dKeyword<VScript.VSocket, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.AT1130.SystemClock.All>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.SystemClock.AllIssues, VAPI.AT1130.SystemClock.All>;
        get system_time_updates(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1130.SystemClock.All>;
        get system_time(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1130.SystemClock.All>;
        /**
          use this to override `output.characteristics.offset_type`; may be useful
          to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
          time
        */
        get offset_type_override(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, VAPI.AT1130.SystemClock.All>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
}
export declare namespace Time {
    const lift: {
        readonly AnalogReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AnalogReference;
        readonly Source: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Source;
    };
    const lower: {
        readonly AnalogReference: (_x: AnalogReference) => string;
        readonly Source: (_x: Source) => string;
    };
    class AnalogReference implements VScript.Referenceable<"Time::Data::AnalogReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Time::Data::AnalogReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get output(): Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class Source implements VScript.Referenceable<"Time::Data::Source"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Time::Data::Source";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.Time.Source>;
        get characteristics(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.Time.OffsetType,
            null | VAPI.Time.GrainRate,
            VAPI.Time.ReferenceFrame,
            number
        ], null | VAPI.Time.SourceCharacteristics, VAPI.AT1130.Time.Source>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.Time.SourceIssues, VAPI.AT1130.Time.Source>;
        get drift(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedDrift, VAPI.AT1130.Time.Source>;
        get offset(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedOffset, VAPI.AT1130.Time.Source>;
        get time_code(): VScript.rKeyword<VScript.VSocket, null | [
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            number,
            number
        ], null | VAPI.Time.TimestampedTimecode, VAPI.AT1130.Time.Source>;
        get ptp_traits(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.PTP.Traits, VAPI.AT1130.Time.Source>;
        get genlock(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.Genlock.AT1130GenlockBackend, VAPI.AT1130.Time.Source>;
    }
}
export declare namespace TimeFlows {
    const lift: {
        readonly Aligner: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Aligner;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Combinator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Combinator;
        readonly Detonator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Detonator;
        readonly DriftConverter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DriftConverter;
        readonly Impostor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Impostor;
        readonly Selector: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Selector;
        readonly Shifter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Shifter;
        readonly Stretcher: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Stretcher;
    };
    const lower: {
        readonly Aligner: (_x: Aligner) => string;
        readonly All: (_x: All) => string;
        readonly Combinator: (_x: Combinator) => string;
        readonly Detonator: (_x: Detonator) => string;
        readonly DriftConverter: (_x: DriftConverter) => string;
        readonly Impostor: (_x: Impostor) => string;
        readonly Selector: (_x: Selector) => string;
        readonly Shifter: (_x: Shifter) => string;
        readonly Stretcher: (_x: Stretcher) => string;
    };
    class Aligner implements VScript.Referenceable<"TimeFlows::Data::Aligner"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Aligner";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src_absolute(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Aligner>;
        get t_src_grain_accurate(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Aligner>;
        get warning_threshold(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Aligner>;
        get holdover_grains(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Aligner>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.TimeFlows.AlignerIssues, VAPI.AT1130.TimeFlows.Aligner>;
    }
    class AlignerAsNamedTableRow extends Aligner {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class All implements VScript.Referenceable<"TimeFlows::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get aligners(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Aligner", AlignerAsNamedTableRow>;
        get combinators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Combinator", CombinatorAsNamedTableRow>;
        get detonators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Detonator", DetonatorAsNamedTableRow>;
        get drift_converters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::DriftConverter", DriftConverterAsNamedTableRow>;
        get impostors(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Impostor", ImpostorAsNamedTableRow>;
        get selectors(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Selector", SelectorAsNamedTableRow>;
        get shifters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Shifter", ShifterAsNamedTableRow>;
        /**
          stretchers shift their input source's measured drift by a user-defined
          amount (note that this demotes `Absolute` and `GrainAccurate` time
          sources to class `FrequencyOnly`). Stretchers are probably useless in a
          production setting, but can be helpful in simulating failure scenarios.
        */
        get stretchers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Stretcher", StretcherAsNamedTableRow>;
    }
    class Combinator implements VScript.Referenceable<"TimeFlows::Data::Combinator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Combinator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get required_offset_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, VAPI.AT1130.TimeFlows.Combinator>;
        get required_ptp_source_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, VAPI.AT1130.TimeFlows.Combinator>;
        get drift_reference(): VScript.rwKeyword<VScript.VSocket, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.AT1130.TimeFlows.Combinator>;
        get min_drift_tolerance(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Combinator>;
        get min_offset_tolerance(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.TimeFlows.Combinator>;
        get quorum(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Combinator>;
        get session_length(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.TimeFlows.Combinator>;
        get selected(): VScript.rKeyword<VScript.VSocket, Array<boolean>, Array<boolean>, VAPI.AT1130.TimeFlows.Combinator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VAPI.AT1130.Time.Source>, VScript.MaybeSparseArray<null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>>, VAPI.AT1130.TimeFlows.Combinator>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class CombinatorAsNamedTableRow extends Combinator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Detonator implements VScript.Referenceable<"TimeFlows::Data::Detonator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Detonator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get max_drift_blast(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Detonator>;
        get max_offset_blast(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.TimeFlows.Detonator>;
        /**
          Discharge
        */
        get discharge(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.TimeFlows.Detonator>;
        /**
          Realign
        */
        get realign(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.TimeFlows.Detonator>;
        get friction(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Detonator>;
        get stiffness(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Detonator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Detonator>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class DetonatorAsNamedTableRow extends Detonator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DriftConverter implements VScript.Referenceable<"TimeFlows::Data::DriftConverter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::DriftConverter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get drift_reference(): VScript.rwKeyword<VScript.VSocket, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.AT1130.TimeFlows.DriftConverter>;
        /**
          ideally, all inputs to a clock combinator should use the same reference
          frame as the clock combinator itself. If this is not the case,
          mismatching inputs will be discarded by default. By setting
          `on_reference_frame_mismatch` to `Convert`, inputs can also be converted
          to the combinator's own reference frame. Note, however, that this
          generally incurs a loss in precision
        */
        get on_drift_reference_mismatch(): VScript.rwKeyword<VScript.VSocket, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.AT1130.TimeFlows.DriftConverter>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.DriftConverter>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class DriftConverterAsNamedTableRow extends DriftConverter {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Impostor implements VScript.Referenceable<"TimeFlows::Data::Impostor"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Impostor";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Impostor>;
        /**
          Insert specified `grain_rate`, or upgrade input to absolute time source
          if null
        */
        get grain_rate(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, VAPI.AT1130.TimeFlows.Impostor>;
        get output(): VAPI.AT1130.Time.Source;
    }
    class ImpostorAsNamedTableRow extends Impostor {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Selector implements VScript.Referenceable<"TimeFlows::Data::Selector"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Selector";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get selected(): VScript.rKeyword<VScript.VSocket, Array<boolean>, Array<boolean>, VAPI.AT1130.TimeFlows.Selector>;
        get t_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VAPI.AT1130.Time.Source>, VScript.MaybeSparseArray<null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>>, VAPI.AT1130.TimeFlows.Selector>;
        get required_offset_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, VAPI.AT1130.TimeFlows.Selector>;
        get required_drift_reference(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, VAPI.AT1130.TimeFlows.Selector>;
        get required_ptp_source_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, VAPI.AT1130.TimeFlows.Selector>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class SelectorAsNamedTableRow extends Selector {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Shifter implements VScript.Referenceable<"TimeFlows::Data::Shifter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Shifter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get shift(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.TimeFlows.Shifter>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Shifter>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class ShifterAsNamedTableRow extends Shifter {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Stretcher implements VScript.Referenceable<"TimeFlows::Data::Stretcher"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Stretcher";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get frequency_shift(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.TimeFlows.Stretcher>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.TimeFlows.Stretcher>;
        get output(): VAPI.AT1130.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class StretcherAsNamedTableRow extends Stretcher {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace UDX {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly UDXOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => UDXOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly UDXOutput: (_x: UDXOutput) => string;
    };
    class All implements VScript.Referenceable<"UDX::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDX::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "UDX::Data::UDXOutput", UDXOutput>;
        get statistics(): VAPI.UDX.UDXStatistics;
    }
    class UDXOutput implements VScript.Referenceable<"UDX::Data::UDXOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDX::Data::UDXOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_source(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.UDX.UDXOutput>;
        get video_standard(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.AT1130.UDX.UDXOutput>;
        get aspect_ratio(): VScript.dKeyword<VScript.VSocket, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.AT1130.UDX.UDXOutput>;
        get sd_active_pixels(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.AT1130.UDX.UDXOutput>;
        get video_full_range(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.UDX.UDXOutput>;
        get on_video_source_lost(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.AT1130.UDX.UDXOutput>;
        get crop(): VAPI.UDX.UDXVideoCrop;
        get transform(): VAPI.UDX.UDXTransform;
        get filter(): VAPI.UDX.UDXFilter;
        get signal(): VAPI.AT1130.Video.Essence;
        get metadata_inserter(): VAPI.AT1130.MetadataProcessor.MetadataInserter;
    }
}
export declare namespace UDXMetadataRequests {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"UDXMetadataRequests::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDXMetadataRequests::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get requests(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::Request", VAPI.AT1130.MetadataProcessor.Request>;
    }
}
export declare namespace Video {
    const lift: {
        readonly Essence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Essence;
        readonly TimedSource: (_raw: [null | string, null | number | string], _socket: VScript.VSocket) => TimedSource;
    };
    const lower: {
        readonly Essence: (_x: Essence) => string;
        readonly TimedSource: (_x: {
            source: null | VAPI.AT1130.Video.Essence;
            switch_time: null | VAPI.Primitives.Timestamp;
        }, _socket: VScript.VSocket) => [null | string, null | number | string];
    };
    class Essence implements VScript.Referenceable<"Video::Data::Essence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Video::Data::Essence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1130.Video.Essence>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.Video.Essence>;
        get pixel_format(): VScript.rKeyword<VScript.VSocket, [
            null | VAPI.Video.ColorSpace,
            VAPI.Video.BitDepth,
            null | VAPI.Video.TransferCharacteristics,
            VAPI.Video.LuminanceAndColorDifferenceSignal
        ], VAPI.Video.PixelFormat, VAPI.AT1130.Video.Essence>;
        get substream(): VScript.rKeyword<VScript.VSocket, [
            VAPI.Video.SubStream,
            boolean
        ], VAPI.Video.EssenceSubstream, VAPI.AT1130.Video.Essence>;
        get frozen(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.Video.Essence>;
        get black(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1130.Video.Essence>;
        get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1130.Video.Essence>;
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock(): VAPI.AT1130.Time.Source;
        get afd(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Video.AspectRatio,
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.Video.AFD, VAPI.AT1130.Video.Essence>;
        get cc(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.Video.ClosedCaption, VAPI.AT1130.Video.Essence>;
    }
    interface TimedSource {
        source: null | VAPI.AT1130.Video.Essence;
        switch_time: null | VAPI.Primitives.Timestamp;
    }
}
export declare namespace VideoMixer {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly BSLK: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => BSLK;
        readonly BSLKLumaKeyer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => BSLKLumaKeyer;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly BSLK: (_x: BSLK) => string;
        readonly BSLKLumaKeyer: (_x: BSLKLumaKeyer) => string;
    };
    class All implements VScript.Referenceable<"VideoMixer::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::All";
        get runtime_constants(): {
            readonly num_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoMixer::Data::BSLK", BSLKAsNamedTableRow>;
    }
    class BSLK implements VScript.Referenceable<"VideoMixer::Data::BSLK"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::BSLK";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoMixer.BSLKIssues, VAPI.AT1130.VideoMixer.BSLK>;
        get v_src0(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoMixer.BSLK>;
        get v_src1(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoMixer.BSLK>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoMixer.BSLK>;
        get phase_target(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.VideoMixer.BSLK>;
        get in_phase(): VScript.rKeyword<VScript.VSocket, Array<null | number>, Array<null | VScript.Duration>, VAPI.AT1130.VideoMixer.BSLK>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1130.VideoMixer.BSLK>;
        get output(): VAPI.AT1130.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoMixer.BSLK>;
        get hw_resources(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1130.VideoMixer.BSLK>;
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.AT1130.VideoMixer.BSLK>;
        get luma_keyer(): BSLKLumaKeyer;
        get mixer(): VAPI.VideoMixer.BSLKMixer;
    }
    class BSLKAsNamedTableRow extends BSLK {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class BSLKLumaKeyer implements VScript.Referenceable<"VideoMixer::Data::BSLK::LumaKeyer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::BSLK::LumaKeyer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoMixer.BSLKLumaKeyer>;
        /**
          Luminance level at and below which everything is transparent
        */
        get clip(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.VideoMixer.BSLKLumaKeyer>;
        /**
          Luminance range above clip to reach full opacity
        */
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.VideoMixer.BSLKLumaKeyer>;
        get opacity(): VAPI.VideoMixer.AutoFader;
        /**
          Invert the transparent / opaque ends of the output range
        */
        get invert(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoMixer.BSLKLumaKeyer>;
    }
}
export declare namespace VideoPlayer {
    const lift: {
        readonly Player: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Player;
        readonly PlayerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PlayerOutput;
        readonly RelationAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudio;
        readonly RelationVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideo;
        readonly Relations: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Relations;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly RelationAudioFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudioFollowers;
        readonly RelationVideoFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideoFollowers;
    };
    const lower: {
        readonly Player: (_x: Player) => string;
        readonly PlayerOutput: (_x: PlayerOutput) => string;
        readonly RelationAudio: (_x: RelationAudio) => string;
        readonly RelationVideo: (_x: RelationVideo) => string;
        readonly Relations: (_x: Relations) => string;
        readonly Time: (_x: Time) => string;
        readonly RelationAudioFollowers: (_x: RelationAudioFollowers) => string;
        readonly RelationVideoFollowers: (_x: RelationVideoFollowers) => string;
    };
    class Player implements VScript.Referenceable<"VideoPlayer::Data::Player"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Player";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoPlayer.PlayerIssues, VAPI.AT1130.VideoPlayer.Player>;
        get upload(): VAPI.VideoPlayer.Upload;
        get memory_usage(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            [
                null | number,
                null | number
            ],
            null | VAPI.Video.Standard
        ], VAPI.VideoPlayer.MemoryCapacity, VAPI.AT1130.VideoPlayer.Player>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            [
                boolean,
                ([0, [VAPI.Video.Standard]] | [
                    1,
                    [VAPI.Definitions.Bandwidth]
                ])
            ]
        ], [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            [
                boolean,
                ([0, [VAPI.Video.Standard]] | [
                    1,
                    [VAPI.Definitions.Bandwidth]
                ])
            ]
        ], VAPI.VideoPlayer.Capabilities, VAPI.VideoPlayer.Capabilities, VAPI.AT1130.VideoPlayer.Player>;
        get gang(): Relations;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.VideoPlayer.Player>;
        get output(): PlayerOutput;
    }
    class PlayerAsNamedTableRow extends Player {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class PlayerOutput implements VScript.Referenceable<"VideoPlayer::Data::PlayerOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::PlayerOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get time(): Time;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.VideoPlayer.PlayerOutput>;
        get control(): VAPI.VideoPlayer.Control;
        get deembedded_audio(): VScript.StronglyTypedArray<VScript.VSocket, "VideoPlayer::Data::GroupSelections", VAPI.VideoPlayer.GroupSelections>;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::Reader", VAPI.VideoPlayer.Reader>;
        get video(): VAPI.AT1130.Video.Essence;
        get audio(): VAPI.AT1130.Audio.Essence;
    }
    class RelationAudio implements VScript.Referenceable<"VideoPlayer::Data::RelationAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.AudioRePlay.Player, null | VScript.Referenceable<"AudioRePlay::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoPlayer.RelationAudio>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::RelationAudio::Followers", RelationAudioFollowers>;
    }
    class RelationVideo implements VScript.Referenceable<"VideoPlayer::Data::RelationVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.VideoPlayer.Player, null | VScript.Referenceable<"VideoPlayer::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoPlayer.RelationVideo>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::RelationVideo::Followers", RelationVideoFollowers>;
    }
    class Relations implements VScript.Referenceable<"VideoPlayer::Data::Relations"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Relations";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): RelationVideo;
        get audio(): RelationAudio;
    }
    class Time implements VScript.Referenceable<"VideoPlayer::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoPlayer.Time>;
        get phaser_range(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.VideoPlayer.Time>;
        get restart_phaser(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.VideoPlayer.Time>;
    }
    class RelationAudioFollowers implements VScript.Referenceable<"VideoPlayer::Data::RelationAudio::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationAudio::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.AudioRePlay.Player, VAPI.AT1130.VideoPlayer.RelationAudioFollowers>;
    }
    class RelationVideoFollowers implements VScript.Referenceable<"VideoPlayer::Data::RelationVideo::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationVideo::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1130.VideoPlayer.Player, VAPI.AT1130.VideoPlayer.RelationVideoFollowers>;
    }
}
export declare namespace VideoRePlay {
    const lift: {
        readonly Delay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Delay;
        readonly DelayOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayOutput;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly Video: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Video;
        readonly DelayInputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayInputs;
    };
    const lower: {
        readonly Delay: (_x: Delay) => string;
        readonly DelayOutput: (_x: DelayOutput) => string;
        readonly Time: (_x: Time) => string;
        readonly Video: (_x: Video) => string;
        readonly DelayInputs: (_x: DelayInputs) => string;
    };
    class Delay implements VScript.Referenceable<"VideoRePlay::Data::Delay"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Delay";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoRePlay.DelayIssues, VAPI.AT1130.VideoRePlay.Delay>;
        get memory_usage(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            [
                null | number,
                null | number
            ],
            [
                null | number,
                null | number
            ],
            null | VAPI.Video.Standard
        ], VAPI.VideoRePlay.MemoryCapacity, VAPI.AT1130.VideoRePlay.Delay>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            VAPI.VideoRePlay.DelayMode,
            ([
                0,
                [
                    boolean,
                    ([0, [VAPI.Video.Standard]] | [
                        1,
                        [VAPI.Definitions.Bandwidth]
                    ])
                ]
            ] | [
                1,
                [VAPI.Video.SquareDivisionStandard]
            ])
        ], [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            VAPI.VideoRePlay.DelayMode,
            ([
                0,
                [
                    boolean,
                    ([0, [VAPI.Video.Standard]] | [
                        1,
                        [VAPI.Definitions.Bandwidth]
                    ])
                ]
            ] | [
                1,
                [VAPI.Video.SquareDivisionStandard]
            ])
        ], VAPI.VideoRePlay.Capabilities, VAPI.VideoRePlay.Capabilities, VAPI.AT1130.VideoRePlay.Delay>;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1130.VideoRePlay.Delay>;
        get dma(): VAPI.VideoRePlay.DMA;
        get inputs(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Delay::Inputs", DelayInputs>;
        get outputs(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoRePlay::Data::DelayOutput", DelayOutputAsNamedTableRow>;
        stop_and_download(pars?: {
            frame_index?: number;
        }): Promise<ArrayBuffer>;
        url(pars?: {
            frame_index?: number;
        }): string;
    }
    class DelayAsNamedTableRow extends Delay {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DelayOutput implements VScript.Referenceable<"VideoRePlay::Data::DelayOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::DelayOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoRePlay.DelayOutput>;
        get time(): Time;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.VideoRePlay.DelayOutput>;
        get delay(): VAPI.VideoRePlay.Buffer;
        get deembedded_audio(): VScript.StronglyTypedArray<VScript.VSocket, "VideoRePlay::Data::GroupSelections", VAPI.VideoRePlay.GroupSelections>;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Reader", VAPI.VideoRePlay.Reader>;
        get video(): VAPI.AT1130.Video.Essence;
        get audio(): VAPI.AT1130.Audio.Essence;
    }
    class DelayOutputAsNamedTableRow extends DelayOutput {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Time implements VScript.Referenceable<"VideoRePlay::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get phaser_range(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1130.VideoRePlay.Time>;
        get restart_phaser(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1130.VideoRePlay.Time>;
    }
    class Video implements VScript.Referenceable<"VideoRePlay::Data::Video"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Video";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.DataRePlay.MemoryInfo;
        get players(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoPlayer::Data::Player", VAPI.AT1130.VideoPlayer.PlayerAsNamedTableRow>;
        get delays(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoRePlay::Data::Delay", DelayAsNamedTableRow>;
        get statistic(): VAPI.DataRePlay.Statistic;
        get ecc(): VAPI.Memory.ECCMuxStatistics;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class DelayInputs implements VScript.Referenceable<"VideoRePlay::Data::Delay::Inputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Delay::Inputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1130.VideoRePlay.DelayInputs>;
        get latest_running_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1130.VideoRePlay.DelayInputs>;
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoRePlay.DelayInputs>;
        get writer(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Writer", VAPI.VideoRePlay.Writer>;
    }
}
export declare namespace VideoSignalGenerator {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly VSG: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VSG;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly VSG: (_x: VSG) => string;
    };
    class All implements VScript.Referenceable<"VideoSignalGenerator::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoSignalGenerator::Data::All";
        get runtime_constants(): {
            readonly num_video_signal_generators: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedArray<VScript.VSocket, "VideoSignalGenerator::Data::VSG", VSG>;
    }
    class VSG implements VScript.Referenceable<"VideoSignalGenerator::Data::VSG"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoSignalGenerator::Data::VSG";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1130.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get output(): VAPI.AT1130.Video.Essence;
        get standard(): VScript.dKeyword<VScript.VSocket, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get pattern(): VScript.rwKeyword<VScript.VSocket, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get cnt0_full(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get cnt1_full(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get cnt0_horz(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get cnt1_horz(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get phase(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1130.VideoSignalGenerator.VSG>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoSignalGenerator.VSGIssues, VAPI.AT1130.VideoSignalGenerator.VSG>;
    }
}
export declare class Root {
    readonly raw: VScript.VSocket;
    readonly audio_engine?: VAPI.AT1130.AudioEngine.All;
    readonly audio_gain?: VAPI.AT1130.AudioGain.All;
    readonly audio_mixer?: VAPI.AT1130.AudioMixer.All;
    readonly audio_shuffler?: VAPI.AT1130.AudioShuffler.All;
    readonly audio_signal_generator?: VAPI.AT1130.AudioSignalGenerator.All;
    readonly clos_x_bar?: VAPI.ClosXBar.All;
    readonly cluster?: VAPI.AT1130.Cluster.All;
    readonly color_correction?: VAPI.AT1130.ColorCorrection.All;
    readonly genlock?: VAPI.AT1130.Genlock.All;
    readonly i_o_module?: VAPI.AT1130.IOModule.All;
    readonly j2_k_decoder?: VAPI.AT1130.J2KDecoder.All;
    readonly master_clock: VAPI.AT1130.MasterClock.All;
    readonly metadata_processor?: VAPI.AT1130.MetadataProcessor.All;
    readonly monitoring?: VAPI.AT1130.Monitoring.All;
    readonly multiviewer?: VAPI.Multiviewer.All;
    readonly multiviewer_i_o?: VAPI.AT1130.MultiviewerIO.All;
    readonly network_interfaces: VAPI.AT1130.NetworkInterfaces.All;
    readonly p_cap?: VAPI.AT1130.PCap.All;
    readonly p_t_p_clock: VAPI.AT1130.PTPClock.All;
    readonly p_t_p_flows: VAPI.AT1130.PTPFlows.All;
    readonly r_t_p_metadata_channel?: VAPI.RTPMetadataChannel.All;
    readonly r_t_p_receiver?: VAPI.AT1130.RTPReceiver.All;
    readonly r_t_p_transmitter?: VAPI.AT1130.RTPTransmitter.All;
    readonly re_play?: VAPI.AT1130.RePlay.All;
    readonly sample_rate_converter?: VAPI.AT1130.SampleRateConverter.All;
    readonly software_update: VAPI.SoftwareUpdate.All;
    readonly splitter?: VAPI.AT1130.Splitter.All;
    readonly system: VAPI.AT1130.System.All;
    readonly system_clock: VAPI.AT1130.SystemClock.All;
    readonly time_flows: VAPI.AT1130.TimeFlows.All;
    readonly u_d_x?: VAPI.AT1130.UDX.All;
    readonly u_d_x_metadata_requests?: VAPI.AT1130.UDXMetadataRequests.All;
    readonly video_mixer?: VAPI.AT1130.VideoMixer.All;
    readonly video_signal_generator?: VAPI.AT1130.VideoSignalGenerator.All;
    constructor(raw: VScript.VSocket);
    static adopt(socket: VScript.VSocket): Root;
    close(): Promise<void>;
}
