import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    CompressorCurveAutoGain: (_raw, _socket) => {
        return {
            cutoff: _raw[0],
            target: _raw[1],
            width: _raw[2],
            ratio: _raw[3]
        };
    },
    StereoPanBalanceBalanceCenterLinear: (_raw, _socket) => {
        return { balance: _raw[0] };
    },
    CompressorARTime: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Samples", value: VAPI.AudioEngine.lift.CompressorARTimeSamples(_raw[1], _socket) };
            case 1: return { variant: "Time", value: VAPI.AudioEngine.lift.CompressorARTimeTime(_raw[1], _socket) };
        }
        ;
    },
    CompressorCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0],
            control: VAPI.AudioEngine.lift.CompressorCapabilitiesControl(_raw[1], _socket),
            lookahead: _raw[2]
        };
    },
    CompressorCurve: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "SoftKnee", value: VAPI.AudioEngine.lift.CompressorCurveSoftKnee(_raw[1], _socket) };
            case 1: return { variant: "HardKnee", value: VAPI.AudioEngine.lift.CompressorCurveHardKnee(_raw[1], _socket) };
            case 2: return { variant: "Ducking", value: VAPI.AudioEngine.lift.CompressorCurveDucking(_raw[1], _socket) };
            case 3: return { variant: "Gate", value: VAPI.AudioEngine.lift.CompressorCurveGate(_raw[1], _socket) };
            case 4: return { variant: "AutoGain", value: VAPI.AudioEngine.lift.CompressorCurveAutoGain(_raw[1], _socket) };
        }
        ;
    },
    CompressorCurvePoint: (_raw, _socket) => {
        return {
            i: _raw[0],
            o: _raw[1],
            c: _raw[2]
        };
    },
    CompressorParameter: (_raw, _socket) => {
        return {
            attack: VAPI.AudioEngine.lift.CompressorARTime(_raw[0], _socket),
            release: VAPI.AudioEngine.lift.CompressorARTime(_raw[1], _socket),
            hold: VAPI.AudioEngine.lift.CompressorARTime(_raw[2], _socket),
            gain: _raw[3]
        };
    },
    CompressorSource: (_raw) => (new CompressorSource(_raw)),
    DelayCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0],
            taps: _raw[1]
        };
    },
    DelayParameter: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Samples", value: VAPI.AudioEngine.lift.DelayParameterSamples(_raw[1], _socket) };
            case 1: return { variant: "Time", value: VAPI.AudioEngine.lift.DelayParameterTime(_raw[1], _socket) };
        }
        ;
    },
    DownMixCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0]
        };
    },
    CompressorCurveDucking: (_raw, _socket) => {
        return {
            threshold: _raw[0],
            width: _raw[1],
            gain: _raw[2]
        };
    },
    Fader: (_raw) => (new Fader(_raw)),
    FilterCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0],
            bands: _raw[1]
        };
    },
    FilterCoeffs: (_raw, _socket) => {
        return {
            a0: _raw[0],
            a1: _raw[1],
            a2: _raw[2],
            b1: _raw[3],
            b2: _raw[4]
        };
    },
    FilterHighPass: (_raw, _socket) => {
        return {
            fc: _raw[0],
            q: _raw[1]
        };
    },
    FilterHighShelf: (_raw, _socket) => {
        return {
            fc: _raw[0],
            gain: _raw[1]
        };
    },
    FilterLowPass: (_raw, _socket) => {
        return {
            fc: _raw[0],
            q: _raw[1]
        };
    },
    FilterLowShelf: (_raw, _socket) => {
        return {
            fc: _raw[0],
            gain: _raw[1]
        };
    },
    FilterParameter: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "LowPass", value: VAPI.AudioEngine.lift.FilterLowPass(_raw[1], _socket) };
            case 1: return { variant: "HighPass", value: VAPI.AudioEngine.lift.FilterHighPass(_raw[1], _socket) };
            case 2: return { variant: "Peak", value: VAPI.AudioEngine.lift.FilterPeak(_raw[1], _socket) };
            case 3: return { variant: "LowShelf", value: VAPI.AudioEngine.lift.FilterLowShelf(_raw[1], _socket) };
            case 4: return { variant: "HighShelf", value: VAPI.AudioEngine.lift.FilterHighShelf(_raw[1], _socket) };
        }
        ;
    },
    FilterPeak: (_raw, _socket) => {
        return {
            fc: _raw[0],
            q: _raw[1],
            gain: _raw[2]
        };
    },
    CompressorCurveGate: (_raw, _socket) => {
        return {
            threshold: _raw[0],
            width: _raw[1]
        };
    },
    Group: (_raw) => (new Group(_raw)),
    HWInputAssignment: (_raw, _socket) => {
        return {
            value: _raw[0]
        };
    },
    CompressorCurveHardKnee: (_raw, _socket) => {
        return {
            threshold: _raw[0],
            ratio: _raw[1]
        };
    },
    Info: (_raw, _socket) => {
        return {
            engine_load: _raw[0],
            planning_time: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
            inputs: VAPI.AudioEngine.lift.Resource(_raw[2], _socket),
            outputs: VAPI.AudioEngine.lift.Resource(_raw[3], _socket),
            faders: VAPI.AudioEngine.lift.Resource(_raw[4], _socket),
            biquads: VAPI.AudioEngine.lift.Resource(_raw[5], _socket),
            delays: _raw[6] === null ? null : VAPI.AudioEngine.lift.InfoDelays(_raw[6], _socket),
            measurement: VAPI.AudioEngine.lift.InfoMeasurement(_raw[7], _socket),
            compressor: _raw[8] === null ? null : VAPI.AudioEngine.lift.InfoCompressor(_raw[8], _socket)
        };
    },
    CompressorCapabilitiesControlInput: (_raw, _socket) => {
        return {
            bandpass: _raw[0]
        };
    },
    InputTrimCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0]
        };
    },
    LoudnessCapabilities: (_raw, _socket) => {
        return {
            front_channels: _raw[0],
            surround_channels: _raw[1],
            k_weighting: _raw[2]
        };
    },
    LoudnessMeasurement: (_raw, _socket) => {
        return {
            momentary: _raw[0],
            short_term: _raw[1],
            gated: _raw[2],
            gated_recorded: VScript.VAPIHelpers.liftNanoseconds(_raw[3], _socket)
        };
    },
    MSFader: (_raw, _socket) => {
        return {
            gain: _raw[0],
            mute: _raw[1]
        };
    },
    MidSideCapabilities: (_raw, _socket) => {
        return {
            input_mode: _raw[0]
        };
    },
    MonoMixCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0],
            master_fader: _raw[1]
        };
    },
    NMinus1Capabilities: (_raw, _socket) => {
        return {
            channels: _raw[0]
        };
    },
    StereoPanBalancePanCenterLinear: (_raw, _socket) => {
        return {
            pan: _raw[0]
        };
    },
    StereoPanBalancePanConstantPower: (_raw, _socket) => {
        return {
            pan: _raw[0]
        };
    },
    StereoPanBalancePanFullLinear: (_raw, _socket) => {
        return {
            pan: _raw[0]
        };
    },
    Resource: (_raw, _socket) => {
        return {
            used: _raw[0],
            available: _raw[1]
        };
    },
    CompressorARTimeSamples: (_raw, _socket) => {
        return {
            samples: _raw[0]
        };
    },
    DelayParameterSamples: (_raw, _socket) => {
        return {
            samples: _raw[0]
        };
    },
    CompressorCapabilitiesControlSidechainOnly: (_raw, _socket) => {
        return {};
    },
    CompressorCurveSoftKnee: (_raw, _socket) => {
        return {
            threshold: _raw[0],
            width: _raw[1],
            ratio: _raw[2]
        };
    },
    StereoMixCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0],
            master_fader: _raw[1]
        };
    },
    StereoPanBalance: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "PanCenterLinear", value: VAPI.AudioEngine.lift.StereoPanBalancePanCenterLinear(_raw[1], _socket) };
            case 1: return { variant: "PanFullLinear", value: VAPI.AudioEngine.lift.StereoPanBalancePanFullLinear(_raw[1], _socket) };
            case 2: return { variant: "PanConstantPower", value: VAPI.AudioEngine.lift.StereoPanBalancePanConstantPower(_raw[1], _socket) };
            case 3: return { variant: "BalanceCenterLinear", value: VAPI.AudioEngine.lift.StereoPanBalanceBalanceCenterLinear(_raw[1], _socket) };
        }
        ;
    },
    CompressorARTimeTime: (_raw, _socket) => {
        return {
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket)
        };
    },
    DelayParameterTime: (_raw, _socket) => {
        return {
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket)
        };
    },
    TruePeakCapabilities: (_raw, _socket) => {
        return {
            channels: _raw[0]
        };
    },
    CompressorBandpass: (_raw, _socket) => {
        return {
            enabled: _raw[0],
            lowcut: VAPI.AudioEngine.lift.FilterHighPass(_raw[1], _socket),
            highcut: VAPI.AudioEngine.lift.FilterLowPass(_raw[2], _socket)
        };
    },
    FilterBands: (_raw) => (new FilterBands(_raw)),
    InfoCompressor: (_raw, _socket) => {
        return {
            curve_ram: VAPI.AudioEngine.lift.Resource(_raw[0], _socket),
            engines: VAPI.AudioEngine.lift.Resource(_raw[1], _socket),
            channels: VAPI.AudioEngine.lift.Resource(_raw[2], _socket)
        };
    },
    CompressorCapabilitiesControl: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Input", value: VAPI.AudioEngine.lift.CompressorCapabilitiesControlInput(_raw[1], _socket) };
            case 1: return { variant: "SidechainOnly", value: VAPI.AudioEngine.lift.CompressorCapabilitiesControlSidechainOnly(_raw[1], _socket) };
        }
        ;
    },
    InfoDelays: (_raw, _socket) => {
        return {
            writer: VAPI.AudioEngine.lift.Resource(_raw[0], _socket),
            reader: VAPI.AudioEngine.lift.Resource(_raw[1], _socket)
        };
    },
    DownMixLevels: (_raw, _socket) => {
        return {
            master: _raw[0],
            l_r: _raw[1],
            center: _raw[2],
            lfe: _raw[3],
            sl_sr: _raw[4],
            sbl_sbr: _raw[5],
            tl_tr: _raw[6],
            tbl_tbr: _raw[7]
        };
    },
    CompressorLookahead: (_raw, _socket) => {
        return {
            enabled: _raw[0],
            delay: VAPI.AudioEngine.lift.DelayParameter(_raw[1], _socket)
        };
    },
    InfoMeasurement: (_raw, _socket) => {
        return {
            truepeak: _raw[0] === null ? null : VAPI.AudioEngine.lift.Resource(_raw[0], _socket),
            rms_meter: _raw[1] === null ? null : VAPI.AudioEngine.lift.Resource(_raw[1], _socket),
            kfilter: _raw[2] === null ? null : VAPI.AudioEngine.lift.Resource(_raw[2], _socket)
        };
    },
    MidSideParams: (_raw, _socket) => {
        return {
            gain: _raw[0],
            width: _raw[1],
            rotation: _raw[2]
        };
    },
};
export const lower = {
    CompressorCurveAutoGain: (_x, _socket) => [
        _x.cutoff,
        _x.target,
        _x.width,
        _x.ratio
    ],
    StereoPanBalanceBalanceCenterLinear: (_x, _socket) => [
        _x.balance
    ],
    CompressorARTime: (_x, _socket) => {
        switch (_x.variant) {
            case "Samples": return [0, VAPI.AudioEngine.lower.CompressorARTimeSamples(_x.value, _socket)];
            case "Time": return [1, VAPI.AudioEngine.lower.CompressorARTimeTime(_x.value, _socket)];
        }
    },
    CompressorCapabilities: (_x, _socket) => [
        _x.channels,
        VAPI.AudioEngine.lower.CompressorCapabilitiesControl(_x.control, _socket),
        _x.lookahead
    ],
    CompressorCurve: (_x, _socket) => {
        switch (_x.variant) {
            case "SoftKnee": return [0, VAPI.AudioEngine.lower.CompressorCurveSoftKnee(_x.value, _socket)];
            case "HardKnee": return [1, VAPI.AudioEngine.lower.CompressorCurveHardKnee(_x.value, _socket)];
            case "Ducking": return [2, VAPI.AudioEngine.lower.CompressorCurveDucking(_x.value, _socket)];
            case "Gate": return [3, VAPI.AudioEngine.lower.CompressorCurveGate(_x.value, _socket)];
            case "AutoGain": return [4, VAPI.AudioEngine.lower.CompressorCurveAutoGain(_x.value, _socket)];
        }
    },
    CompressorCurvePoint: (_x, _socket) => [
        _x.i,
        _x.o,
        _x.c
    ],
    CompressorParameter: (_x, _socket) => [
        VAPI.AudioEngine.lower.CompressorARTime(_x.attack, _socket),
        VAPI.AudioEngine.lower.CompressorARTime(_x.release, _socket),
        VAPI.AudioEngine.lower.CompressorARTime(_x.hold, _socket),
        _x.gain
    ],
    CompressorSource: (_x) => _x.raw.kwl,
    DelayCapabilities: (_x, _socket) => [
        _x.channels,
        _x.taps
    ],
    DelayParameter: (_x, _socket) => {
        switch (_x.variant) {
            case "Samples": return [0, VAPI.AudioEngine.lower.DelayParameterSamples(_x.value, _socket)];
            case "Time": return [1, VAPI.AudioEngine.lower.DelayParameterTime(_x.value, _socket)];
        }
    },
    DownMixCapabilities: (_x, _socket) => [
        _x.channels
    ],
    CompressorCurveDucking: (_x, _socket) => [
        _x.threshold,
        _x.width,
        _x.gain
    ],
    Fader: (_x) => _x.raw.kwl,
    FilterCapabilities: (_x, _socket) => [
        _x.channels,
        _x.bands
    ],
    FilterCoeffs: (_x, _socket) => [
        _x.a0,
        _x.a1,
        _x.a2,
        _x.b1,
        _x.b2
    ],
    FilterHighPass: (_x, _socket) => [
        _x.fc,
        _x.q
    ],
    FilterHighShelf: (_x, _socket) => [
        _x.fc,
        _x.gain
    ],
    FilterLowPass: (_x, _socket) => [
        _x.fc,
        _x.q
    ],
    FilterLowShelf: (_x, _socket) => [
        _x.fc,
        _x.gain
    ],
    FilterParameter: (_x, _socket) => {
        switch (_x.variant) {
            case "LowPass": return [0, VAPI.AudioEngine.lower.FilterLowPass(_x.value, _socket)];
            case "HighPass": return [1, VAPI.AudioEngine.lower.FilterHighPass(_x.value, _socket)];
            case "Peak": return [2, VAPI.AudioEngine.lower.FilterPeak(_x.value, _socket)];
            case "LowShelf": return [3, VAPI.AudioEngine.lower.FilterLowShelf(_x.value, _socket)];
            case "HighShelf": return [4, VAPI.AudioEngine.lower.FilterHighShelf(_x.value, _socket)];
        }
    },
    FilterPeak: (_x, _socket) => [
        _x.fc,
        _x.q,
        _x.gain
    ],
    CompressorCurveGate: (_x, _socket) => [
        _x.threshold,
        _x.width
    ],
    Group: (_x) => _x.raw.kwl,
    HWInputAssignment: (_x, _socket) => [
        _x.value
    ],
    CompressorCurveHardKnee: (_x, _socket) => [
        _x.threshold,
        _x.ratio
    ],
    Info: (_x, _socket) => [
        _x.engine_load,
        VScript.VAPIHelpers.lowerNanoseconds(_x.planning_time, _socket),
        VAPI.AudioEngine.lower.Resource(_x.inputs, _socket),
        VAPI.AudioEngine.lower.Resource(_x.outputs, _socket),
        VAPI.AudioEngine.lower.Resource(_x.faders, _socket),
        VAPI.AudioEngine.lower.Resource(_x.biquads, _socket),
        _x.delays === null ? null : VAPI.AudioEngine.lower.InfoDelays(_x.delays, _socket),
        VAPI.AudioEngine.lower.InfoMeasurement(_x.measurement, _socket),
        _x.compressor === null ? null : VAPI.AudioEngine.lower.InfoCompressor(_x.compressor, _socket)
    ],
    CompressorCapabilitiesControlInput: (_x, _socket) => [
        _x.bandpass
    ],
    InputTrimCapabilities: (_x, _socket) => [
        _x.channels
    ],
    LoudnessCapabilities: (_x, _socket) => [
        _x.front_channels,
        _x.surround_channels,
        _x.k_weighting
    ],
    LoudnessMeasurement: (_x, _socket) => [
        _x.momentary,
        _x.short_term,
        _x.gated,
        VScript.VAPIHelpers.lowerNanoseconds(_x.gated_recorded, _socket)
    ],
    MSFader: (_x, _socket) => [
        _x.gain,
        _x.mute
    ],
    MidSideCapabilities: (_x, _socket) => [
        _x.input_mode
    ],
    MonoMixCapabilities: (_x, _socket) => [
        _x.channels,
        _x.master_fader
    ],
    NMinus1Capabilities: (_x, _socket) => [
        _x.channels
    ],
    StereoPanBalancePanCenterLinear: (_x, _socket) => [
        _x.pan
    ],
    StereoPanBalancePanConstantPower: (_x, _socket) => [
        _x.pan
    ],
    StereoPanBalancePanFullLinear: (_x, _socket) => [
        _x.pan
    ],
    Resource: (_x, _socket) => [
        _x.used,
        _x.available
    ],
    CompressorARTimeSamples: (_x, _socket) => [
        _x.samples
    ],
    DelayParameterSamples: (_x, _socket) => [
        _x.samples
    ],
    CompressorCapabilitiesControlSidechainOnly: (_x, _socket) => [],
    CompressorCurveSoftKnee: (_x, _socket) => [
        _x.threshold,
        _x.width,
        _x.ratio
    ],
    StereoMixCapabilities: (_x, _socket) => [
        _x.channels,
        _x.master_fader
    ],
    StereoPanBalance: (_x, _socket) => {
        switch (_x.variant) {
            case "PanCenterLinear": return [0, VAPI.AudioEngine.lower.StereoPanBalancePanCenterLinear(_x.value, _socket)];
            case "PanFullLinear": return [1, VAPI.AudioEngine.lower.StereoPanBalancePanFullLinear(_x.value, _socket)];
            case "PanConstantPower": return [2, VAPI.AudioEngine.lower.StereoPanBalancePanConstantPower(_x.value, _socket)];
            case "BalanceCenterLinear": return [3, VAPI.AudioEngine.lower.StereoPanBalanceBalanceCenterLinear(_x.value, _socket)];
        }
    },
    CompressorARTimeTime: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    DelayParameterTime: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    TruePeakCapabilities: (_x, _socket) => [
        _x.channels
    ],
    CompressorBandpass: (_x, _socket) => [
        _x.enabled,
        VAPI.AudioEngine.lower.FilterHighPass(_x.lowcut, _socket),
        VAPI.AudioEngine.lower.FilterLowPass(_x.highcut, _socket)
    ],
    FilterBands: (_x) => _x.raw.kwl,
    InfoCompressor: (_x, _socket) => [
        VAPI.AudioEngine.lower.Resource(_x.curve_ram, _socket),
        VAPI.AudioEngine.lower.Resource(_x.engines, _socket),
        VAPI.AudioEngine.lower.Resource(_x.channels, _socket)
    ],
    CompressorCapabilitiesControl: (_x, _socket) => {
        switch (_x.variant) {
            case "Input": return [0, VAPI.AudioEngine.lower.CompressorCapabilitiesControlInput(_x.value, _socket)];
            case "SidechainOnly": return [1, VAPI.AudioEngine.lower.CompressorCapabilitiesControlSidechainOnly(_x.value, _socket)];
        }
    },
    InfoDelays: (_x, _socket) => [
        VAPI.AudioEngine.lower.Resource(_x.writer, _socket),
        VAPI.AudioEngine.lower.Resource(_x.reader, _socket)
    ],
    DownMixLevels: (_x, _socket) => [
        _x.master,
        _x.l_r,
        _x.center,
        _x.lfe,
        _x.sl_sr,
        _x.sbl_sbr,
        _x.tl_tr,
        _x.tbl_tbr
    ],
    CompressorLookahead: (_x, _socket) => [
        _x.enabled,
        VAPI.AudioEngine.lower.DelayParameter(_x.delay, _socket)
    ],
    InfoMeasurement: (_x, _socket) => [
        _x.truepeak === null ? null : VAPI.AudioEngine.lower.Resource(_x.truepeak, _socket),
        _x.rms_meter === null ? null : VAPI.AudioEngine.lower.Resource(_x.rms_meter, _socket),
        _x.kfilter === null ? null : VAPI.AudioEngine.lower.Resource(_x.kfilter, _socket)
    ],
    MidSideParams: (_x, _socket) => [
        _x.gain,
        _x.width,
        _x.rotation
    ],
};
export class CompressorSource {
    raw;
    type_identifier = "AudioEngine::Data::CompressorSource";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Fader {
    raw;
    type_identifier = "AudioEngine::Data::Fader";
    constructor(raw) {
        this.raw = raw;
    }
    get label() {
        return new VScript.rwKeyword(this, "label", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      A value of -128 is interpreted as -Infinity, the range is reduced to
      allow easier automatic mapping to encoders / sliders
    */
    get gain() {
        return new VScript.rwKeyword(this, "gain", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get mute() {
        return new VScript.rwKeyword(this, "mute", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get solo() {
        return new VScript.rwKeyword(this, "solo", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class Group {
    raw;
    type_identifier = "AudioEngine::Data::Group";
    constructor(raw) {
        this.raw = raw;
    }
    get desc() {
        return new VScript.rwKeyword(this, "desc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get parent_group() {
        return new VScript.rwKeyword(this, "parent_group", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, null);
    }
}
export class GroupAsNamedTableRow extends Group {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class FilterBands {
    raw;
    type_identifier = "AudioEngine::Data::Filter::Bands";
    constructor(raw) {
        this.raw = raw;
    }
    get param() {
        return new VScript.rwKeyword(this, "param", {
            lift: VAPI.AudioEngine.lift.FilterParameter,
            lower: VAPI.AudioEngine.lower.FilterParameter
        }, {
            lift: VAPI.AudioEngine.lift.FilterParameter,
            lower: VAPI.AudioEngine.lower.FilterParameter
        }, null);
    }
    get coeffs() {
        return new VScript.rKeyword(this, "coeffs", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.FilterCoeffs),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.FilterCoeffs)
        });
    }
}
