import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AlarmConfiguratin: (_raw, _socket) => {
        return { enable: _raw[0] };
    },
    AlarmConfiguratinWithTiming: (_raw, _socket) => {
        return {
            enable: _raw[0],
            activate_duration: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
            deactivate_duration: VScript.VAPIHelpers.liftNanoseconds(_raw[2], _socket)
        };
    },
    AlarmConfigurationWithTimingAndAudioLevel: (_raw, _socket) => {
        return {
            enable: _raw[0],
            activate_duration: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
            deactivate_duration: VScript.VAPIHelpers.liftNanoseconds(_raw[2], _socket),
            level: _raw[3]
        };
    },
    AlarmConfigurationWithVideoStandard: (_raw, _socket) => {
        return {
            enable: _raw[0],
            video_standard: _raw[1]
        };
    },
    ClusterAudioMonitoringObjectAlarmsConfiguration: (_raw) => (new ClusterAudioMonitoringObjectAlarmsConfiguration(_raw)),
    ClusterAudioMonitoringObjectAlarmsEnable: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            silent_source: _raw[2],
            over_range_source: _raw[3],
            under_range_source: _raw[4],
            unexpected_source_standard: _raw[5],
            tally_source: _raw[6]
        };
    },
    ClusterAudioMonitoringObjectAlarmsSeverityLevel: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            silent_source: _raw[2],
            over_range_source: _raw[3],
            under_range_source: _raw[4],
            unexpected_source_standard: _raw[5]
        };
    },
    ClusterAudioMonitoringObjectConfiguration: (_raw) => (new ClusterAudioMonitoringObjectConfiguration(_raw)),
    ClusterAudioMonitoringObjectRuntimeAlarms: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            silent_source: _raw[2],
            over_range_source: _raw[3],
            under_range_source: _raw[4],
            unexpected_source_standard: _raw[5]
        };
    },
    ClusterGlobalMonitoringObjectsParameters: (_raw) => (new ClusterGlobalMonitoringObjectsParameters(_raw)),
    ClusterMetadataMonitoringObjectAlarmsConfiguration: (_raw) => (new ClusterMetadataMonitoringObjectAlarmsConfiguration(_raw)),
    ClusterMetadataMonitoringObjectAlarmsEnable: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            missing_closed_caption: _raw[2],
            missing_time_code: _raw[3]
        };
    },
    ClusterMetadataMonitoringObjectAlarmsSeverityLevel: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            missing_closed_caption: _raw[2],
            missing_time_code: _raw[3]
        };
    },
    ClusterMetadataMonitoringObjectConfiguration: (_raw) => (new ClusterMetadataMonitoringObjectConfiguration(_raw)),
    ClusterMetadataMonitoringObjectRuntimeAlarms: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            missing_closed_caption: _raw[2],
            missing_time_code: _raw[3]
        };
    },
    ClusterMonitoringObjectAlarmsEnable: (_raw) => (new ClusterMonitoringObjectAlarmsEnable(_raw)),
    ClusterMonitoringObjectAlarmsSeverityLevel: (_raw) => (new ClusterMonitoringObjectAlarmsSeverityLevel(_raw)),
    ClusterMonitoringObjectGlobalConfiguration: (_raw) => (new ClusterMonitoringObjectGlobalConfiguration(_raw)),
    ClusterMonitoringObjectUserAlarmConfiguration: (_raw) => (new ClusterMonitoringObjectUserAlarmConfiguration(_raw)),
    ClusterVideoMonitoringObjectAlarmsConfiguration: (_raw) => (new ClusterVideoMonitoringObjectAlarmsConfiguration(_raw)),
    ClusterVideoMonitoringObjectAlarmsEnable: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            frozen_source: _raw[2],
            black_source: _raw[3],
            unexpected_source_standard: _raw[4],
            tally_source: _raw[5]
        };
    },
    ClusterVideoMonitoringObjectAlarmsSeverityLevel: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            frozen_source: _raw[2],
            black_source: _raw[3],
            unexpected_source_standard: _raw[4]
        };
    },
    ClusterVideoMonitoringObjectConfiguration: (_raw) => (new ClusterVideoMonitoringObjectConfiguration(_raw)),
    ClusterVideoMonitoringObjectRuntimeAlarms: (_raw, _socket) => {
        return {
            not_assigned_source: _raw[0],
            lost_source: _raw[1],
            frozen_source: _raw[2],
            black_source: _raw[3],
            unexpected_source_standard: _raw[4]
        };
    },
    MonitoringObjectChannelID: (_raw, _socket) => {
        return {
            id: _raw[0],
            channel_id: _raw[1]
        };
    },
};
export const lower = {
    AlarmConfiguratin: (_x, _socket) => [
        _x.enable
    ],
    AlarmConfiguratinWithTiming: (_x, _socket) => [
        _x.enable,
        VScript.VAPIHelpers.lowerNanoseconds(_x.activate_duration, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.deactivate_duration, _socket)
    ],
    AlarmConfigurationWithTimingAndAudioLevel: (_x, _socket) => [
        _x.enable,
        VScript.VAPIHelpers.lowerNanoseconds(_x.activate_duration, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.deactivate_duration, _socket),
        _x.level
    ],
    AlarmConfigurationWithVideoStandard: (_x, _socket) => [
        _x.enable,
        _x.video_standard
    ],
    ClusterAudioMonitoringObjectAlarmsConfiguration: (_x) => _x.raw.kwl,
    ClusterAudioMonitoringObjectAlarmsEnable: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.silent_source,
        _x.over_range_source,
        _x.under_range_source,
        _x.unexpected_source_standard,
        _x.tally_source
    ],
    ClusterAudioMonitoringObjectAlarmsSeverityLevel: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.silent_source,
        _x.over_range_source,
        _x.under_range_source,
        _x.unexpected_source_standard
    ],
    ClusterAudioMonitoringObjectConfiguration: (_x) => _x.raw.kwl,
    ClusterAudioMonitoringObjectRuntimeAlarms: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.silent_source,
        _x.over_range_source,
        _x.under_range_source,
        _x.unexpected_source_standard
    ],
    ClusterGlobalMonitoringObjectsParameters: (_x) => _x.raw.kwl,
    ClusterMetadataMonitoringObjectAlarmsConfiguration: (_x) => _x.raw.kwl,
    ClusterMetadataMonitoringObjectAlarmsEnable: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.missing_closed_caption,
        _x.missing_time_code
    ],
    ClusterMetadataMonitoringObjectAlarmsSeverityLevel: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.missing_closed_caption,
        _x.missing_time_code
    ],
    ClusterMetadataMonitoringObjectConfiguration: (_x) => _x.raw.kwl,
    ClusterMetadataMonitoringObjectRuntimeAlarms: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.missing_closed_caption,
        _x.missing_time_code
    ],
    ClusterMonitoringObjectAlarmsEnable: (_x) => _x.raw.kwl,
    ClusterMonitoringObjectAlarmsSeverityLevel: (_x) => _x.raw.kwl,
    ClusterMonitoringObjectGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterMonitoringObjectUserAlarmConfiguration: (_x) => _x.raw.kwl,
    ClusterVideoMonitoringObjectAlarmsConfiguration: (_x) => _x.raw.kwl,
    ClusterVideoMonitoringObjectAlarmsEnable: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.frozen_source,
        _x.black_source,
        _x.unexpected_source_standard,
        _x.tally_source
    ],
    ClusterVideoMonitoringObjectAlarmsSeverityLevel: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.frozen_source,
        _x.black_source,
        _x.unexpected_source_standard
    ],
    ClusterVideoMonitoringObjectConfiguration: (_x) => _x.raw.kwl,
    ClusterVideoMonitoringObjectRuntimeAlarms: (_x, _socket) => [
        _x.not_assigned_source,
        _x.lost_source,
        _x.frozen_source,
        _x.black_source,
        _x.unexpected_source_standard
    ],
    MonitoringObjectChannelID: (_x, _socket) => [
        _x.id,
        _x.channel_id
    ],
};
export class ClusterAudioMonitoringObjectAlarmsConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectAlarmsConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get not_assigned_source() {
        return new VScript.rwKeyword(this, "not_assigned_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get lost_source() {
        return new VScript.rwKeyword(this, "lost_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get silent_source() {
        return new VScript.rwKeyword(this, "silent_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, null);
    }
    get over_range_source() {
        return new VScript.rwKeyword(this, "over_range_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, null);
    }
    get under_range_source() {
        return new VScript.rwKeyword(this, "under_range_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithTimingAndAudioLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithTimingAndAudioLevel
        }, null);
    }
    get unexpected_source_standard() {
        return new VScript.rwKeyword(this, "unexpected_source_standard", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get tally_source() {
        return new VScript.rwKeyword(this, "tally_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
}
export class ClusterAudioMonitoringObjectConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get channel_id_start() {
        return new VScript.rwKeyword(this, "channel_id_start", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get channels_num() {
        return new VScript.rwKeyword(this, "channels_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get channels_combine_function() {
        return new VScript.rwKeyword(this, "channels_combine_function", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get alarms() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectAlarmsConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "alarms"));
    }
}
export class ClusterGlobalMonitoringObjectsParameters {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterGlobalMonitoringObjectsParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get severity_levels() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterMonitoringObjectAlarmsSeverityLevel(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "severity_levels"));
    }
}
export class ClusterMetadataMonitoringObjectAlarmsConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectAlarmsConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get not_assigned_source() {
        return new VScript.rwKeyword(this, "not_assigned_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get lost_source() {
        return new VScript.rwKeyword(this, "lost_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get missing_closed_caption() {
        return new VScript.rwKeyword(this, "missing_closed_caption", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, null);
    }
    get missing_time_code() {
        return new VScript.rwKeyword(this, "missing_time_code", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, null);
    }
}
export class ClusterMetadataMonitoringObjectConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get cc_mode() {
        return new VScript.rwKeyword(this, "cc_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get cc_channel() {
        return new VScript.rwKeyword(this, "cc_channel", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get alarms() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectAlarmsConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "alarms"));
    }
}
export class ClusterMonitoringObjectAlarmsEnable {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsEnable";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.rwKeyword(this, "video", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectAlarmsEnable
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectAlarmsEnable
        }, null);
    }
    get audio() {
        return new VScript.rwKeyword(this, "audio", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectAlarmsEnable
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectAlarmsEnable
        }, null);
    }
    get metadata() {
        return new VScript.rwKeyword(this, "metadata", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectAlarmsEnable
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectAlarmsEnable,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectAlarmsEnable
        }, null);
    }
}
export class ClusterMonitoringObjectAlarmsSeverityLevel {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsSeverityLevel";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.rwKeyword(this, "video", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectAlarmsSeverityLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectAlarmsSeverityLevel
        }, null);
    }
    get audio() {
        return new VScript.rwKeyword(this, "audio", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectAlarmsSeverityLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectAlarmsSeverityLevel
        }, null);
    }
    get metadata() {
        return new VScript.rwKeyword(this, "metadata", {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectAlarmsSeverityLevel
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectAlarmsSeverityLevel,
            lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectAlarmsSeverityLevel
        }, null);
    }
}
export class ClusterMonitoringObjectGlobalConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "video"), (st, _) => VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectConfiguration(st));
    }
    get audio() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "audio"), (st, _) => VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectConfiguration(st));
    }
    get metadata() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "metadata"), (st, _) => VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectConfiguration(st));
    }
    get user_alarms_enable() {
        return new VScript.rwKeyword(this, "user_alarms_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get user_alarms() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "user_alarms"), (st, _) => VAPI.ClusterMonitoringObjects.lift.ClusterMonitoringObjectUserAlarmConfiguration(st));
    }
}
export class ClusterMonitoringObjectGlobalConfigurationAsNamedTableRow extends ClusterMonitoringObjectGlobalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterMonitoringObjectUserAlarmConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectUserAlarmConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get severity_level() {
        return new VScript.rwKeyword(this, "severity_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get label() {
        return new VScript.rwKeyword(this, "label", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterVideoMonitoringObjectAlarmsConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectAlarmsConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get not_assigned_source() {
        return new VScript.rwKeyword(this, "not_assigned_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get lost_source() {
        return new VScript.rwKeyword(this, "lost_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
    get frozen_source() {
        return new VScript.rwKeyword(this, "frozen_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, null);
    }
    get black_source() {
        return new VScript.rwKeyword(this, "black_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratinWithTiming,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratinWithTiming
        }, null);
    }
    get unexpected_source_standard() {
        return new VScript.rwKeyword(this, "unexpected_source_standard", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithVideoStandard,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithVideoStandard
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfigurationWithVideoStandard,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfigurationWithVideoStandard
        }, null);
    }
    get tally_source() {
        return new VScript.rwKeyword(this, "tally_source", {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.AlarmConfiguratin,
            lower: VAPI.ClusterMonitoringObjects.lower.AlarmConfiguratin
        }, null);
    }
}
export class ClusterVideoMonitoringObjectConfiguration {
    raw;
    type_identifier = "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get alarms() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectAlarmsConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "alarms"));
    }
}
export const Enums = {
    TIMECODE: ["LTC", "VTC1", "VTC2"],
    COMBINEFUNCTION: ["OR", "AND"]
};
