import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    MemoryCapacity: (_raw, _socket) => {
        return { as_pages: _raw[0], as_bytes: _raw[1] };
    },
    MemoryInfo: (_raw) => (new MemoryInfo(_raw)),
    Statistic: (_raw) => (new Statistic(_raw)),
};
export const lower = {
    MemoryCapacity: (_x, _socket) => [
        _x.as_pages,
        _x.as_bytes
    ],
    MemoryInfo: (_x) => _x.raw.kwl,
    Statistic: (_x) => _x.raw.kwl,
};
export class MemoryInfo {
    raw;
    type_identifier = "DataRePlay::Data::MemoryInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get page_bits() {
        return new VScript.rKeyword(this, "page_bits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get address_bits() {
        return new VScript.rKeyword(this, "address_bits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get loop_start_address_granularity() {
        return new VScript.rKeyword(this, "loop_start_address_granularity", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get data_bits() {
        return new VScript.rKeyword(this, "data_bits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get page_size() {
        return new VScript.rKeyword(this, "page_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get total_capacity() {
        return new VScript.rKeyword(this, "total_capacity", {
            lift: VAPI.DataRePlay.lift.MemoryCapacity,
            lower: VAPI.DataRePlay.lower.MemoryCapacity
        });
    }
    get free() {
        return new VScript.rKeyword(this, "free", {
            lift: VAPI.DataRePlay.lift.MemoryCapacity,
            lower: VAPI.DataRePlay.lower.MemoryCapacity
        });
    }
}
export class Statistic {
    raw;
    type_identifier = "DataRePlay::Data::Statistic";
    constructor(raw) {
        this.raw = raw;
    }
    get pages_per_instance() {
        return new VScript.rKeyword(this, "pages_per_instance", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_writer_instance() {
        return new VScript.rKeyword(this, "max_writer_instance", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get writer_instance() {
        return new VScript.rKeyword(this, "writer_instance", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_read_instance() {
        return new VScript.rKeyword(this, "max_read_instance", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get read_instance() {
        return new VScript.rKeyword(this, "read_instance", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get memory_map() {
        return new VScript.rKeyword(this, "memory_map", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
