import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly VANCAfdInserterBlank: (_raw: [], _socket: VScript.VSocket) => VANCAfdInserterBlank;
    readonly BypassReplaceFlags: (_raw: [boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => BypassReplaceFlags;
    readonly LatchControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Definitions.LatchControl;
    readonly NAME: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Definitions.NAME;
    readonly VANCAfdInserterPassthrough: (_raw: [], _socket: VScript.VSocket) => VANCAfdInserterPassthrough;
    readonly VANCAfdInserterReplace: (_raw: [null | VAPI.Definitions.VANCAfdCode], _socket: VScript.VSocket) => VANCAfdInserterReplace;
    readonly VANCAfdInserter: (_raw: ([0, []] | [1, []] | [2, [null | VAPI.Definitions.VANCAfdCode]]), _socket: VScript.VSocket) => VANCAfdInserter;
    readonly LatchControlBoundaries: (_raw: [number, number, number], _socket: VScript.VSocket) => LatchControlBoundaries;
};
export declare const lower: {
    readonly VANCAfdInserterBlank: (_x: {}, _socket: VScript.VSocket) => [];
    readonly BypassReplaceFlags: (_x: {
        /**
          Bypass unknown meta data
        */
        c_unknown: boolean;
        /**
          Bypass DID 61 SDID 01 (SMPTE 334-1 CEA-708 / CDP)
        */
        y_334_cea_708_cdp: boolean;
        /**
          Bypass DID 61 SDID 02 (SMPTE 334-1 CEA-608)
        */
        y_334_cea_608: boolean;
        /**
          Bypass DID 62 SDID 01 (SMPTE 334-1 Program description)
        */
        y_334_program: boolean;
        /**
          Bypass DID 62 SDID 02 (SMPTE 334-1 Data broadcast)
        */
        y_334_data: boolean;
        /**
          Bypass DID 62 SDID 03 (SMPTE 334-1 VBI data)
        */
        y_334_vbi: boolean;
        /**
          Bypass DID 41 SDID 07 (SMPTE 2010 - ANSI/SCTE 104)
        */
        y_2010_ansi_scte_104: boolean;
        /**
          Bypass DID 41 SDID 08 (SMPTE 2031 - DVB/SCTE VBI)
        */
        y_2031_dvb_scte_vbi: boolean;
        /**
          Bypass DID 43 SDID 02 (RDD 8 / OP-47)
        */
        y_rdd_8_op_47: boolean;
        /**
          Bypass DID 45 (SMPTE 2020 - Audio Meta Data)
        */
        y_2020_amd: boolean;
        /**
          Bypass DID 53 (OBS Source ID)
        */
        y_obs: boolean;
        /**
          Bypass unknown meta data
        */
        y_unknown: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean];
    readonly LatchControl: (_x: LatchControl) => string;
    readonly NAME: (_x: NAME) => string;
    readonly VANCAfdInserterPassthrough: (_x: {}, _socket: VScript.VSocket) => [];
    readonly VANCAfdInserterReplace: (_x: {
        afd: null | VAPI.Definitions.VANCAfdCode;
    }, _socket: VScript.VSocket) => [null | VAPI.Definitions.VANCAfdCode];
    readonly VANCAfdInserter: (_x: ({
        variant: "Passthrough";
        value: VAPI.Definitions.VANCAfdInserterPassthrough;
    } | {
        variant: "Blank";
        value: VAPI.Definitions.VANCAfdInserterBlank;
    } | {
        variant: "Replace";
        value: VAPI.Definitions.VANCAfdInserterReplace;
    }), _socket: VScript.VSocket) => ([0, []] | [1, []] | [2, [null | VAPI.Definitions.VANCAfdCode]]);
    readonly LatchControlBoundaries: (_x: {
        attack_time: VScript.Duration;
        mediaclock_late: VScript.Duration;
        mediaclock_early: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number, number];
};
export type AudioFormat = "AM824" | "L24" | "L16";
export type Bandwidth = "b1_5Gb" | "b3_0Gb" | "b12_0Gb";
export interface VANCAfdInserterBlank {
}
export interface BypassReplaceFlags {
    /**
      Bypass unknown meta data
    */
    c_unknown: boolean;
    /**
      Bypass DID 61 SDID 01 (SMPTE 334-1 CEA-708 / CDP)
    */
    y_334_cea_708_cdp: boolean;
    /**
      Bypass DID 61 SDID 02 (SMPTE 334-1 CEA-608)
    */
    y_334_cea_608: boolean;
    /**
      Bypass DID 62 SDID 01 (SMPTE 334-1 Program description)
    */
    y_334_program: boolean;
    /**
      Bypass DID 62 SDID 02 (SMPTE 334-1 Data broadcast)
    */
    y_334_data: boolean;
    /**
      Bypass DID 62 SDID 03 (SMPTE 334-1 VBI data)
    */
    y_334_vbi: boolean;
    /**
      Bypass DID 41 SDID 07 (SMPTE 2010 - ANSI/SCTE 104)
    */
    y_2010_ansi_scte_104: boolean;
    /**
      Bypass DID 41 SDID 08 (SMPTE 2031 - DVB/SCTE VBI)
    */
    y_2031_dvb_scte_vbi: boolean;
    /**
      Bypass DID 43 SDID 02 (RDD 8 / OP-47)
    */
    y_rdd_8_op_47: boolean;
    /**
      Bypass DID 45 (SMPTE 2020 - Audio Meta Data)
    */
    y_2020_amd: boolean;
    /**
      Bypass DID 53 (OBS Source ID)
    */
    y_obs: boolean;
    /**
      Bypass unknown meta data
    */
    y_unknown: boolean;
}
export type InputTypes = "SDI" | "VidStream" | "AudStream" | "SRC" | "DELAY" | "TestTone" | "Volume" | "Mixer";
export declare class LatchControl implements VScript.Referenceable<"Definitions::Data::LatchControl"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Definitions::Data::LatchControl";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.dKeyword<VScript.VSocket, VAPI.Definitions.LatchMode, VAPI.Definitions.LatchMode, VAPI.Definitions.LatchMode, VAPI.Definitions.LatchMode, VAPI.Definitions.LatchControl>;
    get boundaries(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Definitions.LatchControlBoundaries, VAPI.Definitions.LatchControlBoundaries, VAPI.Definitions.LatchControl>;
}
export type LatchMode = "On_Start" | "Continuous";
export declare class NAME implements VScript.Referenceable<"Definitions::Data::NAME"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Definitions::Data::NAME";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Is the textual brief
    */
    get brief(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.Definitions.NAME>;
    /**
      Provides textual information
    */
    get description(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.Definitions.NAME>;
}
export type PacketTime = "p1" | "p0_666" | "p0_500" | "p0_333" | "p0_250" | "p0_125";
export interface VANCAfdInserterPassthrough {
}
export interface VANCAfdInserterReplace {
    afd: null | VAPI.Definitions.VANCAfdCode;
}
export type TRSEmbedder = "Embed" | "Bypass" | "Off";
export type VANCAfdCode = "Code_0010" | "Code_0011" | "Code_0100" | "Code_0101" | "Code_0110" | "Code_0111" | "Code_1000" | "Code_1001" | "Code_1010" | "Code_1011" | "Code_1100" | "Code_1101" | "Code_1110" | "Code_1111";
export type VANCAfdInserter = ({
    variant: "Passthrough";
    value: VAPI.Definitions.VANCAfdInserterPassthrough;
} | {
    variant: "Blank";
    value: VAPI.Definitions.VANCAfdInserterBlank;
} | {
    variant: "Replace";
    value: VAPI.Definitions.VANCAfdInserterReplace;
});
export type AudioInput = number;
export interface LatchControlBoundaries {
    attack_time: VScript.Duration;
    mediaclock_late: VScript.Duration;
    mediaclock_early: VScript.Duration;
}
export type RtpPayloadType = number;
export type VideoInput = number;
export declare const Enums: {
    readonly VANCAfdCode: VANCAfdCode[];
    readonly TRSEmbedder: TRSEmbedder[];
    readonly PacketTime: PacketTime[];
    readonly LatchMode: LatchMode[];
    readonly InputTypes: InputTypes[];
    readonly Bandwidth: Bandwidth[];
    readonly AudioFormat: AudioFormat[];
};
