export const lift = {
    BytesCounter: (_raw, _socket) => {
        return {
            bytes_total: _raw[0],
            bytes_per_sec: _raw[1]
        };
    },
    Counter: (_raw, _socket) => {
        return {
            bytes_total: _raw[0],
            packets_total: _raw[1],
            bytes_per_sec: _raw[2],
            packets_per_sec: _raw[3]
        };
    },
    EventsCounter: (_raw, _socket) => {
        return {
            events_total: _raw[0],
            events_per_sec: _raw[1]
        };
    },
    PacketsCounter: (_raw, _socket) => {
        return {
            packets_total: _raw[0],
            packets_per_sec: _raw[1]
        };
    },
};
export const lower = {
    BytesCounter: (_x, _socket) => [
        _x.bytes_total,
        _x.bytes_per_sec
    ],
    Counter: (_x, _socket) => [
        _x.bytes_total,
        _x.packets_total,
        _x.bytes_per_sec,
        _x.packets_per_sec
    ],
    EventsCounter: (_x, _socket) => [
        _x.events_total,
        _x.events_per_sec
    ],
    PacketsCounter: (_x, _socket) => [
        _x.packets_total,
        _x.packets_per_sec
    ],
};
