import * as VScript from "vscript";
export const lift = {
    ECCMuxStatistics: (_raw) => (new ECCMuxStatistics(_raw)),
};
export const lower = {
    ECCMuxStatistics: (_x) => _x.raw.kwl,
};
export class ECCMuxStatistics {
    raw;
    type_identifier = "Memory::Data::ECCMuxStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get err_corrected_sum() {
        return new VScript.rKeyword(this, "err_corrected_sum", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get err_detected_sum() {
        return new VScript.rKeyword(this, "err_detected_sum", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get err_fatal_sum() {
        return new VScript.rKeyword(this, "err_fatal_sum", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_readreq() {
        return new VScript.rKeyword(this, "stats_readreq", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_readdata() {
        return new VScript.rKeyword(this, "stats_readdata", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_readwait() {
        return new VScript.rKeyword(this, "stats_readwait", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get stats_readwait_cmp() {
        return new VScript.rKeyword(this, "stats_readwait_cmp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_readwait_max() {
        return new VScript.rKeyword(this, "stats_readwait_max", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get stats_writedata() {
        return new VScript.rKeyword(this, "stats_writedata", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_writewait() {
        return new VScript.rKeyword(this, "stats_writewait", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get stats_user_readreq() {
        return new VScript.rKeyword(this, "stats_user_readreq", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_user_readwait() {
        return new VScript.rKeyword(this, "stats_user_readwait", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get stats_user_readwait_cmp() {
        return new VScript.rKeyword(this, "stats_user_readwait_cmp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stats_user_readwait_max() {
        return new VScript.rKeyword(this, "stats_user_readwait_max", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get max_wait_duration() {
        return new VScript.rwKeyword(this, "max_wait_duration", {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, null);
    }
    get load() {
        return new VScript.rKeyword(this, "load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Clear statistic counter
    */
    get clear() {
        return new VScript.wKeyword(this, "clear", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
