import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly DMVInternal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.DMVInternal;
    readonly DMVMipMaps: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.DMVMipMaps;
    readonly DMVMipMapsInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.DMVMipMapsInput;
    readonly DMVMipMapsOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.DMVMipMapsOutput;
    readonly DistributedMultiviewer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.DistributedMultiviewer;
    readonly HSLCOLOUR: (_raw: [number, number, number], _socket: VScript.VSocket) => HSLCOLOUR;
    readonly ManifoldCore: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.ManifoldCore;
    readonly ManifoldCoreOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.MultiviewerIO.ManifoldCoreOutput;
    readonly PortInfo: (_raw: [number, number], _socket: VScript.VSocket) => PortInfo;
};
export declare const lower: {
    readonly DMVInternal: (_x: DMVInternal) => string;
    readonly DMVMipMaps: (_x: DMVMipMaps) => string;
    readonly DMVMipMapsInput: (_x: DMVMipMapsInput) => string;
    readonly DMVMipMapsOutput: (_x: DMVMipMapsOutput) => string;
    readonly DistributedMultiviewer: (_x: DistributedMultiviewer) => string;
    readonly HSLCOLOUR: (_x: {
        hue: number;
        saturation: number;
        lightness: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly ManifoldCore: (_x: ManifoldCore) => string;
    readonly ManifoldCoreOutput: (_x: ManifoldCoreOutput) => string;
    readonly PortInfo: (_x: {
        port_line_id: number;
        port_line_stream_id: number;
    }, _socket: VScript.VSocket) => [number, number];
};
export declare class DMVInternal implements VScript.Referenceable<"MultiviewerIO::Data::DMVInternal"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::DMVInternal";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mipmaps(): VAPI.MultiviewerIO.DMVMipMaps;
}
export declare class DMVMipMaps implements VScript.Referenceable<"MultiviewerIO::Data::DMVMipMaps"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::DMVMipMaps";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mipmaps_ins_ports(): VScript.rKeyword<VScript.VSocket, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.MultiviewerIO.DMVMipMaps>;
    get inputs(): VScript.StronglyTypedArray<VScript.VSocket, "MultiviewerIO::Data::DMVMipMapsInput", VAPI.MultiviewerIO.DMVMipMapsInput>;
    get outputs(): VScript.StronglyTypedArray<VScript.VSocket, "MultiviewerIO::Data::DMVMipMapsOutput", VAPI.MultiviewerIO.DMVMipMapsOutput>;
}
export declare class DMVMipMapsInput implements VScript.Referenceable<"MultiviewerIO::Data::DMVMipMapsInput"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::DMVMipMapsInput";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.MultiviewerIO.DMVMipMapsInput>;
    /**
      IP address of the mipmap RTP stream
    */
    get src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsInput>;
    /**
      IP address of the mipmap RTP stream
    */
    get dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsInput>;
    get interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.MultiviewerIO.DMVMipMapsInput>;
    /**
      IP address of the secondary mipmap RTP stream
    */
    get secondary_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsInput>;
    /**
      IP address of the secondary mipmap RTP stream
    */
    get secondary_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsInput>;
    get secondary_interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.MultiviewerIO.DMVMipMapsInput>;
    get metadata(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.MultiviewerIO.DMVMipMapsInput>;
    get global_source_id(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.MultiviewerIO.DMVMipMapsInput>;
    get global_source_rl_id(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.MultiviewerIO.DMVMipMapsInput>;
}
export declare class DMVMipMapsOutput implements VScript.Referenceable<"MultiviewerIO::Data::DMVMipMapsOutput"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::DMVMipMapsOutput";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get bytes_per_second(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.MultiviewerIO.DMVMipMapsOutput>;
    /**
      IP address of the mipmap RTP stream for port 0
    */
    get port_0_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsOutput>;
    /**
      IP address of the mipmap RTP stream for port 1
    */
    get port_1_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.DMVMipMapsOutput>;
    get port_info(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.MultiviewerIO.PortInfo, VAPI.MultiviewerIO.DMVMipMapsOutput>;
}
export type DOUBLEBUFFERMODE = "ON" | "OFF" | "AUTO";
export declare class DistributedMultiviewer implements VScript.Referenceable<"MultiviewerIO::Data::DistributedMultiviewer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::DistributedMultiviewer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.MultiviewerIO.DistributedMultiviewer>;
    get internal(): VAPI.MultiviewerIO.DMVInternal;
}
export interface HSLCOLOUR {
    hue: number;
    saturation: number;
    lightness: number;
}
export declare class ManifoldCore implements VScript.Referenceable<"MultiviewerIO::Data::ManifoldCore"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::ManifoldCore";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get tile_width(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.MultiviewerIO.ManifoldCore>;
    get tile_height(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.MultiviewerIO.ManifoldCore>;
    get rasterizers_num(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.MultiviewerIO.ManifoldCore>;
    get read_grant_size(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.MultiviewerIO.ManifoldCore>;
    get write_grant_size(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.MultiviewerIO.ManifoldCore>;
    get outputs(): VScript.StronglyTypedArray<VScript.VSocket, "MultiviewerIO::Data::ManifoldCoreOutput", VAPI.MultiviewerIO.ManifoldCoreOutput>;
}
export declare class ManifoldCoreOutput implements VScript.Referenceable<"MultiviewerIO::Data::ManifoldCoreOutput"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "MultiviewerIO::Data::ManifoldCoreOutput";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get standard(): VScript.rKeyword<VScript.VSocket, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get double_buffer_mode(): VScript.rKeyword<VScript.VSocket, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get current_double_buffer_mode(): VScript.rKeyword<VScript.VSocket, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get rotation(): VScript.rKeyword<VScript.VSocket, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get streaming_enable(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get streaming_transport_format(): VScript.rKeyword<VScript.VSocket, VAPI.Video.TransportFormat, VAPI.Video.TransportFormat, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    /**
      Destination IP address of the Head stream
    */
    get streaming_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    /**
      Secondary Destination IP address of the Head stream
    */
    get streaming_secondary_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.MultiviewerIO.ManifoldCoreOutput>;
    get bgnd_colour(): VScript.rKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], VAPI.MultiviewerIO.HSLCOLOUR, VAPI.MultiviewerIO.ManifoldCoreOutput>;
}
export type MultiviewerHeadVideoStandard = "HD1080p23_98" | "HD1080p24" | "HD1080p25" | "HD1080p29_97" | "HD1080p30" | "HD1080p50" | "HD1080p59_94" | "HD1080p60" | "HD2160p50" | "HD2160p59_94" | "HD2160p60";
export type OUTPUTORIENTATION = "HORIZONTAL" | "HORIZONTAL_REVERSE" | "VERTICAL" | "VERTICAL_REVERSE";
export type OUTPUTROTATIONMODE = "NORMAL" | "COUNTERCLOCKWISE" | "CLOCKWISE";
export interface PortInfo {
    port_line_id: number;
    port_line_stream_id: number;
}
export type VideoInterface = "SD" | "HD" | "DualLink_HD" | "SingleLink_3G_A" | "SingleLink_3G_B_DL" | "SingleLink_3G_B_DS" | "DualLink_3G_B" | "DualLink_3G_C" | "QuadLink_3G_A" | "QuadLink_3G_B" | "SingleLink_12G";
export type VideoRaster = "NTSC" | "PAL" | "r720" | "r1920x1080" | "r2048x1080" | "r3840x2160" | "r4096x2160";
export declare const Enums: {
    readonly VideoRaster: VideoRaster[];
    readonly VideoInterface: VideoInterface[];
    readonly OUTPUTROTATIONMODE: OUTPUTROTATIONMODE[];
    readonly OUTPUTORIENTATION: OUTPUTORIENTATION[];
    readonly MultiviewerHeadVideoStandard: MultiviewerHeadVideoStandard[];
    readonly DOUBLEBUFFERMODE: DOUBLEBUFFERMODE[];
};
