import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    DMVInternal: (_raw) => (new DMVInternal(_raw)),
    DMVMipMaps: (_raw) => (new DMVMipMaps(_raw)),
    DMVMipMapsInput: (_raw) => (new DMVMipMapsInput(_raw)),
    DMVMipMapsOutput: (_raw) => (new DMVMipMapsOutput(_raw)),
    DistributedMultiviewer: (_raw) => (new DistributedMultiviewer(_raw)),
    HSLCOLOUR: (_raw, _socket) => {
        return {
            hue: _raw[0],
            saturation: _raw[1],
            lightness: _raw[2]
        };
    },
    ManifoldCore: (_raw) => (new ManifoldCore(_raw)),
    ManifoldCoreOutput: (_raw) => (new ManifoldCoreOutput(_raw)),
    PortInfo: (_raw, _socket) => {
        return {
            port_line_id: _raw[0],
            port_line_stream_id: _raw[1]
        };
    },
};
export const lower = {
    DMVInternal: (_x) => _x.raw.kwl,
    DMVMipMaps: (_x) => _x.raw.kwl,
    DMVMipMapsInput: (_x) => _x.raw.kwl,
    DMVMipMapsOutput: (_x) => _x.raw.kwl,
    DistributedMultiviewer: (_x) => _x.raw.kwl,
    HSLCOLOUR: (_x, _socket) => [
        _x.hue,
        _x.saturation,
        _x.lightness
    ],
    ManifoldCore: (_x) => _x.raw.kwl,
    ManifoldCoreOutput: (_x) => _x.raw.kwl,
    PortInfo: (_x, _socket) => [
        _x.port_line_id,
        _x.port_line_stream_id
    ],
};
export class DMVInternal {
    raw;
    type_identifier = "MultiviewerIO::Data::DMVInternal";
    constructor(raw) {
        this.raw = raw;
    }
    get mipmaps() {
        return VAPI.MultiviewerIO.lift.DMVMipMaps(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "mipmaps"));
    }
}
export class DMVMipMaps {
    raw;
    type_identifier = "MultiviewerIO::Data::DMVMipMaps";
    constructor(raw) {
        this.raw = raw;
    }
    get mipmaps_ins_ports() {
        return new VScript.rKeyword(this, "mipmaps_ins_ports", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get inputs() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "inputs"), (st, _) => VAPI.MultiviewerIO.lift.DMVMipMapsInput(st));
    }
    get outputs() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "outputs"), (st, _) => VAPI.MultiviewerIO.lift.DMVMipMapsOutput(st));
    }
}
export class DMVMipMapsInput {
    raw;
    type_identifier = "MultiviewerIO::Data::DMVMipMapsInput";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IP address of the mipmap RTP stream
    */
    get src_ip_address() {
        return new VScript.rKeyword(this, "src_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IP address of the mipmap RTP stream
    */
    get dest_ip_address() {
        return new VScript.rKeyword(this, "dest_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get interface() {
        return new VScript.rKeyword(this, "interface", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
    /**
      IP address of the secondary mipmap RTP stream
    */
    get secondary_src_ip_address() {
        return new VScript.rKeyword(this, "secondary_src_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IP address of the secondary mipmap RTP stream
    */
    get secondary_dest_ip_address() {
        return new VScript.rKeyword(this, "secondary_dest_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get secondary_interface() {
        return new VScript.rKeyword(this, "secondary_interface", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
    get metadata() {
        return new VScript.rKeyword(this, "metadata", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get global_source_id() {
        return new VScript.rKeyword(this, "global_source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get global_source_rl_id() {
        return new VScript.rKeyword(this, "global_source_rl_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class DMVMipMapsOutput {
    raw;
    type_identifier = "MultiviewerIO::Data::DMVMipMapsOutput";
    constructor(raw) {
        this.raw = raw;
    }
    get bytes_per_second() {
        return new VScript.rKeyword(this, "bytes_per_second", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IP address of the mipmap RTP stream for port 0
    */
    get port_0_ip_address() {
        return new VScript.rKeyword(this, "port_0_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IP address of the mipmap RTP stream for port 1
    */
    get port_1_ip_address() {
        return new VScript.rKeyword(this, "port_1_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get port_info() {
        return new VScript.rKeyword(this, "port_info", {
            lift: VAPI.MultiviewerIO.lift.PortInfo,
            lower: VAPI.MultiviewerIO.lower.PortInfo
        });
    }
}
export class DistributedMultiviewer {
    raw;
    type_identifier = "MultiviewerIO::Data::DistributedMultiviewer";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get internal() {
        return VAPI.MultiviewerIO.lift.DMVInternal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "internal"));
    }
}
export class ManifoldCore {
    raw;
    type_identifier = "MultiviewerIO::Data::ManifoldCore";
    constructor(raw) {
        this.raw = raw;
    }
    get tile_width() {
        return new VScript.rwKeyword(this, "tile_width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get tile_height() {
        return new VScript.rwKeyword(this, "tile_height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rasterizers_num() {
        return new VScript.rwKeyword(this, "rasterizers_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get read_grant_size() {
        return new VScript.rwKeyword(this, "read_grant_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get write_grant_size() {
        return new VScript.rwKeyword(this, "write_grant_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get outputs() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "outputs"), (st, _) => VAPI.MultiviewerIO.lift.ManifoldCoreOutput(st));
    }
}
export class ManifoldCoreOutput {
    raw;
    type_identifier = "MultiviewerIO::Data::ManifoldCoreOutput";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get standard() {
        return new VScript.rKeyword(this, "standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get double_buffer_mode() {
        return new VScript.rKeyword(this, "double_buffer_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get current_double_buffer_mode() {
        return new VScript.rKeyword(this, "current_double_buffer_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get rotation() {
        return new VScript.rKeyword(this, "rotation", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get streaming_enable() {
        return new VScript.rKeyword(this, "streaming_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get streaming_transport_format() {
        return new VScript.rKeyword(this, "streaming_transport_format", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Destination IP address of the Head stream
    */
    get streaming_dest_ip_address() {
        return new VScript.rKeyword(this, "streaming_dest_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Secondary Destination IP address of the Head stream
    */
    get streaming_secondary_dest_ip_address() {
        return new VScript.rKeyword(this, "streaming_secondary_dest_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get bgnd_colour() {
        return new VScript.rKeyword(this, "bgnd_colour", {
            lift: VAPI.MultiviewerIO.lift.HSLCOLOUR,
            lower: VAPI.MultiviewerIO.lower.HSLCOLOUR
        });
    }
}
export const Enums = {
    VideoRaster: ["NTSC", "PAL", "r720", "r1920x1080", "r2048x1080", "r3840x2160", "r4096x2160"],
    VideoInterface: ["SD", "HD", "DualLink_HD", "SingleLink_3G_A", "SingleLink_3G_B_DL", "SingleLink_3G_B_DS", "DualLink_3G_B", "DualLink_3G_C", "QuadLink_3G_A", "QuadLink_3G_B", "SingleLink_12G"],
    OUTPUTROTATIONMODE: ["NORMAL", "COUNTERCLOCKWISE", "CLOCKWISE"],
    OUTPUTORIENTATION: ["HORIZONTAL", "HORIZONTAL_REVERSE", "VERTICAL", "VERTICAL_REVERSE"],
    MultiviewerHeadVideoStandard: ["HD1080p23_98", "HD1080p24", "HD1080p25", "HD1080p29_97", "HD1080p30", "HD1080p50", "HD1080p59_94", "HD1080p60", "HD2160p50", "HD2160p59_94", "HD2160p60"],
    DOUBLEBUFFERMODE: ["ON", "OFF", "AUTO"]
};
