import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly FileInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PCap.FileInfo;
    readonly FileProperties: (_raw: [number | string, VAPI.PCap.TimeResolution, number, number, number, number, number, number, number], _socket: VScript.VSocket) => FileProperties;
    readonly IGMPMembership: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PCap.IGMPMembership;
    readonly MemoryRange: (_raw: [number, number, number], _socket: VScript.VSocket) => MemoryRange;
    readonly SrcDstPair: (_raw: [null | string, null | string], _socket: VScript.VSocket) => SrcDstPair;
    readonly InstancePendingDmaTransfers: (_raw: [number, number], _socket: VScript.VSocket) => InstancePendingDmaTransfers;
};
export declare const lower: {
    readonly FileInfo: (_x: FileInfo) => string;
    readonly FileProperties: (_x: {
        uploaded_at: VAPI.Primitives.Timestamp;
        time_resolution: VAPI.PCap.TimeResolution;
        packets_included: VAPI.Primitives.Unsigned64;
        packets_skipped: VAPI.Primitives.Unsigned64;
        packets_reordered: VAPI.Primitives.Unsigned64;
        intervals_shortened: VAPI.Primitives.Unsigned64;
        total_length: VScript.Duration;
        warnings_generated_during_upload: VAPI.Primitives.Unsigned64;
        last_burstgroup: VAPI.Primitives.Unsigned64;
    }, _socket: VScript.VSocket) => [number | string, VAPI.PCap.TimeResolution, number, number, number, number, number, number, number];
    readonly IGMPMembership: (_x: IGMPMembership) => string;
    readonly MemoryRange: (_x: {
        start: VAPI.PCap.MemoryAddress;
        stop: VAPI.PCap.MemoryAddress;
        fill_level: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly SrcDstPair: (_x: {
        src: null | string;
        dst: null | string;
    }, _socket: VScript.VSocket) => [null | string, null | string];
    readonly InstancePendingDmaTransfers: (_x: {
        downloads: VAPI.Primitives.Unsigned16;
        uploads: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [number, number];
};
export type DMAMode = "Download" | "Upload";
export type Delay = VScript.Duration;
export type FileFormat = "PCap" | "Raw";
export declare class FileInfo implements VScript.Referenceable<"PCap::Data::FileInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PCap::Data::FileInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get filename(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.PCap.FileInfo>;
    get properties(): VScript.rKeyword<VScript.VSocket, null | [
        number | string,
        VAPI.PCap.TimeResolution,
        number,
        number,
        number,
        number,
        number,
        number,
        number
    ], null | VAPI.PCap.FileProperties, VAPI.PCap.FileInfo>;
}
export interface FileProperties {
    uploaded_at: VAPI.Primitives.Timestamp;
    time_resolution: VAPI.PCap.TimeResolution;
    packets_included: VAPI.Primitives.Unsigned64;
    packets_skipped: VAPI.Primitives.Unsigned64;
    packets_reordered: VAPI.Primitives.Unsigned64;
    intervals_shortened: VAPI.Primitives.Unsigned64;
    total_length: VScript.Duration;
    warnings_generated_during_upload: VAPI.Primitives.Unsigned64;
    last_burstgroup: VAPI.Primitives.Unsigned64;
}
export declare class IGMPMembership implements VScript.Referenceable<"PCap::Data::IGMPMembership"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PCap::Data::IGMPMembership";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get addresses(): VScript.dKeyword<VScript.VSocket, [
        null | string,
        null | string
    ], [
        null | string,
        null | string
    ], VAPI.PCap.SrcDstPair, VAPI.PCap.SrcDstPair, VAPI.PCap.IGMPMembership>;
}
export declare class IGMPMembershipAsNamedTableRow extends IGMPMembership {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export type MemoryAddress = number;
/**
  Memory area currently holding valid pcap data
*/
export interface MemoryRange {
    start: VAPI.PCap.MemoryAddress;
    stop: VAPI.PCap.MemoryAddress;
    fill_level: number;
}
export interface SrcDstPair {
    src: null | string;
    dst: null | string;
}
export type TimeResolution = "Microseconds" | "Nanoseconds";
export interface InstancePendingDmaTransfers {
    downloads: VAPI.Primitives.Unsigned16;
    uploads: VAPI.Primitives.Unsigned16;
}
export declare const Enums: {
    readonly TimeResolution: TimeResolution[];
    readonly FileFormat: FileFormat[];
    readonly DMAMode: DMAMode[];
};
