import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    FileInfo: (_raw) => (new FileInfo(_raw)),
    FileProperties: (_raw, _socket) => {
        return {
            uploaded_at: VScript.VAPIHelpers.liftTimestamp(_raw[0], _socket),
            time_resolution: _raw[1],
            packets_included: _raw[2],
            packets_skipped: _raw[3],
            packets_reordered: _raw[4],
            intervals_shortened: _raw[5],
            total_length: VScript.VAPIHelpers.liftNanoseconds(_raw[6], _socket),
            warnings_generated_during_upload: _raw[7],
            last_burstgroup: _raw[8]
        };
    },
    IGMPMembership: (_raw) => (new IGMPMembership(_raw)),
    MemoryRange: (_raw, _socket) => {
        return {
            start: _raw[0],
            stop: _raw[1],
            fill_level: _raw[2]
        };
    },
    SrcDstPair: (_raw, _socket) => {
        return {
            src: _raw[0],
            dst: _raw[1]
        };
    },
    InstancePendingDmaTransfers: (_raw, _socket) => {
        return {
            downloads: _raw[0],
            uploads: _raw[1]
        };
    },
};
export const lower = {
    FileInfo: (_x) => _x.raw.kwl,
    FileProperties: (_x, _socket) => [
        VScript.VAPIHelpers.lowerTimestamp(_x.uploaded_at, _socket),
        _x.time_resolution,
        _x.packets_included,
        _x.packets_skipped,
        _x.packets_reordered,
        _x.intervals_shortened,
        VScript.VAPIHelpers.lowerNanoseconds(_x.total_length, _socket),
        _x.warnings_generated_during_upload,
        _x.last_burstgroup
    ],
    IGMPMembership: (_x) => _x.raw.kwl,
    MemoryRange: (_x, _socket) => [
        _x.start,
        _x.stop,
        _x.fill_level
    ],
    SrcDstPair: (_x, _socket) => [
        _x.src,
        _x.dst
    ],
    InstancePendingDmaTransfers: (_x, _socket) => [
        _x.downloads,
        _x.uploads
    ],
};
export class FileInfo {
    raw;
    type_identifier = "PCap::Data::FileInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get filename() {
        return new VScript.rKeyword(this, "filename", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get properties() {
        return new VScript.rKeyword(this, "properties", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PCap.lift.FileProperties),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PCap.lower.FileProperties)
        });
    }
}
export class IGMPMembership {
    raw;
    type_identifier = "PCap::Data::IGMPMembership";
    constructor(raw) {
        this.raw = raw;
    }
    get addresses() {
        return new VScript.dKeyword(this, "addresses", {
            lift: VAPI.PCap.lift.SrcDstPair,
            lower: VAPI.PCap.lower.SrcDstPair
        }, {
            lift: VAPI.PCap.lift.SrcDstPair,
            lower: VAPI.PCap.lower.SrcDstPair
        }, null);
    }
}
export class IGMPMembershipAsNamedTableRow extends IGMPMembership {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export const Enums = {
    TimeResolution: ["Microseconds", "Nanoseconds"],
    FileFormat: ["PCap", "Raw"],
    DMAMode: ["Download", "Upload"]
};
