import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    MicroEpoch: (_raw, _socket) => {
        return {
            epoch_index: _raw[0],
            continuity_index: _raw[1],
            reference_time: VScript.VAPIHelpers.liftTimestamp(_raw[2], _socket),
            reference_counter: _raw[3],
            fpga_drift_to_clock: _raw[4],
            best_before: _raw[5],
            g23_98: VScript.VAPIHelpers.liftSeconds(_raw[6], _socket),
            g24: VScript.VAPIHelpers.liftSeconds(_raw[7], _socket),
            g25: VScript.VAPIHelpers.liftSeconds(_raw[8], _socket),
            g29_97: VScript.VAPIHelpers.liftSeconds(_raw[9], _socket),
            g30: VScript.VAPIHelpers.liftSeconds(_raw[10], _socket),
            g50: VScript.VAPIHelpers.liftSeconds(_raw[11], _socket),
            g59_94: VScript.VAPIHelpers.liftSeconds(_raw[12], _socket),
            g60: VScript.VAPIHelpers.liftSeconds(_raw[13], _socket),
            grtp_48k: VScript.VAPIHelpers.liftSeconds(_raw[14], _socket),
            grtp_90k: VScript.VAPIHelpers.liftSeconds(_raw[15], _socket),
            grtp_27m: VScript.VAPIHelpers.liftSeconds(_raw[16], _socket),
            grtp_96k: VScript.VAPIHelpers.liftSeconds(_raw[17], _socket)
        };
    },
    MicroEpochs: (_raw, _socket) => {
        return {
            current: VAPI.PTPClock.lift.MicroEpoch(_raw[0], _socket),
            previous: VAPI.PTPClock.lift.MicroEpoch(_raw[1], _socket),
            delta_offset: _raw[2] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[2], _socket),
            delta_drift: _raw[3]
        };
    },
    AllStatisticsCounters: (_raw, _socket) => {
        return {
            missing_samples: _raw[0],
            bp_overall: _raw[1],
            bp_offset: _raw[2],
            bp_offset_errors: _raw[3],
            bp_drift: _raw[4],
            bp_drift_errors: _raw[5]
        };
    },
    AllParameters: (_raw) => (new AllParameters(_raw)),
    AllParametersPllParsCalibrated: (_raw) => (new AllParametersPllParsCalibrated(_raw)),
    AllStatistics: (_raw) => (new AllStatistics(_raw)),
};
export const lower = {
    MicroEpoch: (_x, _socket) => [
        _x.epoch_index,
        _x.continuity_index,
        VScript.VAPIHelpers.lowerTimestamp(_x.reference_time, _socket),
        _x.reference_counter,
        _x.fpga_drift_to_clock,
        _x.best_before,
        VScript.VAPIHelpers.lowerSeconds(_x.g23_98, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g24, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g25, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g29_97, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g30, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g50, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g59_94, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.g60, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.grtp_48k, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.grtp_90k, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.grtp_27m, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.grtp_96k, _socket)
    ],
    MicroEpochs: (_x, _socket) => [
        VAPI.PTPClock.lower.MicroEpoch(_x.current, _socket),
        VAPI.PTPClock.lower.MicroEpoch(_x.previous, _socket),
        _x.delta_offset === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.delta_offset, _socket),
        _x.delta_drift
    ],
    AllStatisticsCounters: (_x, _socket) => [
        _x.missing_samples,
        _x.bp_overall,
        _x.bp_offset,
        _x.bp_offset_errors,
        _x.bp_drift,
        _x.bp_drift_errors
    ],
    AllParameters: (_x) => _x.raw.kwl,
    AllParametersPllParsCalibrated: (_x) => _x.raw.kwl,
    AllStatistics: (_x) => _x.raw.kwl,
};
export class AllParameters {
    raw;
    type_identifier = "PTPClock::Data::All::Parameters";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      use this as the default UTC/TAI offset for time sources that don't supply
      this information on their own (i.e., PTP agents enslaved to a
      sufficiently well-informed Master). Following the PTP standard, this
      denotes the TAI-to-UTC offset and hence should always be positive.
    */
    get default_utc_offset_seconds() {
        return new VScript.rwKeyword(this, "default_utc_offset_seconds", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get locking_policy() {
        return new VScript.rwKeyword(this, "locking_policy", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pll_pars_calibrated() {
        return VAPI.PTPClock.lift.AllParametersPllParsCalibrated(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "pll_pars_calibrated"));
    }
    get pll_pars_uncalibrated() {
        return new VScript.rwKeyword(this, "pll_pars_uncalibrated", {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, null);
    }
    get max_rel_acceleration() {
        return new VScript.rKeyword(this, "max_rel_acceleration", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_allowed_offset() {
        return new VScript.rwKeyword(this, "max_allowed_offset", {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, null);
    }
    /**
      ignore incoming messages for this long after irregular clock adjustments
      and hard resets
    */
    get timeout_after_reset() {
        return new VScript.rwKeyword(this, "timeout_after_reset", {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, null);
    }
    get capture_threshold() {
        return new VScript.rwKeyword(this, "capture_threshold", {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, null);
    }
    get convergence_threshold() {
        return new VScript.rwKeyword(this, "convergence_threshold", {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, {
            lift: VScript.VAPIHelpers.liftSeconds,
            lower: VScript.VAPIHelpers.lowerSeconds
        }, null);
    }
    /**
      Don't perform jumps unless (i) `|input.offset.value| <
      capture_threshold`, or (ii) `|input.offset.error| <
      relative_accuracy_threshold * |input.offset.value|`. Set to exactly zero
      to disable condition (ii).
    */
    get relative_accuracy_threshold() {
        return new VScript.rwKeyword(this, "relative_accuracy_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get capture_drift_threshold() {
        return new VScript.rwKeyword(this, "capture_drift_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get convergence_drift_threshold() {
        return new VScript.rwKeyword(this, "convergence_drift_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Don't perform jumps unless (i) `|input.drift.value| <
      capture_drift_threshold`, or (ii) `|input.drift.error| <
      relative_drift_accuracy_threshold * |input.drift.value|`. Set to exactly
      zero to disable condition (ii).
    */
    get relative_drift_accuracy_threshold() {
        return new VScript.rwKeyword(this, "relative_drift_accuracy_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get promotion_threshold() {
        return new VScript.rwKeyword(this, "promotion_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get demotion_threshold() {
        return new VScript.rwKeyword(this, "demotion_threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Determines how long the PTP clock may remain uncalibrated before it
      resets itself
    */
    get calibration_timeout() {
        return new VScript.rwKeyword(this, "calibration_timeout", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    /**
      If set to `Reset`, a calibration timeout will reset the clock
      controller's internal state and all estimates currently held by PTP
      agents. If set to `ResetAggressively`, agents will be reinitialized
      completely, clearing also their currently selected best masters and any
      other transient data they may hold
    */
    get on_calibration_timeout() {
        return new VScript.rwKeyword(this, "on_calibration_timeout", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      use this to override `output.characteristics.offset_type`; may be useful
      to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
      time
    */
    get offset_type_override() {
        return new VScript.rwKeyword(this, "offset_type_override", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      after discontinuous clock changes, the PTPClock will automatically
      discard newly incoming messages for a short while to avoid locking onto
      obsolete data. In some scenarios (such as redundant analogref-derived
      master setups), it may make sense to further increase this timeout to
      higher constant values; in case of doubt, best leave this setting at its
      default value of 0ns.
    */
    get minimum_timeout_after_jump() {
        return new VScript.rwKeyword(this, "minimum_timeout_after_jump", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
}
export class AllParametersPllParsCalibrated {
    raw;
    type_identifier = "PTPClock::Data::All::Parameters::PllParsCalibrated";
    constructor(raw) {
        this.raw = raw;
    }
    get inner_corridor() {
        return new VScript.rwKeyword(this, "inner_corridor", {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, null);
    }
    get outer() {
        return new VScript.rwKeyword(this, "outer", {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, {
            lift: VAPI.Servos.lift.PLLParameters,
            lower: VAPI.Servos.lower.PLLParameters
        }, null);
    }
}
export class AllStatistics {
    raw;
    type_identifier = "PTPClock::Data::All::Statistics";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      counter values may be negative to indicate deviations beyond the holdover
      threshold
    */
    get counters() {
        return new VScript.rKeyword(this, "counters", {
            lift: VAPI.PTPClock.lift.AllStatisticsCounters,
            lower: VAPI.PTPClock.lower.AllStatisticsCounters
        });
    }
    get attempting_calibration_for() {
        return new VScript.rKeyword(this, "attempting_calibration_for", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
}
export const Enums = {
    State: ["FreeRun", "Uncalibrated", "Calibrated", "CalibratedAndLocked"],
    Mode: ["LockToInput", "UseInternalOscillator", "Disconnect"]
};
