import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly SlaveSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.SlaveSettings;
    readonly AgentSlaveStatisticsDelayRespDefects: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.AgentSlaveStatisticsDelayRespDefects;
    readonly AllGeneralSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.AllGeneralSettings;
    readonly MasterSettingsGrandmaster: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.MasterSettingsGrandmaster;
    readonly AgentSlaveStatisticsInstantaneousEstimate: (_raw: [VAPI.PTPFlows.MeasurementFamily, number | string, number | string, boolean], _socket: VScript.VSocket) => AgentSlaveStatisticsInstantaneousEstimate;
    readonly AgentMasterStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.AgentMasterStatistics;
    readonly AgentSlaveStatisticsOneWayDelay: (_raw: [number, number], _socket: VScript.VSocket) => AgentSlaveStatisticsOneWayDelay;
    readonly AgentSlaveStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.AgentSlaveStatistics;
    readonly AgentSlaveStatisticsSyncDefects: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTPFlows.AgentSlaveStatisticsSyncDefects;
};
export declare const lower: {
    readonly SlaveSettings: (_x: SlaveSettings) => string;
    readonly AgentSlaveStatisticsDelayRespDefects: (_x: AgentSlaveStatisticsDelayRespDefects) => string;
    readonly AllGeneralSettings: (_x: AllGeneralSettings) => string;
    readonly MasterSettingsGrandmaster: (_x: MasterSettingsGrandmaster) => string;
    readonly AgentSlaveStatisticsInstantaneousEstimate: (_x: {
        type: VAPI.PTPFlows.MeasurementFamily;
        slave_time: VAPI.Primitives.Timestamp;
        master_time: VAPI.Primitives.Timestamp;
        accepted: boolean;
    }, _socket: VScript.VSocket) => [VAPI.PTPFlows.MeasurementFamily, number | string, number | string, boolean];
    readonly AgentMasterStatistics: (_x: AgentMasterStatistics) => string;
    readonly AgentSlaveStatisticsOneWayDelay: (_x: {
        mean: VScript.Duration;
        error: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
    readonly AgentSlaveStatistics: (_x: AgentSlaveStatistics) => string;
    readonly AgentSlaveStatisticsSyncDefects: (_x: AgentSlaveStatisticsSyncDefects) => string;
};
export type DiffServCodePoint = number;
export type Log2Interval = number;
export type MeasurementFamily = "SyncFollowUp" | "DelayRespReq";
export type MessageClass = "Event" | "General";
export type MessageType = "Sync" | "Delay_Req" | "Pdelay_Req" | "Pdelay_Resp" | "Follow_Up" | "Delay_Resp" | "Pdelay_Resp_Follow_Up" | "Announce" | "Signaling" | "Management" | "Invalid";
export type Nibble = number;
export type QualityAssessment = "Convergent" | "Normal" | "Divergent" | "None";
export type Routing = "Unicast" | "Multicast";
export type SequenceNumber = VAPI.Primitives.Unsigned16;
export declare class SlaveSettings implements VScript.Referenceable<"PTPFlows::Data::SlaveSettings"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::SlaveSettings";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      base-2 logarithm of the delay request interval in seconds. E.g., a
      setting of -3 will cause this agent to emit delay requests 8 times a
      second; 4 times a second if this is set to -2. Delay request intervals
      may not be shorter than the minimum delay request interval set by the
      currently active master.
    */
    get log2_delayreq_interval(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.Log2Interval, VAPI.PTPFlows.Log2Interval, VAPI.PTPFlows.SlaveSettings>;
    get log2_master_sync_interval(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.PTPFlows.SlaveSettings>;
    /**
      minimum delay request interval as set by the most recently received delay
      response message
    */
    get relative_min_log2_delayreq_interval(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.PTPFlows.SlaveSettings>;
    /**
      unlike sync and follow-up messages, which contain no client-dependent
      information and are thus useful to all clients within their PTP domain,
      delay request/response messages are useful only to the inquiring client
      (and perhaps to the master if it wishes to monitor its clients' timing
      properties). Exchanging these messages via unicast reduces both network
      traffic and local workload but yields otherwise identical results (this
      mode may also be called `Hybrid` on other products). If
      `delay_req_routing` is set to `Multicast`, this optimization is disabled
      and all delay requests emitted by this agent will be sent to the PTP
      multicast event address `224.0.1.129:319`
    */
    get delay_req_routing(): VScript.dKeyword<VScript.VSocket, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.SlaveSettings>;
}
export type Version = VAPI.PTPFlows.Nibble;
/**
  if `best_master_selection` is set to `Eager`, an incoming Announce message
  will immediately register its sender as the currently accepted PTP master
  if all previously registered masters are deemed inferior by the BMC
  algorithm. Conversely, if `Cautious` is selected, and if the PTPClock is
  currently calibrated, a previously selected PTP master will be retained
  until it times out
*/
export type AllGeneralSettingsBestMasterSelection = "Eager" | "Cautious";
export type MasterSettingsDelayDecimationFactor = number;
export declare class AgentSlaveStatisticsDelayRespDefects implements VScript.Referenceable<"PTPFlows::Data::Agent::SlaveStatistics::DelayRespDefects"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::Agent::SlaveStatistics::DelayRespDefects";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      number of delay request/response message pairs that were discarded
      because they were too far off the mark compared to current estimates
    */
    get num_outliers(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatisticsDelayRespDefects>;
    /**
      number of delay request/response message pairs that were discarded
      because their `requesting_port_identity` did not agree with the agent's
      own port identity
    */
    get num_wrong_requesting_port_identity(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatisticsDelayRespDefects>;
    /**
      number of delay request/response message pairs that were discarded
      because their `source_port_identity` did not agree with the master's port
      identity
    */
    get num_wrong_source_port_identity(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatisticsDelayRespDefects>;
}
export declare class AllGeneralSettings implements VScript.Referenceable<"PTPFlows::Data::All::GeneralSettings"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::All::GeneralSettings";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      remove visible masters if the time elapsed since their last Announce
      message exceeds `master_timeout`
    */
    get master_timeout(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.PTPFlows.AllGeneralSettings>;
    /**
      if `best_master_selection` is set to `Eager`, an incoming Announce
      message will immediately register its sender as the currently accepted
      PTP master if all previously registered masters are deemed inferior by
      the BMC algorithm. Conversely, if `Cautious` is selected, and if the
      PTPClock is currently calibrated, a previously selected PTP master will
      be retained until it times out
    */
    get best_master_selection(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPFlows.AllGeneralSettingsBestMasterSelection, VAPI.PTPFlows.AllGeneralSettingsBestMasterSelection, VAPI.PTPFlows.AllGeneralSettingsBestMasterSelection, VAPI.PTPFlows.AllGeneralSettingsBestMasterSelection, VAPI.PTPFlows.AllGeneralSettings>;
    /**
      offload DelayResponse generation to hardware if supported by the
      currently active FPGA build
    */
    get hardware_offload(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.PTPFlows.AllGeneralSettings>;
    /**
      if DelayResponse hardware offloading is available, delay requests will by
      default not be forwarded to the CPU. If you wish to do so to, e.g.,
      analyze incoming traffic using `tcpdump`, set this option to `false`
    */
    get absorb_delayrequests(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.PTPFlows.AllGeneralSettings>;
}
export declare class MasterSettingsGrandmaster implements VScript.Referenceable<"PTPFlows::Data::MasterSettings::Grandmaster"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::MasterSettings::Grandmaster";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      this value will be used as `priority_1` if this agent is set to act as a
      PTP master
    */
    get priority_1(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.Unsigned8, null | VAPI.Primitives.Unsigned8, VAPI.PTPFlows.MasterSettingsGrandmaster>;
    /**
      this value will be used as `priority_2` if this agent is set to act as a
      PTP master
    */
    get priority_2(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.Unsigned8, null | VAPI.Primitives.Unsigned8, VAPI.PTPFlows.MasterSettingsGrandmaster>;
    /**
      this value will be used as `clock_quality` if this agent is set to act as
      a PTP master
    */
    get clock_quality(): VScript.dKeyword<VScript.VSocket, null | [
        VAPI.PTP.ClockClass,
        VAPI.PTP.ClockAccuracy,
        number
    ], null | [
        VAPI.PTP.ClockClass,
        VAPI.PTP.ClockAccuracy,
        number
    ], null | VAPI.PTP.ClockQuality, null | VAPI.PTP.ClockQuality, VAPI.PTPFlows.MasterSettingsGrandmaster>;
    /**
      ClockIdentity as defined by the PTP standard, stored in big-endian order.
    */
    get clock_identity(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.PTP.ClockIdentity, VAPI.PTPFlows.MasterSettingsGrandmaster>;
}
export interface AgentSlaveStatisticsInstantaneousEstimate {
    type: VAPI.PTPFlows.MeasurementFamily;
    slave_time: VAPI.Primitives.Timestamp;
    master_time: VAPI.Primitives.Timestamp;
    accepted: boolean;
}
export type AgentIssues = {
    no_delays: boolean;
    no_syncs: boolean;
};
/**
  base-2 logarithm of the announce interval in seconds. E.g., a setting of -2
  will cause this agent to emit announce messages 4 times a second; 2 times a
  second if this is set to -1.
*/
export type MasterSettingsLog2AnnounceInterval = number;
/**
  base-2 logarithm of the sync interval in seconds. E.g., a setting of -3
  will cause this agent to emit sync and followup messages 8 times a second;
  4 times a second if this is set to -2.
*/
export type MasterSettingsLog2SyncInterval = number;
export declare class AgentMasterStatistics implements VScript.Referenceable<"PTPFlows::Data::Agent::MasterStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::Agent::MasterStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get num_announces_sent(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentMasterStatistics>;
    get num_syncs_sent(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentMasterStatistics>;
    get num_followups_sent(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentMasterStatistics>;
    get num_delayreqs_received(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentMasterStatistics>;
    get num_delayresps_sent(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentMasterStatistics>;
}
export type AgentMode = "SlaveOnly" | "MasterSlave" | "MasterOnly";
export interface AgentSlaveStatisticsOneWayDelay {
    mean: VScript.Duration;
    error: VScript.Duration;
}
export declare class AgentSlaveStatistics implements VScript.Referenceable<"PTPFlows::Data::Agent::SlaveStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::Agent::SlaveStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get num_syncs_received(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    get num_followups_received(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    /**
      number of measurements performed on the basis of incoming sync/followup
      messages. May be smaller than the number of received sync messages due
      to, e.g., missing followup messages
    */
    get num_sync_measurements(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    /**
      number of delay request messages handed off to the operating system. The
      actual number of transmitted messages may be lower in case of network
      configuration issues; check `num_delay_measurements` if you suspect this
      to be the case
    */
    get num_delayreqs_sent(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    get num_delayresps_received(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    /**
      number of delay response messages considered for further processing. May
      be smaller than the number of received delay response messages due to,
      e.g., mismatching requesting source port identities (especially when
      operating in multicast routing mode)
    */
    get num_delayresps_considered(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    /**
      number of delay response messages that were considered for processing,
      but later discarded for other reasons
    */
    get num_delayresps_discarded(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    /**
      number of measurements performed on the basis of delay request/response
      messages. May be both smaller than the number of dispatched delay request
      messages (perhaps due to network configuration issues), and smaller than
      the number of received delay response messages (especially when operating
      in multicast routing mode, where most incoming delay response messages
      are typically intended for other PTP clients)
    */
    get num_delay_measurements(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatistics>;
    get sync_defects(): VAPI.PTPFlows.AgentSlaveStatisticsSyncDefects;
    get delay_resp_defects(): VAPI.PTPFlows.AgentSlaveStatisticsDelayRespDefects;
    get one_way_delay(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.PTPFlows.AgentSlaveStatisticsOneWayDelay, VAPI.PTPFlows.AgentSlaveStatistics>;
    get estimated_jitter(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.PTPFlows.AgentSlaveStatistics>;
    get publish_instantaneous_estimates(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.PTPFlows.AgentSlaveStatistics>;
    get instantaneous_estimate(): VScript.rKeyword<VScript.VSocket, null | [
        VAPI.PTPFlows.MeasurementFamily,
        number | string,
        number | string,
        boolean
    ], null | VAPI.PTPFlows.AgentSlaveStatisticsInstantaneousEstimate, VAPI.PTPFlows.AgentSlaveStatistics>;
}
export type AgentState = "Inactive" | "Listening" | "Passive" | "Slave" | "Master";
export declare class AgentSlaveStatisticsSyncDefects implements VScript.Referenceable<"PTPFlows::Data::Agent::SlaveStatistics::SyncDefects"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTPFlows::Data::Agent::SlaveStatistics::SyncDefects";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      number of sync messages (if one-step) or sync/follow-up message pairs
      that were discarded because they were too far off the mark compared to
      current estimates
    */
    get num_outliers(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatisticsSyncDefects>;
    /**
      number of sync messages (if one-step) or sync/follow-up message pairs
      that were discarded because their `source_port_identity` did not agree
      with the master's port identity
    */
    get num_wrong_source_port_identity(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.PTPFlows.AgentSlaveStatisticsSyncDefects>;
}
export declare const Enums: {
    readonly Routing: Routing[];
    readonly QualityAssessment: QualityAssessment[];
    readonly MessageType: MessageType[];
    readonly MessageClass: MessageClass[];
    readonly MeasurementFamily: MeasurementFamily[];
};
