import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AudioConfigurationContainer: (_raw) => (new AudioConfigurationContainer(_raw)),
    AudioConfigurationFormat: (_raw, _socket) => {
        return {
            num_channels: _raw[0],
            format: _raw[1],
            packet_time: _raw[2]
        };
    },
    AudioGroupControl: (_raw) => (new AudioGroupControl(_raw)),
    AudioGroupControlStatus: (_raw) => (new AudioGroupControlStatus(_raw)),
    JpegXSCompressionBandwidth: (_raw, _socket) => {
        return {
            max_data_rate: _raw[0]
        };
    },
    Constraints: (_raw) => (new Constraints(_raw)),
    HeaderSettings: (_raw, _socket) => {
        return {
            payload_type: _raw[0],
            class_of_service: _raw[1],
            traffic_class: _raw[2],
            ssrc: _raw[3],
            ttl: _raw[4]
        };
    },
    IpConfig: (_raw) => (new IpConfig(_raw)),
    IpConfigInterfaces: (_raw) => (new IpConfigInterfaces(_raw)),
    IpConfigMipMap: (_raw) => (new IpConfigMipMap(_raw)),
    IpSDPConfigInterfaces: (_raw) => (new IpSDPConfigInterfaces(_raw)),
    JpegXSCompression: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Bandwidth", value: VAPI.RTPTransmitter.lift.JpegXSCompressionBandwidth(_raw[1], _socket) };
            case 1: return { variant: "Ratio", value: VAPI.RTPTransmitter.lift.JpegXSCompressionRatio(_raw[1], _socket) };
        }
        ;
    },
    JpegXsSettings: (_raw, _socket) => {
        return {
            compression: VAPI.RTPTransmitter.lift.JpegXSCompression(_raw[0], _socket),
            lvl_weight_mode: _raw[1],
            add_st2110_40: _raw[2],
            omit_mandatory_pre_header: _raw[3]
        };
    },
    MipMapEncoder: (_raw) => (new MipMapEncoder(_raw)),
    MuxStatistics: (_raw) => (new MuxStatistics(_raw)),
    JpegXSCompressionRatio: (_raw, _socket) => {
        return {
            ratio: _raw[0]
        };
    },
    RouterError: (_raw) => (new RouterError(_raw)),
    SSRCStatus: (_raw, _socket) => {
        return {
            ssrc: _raw[0],
            ssrc_counter: _raw[1]
        };
    },
    ST20226Settings: (_raw, _socket) => {
        return {};
    },
    ST2042Settings: (_raw, _socket) => {
        return {
            compression: _raw[0],
            add_st2110_40: _raw[1]
        };
    },
    SourceAddressVlan: (_raw, _socket) => {
        return {
            vlan_id: _raw[0],
            src_address: _raw[1]
        };
    },
    Tagging: (_raw, _socket) => {
        return {
            tagging_hw_value: _raw[0],
            tagging_decipher: VAPI.RTPTransmitter.lift.TaggingDecipher(_raw[1], _socket)
        };
    },
    TaggingDecipher: (_raw, _socket) => {
        return {
            vlan_id: _raw[0],
            class_of_service: _raw[1]
        };
    },
    IpConfigMipMapActiveStreamParameter: (_raw, _socket) => {
        return {
            src_address: _raw[0],
            dst_address: _raw[1],
            lane_id: _raw[2],
            stream_id: _raw[3],
            vlan_id: _raw[4]
        };
    },
    RouterErrorErrorInput: (_raw, _socket) => {
        return {
            max_fifo_level: _raw[0],
            max_fifo_level_last_read: _raw[1],
            overflow: _raw[2],
            error_irq_counter: _raw[3]
        };
    },
    RouterErrorErrorOutput: (_raw, _socket) => {
        return {
            max_fifo_level: _raw[0],
            max_fifo_level_last_read: _raw[1],
            overflow: _raw[2]
        };
    },
    IpConfigHeaderInfo: (_raw) => (new IpConfigHeaderInfo(_raw)),
    SessionInterfaces: (_raw, _socket) => {
        return {
            primary: _raw[0] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
            secondary: _raw[1] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
        };
    },
    MediaStreamerIpConfiguration: (_raw) => (new MediaStreamerIpConfiguration(_raw)),
    MediaStreamerVideoIpConfiguration: (_raw) => (new MediaStreamerVideoIpConfiguration(_raw)),
    MipMapStreamerIpConfiguration: (_raw) => (new MipMapStreamerIpConfiguration(_raw)),
    JpegXsHardware: (_raw, _socket) => {
        return {
            width: _raw[0],
            height: _raw[1],
            mode: _raw[2],
            budget_per_frame: _raw[3],
            vld: _raw[4],
            number_of_images: _raw[5],
            video_depth: _raw[6],
            play_mode: _raw[7],
            level_weights: _raw[8],
            profile: _raw[9]
        };
    },
    AllLicenseInformation: (_raw) => (new AllLicenseInformation(_raw)),
    MipMapStreamerIpConfigurationMedia: (_raw) => (new MipMapStreamerIpConfigurationMedia(_raw)),
    AllSettingsOnIncompleteConfiguration: (_raw, _socket) => {
        return {
            refuse_activation: _raw[0],
            reserve_resources: _raw[1]
        };
    },
    MuxStatisticsPort0: (_raw, _socket) => {
        return {
            words: _raw[0],
            packets: _raw[1]
        };
    },
    MuxStatisticsPort1: (_raw, _socket) => {
        return {
            words: _raw[0],
            packets: _raw[1]
        };
    },
    MuxStatisticsScheduler: (_raw, _socket) => {
        return {
            packets: _raw[0]
        };
    },
    AllSettings: (_raw) => (new AllSettings(_raw)),
};
export const lower = {
    AudioConfigurationContainer: (_x) => _x.raw.kwl,
    AudioConfigurationFormat: (_x, _socket) => [
        _x.num_channels,
        _x.format,
        _x.packet_time
    ],
    AudioGroupControl: (_x) => _x.raw.kwl,
    AudioGroupControlStatus: (_x) => _x.raw.kwl,
    JpegXSCompressionBandwidth: (_x, _socket) => [
        _x.max_data_rate
    ],
    Constraints: (_x) => _x.raw.kwl,
    HeaderSettings: (_x, _socket) => [
        _x.payload_type,
        _x.class_of_service,
        _x.traffic_class,
        _x.ssrc,
        _x.ttl
    ],
    IpConfig: (_x) => _x.raw.kwl,
    IpConfigInterfaces: (_x) => _x.raw.kwl,
    IpConfigMipMap: (_x) => _x.raw.kwl,
    IpSDPConfigInterfaces: (_x) => _x.raw.kwl,
    JpegXSCompression: (_x, _socket) => {
        switch (_x.variant) {
            case "Bandwidth": return [0, VAPI.RTPTransmitter.lower.JpegXSCompressionBandwidth(_x.value, _socket)];
            case "Ratio": return [1, VAPI.RTPTransmitter.lower.JpegXSCompressionRatio(_x.value, _socket)];
        }
    },
    JpegXsSettings: (_x, _socket) => [
        VAPI.RTPTransmitter.lower.JpegXSCompression(_x.compression, _socket),
        _x.lvl_weight_mode,
        _x.add_st2110_40,
        _x.omit_mandatory_pre_header
    ],
    MipMapEncoder: (_x) => _x.raw.kwl,
    MuxStatistics: (_x) => _x.raw.kwl,
    JpegXSCompressionRatio: (_x, _socket) => [
        _x.ratio
    ],
    RouterError: (_x) => _x.raw.kwl,
    SSRCStatus: (_x, _socket) => [
        _x.ssrc,
        _x.ssrc_counter
    ],
    ST20226Settings: (_x, _socket) => [],
    ST2042Settings: (_x, _socket) => [
        _x.compression,
        _x.add_st2110_40
    ],
    SourceAddressVlan: (_x, _socket) => [
        _x.vlan_id,
        _x.src_address
    ],
    Tagging: (_x, _socket) => [
        _x.tagging_hw_value,
        VAPI.RTPTransmitter.lower.TaggingDecipher(_x.tagging_decipher, _socket)
    ],
    TaggingDecipher: (_x, _socket) => [
        _x.vlan_id,
        _x.class_of_service
    ],
    IpConfigMipMapActiveStreamParameter: (_x, _socket) => [
        _x.src_address,
        _x.dst_address,
        _x.lane_id,
        _x.stream_id,
        _x.vlan_id
    ],
    RouterErrorErrorInput: (_x, _socket) => [
        _x.max_fifo_level,
        _x.max_fifo_level_last_read,
        _x.overflow,
        _x.error_irq_counter
    ],
    RouterErrorErrorOutput: (_x, _socket) => [
        _x.max_fifo_level,
        _x.max_fifo_level_last_read,
        _x.overflow
    ],
    IpConfigHeaderInfo: (_x) => _x.raw.kwl,
    SessionInterfaces: (_x, _socket) => [
        _x.primary === null ? null : _x.primary.raw.kwl,
        _x.secondary === null ? null : _x.secondary.raw.kwl
    ],
    MediaStreamerIpConfiguration: (_x) => _x.raw.kwl,
    MediaStreamerVideoIpConfiguration: (_x) => _x.raw.kwl,
    MipMapStreamerIpConfiguration: (_x) => _x.raw.kwl,
    JpegXsHardware: (_x, _socket) => [
        _x.width,
        _x.height,
        _x.mode,
        _x.budget_per_frame,
        _x.vld,
        _x.number_of_images,
        _x.video_depth,
        _x.play_mode,
        _x.level_weights,
        _x.profile
    ],
    AllLicenseInformation: (_x) => _x.raw.kwl,
    MipMapStreamerIpConfigurationMedia: (_x) => _x.raw.kwl,
    AllSettingsOnIncompleteConfiguration: (_x, _socket) => [
        _x.refuse_activation,
        _x.reserve_resources
    ],
    MuxStatisticsPort0: (_x, _socket) => [
        _x.words,
        _x.packets
    ],
    MuxStatisticsPort1: (_x, _socket) => [
        _x.words,
        _x.packets
    ],
    MuxStatisticsScheduler: (_x, _socket) => [
        _x.packets
    ],
    AllSettings: (_x) => _x.raw.kwl,
};
export class AudioConfigurationContainer {
    raw;
    type_identifier = "RTPTransmitter::Data::AudioConfigurationContainer";
    constructor(raw) {
        this.raw = raw;
    }
    get transport_format() {
        return new VScript.dKeyword(this, "transport_format", {
            lift: VAPI.RTPTransmitter.lift.AudioConfigurationFormat,
            lower: VAPI.RTPTransmitter.lower.AudioConfigurationFormat
        }, {
            lift: VAPI.RTPTransmitter.lift.AudioConfigurationFormat,
            lower: VAPI.RTPTransmitter.lower.AudioConfigurationFormat
        }, null);
    }
}
export class AudioGroupControl {
    raw;
    type_identifier = "RTPTransmitter::Data::AudioGroupControl";
    constructor(raw) {
        this.raw = raw;
    }
    get remapping() {
        return new VScript.rKeyword(this, "remapping", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get enabled_output_0() {
        return new VScript.rKeyword(this, "enabled_output_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get enabled_output_1() {
        return new VScript.rKeyword(this, "enabled_output_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get used_groups() {
        return new VScript.rKeyword(this, "used_groups", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class AudioGroupControlStatus {
    raw;
    type_identifier = "RTPTransmitter::Data::AudioGroupControlStatus";
    constructor(raw) {
        this.raw = raw;
    }
    get primary() {
        return new VScript.rKeyword(this, "primary", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get secondary() {
        return new VScript.rKeyword(this, "secondary", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Constraints {
    raw;
    type_identifier = "RTPTransmitter::Data::Constraints";
    constructor(raw) {
        this.raw = raw;
    }
    get calculation_standard() {
        return new VScript.rKeyword(this, "calculation_standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get latched_standard() {
        return new VScript.rKeyword(this, "latched_standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get current_send_standard() {
        return new VScript.rKeyword(this, "current_send_standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get latched_pixel_format() {
        return new VScript.rKeyword(this, "latched_pixel_format", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.PixelFormat),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.PixelFormat)
        });
    }
    get standard() {
        return new VScript.dKeyword(this, "standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get sub_stream() {
        return new VScript.rKeyword(this, "sub_stream", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_bandwidth() {
        return new VScript.dKeyword(this, "max_bandwidth", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class IpConfig {
    raw;
    type_identifier = "RTPTransmitter::Data::IpConfig";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp_a() {
        return new VScript.rKeyword(this, "sdp_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get preserve_src_ip_entry() {
        return new VScript.rwKeyword(this, "preserve_src_ip_entry", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get src_address_vlan() {
        return new VScript.dKeyword(this, "src_address_vlan", {
            lift: VAPI.RTPTransmitter.lift.SourceAddressVlan,
            lower: VAPI.RTPTransmitter.lower.SourceAddressVlan
        }, {
            lift: VAPI.RTPTransmitter.lift.SourceAddressVlan,
            lower: VAPI.RTPTransmitter.lower.SourceAddressVlan
        }, null);
    }
    /**
      IP (multicast) destination address of the RTP stream
    */
    get dst_address() {
        return new VScript.dKeyword(this, "dst_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => VScript.addrs_equal_up_to_port({ command, status }) }));
    }
    get header_settings() {
        return new VScript.dKeyword(this, "header_settings", {
            lift: VAPI.RTPTransmitter.lift.HeaderSettings,
            lower: VAPI.RTPTransmitter.lower.HeaderSettings
        }, {
            lift: VAPI.RTPTransmitter.lift.HeaderSettings,
            lower: VAPI.RTPTransmitter.lower.HeaderSettings
        }, null);
    }
    get header_info() {
        return VAPI.RTPTransmitter.lift.IpConfigHeaderInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "header_info"));
    }
}
export class IpConfigInterfaces {
    raw;
    type_identifier = "RTPTransmitter::Data::IpConfigInterfaces";
    constructor(raw) {
        this.raw = raw;
    }
    get primary() {
        return VAPI.RTPTransmitter.lift.IpConfig(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
    }
    get secondary() {
        return VAPI.RTPTransmitter.lift.IpConfig(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
    }
}
export class IpConfigMipMap {
    raw;
    type_identifier = "RTPTransmitter::Data::IpConfigMipMap";
    constructor(raw) {
        this.raw = raw;
    }
    get active_stream_parameter() {
        return new VScript.rKeyword(this, "active_stream_parameter", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lift.IpConfigMipMapActiveStreamParameter),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lower.IpConfigMipMapActiveStreamParameter)
        });
    }
}
export class IpSDPConfigInterfaces {
    raw;
    type_identifier = "RTPTransmitter::Data::IpSDPConfigInterfaces";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp_a() {
        return new VScript.rKeyword(this, "sdp_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get primary() {
        return VAPI.RTPTransmitter.lift.IpConfig(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "primary"));
    }
    get secondary() {
        return VAPI.RTPTransmitter.lift.IpConfig(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "secondary"));
    }
}
export class MipMapEncoder {
    raw;
    type_identifier = "RTPTransmitter::Data::MipMapEncoder";
    constructor(raw) {
        this.raw = raw;
    }
    get allocated_blocks() {
        return new VScript.rKeyword(this, "allocated_blocks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get block_addr() {
        return new VScript.rKeyword(this, "block_addr", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class MuxStatistics {
    raw;
    type_identifier = "RTPTransmitter::Data::MuxStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get port0() {
        return new VScript.rKeyword(this, "port0", {
            lift: VAPI.RTPTransmitter.lift.MuxStatisticsPort0,
            lower: VAPI.RTPTransmitter.lower.MuxStatisticsPort0
        });
    }
    get port1() {
        return new VScript.rKeyword(this, "port1", {
            lift: VAPI.RTPTransmitter.lift.MuxStatisticsPort1,
            lower: VAPI.RTPTransmitter.lower.MuxStatisticsPort1
        });
    }
    get scheduler() {
        return new VScript.rKeyword(this, "scheduler", {
            lift: VAPI.RTPTransmitter.lift.MuxStatisticsScheduler,
            lower: VAPI.RTPTransmitter.lower.MuxStatisticsScheduler
        });
    }
}
export class RouterError {
    raw;
    type_identifier = "RTPTransmitter::Data::RouterError";
    constructor(raw) {
        this.raw = raw;
    }
    get error_input() {
        return new VScript.rKeyword(this, "error_input", {
            lift: VAPI.RTPTransmitter.lift.RouterErrorErrorInput,
            lower: VAPI.RTPTransmitter.lower.RouterErrorErrorInput
        });
    }
    get error_output() {
        return new VScript.rKeyword(this, "error_output", {
            lift: VAPI.RTPTransmitter.lift.RouterErrorErrorOutput,
            lower: VAPI.RTPTransmitter.lower.RouterErrorErrorOutput
        });
    }
}
export class IpConfigHeaderInfo {
    raw;
    type_identifier = "RTPTransmitter::Data::IpConfig::HeaderInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get tagging() {
        return new VScript.rKeyword(this, "tagging", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lift.Tagging),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lower.Tagging)
        });
    }
    get ssrc_info() {
        return new VScript.rKeyword(this, "ssrc_info", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lift.SSRCStatus),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPTransmitter.lower.SSRCStatus)
        });
    }
    /**
      MAC address, stored in big-endian order.
    */
    get unicast_dst_mac_address() {
        return new VScript.rKeyword(this, "unicast_dst_mac_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class MediaStreamerIpConfiguration {
    raw;
    type_identifier = "RTPTransmitter::Data::MediaStreamer::IpConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp_a() {
        return new VScript.rKeyword(this, "sdp_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get media() {
        return VAPI.RTPTransmitter.lift.IpConfigInterfaces(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media"));
    }
}
export class MediaStreamerVideoIpConfiguration {
    raw;
    type_identifier = "RTPTransmitter::Data::MediaStreamerVideo::IpConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp_a() {
        return new VScript.rKeyword(this, "sdp_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video() {
        return VAPI.RTPTransmitter.lift.IpSDPConfigInterfaces(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
    }
    get meta() {
        return VAPI.RTPTransmitter.lift.IpSDPConfigInterfaces(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "meta"));
    }
}
export class MipMapStreamerIpConfiguration {
    raw;
    type_identifier = "RTPTransmitter::Data::MipMapStreamer::IpConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get media() {
        return VAPI.RTPTransmitter.lift.MipMapStreamerIpConfigurationMedia(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "media"));
    }
}
export class AllLicenseInformation {
    raw;
    type_identifier = "RTPTransmitter::Data::All::LicenseInformation";
    constructor(raw) {
        this.raw = raw;
    }
    get num_jpeg_xs_transmitters() {
        return new VScript.rKeyword(this, "num_jpeg_xs_transmitters", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class MipMapStreamerIpConfigurationMedia {
    raw;
    type_identifier = "RTPTransmitter::Data::MipMapStreamer::IpConfiguration::Media";
    constructor(raw) {
        this.raw = raw;
    }
    get primary() {
        return VAPI.RTPTransmitter.lift.IpConfigMipMap(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
    }
    get secondary() {
        return VAPI.RTPTransmitter.lift.IpConfigMipMap(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
    }
}
export class AllSettings {
    raw;
    type_identifier = "RTPTransmitter::Data::All::Settings";
    constructor(raw) {
        this.raw = raw;
    }
    get on_incomplete_configuration() {
        return new VScript.rwKeyword(this, "on_incomplete_configuration", {
            lift: VAPI.RTPTransmitter.lift.AllSettingsOnIncompleteConfiguration,
            lower: VAPI.RTPTransmitter.lower.AllSettingsOnIncompleteConfiguration
        }, {
            lift: VAPI.RTPTransmitter.lift.AllSettingsOnIncompleteConfiguration,
            lower: VAPI.RTPTransmitter.lower.AllSettingsOnIncompleteConfiguration
        }, null);
    }
    /**
      reserves a desired bandwidth from the maximum possible throughput of the
      port to be used for inband control
    */
    get reserved_bandwidth() {
        return new VScript.rwKeyword(this, "reserved_bandwidth", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get check_ip_address_timeout() {
        return new VScript.rwKeyword(this, "check_ip_address_timeout", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
}
export const Enums = {
    VideoDepth: ["depths_8", "depths_10", "depths_12"],
    ValidateMode: ["validate_start", "validate_stop"],
    TrafficClassOrQos: ["assured_forwarding_default", "assured_forwarding_11", "assured_forwarding_12", "assured_forwarding_13", "assured_forwarding_21", "assured_forwarding_22", "assured_forwarding_23", "assured_forwarding_31", "assured_forwarding_32", "assured_forwarding_33", "assured_forwarding_41", "assured_forwarding_42", "assured_forwarding_43", "assured_forwarding_ef"],
    StripMining: ["ReduceToMinimum", "HoldInBackhand"],
    SPSMode: ["possible", "in_use", "is_optimized"],
    ReduceMaxThroughput: ["doNotReduce", "ReduceBy_1Percent", "ReduceBy_2Percent", "ReduceBy_3Percent", "ReduceBy_4Percent", "ReduceBy_5Percent", "ReduceBy_6Percent", "ReduceBy_7Percent", "ReduceBy_8Percent", "ReduceBy_9Percent", "ReduceBy_10Percent"],
    PackingMode: ["GPM", "BPM"],
    OnConfiguration: ["RefuseActivation", "AllowActivation"],
    LVLMODE: ["peak_signal_noise_ratio", "visual_optimization"],
    ColorSampleMode: ["GB_444", "YCbCr_422", "YCbCr_420", "YCbCr_444"],
    ClassOfService: ["best_effort", "medium_priority", "high_priority", "voice_call_signaling", "video", "voice"],
    ActivationControl: ["Off", "Off_preserve_resource", "On"]
};
