import * as VScript from "vscript";
export const lift = {
    PAIRCOM: (_raw) => (new PAIRCOM(_raw)),
    READSTATUS: (_raw) => (new READSTATUS(_raw)),
};
export const lower = {
    PAIRCOM: (_x) => _x.raw.kwl,
    READSTATUS: (_x) => _x.raw.kwl,
};
export class PAIRCOM {
    raw;
    type_identifier = "SampleRateConverter::Data::PAIRCOM";
    constructor(raw) {
        this.raw = raw;
    }
    get hw_value() {
        return new VScript.rKeyword(this, "hw_value", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get enable() {
        return new VScript.rKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get channels() {
        return new VScript.rKeyword(this, "channels", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class READSTATUS {
    raw;
    type_identifier = "SampleRateConverter::Data::READSTATUS";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      accumulated number of µ sync errors, checked once per second
    */
    get mu_sync_error() {
        return new VScript.rKeyword(this, "mu_sync_error", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      accumulated number of input errors (unstable input clock), checked once
      per second
    */
    get input_error() {
        return new VScript.rKeyword(this, "input_error", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      accumulated number of SRC reference clock errors (unstable genlock),
      checked once per second
    */
    get ref_ready() {
        return new VScript.rKeyword(this, "ref_ready", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Clear
    */
    get clear_statistic() {
        return new VScript.wKeyword(this, "clear_statistic", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
