import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ServiceResourceUsage: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ServicesList.ServiceResourceUsage;
    readonly ServicesList: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ServicesList.ServicesList;
};
export declare const lower: {
    readonly ServiceResourceUsage: (_x: ServiceResourceUsage) => string;
    readonly ServicesList: (_x: ServicesList) => string;
};
export declare class ServiceResourceUsage implements VScript.Referenceable<"ServicesList::Data::ServiceResourceUsage"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ServicesList::Data::ServiceResourceUsage";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      CPU usage in percent
    */
    get cpu_usage(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.ServicesList.ServiceResourceUsage>;
    /**
      Memory usage in bytes
    */
    get memory_usage(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned64, VAPI.ServicesList.ServiceResourceUsage>;
}
export declare class ServicesList implements VScript.Referenceable<"ServicesList::Data::ServicesList"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ServicesList::Data::ServicesList";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get vm_genlock(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_i2cserver(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_j2kdecoder(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_matrix(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_metaproc(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_multiviewer(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_neighborhood_watch(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_networkmgr(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_ptp(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_rtpreceiver(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_securitymgr(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_server(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_system(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_timeflows(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_udx(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_uploadmgr(): VAPI.ServicesList.ServiceResourceUsage;
    get vm_webserver(): VAPI.ServicesList.ServiceResourceUsage;
    get snmpd(): VAPI.ServicesList.ServiceResourceUsage;
    get rsyslog(): VAPI.ServicesList.ServiceResourceUsage;
}
