import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ManifoldCoreStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.ManifoldCoreStatistics;
    readonly ManifoldMemoryStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.ManifoldMemoryStatistics;
    readonly UDXFilter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.UDXFilter;
    readonly UDXStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.UDXStatistics;
    readonly UDXTransform: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.UDXTransform;
    readonly UDXVideoCrop: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.UDX.UDXVideoCrop;
};
export declare const lower: {
    readonly ManifoldCoreStatistics: (_x: ManifoldCoreStatistics) => string;
    readonly ManifoldMemoryStatistics: (_x: ManifoldMemoryStatistics) => string;
    readonly UDXFilter: (_x: UDXFilter) => string;
    readonly UDXStatistics: (_x: UDXStatistics) => string;
    readonly UDXTransform: (_x: UDXTransform) => string;
    readonly UDXVideoCrop: (_x: UDXVideoCrop) => string;
};
export type Height = number;
export declare class ManifoldCoreStatistics implements VScript.Referenceable<"UDX::Data::ManifoldCoreStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::ManifoldCoreStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sync_length(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get sync_calc_length(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_0_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_1_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_2_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_3_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_4_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_5_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_6_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get output_7_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get total_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get core_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get core_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
    get core_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.UDX.TUnsignedMax, VAPI.UDX.ManifoldCoreStatistics>;
}
export declare class ManifoldMemoryStatistics implements VScript.Referenceable<"UDX::Data::ManifoldMemoryStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::ManifoldMemoryStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mem_band_max_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.UDX.ManifoldMemoryStatistics>;
    get mem_band_write_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.UDX.ManifoldMemoryStatistics>;
    get mem_band_read_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.UDX.ManifoldMemoryStatistics>;
}
export type TUnsignedMax = number;
export type UDXVideoStandard = "PAL" | "NTSC" | "HD720p25" | "HD720p29_97" | "HD720p30" | "HD720p50" | "HD720p59_94" | "HD720p60" | "HD1080p23_98" | "HD1080sF23_98" | "HD1080p24" | "HD1080sF24" | "HD1080p25" | "HD1080sF25" | "HD1080p29_97" | "HD1080sF29_97" | "HD1080p30" | "HD1080sF30" | "HD1080i50" | "HD1080i59_94" | "HD1080i60" | "HD1080p50" | "HD1080p59_94" | "HD1080p60" | "HD2160p50" | "HD2160p59_94" | "HD2160p60";
export type UDXASPECTRATIO = "ANAMORPHIC" | "LETTERBOX" | "PILLARBOX" | "CENTERCUT";
export type UDXFILTERWINDOW = "HAMMING" | "KAISER";
export declare class UDXFilter implements VScript.Referenceable<"UDX::Data::UDXFilter"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::UDXFilter";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXFilter>;
    get window(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXFILTERWINDOW, VAPI.UDX.UDXFILTERWINDOW, VAPI.UDX.UDXFILTERWINDOW, VAPI.UDX.UDXFILTERWINDOW, VAPI.UDX.UDXFilter>;
    get h_filter_offset(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXFilter>;
    get v_filter_offset(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXFilter>;
}
export type UDXOFFSETMODE = "AUTO" | "OFFSET_AUTO" | "OFFSET_MANUAL";
export type UDXSDACTIVEWIDTH = "W720" | "W702";
export type UDXSOURCESHOWMODE = "SHOW_BLACK" | "SHOW_LAST_FRAME";
export declare class UDXStatistics implements VScript.Referenceable<"UDX::Data::UDXStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::UDXStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get cores(): VScript.StronglyTypedArray<VScript.VSocket, "UDX::Data::ManifoldCoreStatistics", VAPI.UDX.ManifoldCoreStatistics>;
    get memory(): VAPI.UDX.ManifoldMemoryStatistics;
}
export declare class UDXTransform implements VScript.Referenceable<"UDX::Data::UDXTransform"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::UDXTransform";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get pos_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXTransform>;
    get pos_x(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXTransform>;
    get pos_y(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXTransform>;
    get size_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXTransform>;
    get size_x(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXTransform>;
    get size_y(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.UDX.UDXTransform>;
}
export declare class UDXVideoCrop implements VScript.Referenceable<"UDX::Data::UDXVideoCrop"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "UDX::Data::UDXVideoCrop";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get crop_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXOFFSETMODE, VAPI.UDX.UDXVideoCrop>;
    get left(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.UDX.Width, VAPI.UDX.Width, VAPI.UDX.UDXVideoCrop>;
    get right(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.UDX.Width, VAPI.UDX.Width, VAPI.UDX.UDXVideoCrop>;
    get top(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.UDX.Height, VAPI.UDX.Height, VAPI.UDX.UDXVideoCrop>;
    get bottom(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.UDX.Height, VAPI.UDX.Height, VAPI.UDX.UDXVideoCrop>;
}
export type Width = number;
export declare const Enums: {
    readonly UDXSOURCESHOWMODE: UDXSOURCESHOWMODE[];
    readonly UDXSDACTIVEWIDTH: UDXSDACTIVEWIDTH[];
    readonly UDXOFFSETMODE: UDXOFFSETMODE[];
    readonly UDXFILTERWINDOW: UDXFILTERWINDOW[];
    readonly UDXASPECTRATIO: UDXASPECTRATIO[];
    readonly UDXVideoStandard: UDXVideoStandard[];
};
