import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AFD: (_raw, _socket) => {
        return {
            ar: _raw[0],
            code: _raw[1],
            top: _raw[2],
            bottom: _raw[3],
            left: _raw[4],
            right: _raw[5]
        };
    },
    ClosedCaption: (_raw) => (new ClosedCaption(_raw)),
    HSLCOLOUR: (_raw, _socket) => {
        return {
            hue: _raw[0],
            saturation: _raw[1],
            lightness: _raw[2]
        };
    },
    HSLCOLOURWITHOPACITY: (_raw, _socket) => {
        return {
            hue: _raw[0],
            saturation: _raw[1],
            lightness: _raw[2],
            opacity: _raw[3]
        };
    },
    OverridePixelFormat: (_raw, _socket) => {
        return {
            colorspace: _raw[0],
            bit_depth: _raw[1],
            transfer_characteristics: _raw[2]
        };
    },
    PixelFormat: (_raw, _socket) => {
        return {
            colorspace: _raw[0],
            bit_depth: _raw[1],
            tc: _raw[2],
            lcd: _raw[3]
        };
    },
    TCLCD: (_raw, _socket) => {
        return { tc: _raw[0], lcd: _raw[1] };
    },
    TimestampedSignature: (_raw, _socket) => {
        return {
            free_running_counter: _raw[0],
            signature: _raw[1]
        };
    },
    ClosedCaptionChannelsPresent: (_raw, _socket) => {
        return {
            c_c0: _raw[0],
            c_c1: _raw[1],
            c_c2: _raw[2],
            c_c3: _raw[3]
        };
    },
    EssenceSubstream: (_raw, _socket) => {
        return {
            stream: _raw[0],
            splitter: _raw[1]
        };
    },
};
export const lower = {
    AFD: (_x, _socket) => [
        _x.ar,
        _x.code,
        _x.top,
        _x.bottom,
        _x.left,
        _x.right
    ],
    ClosedCaption: (_x) => _x.raw.kwl,
    HSLCOLOUR: (_x, _socket) => [
        _x.hue,
        _x.saturation,
        _x.lightness
    ],
    HSLCOLOURWITHOPACITY: (_x, _socket) => [
        _x.hue,
        _x.saturation,
        _x.lightness,
        _x.opacity
    ],
    OverridePixelFormat: (_x, _socket) => [
        _x.colorspace,
        _x.bit_depth,
        _x.transfer_characteristics
    ],
    PixelFormat: (_x, _socket) => [
        _x.colorspace,
        _x.bit_depth,
        _x.tc,
        _x.lcd
    ],
    TCLCD: (_x, _socket) => [
        _x.tc,
        _x.lcd
    ],
    TimestampedSignature: (_x, _socket) => [
        _x.free_running_counter,
        _x.signature
    ],
    ClosedCaptionChannelsPresent: (_x, _socket) => [
        _x.c_c0,
        _x.c_c1,
        _x.c_c2,
        _x.c_c3
    ],
    EssenceSubstream: (_x, _socket) => [
        _x.stream,
        _x.splitter
    ],
};
export class ClosedCaption {
    raw;
    type_identifier = "Video::Data::ClosedCaption";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get channels_present() {
        return new VScript.rKeyword(this, "channels_present", {
            lift: VAPI.Video.lift.ClosedCaptionChannelsPresent,
            lower: VAPI.Video.lower.ClosedCaptionChannelsPresent
        });
    }
    get screen() {
        return new VScript.rKeyword(this, "screen", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    XsCompression: ["C5To1", "C6_66To1", "C8To1", "C10To1", "C20To1", "C25To1", "C40To1"],
    TransportStructure: ["Interlaced", "Segmented", "Progressive"],
    TransportFormat: ["ST2022_6", "ST2110_GPM", "ST2110_BPM", "ST2042_raw", "ST2110_22_JpegXS"],
    TransferCharacteristics: ["SDR", "HLG", "PQ"],
    SubStream2SI: ["QUAD_2SI_1", "QUAD_2SI_2", "QUAD_2SI_3", "QUAD_2SI_4"],
    SubStream: ["QUAD_2SI_1", "QUAD_2SI_2", "QUAD_2SI_3", "QUAD_2SI_4", "UNSPECIFIED_CHANNEL_0", "UNSPECIFIED_CHANNEL_1", "UNSPECIFIED_CHANNEL_2", "UNSPECIFIED_CHANNEL_3", "UNSPECIFIED_CHANNEL_4", "UNSPECIFIED_CHANNEL_5", "UNSPECIFIED_CHANNEL_6", "UNSPECIFIED_CHANNEL_7"],
    Standard: ["PAL", "NTSC", "HD720p25", "HD720p29_97", "HD720p30", "HD720p50", "HD720p59_94", "HD720p60", "HD1080p23_98", "HD1080sF23_98", "HD1080p24", "HD1080sF24", "HD1080p25", "HD1080sF25", "HD1080p29_97", "HD1080sF29_97", "HD1080p30", "HD1080sF30", "HD1080i50", "HD1080i59_94", "HD1080i60", "HD1080p50", "HD1080p59_94", "HD1080p60", "HD2160p23_98", "HD2160p24", "HD2160p25", "HD2160p29_97", "HD2160p30", "HD2160p50", "HD2160p59_94", "HD2160p60", "HD1080p24_DCI", "HD1080sF25_DCI"],
    SquareDivisionStandard: ["HD2160p50", "HD2160p59_94", "HD2160p60"],
    Speed: ["SD", "HD", "s3G_A", "s3G_B", "s12G"],
    Sampling: ["b8_422_YUV", "b10_422_YUV", "b12_422_YUV", "b10_444_YUV", "b10_444_GBR", "b12_444_YUV", "b12_444_GBR", "b12_444_XYZ", "b10_4444_YUVA", "b10_4444_GBRA", "b8_4444_YUVA"],
    SDITXFrequency: ["F74_175MHz", "F74_25MHz", "F148_35MHz", "F148_5MHz", "F296_7MHz", "F297MHz"],
    Refresh: ["fp23_98", "fsF23_98", "fp24", "fsF24", "fp25", "fsF25", "fp29_97", "fsF29_97", "fp30", "fsF30", "fp50", "fi50", "fp59_94", "fi59_94", "fp60", "fi60"],
    Raster: ["NTSC", "PAL", "r720", "r1080", "r2048", "r2160"],
    PixelClockFrequency: ["F13_5MHz", "F74_175MHz", "F74_25MHz", "F148_35MHz", "F148_5MHz", "F296_7MHz", "F297MHz"],
    OverrideTransferCharacteristics: ["Passthrough", "Remove", "SDR", "HLG", "PQ"],
    OverrideColorSpace: ["Passthrough", "Remove", "BT601", "BT709", "BT2020", "BT2100"],
    OverrideBitDepth: ["Passthrough", "BitDepth8", "BitDepth10", "BitDepth12", "BitDepth10_FullRange", "BitDepth12_FullRange"],
    LuminanceAndColorDifferenceSignal: ["YCbCr", "ICtCp"],
    GeneralizedTransportFormat: ["ST2022_6", "ST2110_GPM", "ST2110_BPM", "ST2042_raw", "ST2110_22_JpegXS", "RFC4175"],
    FrameRate: ["f23_98", "f24", "f25", "f29_97", "f30", "f50", "f59_94", "f60"],
    Field: ["First", "Second"],
    DiracCompression: ["C_2_5", "C_3_33", "C_4", "C_4_44", "C_6_66", "C_8"],
    ColorSpace: ["BT601", "BT709", "BT2020", "BT2100"],
    ClosedCaptionMode: ["CEA608", "CEA708", "OP47"],
    ClosedCaptionChannel: ["CC0", "CC1", "CC2", "CC3"],
    CEA608Field: ["L21_Field1", "L21_Field2"],
    BitDepth: ["BitDepth8", "BitDepth10", "BitDepth12", "BitDepth10_FullRange", "BitDepth12_FullRange"],
    BNCInputFreq: ["ceDisable", "ceMADI", "ceSD", "ceHD", "ce3G", "ce6G", "ce12G"],
    AspectRatio: ["AR_4_3", "AR_16_9"]
};
