import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AutoFader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoMixer.AutoFader;
    readonly BSLKMixer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoMixer.BSLKMixer;
    readonly AutoFaderTransition: (_raw: [number, number], _socket: VScript.VSocket) => AutoFaderTransition;
};
export declare const lower: {
    readonly AutoFader: (_x: AutoFader) => string;
    readonly BSLKMixer: (_x: BSLKMixer) => string;
    readonly AutoFaderTransition: (_x: {
        target: number;
        /**
          Time for a full transition from 0.0 to 1.0 - set to 0s for jump
          to target
        */
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
};
export declare class AutoFader implements VScript.Referenceable<"VideoMixer::Data::AutoFader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoMixer::Data::AutoFader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get current(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.VideoMixer.AutoFader>;
    get transition(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number
    ], [
        number,
        number
    ], VAPI.VideoMixer.AutoFaderTransition, VAPI.VideoMixer.AutoFaderTransition, VAPI.VideoMixer.AutoFader>;
}
export type BSLKMode = "MIXER" | "MIXER_INDEPENDENT" | "LUMA_KEYER" | "LUMA_KEYER_ADDITIVE";
export type BSLKIssues = {
    luma_keyer_v_src_out_of_range: boolean;
    mismatching_standards: boolean;
    missing_input: boolean;
    no_background: boolean;
    no_hw_resources: boolean;
    uhd_resources_required: boolean;
    v_src0_out_of_range: boolean;
    v_src1_out_of_range: boolean;
};
export declare class BSLKMixer implements VScript.Referenceable<"VideoMixer::Data::BSLK::Mixer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoMixer::Data::BSLK::Mixer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Fader value for crossfade in MIXER mode, or for v_src0 in
      MIXER_INDEPENDENT mode
    */
    get fader0(): VAPI.VideoMixer.AutoFader;
    /**
      Fader value for for source1 in MIXER_INDEPENDENT mode, unused otherwise
    */
    get fader1(): VAPI.VideoMixer.AutoFader;
    /**
      Color mixed in when the sum of fader0 and fader1 is below 1.0 in
      MIXER_INDEPENDENT mode
    */
    get fade_via(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Video.HSLCOLOUR, VAPI.Video.HSLCOLOUR, VAPI.VideoMixer.BSLKMixer>;
    /**
      Which input is the ANC data and V sync source
    */
    get anc_input(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.VideoMixer.BSLKMixer>;
}
export interface AutoFaderTransition {
    target: number;
    /**
      Time for a full transition from 0.0 to 1.0 - set to 0s for jump to target
    */
    time: VScript.Duration;
}
export declare const Enums: {
    readonly BSLKMode: BSLKMode[];
};
