import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AllocationMode: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Frames", value: VAPI.VideoPlayer.lift.FramesSettings(_raw[1], _socket) };
            case 1: return { variant: "Time", value: VAPI.VideoPlayer.lift.TimeSettings(_raw[1], _socket) };
        }
        ;
    },
    VideoLimitationBandwidth: (_raw, _socket) => {
        return {
            max_bandwidth: _raw[0]
        };
    },
    Capabilities: (_raw, _socket) => {
        return {
            capacity: _raw[0] === null ? null : VAPI.VideoPlayer.lift.AllocationMode(_raw[0], _socket),
            input_caliber: VAPI.VideoPlayer.lift.SingleSettings(_raw[1], _socket)
        };
    },
    Control: (_raw) => (new Control(_raw)),
    FramesSettings: (_raw, _socket) => {
        return {
            frames: _raw[0]
        };
    },
    FramesTime: (_raw, _socket) => {
        return {
            frames: _raw[0],
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
    GroupSelections: (_raw) => (new GroupSelections(_raw)),
    Header: (_raw) => (new Header(_raw)),
    Load: (_raw) => (new Load(_raw)),
    MemoryCapacity: (_raw, _socket) => {
        return {
            as_pages: _raw[0],
            as_bytes: _raw[1],
            as_requested: VAPI.VideoPlayer.lift.MemoryCapacityAsRequested(_raw[2], _socket),
            calculation_standard: _raw[3]
        };
    },
    OutputDebug: (_raw) => (new OutputDebug(_raw)),
    Reader: (_raw) => (new Reader(_raw)),
    SingleSettings: (_raw, _socket) => {
        return {
            add_blanking: _raw[0],
            constraints: VAPI.VideoPlayer.lift.VideoLimitation(_raw[1], _socket)
        };
    },
    VideoLimitationStandard: (_raw, _socket) => {
        return {
            standard: _raw[0]
        };
    },
    TimeSettings: (_raw, _socket) => {
        return {
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket)
        };
    },
    Upload: (_raw) => (new Upload(_raw)),
    VideoLimitation: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Standard", value: VAPI.VideoPlayer.lift.VideoLimitationStandard(_raw[1], _socket) };
            case 1: return { variant: "Bandwidth", value: VAPI.VideoPlayer.lift.VideoLimitationBandwidth(_raw[1], _socket) };
        }
        ;
    },
    MemoryCapacityAsRequested: (_raw, _socket) => {
        return {
            frames: _raw[0],
            time: _raw[1] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
    HeaderDate: (_raw, _socket) => {
        return {
            year: _raw[0],
            month: _raw[1],
            day: _raw[2]
        };
    },
    HeaderTimeOfDay: (_raw, _socket) => {
        return {
            hours: _raw[0],
            minutes: _raw[1],
            seconds: _raw[2]
        };
    },
};
export const lower = {
    AllocationMode: (_x, _socket) => {
        switch (_x.variant) {
            case "Frames": return [0, VAPI.VideoPlayer.lower.FramesSettings(_x.value, _socket)];
            case "Time": return [1, VAPI.VideoPlayer.lower.TimeSettings(_x.value, _socket)];
        }
    },
    VideoLimitationBandwidth: (_x, _socket) => [
        _x.max_bandwidth
    ],
    Capabilities: (_x, _socket) => [
        _x.capacity === null ? null : VAPI.VideoPlayer.lower.AllocationMode(_x.capacity, _socket),
        VAPI.VideoPlayer.lower.SingleSettings(_x.input_caliber, _socket)
    ],
    Control: (_x) => _x.raw.kwl,
    FramesSettings: (_x, _socket) => [
        _x.frames
    ],
    FramesTime: (_x, _socket) => [
        _x.frames,
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    GroupSelections: (_x) => _x.raw.kwl,
    Header: (_x) => _x.raw.kwl,
    Load: (_x) => _x.raw.kwl,
    MemoryCapacity: (_x, _socket) => [
        _x.as_pages,
        _x.as_bytes,
        VAPI.VideoPlayer.lower.MemoryCapacityAsRequested(_x.as_requested, _socket),
        _x.calculation_standard
    ],
    OutputDebug: (_x) => _x.raw.kwl,
    Reader: (_x) => _x.raw.kwl,
    SingleSettings: (_x, _socket) => [
        _x.add_blanking,
        VAPI.VideoPlayer.lower.VideoLimitation(_x.constraints, _socket)
    ],
    VideoLimitationStandard: (_x, _socket) => [
        _x.standard
    ],
    TimeSettings: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    Upload: (_x) => _x.raw.kwl,
    VideoLimitation: (_x, _socket) => {
        switch (_x.variant) {
            case "Standard": return [0, VAPI.VideoPlayer.lower.VideoLimitationStandard(_x.value, _socket)];
            case "Bandwidth": return [1, VAPI.VideoPlayer.lower.VideoLimitationBandwidth(_x.value, _socket)];
        }
    },
    MemoryCapacityAsRequested: (_x, _socket) => [
        _x.frames,
        _x.time === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    HeaderDate: (_x, _socket) => [
        _x.year,
        _x.month,
        _x.day
    ],
    HeaderTimeOfDay: (_x, _socket) => [
        _x.hours,
        _x.minutes,
        _x.seconds
    ],
};
export class Control {
    raw;
    type_identifier = "VideoPlayer::Data::Control";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Stop
    */
    get stop() {
        return new VScript.wKeyword(this, "stop", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Play
    */
    get play() {
        return new VScript.wKeyword(this, "play", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Back
    */
    get step_backward() {
        return new VScript.wKeyword(this, "step_backward", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Forward
    */
    get step_forward() {
        return new VScript.wKeyword(this, "step_forward", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Jump
    */
    get jump() {
        return new VScript.wKeyword(this, "jump", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get frame() {
        return new VScript.dKeyword(this, "frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get motion_status() {
        return new VScript.rKeyword(this, "motion_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get visible_frame() {
        return new VScript.rKeyword(this, "visible_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class GroupSelections {
    raw;
    type_identifier = "VideoPlayer::Data::GroupSelections";
    constructor(raw) {
        this.raw = raw;
    }
    get group() {
        return new VScript.dKeyword(this, "group", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class Header {
    raw;
    type_identifier = "VideoPlayer::Data::Header";
    constructor(raw) {
        this.raw = raw;
    }
    get date() {
        return new VScript.rKeyword(this, "date", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lift.HeaderDate),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lower.HeaderDate)
        });
    }
    get time_of_day() {
        return new VScript.rKeyword(this, "time_of_day", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lift.HeaderTimeOfDay),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lower.HeaderTimeOfDay)
        });
    }
    get standard() {
        return new VScript.rKeyword(this, "standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get interlace() {
        return new VScript.rKeyword(this, "interlace", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get frames() {
        return new VScript.rKeyword(this, "frames", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get time() {
        return new VScript.rKeyword(this, "time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    get add_blanking() {
        return new VScript.rKeyword(this, "add_blanking", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get h_active() {
        return new VScript.rKeyword(this, "h_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get v_active() {
        return new VScript.rKeyword(this, "v_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get h_total() {
        return new VScript.rKeyword(this, "h_total", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get v_total() {
        return new VScript.rKeyword(this, "v_total", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get colorspace() {
        return new VScript.rKeyword(this, "colorspace", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get tc() {
        return new VScript.rKeyword(this, "tc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Load {
    raw;
    type_identifier = "VideoPlayer::Data::Load";
    constructor(raw) {
        this.raw = raw;
    }
    get file() {
        return new VScript.dKeyword(this, "file", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Load Clip
    */
    get load() {
        return new VScript.wKeyword(this, "load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get progress() {
        return new VScript.rKeyword(this, "progress", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class OutputDebug {
    raw;
    type_identifier = "VideoPlayer::Data::OutputDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get reader_id() {
        return new VScript.rKeyword(this, "reader_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reader_v_idx() {
        return new VScript.rKeyword(this, "reader_v_idx", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_first_active_line_field_0() {
        return new VScript.rKeyword(this, "start_first_active_line_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_first_blanking_line_field_0() {
        return new VScript.rKeyword(this, "end_first_blanking_line_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_first_active_line_field_1() {
        return new VScript.rKeyword(this, "start_first_active_line_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_first_blanking_line_field_1() {
        return new VScript.rKeyword(this, "end_first_blanking_line_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_number_field_0() {
        return new VScript.rKeyword(this, "line_number_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_number_field_1() {
        return new VScript.rKeyword(this, "line_number_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_total() {
        return new VScript.rKeyword(this, "line_total", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_line_number_generator() {
        return new VScript.rKeyword(this, "start_line_number_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_v_flag_generator() {
        return new VScript.rKeyword(this, "start_v_flag_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_blanking() {
        return new VScript.rKeyword(this, "horizontal_blanking", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_active() {
        return new VScript.rKeyword(this, "horizontal_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_hanc() {
        return new VScript.rKeyword(this, "mode_hanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_vanc() {
        return new VScript.rKeyword(this, "mode_vanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_video() {
        return new VScript.rKeyword(this, "mode_video", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_en_cnt() {
        return new VScript.rKeyword(this, "mode_en_cnt", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ce_sel() {
        return new VScript.rKeyword(this, "ce_sel", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ce_sel_enable() {
        return new VScript.rKeyword(this, "ce_sel_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get length_frame() {
        return new VScript.rKeyword(this, "length_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get length_line() {
        return new VScript.rKeyword(this, "length_line", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_line() {
        return new VScript.rKeyword(this, "stride_line", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_frame() {
        return new VScript.rKeyword(this, "stride_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_address() {
        return new VScript.rKeyword(this, "start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_address() {
        return new VScript.rKeyword(this, "end_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get jump() {
        return new VScript.rKeyword(this, "jump", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reset() {
        return new VScript.rKeyword(this, "reset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_generator() {
        return new VScript.rKeyword(this, "start_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get delta_frame() {
        return new VScript.rKeyword(this, "delta_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get delta_time() {
        return new VScript.rKeyword(this, "delta_time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get time_from_start() {
        return new VScript.rKeyword(this, "time_from_start", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get delta_start_address() {
        return new VScript.rKeyword(this, "delta_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get frame_start_address() {
        return new VScript.rKeyword(this, "frame_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get register_panic() {
        return new VScript.rKeyword(this, "register_panic", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Reader {
    raw;
    type_identifier = "VideoPlayer::Data::Reader";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return VAPI.VideoPlayer.lift.OutputDebug(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "debug"));
    }
}
export class Upload {
    raw;
    type_identifier = "VideoPlayer::Data::Upload";
    constructor(raw) {
        this.raw = raw;
    }
    get load() {
        return VAPI.VideoPlayer.lift.Load(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "load"));
    }
    get header() {
        return VAPI.VideoPlayer.lift.Header(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "header"));
    }
}
export const Enums = {
    MotionStatus: ["Stop", "Play", "StepBackward", "StepForward", "Jump"],
    InputMode: ["Single", "Quad", "UHD"],
    Groups: ["Group0", "Group1", "Group2", "Group3"],
    DelayMode: ["FrameSync_Freeze", "FrameSync_Black", "FramePhaser"],
    BufferMode: ["Frames", "Time"]
};
