import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly VideoLimitationBandwidth: (_raw: [VAPI.Definitions.Bandwidth], _socket: VScript.VSocket) => VideoLimitationBandwidth;
    readonly Buffer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.Buffer;
    readonly Capabilities: (_raw: [null | ([0, [number]] | [1, [number]]), VAPI.VideoRePlay.DelayMode, ([0, [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]] | [1, [VAPI.Video.SquareDivisionStandard]])], _socket: VScript.VSocket) => Capabilities;
    readonly DMA: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.DMA;
    readonly File: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.File;
    readonly GroupSelections: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.GroupSelections;
    readonly Http: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.Http;
    readonly InputCaliber: (_raw: ([0, [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]] | [1, [VAPI.Video.SquareDivisionStandard]]), _socket: VScript.VSocket) => InputCaliber;
    readonly InputDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.InputDebug;
    readonly MemoryCapacity: (_raw: [number, number, [null | number, null | number], [null | number, null | number], null | VAPI.Video.Standard], _socket: VScript.VSocket) => MemoryCapacity;
    readonly OutputDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.OutputDebug;
    readonly Reader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.Reader;
    readonly SingleSettings: (_raw: [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])], _socket: VScript.VSocket) => SingleSettings;
    readonly SquareSettings: (_raw: [VAPI.Video.SquareDivisionStandard], _socket: VScript.VSocket) => SquareSettings;
    readonly VideoLimitationStandard: (_raw: [VAPI.Video.Standard], _socket: VScript.VSocket) => VideoLimitationStandard;
    readonly VideoLimitation: (_raw: ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]]), _socket: VScript.VSocket) => VideoLimitation;
    readonly Writer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.VideoRePlay.Writer;
    readonly MemoryCapacityAsAllocated: (_raw: [null | number, null | number], _socket: VScript.VSocket) => MemoryCapacityAsAllocated;
    readonly MemoryCapacityAsRequested: (_raw: [null | number, null | number], _socket: VScript.VSocket) => MemoryCapacityAsRequested;
    readonly BufferCurrentDelay: (_raw: [null | number, null | number], _socket: VScript.VSocket) => BufferCurrentDelay;
};
export declare const lower: {
    readonly VideoLimitationBandwidth: (_x: {
        max_bandwidth: VAPI.Definitions.Bandwidth;
    }, _socket: VScript.VSocket) => [VAPI.Definitions.Bandwidth];
    readonly Buffer: (_x: Buffer) => string;
    readonly Capabilities: (_x: {
        capacity: null | VAPI.VideoPlayer.AllocationMode;
        delay_mode: VAPI.VideoRePlay.DelayMode;
        input_caliber: VAPI.VideoRePlay.InputCaliber;
    }, _socket: VScript.VSocket) => [null | ([0, [number]] | [1, [number]]), VAPI.VideoRePlay.DelayMode, ([0, [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]] | [1, [VAPI.Video.SquareDivisionStandard]])];
    readonly DMA: (_x: DMA) => string;
    readonly File: (_x: File) => string;
    readonly GroupSelections: (_x: GroupSelections) => string;
    readonly Http: (_x: Http) => string;
    readonly InputCaliber: (_x: ({
        variant: "Single";
        value: VAPI.VideoRePlay.SingleSettings;
    } | {
        variant: "Square_division";
        value: VAPI.VideoRePlay.SquareSettings;
    }), _socket: VScript.VSocket) => ([0, [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])]] | [1, [VAPI.Video.SquareDivisionStandard]]);
    readonly InputDebug: (_x: InputDebug) => string;
    readonly MemoryCapacity: (_x: {
        as_pages: VAPI.Primitives.Unsigned16;
        as_bytes: VAPI.Primitives.Unsigned64;
        as_requested: VAPI.VideoRePlay.MemoryCapacityAsRequested;
        as_allocated: VAPI.VideoRePlay.MemoryCapacityAsAllocated;
        /**
          This standard is used to calculate the required memory. It
          is derived from the (add_blanking, video_limitation,
          Frames, Time) settings
        */
        calculation_standard: null | VAPI.Video.Standard;
    }, _socket: VScript.VSocket) => [number, number, [null | number, null | number], [null | number, null | number], null | VAPI.Video.Standard];
    readonly OutputDebug: (_x: OutputDebug) => string;
    readonly Reader: (_x: Reader) => string;
    readonly SingleSettings: (_x: {
        add_blanking: boolean;
        constraints: VAPI.VideoRePlay.VideoLimitation;
    }, _socket: VScript.VSocket) => [boolean, ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]])];
    readonly SquareSettings: (_x: {
        standard: VAPI.Video.SquareDivisionStandard;
    }, _socket: VScript.VSocket) => [VAPI.Video.SquareDivisionStandard];
    readonly VideoLimitationStandard: (_x: {
        standard: VAPI.Video.Standard;
    }, _socket: VScript.VSocket) => [VAPI.Video.Standard];
    readonly VideoLimitation: (_x: ({
        variant: "Standard";
        value: VAPI.VideoRePlay.VideoLimitationStandard;
    } | {
        variant: "Bandwidth";
        value: VAPI.VideoRePlay.VideoLimitationBandwidth;
    }), _socket: VScript.VSocket) => ([0, [VAPI.Video.Standard]] | [1, [VAPI.Definitions.Bandwidth]]);
    readonly Writer: (_x: Writer) => string;
    readonly MemoryCapacityAsAllocated: (_x: {
        frames: null | number;
        time: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly MemoryCapacityAsRequested: (_x: {
        frames: null | number;
        time: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly BufferCurrentDelay: (_x: {
        as_frames: null | number;
        as_time: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number];
};
export interface VideoLimitationBandwidth {
    max_bandwidth: VAPI.Definitions.Bandwidth;
}
export declare class Buffer implements VScript.Referenceable<"VideoRePlay::Data::Buffer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::Buffer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get offset(): VScript.dKeyword<VScript.VSocket, null | ([0, [number]] | [
        1,
        [number]
    ]), null | ([0, [number]] | [
        1,
        [number]
    ]), null | VAPI.VideoPlayer.AllocationMode, null | VAPI.VideoPlayer.AllocationMode, VAPI.VideoRePlay.Buffer>;
    get current_delay(): VScript.rKeyword<VScript.VSocket, null | [
        null | number,
        null | number
    ], null | VAPI.VideoRePlay.BufferCurrentDelay, VAPI.VideoRePlay.Buffer>;
}
export type BufferMode = "Frames" | "Time";
export interface Capabilities {
    capacity: null | VAPI.VideoPlayer.AllocationMode;
    delay_mode: VAPI.VideoRePlay.DelayMode;
    input_caliber: VAPI.VideoRePlay.InputCaliber;
}
export declare class DMA implements VScript.Referenceable<"VideoRePlay::Data::DMA"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::DMA";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get file(): VAPI.VideoRePlay.File;
    get http(): VAPI.VideoRePlay.Http;
}
export type DelayMode = "FrameSync_Freeze" | "FrameSync_Black" | "FramePhaser";
export type DmaTrigger = "frame" | "clip_in_files" | "clip_single_file";
export type DmaTriggerSetup = "Stop" | "Restart";
export type DmaTriggerSetupStatus = "Stop" | "Restart" | "Process" | "Done";
export declare class File implements VScript.Referenceable<"VideoRePlay::Data::File"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::File";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Trigger DMA writer
    */
    get trigger_dma_writer(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoRePlay.File>;
    /**
      Trigger DMA reader
    */
    get trigger_dma_reader(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.VideoRePlay.File>;
    get setup_dma_reader(): VScript.rwKeyword<VScript.VSocket, VAPI.VideoRePlay.DmaTrigger, VAPI.VideoRePlay.DmaTrigger, VAPI.VideoRePlay.DmaTrigger, VAPI.VideoRePlay.DmaTrigger, VAPI.VideoRePlay.File>;
}
export declare class GroupSelections implements VScript.Referenceable<"VideoRePlay::Data::GroupSelections"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::GroupSelections";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get group(): VScript.dKeyword<VScript.VSocket, null | VAPI.VideoRePlay.Groups, null | VAPI.VideoRePlay.Groups, null | VAPI.VideoRePlay.Groups, null | VAPI.VideoRePlay.Groups, VAPI.VideoRePlay.GroupSelections>;
}
export type Groups = "Group0" | "Group1" | "Group2" | "Group3";
export declare class Http implements VScript.Referenceable<"VideoRePlay::Data::Http"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::Http";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      before initiate the dma download process, stop the writer/reader. If the
      job ist done, restart the writer/reader
    */
    get setup_handler(): VScript.rwKeyword<VScript.VSocket, null | VAPI.VideoRePlay.DmaTriggerSetup, null | VAPI.VideoRePlay.DmaTriggerSetup, null | VAPI.VideoRePlay.DmaTriggerSetup, null | VAPI.VideoRePlay.DmaTriggerSetup, VAPI.VideoRePlay.Http>;
    get handler_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.VideoRePlay.DmaTriggerSetupStatus, null | VAPI.VideoRePlay.DmaTriggerSetupStatus, VAPI.VideoRePlay.Http>;
}
export type InputCaliber = ({
    variant: "Single";
    value: VAPI.VideoRePlay.SingleSettings;
} | {
    variant: "Square_division";
    value: VAPI.VideoRePlay.SquareSettings;
});
export declare class InputDebug implements VScript.Referenceable<"VideoRePlay::Data::InputDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::InputDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get writer_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get stride_line(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get stride_frame(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get start_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get end_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get num_lines(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get horizontal_blanking(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get horizontal_error(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get horizontal_active(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_hanc(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_vanc(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_enable(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_interlaced(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_stop(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get mode_en_cnt(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get delta_time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoRePlay.InputDebug>;
    get time_from_start(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoRePlay.InputDebug>;
    get delta_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get frame_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.InputDebug>;
    get in_panic(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoRePlay.InputDebug>;
}
export type InputMode = "Single" | "Quad" | "UHD";
export interface MemoryCapacity {
    as_pages: VAPI.Primitives.Unsigned16;
    as_bytes: VAPI.Primitives.Unsigned64;
    as_requested: VAPI.VideoRePlay.MemoryCapacityAsRequested;
    as_allocated: VAPI.VideoRePlay.MemoryCapacityAsAllocated;
    /**
      This standard is used to calculate the required memory. It is derived
      from the (add_blanking, video_limitation, Frames, Time) settings
    */
    calculation_standard: null | VAPI.Video.Standard;
}
export declare class OutputDebug implements VScript.Referenceable<"VideoRePlay::Data::OutputDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::OutputDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get reader_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get reader_v_idx(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get reader_w_idx(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_first_active_line_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get end_first_blanking_line_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_first_active_line_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get end_first_blanking_line_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get line_number_field_0(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get line_number_field_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get line_total(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_line_number_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_v_flag_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get horizontal_blanking(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get horizontal_active(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get mode_hanc(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get mode_vanc(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get mode_video(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get mode_en_cnt(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get ce_sel(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get ce_sel_enable(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get length_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get length_line(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get stride_line(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get stride_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get end_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get jump(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get reset(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get start_generator(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get delta_frame(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.VideoRePlay.OutputDebug>;
    get delta_time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoRePlay.OutputDebug>;
    get time_from_start(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.VideoRePlay.OutputDebug>;
    get delta_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get frame_start_address(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.VideoRePlay.OutputDebug>;
    get register_panic(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoRePlay.OutputDebug>;
}
export declare class Reader implements VScript.Referenceable<"VideoRePlay::Data::Reader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::Reader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoRePlay.Reader>;
    get debug(): VAPI.VideoRePlay.OutputDebug;
}
export interface SingleSettings {
    add_blanking: boolean;
    constraints: VAPI.VideoRePlay.VideoLimitation;
}
export interface SquareSettings {
    standard: VAPI.Video.SquareDivisionStandard;
}
export interface VideoLimitationStandard {
    standard: VAPI.Video.Standard;
}
export type VideoLimitation = ({
    variant: "Standard";
    value: VAPI.VideoRePlay.VideoLimitationStandard;
} | {
    variant: "Bandwidth";
    value: VAPI.VideoRePlay.VideoLimitationBandwidth;
});
export declare class Writer implements VScript.Referenceable<"VideoRePlay::Data::Writer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "VideoRePlay::Data::Writer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.VideoRePlay.Writer>;
    get debug(): VAPI.VideoRePlay.InputDebug;
}
export interface MemoryCapacityAsAllocated {
    frames: null | number;
    time: null | VScript.Duration;
}
export interface MemoryCapacityAsRequested {
    frames: null | number;
    time: null | VScript.Duration;
}
export interface BufferCurrentDelay {
    as_frames: null | number;
    as_time: null | VScript.Duration;
}
export type DelayIssues = {
    missing_input_standard: boolean;
    missing_latched_standard: boolean;
    missing_timesource: boolean;
    out_of_memory: boolean;
    out_of_readers: boolean;
    out_of_writers: boolean;
};
export declare const Enums: {
    readonly InputMode: InputMode[];
    readonly Groups: Groups[];
    readonly DmaTriggerSetupStatus: DmaTriggerSetupStatus[];
    readonly DmaTriggerSetup: DmaTriggerSetup[];
    readonly DmaTrigger: DmaTrigger[];
    readonly DelayMode: DelayMode[];
    readonly BufferMode: BufferMode[];
};
