import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    VideoLimitationBandwidth: (_raw, _socket) => {
        return { max_bandwidth: _raw[0] };
    },
    Buffer: (_raw) => (new Buffer(_raw)),
    Capabilities: (_raw, _socket) => {
        return {
            capacity: _raw[0] === null ? null : VAPI.VideoPlayer.lift.AllocationMode(_raw[0], _socket),
            delay_mode: _raw[1],
            input_caliber: VAPI.VideoRePlay.lift.InputCaliber(_raw[2], _socket)
        };
    },
    DMA: (_raw) => (new DMA(_raw)),
    File: (_raw) => (new File(_raw)),
    GroupSelections: (_raw) => (new GroupSelections(_raw)),
    Http: (_raw) => (new Http(_raw)),
    InputCaliber: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Single", value: VAPI.VideoRePlay.lift.SingleSettings(_raw[1], _socket) };
            case 1: return { variant: "Square_division", value: VAPI.VideoRePlay.lift.SquareSettings(_raw[1], _socket) };
        }
        ;
    },
    InputDebug: (_raw) => (new InputDebug(_raw)),
    MemoryCapacity: (_raw, _socket) => {
        return {
            as_pages: _raw[0],
            as_bytes: _raw[1],
            as_requested: VAPI.VideoRePlay.lift.MemoryCapacityAsRequested(_raw[2], _socket),
            as_allocated: VAPI.VideoRePlay.lift.MemoryCapacityAsAllocated(_raw[3], _socket),
            calculation_standard: _raw[4]
        };
    },
    OutputDebug: (_raw) => (new OutputDebug(_raw)),
    Reader: (_raw) => (new Reader(_raw)),
    SingleSettings: (_raw, _socket) => {
        return {
            add_blanking: _raw[0],
            constraints: VAPI.VideoRePlay.lift.VideoLimitation(_raw[1], _socket)
        };
    },
    SquareSettings: (_raw, _socket) => {
        return {
            standard: _raw[0]
        };
    },
    VideoLimitationStandard: (_raw, _socket) => {
        return {
            standard: _raw[0]
        };
    },
    VideoLimitation: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Standard", value: VAPI.VideoRePlay.lift.VideoLimitationStandard(_raw[1], _socket) };
            case 1: return { variant: "Bandwidth", value: VAPI.VideoRePlay.lift.VideoLimitationBandwidth(_raw[1], _socket) };
        }
        ;
    },
    Writer: (_raw) => (new Writer(_raw)),
    MemoryCapacityAsAllocated: (_raw, _socket) => {
        return {
            frames: _raw[0],
            time: _raw[1] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
    MemoryCapacityAsRequested: (_raw, _socket) => {
        return {
            frames: _raw[0],
            time: _raw[1] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
    BufferCurrentDelay: (_raw, _socket) => {
        return {
            as_frames: _raw[0],
            as_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
};
export const lower = {
    VideoLimitationBandwidth: (_x, _socket) => [
        _x.max_bandwidth
    ],
    Buffer: (_x) => _x.raw.kwl,
    Capabilities: (_x, _socket) => [
        _x.capacity === null ? null : VAPI.VideoPlayer.lower.AllocationMode(_x.capacity, _socket),
        _x.delay_mode,
        VAPI.VideoRePlay.lower.InputCaliber(_x.input_caliber, _socket)
    ],
    DMA: (_x) => _x.raw.kwl,
    File: (_x) => _x.raw.kwl,
    GroupSelections: (_x) => _x.raw.kwl,
    Http: (_x) => _x.raw.kwl,
    InputCaliber: (_x, _socket) => {
        switch (_x.variant) {
            case "Single": return [0, VAPI.VideoRePlay.lower.SingleSettings(_x.value, _socket)];
            case "Square_division": return [1, VAPI.VideoRePlay.lower.SquareSettings(_x.value, _socket)];
        }
    },
    InputDebug: (_x) => _x.raw.kwl,
    MemoryCapacity: (_x, _socket) => [
        _x.as_pages,
        _x.as_bytes,
        VAPI.VideoRePlay.lower.MemoryCapacityAsRequested(_x.as_requested, _socket),
        VAPI.VideoRePlay.lower.MemoryCapacityAsAllocated(_x.as_allocated, _socket),
        _x.calculation_standard
    ],
    OutputDebug: (_x) => _x.raw.kwl,
    Reader: (_x) => _x.raw.kwl,
    SingleSettings: (_x, _socket) => [
        _x.add_blanking,
        VAPI.VideoRePlay.lower.VideoLimitation(_x.constraints, _socket)
    ],
    SquareSettings: (_x, _socket) => [
        _x.standard
    ],
    VideoLimitationStandard: (_x, _socket) => [
        _x.standard
    ],
    VideoLimitation: (_x, _socket) => {
        switch (_x.variant) {
            case "Standard": return [0, VAPI.VideoRePlay.lower.VideoLimitationStandard(_x.value, _socket)];
            case "Bandwidth": return [1, VAPI.VideoRePlay.lower.VideoLimitationBandwidth(_x.value, _socket)];
        }
    },
    Writer: (_x) => _x.raw.kwl,
    MemoryCapacityAsAllocated: (_x, _socket) => [
        _x.frames,
        _x.time === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    MemoryCapacityAsRequested: (_x, _socket) => [
        _x.frames,
        _x.time === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    BufferCurrentDelay: (_x, _socket) => [
        _x.as_frames,
        _x.as_time === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.as_time, _socket)
    ],
};
export class Buffer {
    raw;
    type_identifier = "VideoRePlay::Data::Buffer";
    constructor(raw) {
        this.raw = raw;
    }
    get offset() {
        return new VScript.dKeyword(this, "offset", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lift.AllocationMode),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lower.AllocationMode)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lift.AllocationMode),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoPlayer.lower.AllocationMode)
        }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command === null && status === null) || (command !== null && status !== null) && ((command.variant === 'Frames' && status.variant === 'Frames' && status.value.frames >= command.value.frames) || (command.variant === 'Time' && status.variant === 'Time' && status.value.time.s() >= command.value.time.s())) }));
    }
    get current_delay() {
        return new VScript.rKeyword(this, "current_delay", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoRePlay.lift.BufferCurrentDelay),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.VideoRePlay.lower.BufferCurrentDelay)
        });
    }
}
export class DMA {
    raw;
    type_identifier = "VideoRePlay::Data::DMA";
    constructor(raw) {
        this.raw = raw;
    }
    get file() {
        return VAPI.VideoRePlay.lift.File(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "file"));
    }
    get http() {
        return VAPI.VideoRePlay.lift.Http(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "http"));
    }
}
export class File {
    raw;
    type_identifier = "VideoRePlay::Data::File";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Trigger DMA writer
    */
    get trigger_dma_writer() {
        return new VScript.wKeyword(this, "trigger_dma_writer", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Trigger DMA reader
    */
    get trigger_dma_reader() {
        return new VScript.wKeyword(this, "trigger_dma_reader", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get setup_dma_reader() {
        return new VScript.rwKeyword(this, "setup_dma_reader", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class GroupSelections {
    raw;
    type_identifier = "VideoRePlay::Data::GroupSelections";
    constructor(raw) {
        this.raw = raw;
    }
    get group() {
        return new VScript.dKeyword(this, "group", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class Http {
    raw;
    type_identifier = "VideoRePlay::Data::Http";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      before initiate the dma download process, stop the writer/reader. If the
      job ist done, restart the writer/reader
    */
    get setup_handler() {
        return new VScript.rwKeyword(this, "setup_handler", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get handler_status() {
        return new VScript.rKeyword(this, "handler_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class InputDebug {
    raw;
    type_identifier = "VideoRePlay::Data::InputDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get writer_id() {
        return new VScript.rKeyword(this, "writer_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_line() {
        return new VScript.rKeyword(this, "stride_line", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_frame() {
        return new VScript.rKeyword(this, "stride_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_address() {
        return new VScript.rKeyword(this, "start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_address() {
        return new VScript.rKeyword(this, "end_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_lines() {
        return new VScript.rKeyword(this, "num_lines", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_blanking() {
        return new VScript.rKeyword(this, "horizontal_blanking", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_error() {
        return new VScript.rKeyword(this, "horizontal_error", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_active() {
        return new VScript.rKeyword(this, "horizontal_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_hanc() {
        return new VScript.rKeyword(this, "mode_hanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_vanc() {
        return new VScript.rKeyword(this, "mode_vanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_enable() {
        return new VScript.rKeyword(this, "mode_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_interlaced() {
        return new VScript.rKeyword(this, "mode_interlaced", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_stop() {
        return new VScript.rKeyword(this, "mode_stop", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_en_cnt() {
        return new VScript.rKeyword(this, "mode_en_cnt", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get delta_time() {
        return new VScript.rKeyword(this, "delta_time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get time_from_start() {
        return new VScript.rKeyword(this, "time_from_start", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get delta_start_address() {
        return new VScript.rKeyword(this, "delta_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get frame_start_address() {
        return new VScript.rKeyword(this, "frame_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get in_panic() {
        return new VScript.rKeyword(this, "in_panic", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class OutputDebug {
    raw;
    type_identifier = "VideoRePlay::Data::OutputDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get reader_id() {
        return new VScript.rKeyword(this, "reader_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reader_v_idx() {
        return new VScript.rKeyword(this, "reader_v_idx", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reader_w_idx() {
        return new VScript.rKeyword(this, "reader_w_idx", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_first_active_line_field_0() {
        return new VScript.rKeyword(this, "start_first_active_line_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_first_blanking_line_field_0() {
        return new VScript.rKeyword(this, "end_first_blanking_line_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_first_active_line_field_1() {
        return new VScript.rKeyword(this, "start_first_active_line_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_first_blanking_line_field_1() {
        return new VScript.rKeyword(this, "end_first_blanking_line_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_number_field_0() {
        return new VScript.rKeyword(this, "line_number_field_0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_number_field_1() {
        return new VScript.rKeyword(this, "line_number_field_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get line_total() {
        return new VScript.rKeyword(this, "line_total", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_line_number_generator() {
        return new VScript.rKeyword(this, "start_line_number_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_v_flag_generator() {
        return new VScript.rKeyword(this, "start_v_flag_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_blanking() {
        return new VScript.rKeyword(this, "horizontal_blanking", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_active() {
        return new VScript.rKeyword(this, "horizontal_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_hanc() {
        return new VScript.rKeyword(this, "mode_hanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_vanc() {
        return new VScript.rKeyword(this, "mode_vanc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_video() {
        return new VScript.rKeyword(this, "mode_video", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mode_en_cnt() {
        return new VScript.rKeyword(this, "mode_en_cnt", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ce_sel() {
        return new VScript.rKeyword(this, "ce_sel", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ce_sel_enable() {
        return new VScript.rKeyword(this, "ce_sel_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get length_frame() {
        return new VScript.rKeyword(this, "length_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get length_line() {
        return new VScript.rKeyword(this, "length_line", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_line() {
        return new VScript.rKeyword(this, "stride_line", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stride_frame() {
        return new VScript.rKeyword(this, "stride_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_address() {
        return new VScript.rKeyword(this, "start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_address() {
        return new VScript.rKeyword(this, "end_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get jump() {
        return new VScript.rKeyword(this, "jump", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reset() {
        return new VScript.rKeyword(this, "reset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_generator() {
        return new VScript.rKeyword(this, "start_generator", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get delta_frame() {
        return new VScript.rKeyword(this, "delta_frame", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get delta_time() {
        return new VScript.rKeyword(this, "delta_time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get time_from_start() {
        return new VScript.rKeyword(this, "time_from_start", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get delta_start_address() {
        return new VScript.rKeyword(this, "delta_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get frame_start_address() {
        return new VScript.rKeyword(this, "frame_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get register_panic() {
        return new VScript.rKeyword(this, "register_panic", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Reader {
    raw;
    type_identifier = "VideoRePlay::Data::Reader";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return VAPI.VideoRePlay.lift.OutputDebug(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "debug"));
    }
}
export class Writer {
    raw;
    type_identifier = "VideoRePlay::Data::Writer";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return VAPI.VideoRePlay.lift.InputDebug(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "debug"));
    }
}
export const Enums = {
    InputMode: ["Single", "Quad", "UHD"],
    Groups: ["Group0", "Group1", "Group2", "Group3"],
    DmaTriggerSetupStatus: ["Stop", "Restart", "Process", "Done"],
    DmaTriggerSetup: ["Stop", "Restart"],
    DmaTrigger: ["frame", "clip_in_files", "clip_single_file"],
    DelayMode: ["FrameSync_Freeze", "FrameSync_Black", "FramePhaser"],
    BufferMode: ["Frames", "Time"]
};
