import { deepEqual } from "./polyfills/polyfill_util.js";
export function enforce(condition, errMsg) {
	if (!condition) {
		debugger;
		throw new Error(errMsg);
	}
}
export function assert_nothrow(_condition, _errMsg) {}
export function enforce_nonnull(t, what) {
	if (t === null || t === undefined) {
		debugger;
		throw new Error(
			`${what ?? "Given value"} should have been non-nullish, but is ${t}`,
		);
	}
	return t;
}
export function enforce_eq(x, y) {
	if (!deepEqual(x, y)) {
		debugger;
		throw new Error(
			`LHS is ${JSON.stringify(x)}, differs from RHS ${JSON.stringify(y)}`,
		);
	}
}
export function unreachable(msg) {
	debugger;
	throw new Error(
		"This point should have been unreachable" + (msg ? `: ${msg}` : ""),
	);
}
//# sourceMappingURL=data:application/json;base64,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
