export function staticArray1TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [tc.lift(raw_elems[0], backing_store)],
		lower: (elems, backing_store) => [tc.lower(elems[0], backing_store)],
	};
}
export function staticWritableArray1TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems)) {
				return [tc.lift(raw_elems[0], backing_store)];
			} else {
				const ret = {};
				for (const i in raw_elems) {
					ret[i] = tc.lift(raw_elems[i], backing_store);
				}
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) {
				return [tc.lower(elems[0], backing_store)];
			} else {
				const ret = {};
				for (const i in elems) {
					ret[i] = tc.lower(elems[i], backing_store);
				}
				return ret;
			}
		},
	};
}
export function staticArray2TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
		],
	};
}
export function staticWritableArray2TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems)) {
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
				];
			} else {
				const ret = {};
				for (const i in raw_elems) {
					ret[i] = tc.lift(raw_elems[i], backing_store);
				}
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) {
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
				];
			} else {
				const ret = {};
				for (const i in elems) {
					ret[i] = tc.lower(elems[i], backing_store);
				}
				return ret;
			}
		},
	};
}
export function staticArray3TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
		],
	};
}
export function staticWritableArray3TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems)) {
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
				];
			} else {
				const ret = {};
				for (const i in raw_elems) {
					ret[i] = tc.lift(raw_elems[i], backing_store);
				}
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) {
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
				];
			} else {
				const ret = {};
				for (const i in elems) {
					ret[i] = tc.lower(elems[i], backing_store);
				}
				return ret;
			}
		},
	};
}
export function staticArray4TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
			tc.lift(raw_elems[3], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
			tc.lower(elems[3], backing_store),
		],
	};
}
export function staticWritableArray4TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems)) {
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
					tc.lift(raw_elems[3], backing_store),
				];
			} else {
				const ret = {};
				for (const i in raw_elems) {
					ret[i] = tc.lift(raw_elems[i], backing_store);
				}
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) {
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
					tc.lower(elems[3], backing_store),
				];
			} else {
				const ret = {};
				for (const i in elems) {
					ret[i] = tc.lower(elems[i], backing_store);
				}
				return ret;
			}
		},
	};
}
export function staticArray16TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
			tc.lift(raw_elems[3], backing_store),
			tc.lift(raw_elems[4], backing_store),
			tc.lift(raw_elems[5], backing_store),
			tc.lift(raw_elems[6], backing_store),
			tc.lift(raw_elems[7], backing_store),
			tc.lift(raw_elems[8], backing_store),
			tc.lift(raw_elems[9], backing_store),
			tc.lift(raw_elems[10], backing_store),
			tc.lift(raw_elems[11], backing_store),
			tc.lift(raw_elems[12], backing_store),
			tc.lift(raw_elems[13], backing_store),
			tc.lift(raw_elems[14], backing_store),
			tc.lift(raw_elems[15], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
			tc.lower(elems[3], backing_store),
			tc.lower(elems[4], backing_store),
			tc.lower(elems[5], backing_store),
			tc.lower(elems[6], backing_store),
			tc.lower(elems[7], backing_store),
			tc.lower(elems[8], backing_store),
			tc.lower(elems[9], backing_store),
			tc.lower(elems[10], backing_store),
			tc.lower(elems[11], backing_store),
			tc.lower(elems[12], backing_store),
			tc.lower(elems[13], backing_store),
			tc.lower(elems[14], backing_store),
			tc.lower(elems[15], backing_store),
		],
	};
}
export function staticWritableArray16TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems)) {
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
					tc.lift(raw_elems[3], backing_store),
					tc.lift(raw_elems[4], backing_store),
					tc.lift(raw_elems[5], backing_store),
					tc.lift(raw_elems[6], backing_store),
					tc.lift(raw_elems[7], backing_store),
					tc.lift(raw_elems[8], backing_store),
					tc.lift(raw_elems[9], backing_store),
					tc.lift(raw_elems[10], backing_store),
					tc.lift(raw_elems[11], backing_store),
					tc.lift(raw_elems[12], backing_store),
					tc.lift(raw_elems[13], backing_store),
					tc.lift(raw_elems[14], backing_store),
					tc.lift(raw_elems[15], backing_store),
				];
			} else {
				const ret = {};
				for (const i in raw_elems) {
					ret[i] = tc.lift(raw_elems[i], backing_store);
				}
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) {
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
					tc.lower(elems[3], backing_store),
					tc.lower(elems[4], backing_store),
					tc.lower(elems[5], backing_store),
					tc.lower(elems[6], backing_store),
					tc.lower(elems[7], backing_store),
					tc.lower(elems[8], backing_store),
					tc.lower(elems[9], backing_store),
					tc.lower(elems[10], backing_store),
					tc.lower(elems[11], backing_store),
					tc.lower(elems[12], backing_store),
					tc.lower(elems[13], backing_store),
					tc.lower(elems[14], backing_store),
					tc.lower(elems[15], backing_store),
				];
			} else {
				const ret = {};
				for (const i in elems) {
					ret[i] = tc.lower(elems[i], backing_store);
				}
				return ret;
			}
		},
	};
}
//# sourceMappingURL=data:application/json;base64,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
