export type Level =
	| "Emergency"
	| "Alert"
	| "Critical"
	| "Error"
	| "Warning"
	| "Notice"
	| "Info"
	| "Debug";
export interface ErrorMessage {
	level: Level;
	originator: string;
	content_md: string;
}
export type Logger = (msg: string, level: Level) => void;
export declare function int_of_level(level: Level): number;
export declare function level_of_int(i: number): Level;
export declare function read_error_message(
	message_md: string,
): ErrorMessage | null;
