import { enforce } from "./utilities.js";
const message_re = new RegExp(
	/^<([0-9]+)>[^\s]+\s+[0-9]+\s+[0-9]+:[0-9]+:[0-9]+\s+([^ ]+?):(.*)/,
);
const ALL_LEVELS = [
	"Emergency",
	"Alert",
	"Critical",
	"Error",
	"Warning",
	"Notice",
	"Info",
	"Debug",
];
export function int_of_level(level) {
	return ALL_LEVELS.findIndex((l) => l === level);
}
export function level_of_int(i) {
	enforce(Math.round(i) === i && i >= 0 && i < ALL_LEVELS.length);
	return ALL_LEVELS[i];
}
export function read_error_message(message_md) {
	const m = message_md.match(message_re);
	if (m === null) {
		return null;
	}
	const level_raw = parseInt(m[1]) - 8;
	const originator = m[2];
	const content_md = m[3].trim();
	if (level_raw >= 0 && level_raw < ALL_LEVELS.length)
		return { level: level_of_int(level_raw), originator, content_md };
	else {
		enforce(false);
		return { level: "Alert", originator, content_md };
	}
}
//# sourceMappingURL=data:application/json;base64,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
