import { StringIDPool } from "./id_pool.js";
import { enforce, enforce_nonnull } from "./utilities.js";
function add_marker(m, n, i) {
	enforce(n.markers[i].findIndex((m2) => m2 === m) === -1);
	n.markers[i].push(m);
	if (n.eq_markers.findIndex((m2) => m2 === m) === -1) {
		n.eq_markers.push(m);
	}
	const next = n.forward[i];
	if (next.eq_markers.findIndex((m2) => m2 === m) === -1) {
		next.eq_markers.push(m);
	}
}
function maybe_remove_marker(m, n, i) {
	const i_marker = n.markers[i].findIndex((m2) => m2 === m);
	if (i_marker !== -1) {
		n.markers[i].splice(i_marker, 1);
		const l = n.eq_markers.findIndex((m2) => m2 === m);
		if (l !== -1) {
			n.eq_markers.splice(l, 1);
		}
		const next = n.forward[i];
		const j = next.eq_markers.findIndex((m2) => m2 === m);
		if (j !== -1) {
			next.eq_markers.splice(j, 1);
		}
		return true;
	}
	return false;
}
export class ListenerSkipList {
	static MAX_LEVELS = 24;
	head;
	level = 1;
	intervals = new Map();
	constructor(max_id) {
		const end = {
			key: max_id + 1,
			forward: [],
			markers: [],
			eq_markers: [],
			owners: [],
		};
		this.head = {
			key: 0,
			forward: Array.from({ length: ListenerSkipList.MAX_LEVELS }, (_) => end),
			markers: Array.from({ length: ListenerSkipList.MAX_LEVELS }, (_) => []),
			eq_markers: [],
			owners: [],
		};
	}
	static random_level() {
		let lvl = 1;
		while (Math.random() < 0.5 && lvl < ListenerSkipList.MAX_LEVELS) {
			lvl++;
		}
		return lvl;
	}
	insert_endpoint(search_key) {
		const update = Array.from({
			length: ListenerSkipList.MAX_LEVELS,
		});
		let x = this.head;
		for (let i = this.level - 1; i >= 0; --i) {
			while (x.forward[i].key < search_key) {
				x = x.forward[i];
			}
			update[i] = x;
		}
		enforce_nonnull(x.forward[0]);
		x = x.forward[0];
		if (x.key === search_key) {
			return { N: x, updated: [] };
		} else {
			const lvl = ListenerSkipList.random_level();
			if (lvl > this.level) {
				for (let i = this.level; i < lvl; ++i) {
					update[i] = this.head;
				}
				this.level = lvl;
			}
			x = {
				key: search_key,
				forward: Array.from({ length: lvl }),
				markers: Array.from({ length: lvl }, (_) => []),
				eq_markers: [],
				owners: [],
			};
			for (let i = 0; i < lvl; ++i) {
				enforce_nonnull(update[i]);
				x.forward[i] = update[i].forward[i];
				update[i].forward[i] = x;
			}
			enforce(update.length >= lvl);
			return { N: x, updated: update.slice(0, lvl) };
		}
	}
	adjust_markers_on_insert(N, updated) {
		let promoted = new Set();
		let new_promoted = new Set();
		const remove_marker_from_path = (m, start, end, i) => {
			let x = start;
			while (x.key < end.key) {
				for (let j = Math.min(i, x.forward.length - 1); j >= 0; --j) {
					if (maybe_remove_marker(m, x, j) || j === 0) {
						x = x.forward[j];
						break;
					}
				}
			}
		};
		const lvl = N.forward.length;
		for (let i = 0; i <= lvl - 2; ++i) {
			enforce_nonnull(updated[i]);
			enforce_nonnull(updated[i].markers[i]);
			enforce(
				updated[i].markers[i].length === new Set(updated[i].markers[i]).size,
			);
			for (const m of updated[i].markers[i]) {
				const intvl = this.intervals.get(m);
				if (intvl.min <= N.key && intvl.max >= N.forward[i + 1].key) {
					remove_marker_from_path(m, N.forward[i], N.forward[i + 1], i);
					new_promoted.add(m);
				} else {
					add_marker(m, N, i);
				}
			}
			for (const m of promoted.values()) {
				const intvl = this.intervals.get(m);
				if (intvl.min <= N.key && intvl.max >= N.forward[i + 1].key) {
					remove_marker_from_path(m, N.forward[i], N.forward[i + 1], i);
				} else {
					add_marker(m, N, i);
					promoted.delete(m);
				}
			}
			promoted = new Set([...promoted, ...new_promoted]);
			new_promoted = new Set();
		}
		const LN = lvl - 1;
		for (const m of updated[LN].markers[LN]) {
			promoted.add(m);
		}
		N.markers[LN] = [];
		for (const m of promoted.values()) {
			add_marker(m, N, LN);
		}
		promoted = new Set();
		new_promoted = new Set();
		for (let i = 0; i <= lvl - 2; ++i) {
			for (const m of updated[i].markers[i]) {
				const intvl = this.intervals.get(m);
				if (intvl.min <= updated[i + 1].key && intvl.max >= N.key) {
					remove_marker_from_path(m, updated[i + 1], N, i);
					new_promoted.add(m);
				}
			}
			for (const m of promoted.values()) {
				const intvl = this.intervals.get(m);
				if (
					intvl.min <= updated[i].key &&
					intvl.max >= N.key &&
					!(intvl.min <= updated[i + 1].key)
				) {
					enforce(updated[i].forward[i] === N);
					enforce(updated[i].markers[i].findIndex((m2) => m2 === m) === -1);
					add_marker(m, updated[i], i);
					enforce(updated[i].forward[i].key === N.key);
					promoted.delete(m);
				} else {
					remove_marker_from_path(m, updated[i + 1], N, i);
				}
			}
			promoted = new Set([...promoted, ...new_promoted]);
			new_promoted = new Set();
		}
		const top = lvl - 1;
		for (const m of updated[top].markers[top]) {
			promoted.add(m);
		}
		updated[top].markers[top] = [];
		for (const m of promoted.values()) {
			add_marker(m, updated[top], top);
		}
	}
	place_markers(m) {
		enforce(this.intervals.has(m));
		const intvl = this.intervals.get(m);
		let x = this.find_node(intvl.min);
		enforce(x && x.key === intvl.min);
		enforce(x.eq_markers.findIndex((m2) => m2 === m) === -1);
		x.eq_markers.push(m);
		let i = 0;
		while (x.forward[i].key <= intvl.max) {
			enforce(x.key >= intvl.min);
			while (i !== x.forward.length - 1 && x.forward[i + 1].key <= intvl.max) {
				i = i + 1;
			}
			enforce(x.eq_markers.findIndex((m2) => m2 === m) !== -1);
			add_marker(m, x, i);
			x = x.forward[i];
		}
		while (x.key !== intvl.max) {
			enforce(x.key < intvl.max);
			enforce(intvl.min <= x.key);
			while (i !== 0 && !(intvl.max >= x.forward[i].key)) {
				i = i - 1;
			}
			add_marker(m, x, i);
			x = x.forward[i];
		}
	}
	find_node(key) {
		let x = this.head;
		for (let i = ListenerSkipList.MAX_LEVELS - 1; i >= 0; --i) {
			while (x.forward[i] && x.forward[i].key < key) {
				x = x.forward[i];
			}
		}
		x = x.forward[0];
		if (x.key === key) {
			return x;
		} else {
			return null;
		}
	}
	print() {
		let all_nodes = [];
		for (let x = this.head; x.forward.length > 0; x = x.forward[0]) {
			all_nodes.push(x);
		}
		const print_node = (n) => {
			console.log({ ...n, forward: n.forward.map((f) => f.key) });
		};
		console.log(this.intervals);
		all_nodes.forEach(print_node);
	}
	selfcheck() {
		let all_nodes = [];
		for (let x = this.head; x.forward.length > 0; x = x.forward[0]) {
			all_nodes.push(x);
		}
		for (const node of all_nodes) {
			const all_markers = new Set();
			for (let i = 1; i < node.markers.length; ++i) {
				for (const m of node.markers[i]) {
					enforce(
						!all_markers.has(m),
						`Node #${node.key} contains marker ${m} multiple times`,
					);
					all_markers.add(m);
					for (const other_node of all_nodes) {
						if (other_node.key <= node.key) continue;
						if (other_node.key >= node.forward[i].key) break;
						for (let j = 0; j < i && j < other_node.markers.length; ++j) {
							enforce(
								other_node.markers[j].findIndex((m2) => m2 === m) === -1,
								`Node #${other_node.key} collides with #${node.key} (marker ${m})`,
							);
							if (other_node.markers[j].findIndex((m2) => m2 === m) !== -1) {
								process.exit(7);
							}
						}
					}
				}
			}
		}
	}
	find(key) {
		let x = this.head;
		let S = new Set();
		for (let i = ListenerSkipList.MAX_LEVELS - 1; i > 0; --i) {
			while (x.forward[i] && x.forward[i].key < key) {
				x = x.forward[i];
			}
			for (const m of x.markers[i]) {
				S.add(m);
			}
		}
		while (x.forward[0].key < key) {
			x = x.forward[0];
		}
		if (x.forward[0].key !== key) {
			for (const m of x.markers[0]) {
				S.add(m);
			}
		} else {
			for (const m of x.forward[0].eq_markers) {
				S.add(m);
			}
		}
		const result = [];
		for (const el of S) {
			result.push(this.intervals.get(el).handler);
		}
		return result;
	}
	register(interval, handler) {
		const m = StringIDPool.generate_id();
		enforce(!this.intervals.has(m));
		this.intervals.set(m, { min: interval[0], max: interval[1], handler });
		const ins_min = this.insert_endpoint(interval[0]);
		if (ins_min.updated.length > 0) {
			this.adjust_markers_on_insert(ins_min.N, ins_min.updated);
		}
		const ins_max = this.insert_endpoint(interval[1]);
		if (ins_max.updated.length > 0) {
			this.adjust_markers_on_insert(ins_max.N, ins_max.updated);
		}
		this.place_markers(m);
		return {
			unregister: () => {
				this.unregister(m);
			},
		};
	}
	unregister(m) {
		void m;
	}
}
//# sourceMappingURL=data:application/json;base64,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
