import { enforce } from "./utilities.js";
export class StringIDPool {
	static s_cur_id = BigInt(0);
	static generate_id() {
		StringIDPool.s_cur_id = StringIDPool.s_cur_id + BigInt(1);
		return StringIDPool.s_cur_id.toString(36);
	}
	static generate_or_use_id(dict, suggested_id) {
		const id = suggested_id ?? StringIDPool.generate_id();
		enforce(
			suggested_id !== undefined ||
				(typeof dict === "object" &&
					!Object.prototype.hasOwnProperty.call(dict, id)) ||
				(dict instanceof Map && !dict.has(id)),
		);
		return id;
	}
}
export class NumericIDPool {
	static s_cur_id = 0;
	static MODULUS = Math.pow(2, 50);
	static generate_id() {
		NumericIDPool.s_cur_id =
			(NumericIDPool.s_cur_id + 1) % NumericIDPool.MODULUS;
		return NumericIDPool.s_cur_id;
	}
}
//# sourceMappingURL=data:application/json;base64,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
