import {
	Generation,
	Generational,
	KeywordPayload,
	KWLName,
	MaybeMissing,
	Path,
	SysName,
} from "./pervasives.js";
export type KWLCacheEntry = [
	parent: KWLCacheEntry | undefined,
	gen: Generation,
	kw: Map<SysName, Generational<KeywordPayload>>,
];
export declare class KWLCache {
	private m_data;
	dump_stats(): void;
	register(data: {
		kwl: KWLName<"full">;
		kw: {
			[sys_name: string]: KeywordPayload;
		};
	}): void;
	clear(): void;
	query_kw<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
	): MaybeMissing<Generational<T>>;
	query_kwl(
		kwl: KWLName<"full">,
	): MaybeMissing<Generational<Map<SysName, Generational<KeywordPayload>>>>;
	private get_or_insert;
	private insert;
}
