import { MissingData } from "./pervasives.js";
import {
	enforce_nonnull,
	path_index,
	path_strip_trailing_index,
} from "./utilities.js";
export class KWLCache {
	m_data = new Map();
	dump_stats() {
		let total = 0;
		for (const [_, entry] of this.m_data) {
			total += entry[2].size;
		}
		console.log(
			`KWLCache: ${this.m_data.size} entries @ toplevel, ${total} in total`,
		);
	}
	register(data) {
		let entry = this.get_or_insert(data.kwl);
		for (const sys_name in data.kw) {
			entry[2].set(sys_name, [
				((entry[2].get(sys_name)?.[0] ?? -1) + 1) & 0xfffffff,
				data.kw[sys_name],
			]);
		}
		while (entry !== undefined) {
			entry[1] = entry[1] + 1;
			entry = entry?.[0];
		}
	}
	clear() {
		this.m_data.clear();
	}
	query_kw(path) {
		const maybe_payload = this.m_data.get(path.kwl)?.[2].get(path.kw);
		if (maybe_payload === undefined) {
			return MissingData;
		}
		return [maybe_payload[0], maybe_payload[1]];
	}
	query_kwl(kwl) {
		const maybe_entry = this.m_data.get(kwl);
		if (maybe_entry === undefined) {
			return MissingData;
		}
		return [maybe_entry[1], maybe_entry[2]];
	}
	get_or_insert(kwl) {
		const cur_entry = this.m_data.get(kwl);
		if (cur_entry !== undefined) return cur_entry;
		return this.insert(kwl);
	}
	insert(kwl) {
		let cur_entry = undefined;
		const parts = kwl.split(".").flatMap((segment, i) => {
			const index = path_index(segment);
			if (index === undefined) {
				return [(i === 0 ? "" : ".") + segment];
			} else {
				return [
					(i === 0 ? "" : ".") + path_strip_trailing_index(segment),
					`[${index}]`,
				];
			}
		});
		let path = "";
		for (const part of parts) {
			path += part;
			let next_entry = this.m_data.get(path);
			if (next_entry === undefined) {
				this.m_data.set(path, [cur_entry, -1, new Map()]);
				next_entry = enforce_nonnull(this.m_data.get(path));
			}
			cur_entry = next_entry;
		}
		return enforce_nonnull(cur_entry);
	}
}
//# sourceMappingURL=data:application/json;base64,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
