import { WebSocket } from "ws";
export function binary_concat(header, msg) {
	return Buffer.concat([header, msg]);
}
export class Adapter {
	socket;
	constructor(pars) {
		try {
			const port_suffix = pars.port ? `:${pars.port}` : "";
			const url = `${pars.protocol ?? "ws"}://${pars.ip}${port_suffix}/socket`;
			const socket_opts = {
				ip: pars.ip,
				towel: pars.towel,
				servername: "",
				maxPayload: pars.max_payload_size ?? 1024 * 1024,
				rejectUnauthorized: pars.reject_unauthorized,
				...(pars.login
					? {
							auth: `${pars.login.user}:${pars.login.password}`,
						}
					: {}),
			};
			const listeners = {
				"unexpected-response": (_, rsp) => {
					if (rsp.statusCode === 401 && rsp.statusMessage === "Unauthorized") {
						pars.reject(
							new Error(
								`Unable to connect to ${pars.ip}; this machine appears to be password-protected (try specifying the login parameter within your VM.open or VSocket.open call)`,
							),
						);
					} else {
						const s_code =
							rsp.statusCode !== undefined
								? `status code: ${rsp.statusCode}`
								: "";
						const s_msg =
							rsp.statusCode !== undefined
								? `status message: ${rsp.statusMessage}`
								: "";
						const suffix =
							s_code.length + s_msg.length === 0
								? ""
								: `(${s_code}${Math.min(s_code.length, s_msg.length) !== 0 ? ", " : ""}${s_msg})`;
						pars.reject(
							new Error(
								`Connection attempt aborted; got unexpected response${suffix}`,
							),
						);
					}
				},
				error: (err) => {
					pars.reject(err);
				},
				close: (_, code, reason) => {
					pars.reject(
						new Error(
							`WebSocket connection to ${pars.ip} unexpectedly closed (code ${code}, reason ${reason})`,
						),
					);
				},
			};
			this.socket = new WebSocket(url, {
				...socket_opts,
				handshakeTimeout: pars.timeout.ms(),
				skipUTF8Validation: true,
			})
				.addListener("unexpected-response", listeners["unexpected-response"])
				.on("error", listeners["error"])
				.on("close", listeners["close"])
				.on("open", () => {
					this.socket.on("error", pars.on_error).on("close", pars.on_close);
				});
			this.socket.onmessage = (msg) => {
				this.socket.onmessage = pars.on_further_msg;
				pars.on_first_msg(msg.data);
			};
		} catch (e) {
			pars.reject(e);
		}
	}
	send(data) {
		this.socket.send(data);
	}
	close() {
		this.socket.removeAllListeners();
		this.socket.terminate();
	}
}
//# sourceMappingURL=data:application/json;base64,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
