import { download_json } from "./polyfills/polyfill_http.js";
export class ResourceCache {
	storage = {};
	clients = {};
	async retrieve(pars) {
		if (Object.prototype.hasOwnProperty.call(this.storage, pars.key)) {
			return this.storage[pars.key];
		}
		let should_download = false;
		if (!Object.prototype.hasOwnProperty.call(this.clients, pars.key)) {
			this.clients[pars.key] = [];
			should_download = true;
		}
		const result = new Promise((resolve, reject) => {
			this.clients[pars.key].push({ resolve, reject });
		});
		if (should_download) {
			try {
				const payload = await download_json(pars);
				this.storage[pars.key] = payload;
				for (const client of this.clients[pars.key]) {
					client.resolve(payload);
				}
			} catch (e) {
				for (const client of this.clients[pars.key]) {
					client.reject(e);
				}
			}
			delete this.clients[pars.key];
		}
		return result;
	}
}
//# sourceMappingURL=data:application/json;base64,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
