import { enforce } from "./utilities.js";
export function indices(rowmask) {
	const nibble_count = rowmask.length;
	const indices = [];
	for (let i_nibble = 0; i_nibble < nibble_count; i_nibble++) {
		let cur_idx = i_nibble * 4;
		const char_code = rowmask.charCodeAt(i_nibble);
		enforce(
			(char_code >= "0".charCodeAt(0) && char_code < 58) ||
				(char_code >= "A".charCodeAt(0) && char_code < 71),
		);
		let value = char_code >= 65 ? char_code - 55 : char_code - 48;
		while (value > 0) {
			if ((value & 1) === 1) {
				indices.push(cur_idx);
			}
			value >>>= 1;
			cur_idx += 1;
		}
	}
	return indices;
}
export function has_index(rowmask, i) {
	const i_nibble = i >>> 2;
	if (i_nibble >= rowmask.length) return false;
	const char_code = rowmask.charCodeAt(i_nibble);
	enforce(
		(char_code >= "0".charCodeAt(0) && char_code < 58) ||
			(char_code >= "A".charCodeAt(0) && char_code < 71),
	);
	const value = char_code >= 65 ? char_code - 55 : char_code - 48;
	return ((value >>> (i % 4)) & 1) !== 0;
}
//# sourceMappingURL=data:application/json;base64,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
