import {
	CommonKeywordProperties,
	ConstantsDictionary,
	ElementCount,
	SubtreeMultiplicityProperties,
	SysName,
} from "./pervasives.js";
export type OtherNodeProperties = {
	formatter?: string;
	filter?: string;
	visibility?: "basic" | "advanced" | "developer";
};
export interface CommonNodeProperties<DataType> {
	data_type: DataType;
	sys_name: SysName;
	brief?: string;
	desc?: string;
	other_properties: OtherNodeProperties;
	type_identifier?: string;
}
export type KeywordDescription<Stage extends "raw"> =
	AtomicFieldDescription<Stage> & CommonKeywordProperties<Stage>;
export type ScalarMultiplicityProperties<Stage extends "raw"> =
	| {}
	| {
			array_size: ElementCount<Stage>;
	  }
	| {
			vector_size: ElementCount<Stage>;
	  };
export type SubtreeDescription<Stage extends "raw"> =
	CommonNodeProperties<"subtree"> &
		(Stage extends "raw"
			? {
					children?: Array<ChildDescription<Stage>>;
				}
			: {
					children: Array<ChildDescription<Stage>>;
					stride: number;
					starting_index: {
						[child_name: string]: number;
					};
					type_identifier?: string;
				}) &
		SubtreeMultiplicityProperties<Stage>;
export type AtomicSubtreeDescription<Stage extends "raw"> =
	CommonNodeProperties<"atomic subtree"> & {
		optional: boolean;
	} & (Stage extends "raw"
			? {
					children?: AtomicFieldDescription<Stage>[];
				}
			: {
					children: AtomicFieldDescription<Stage>[];
				});
export type StringDescription = CommonNodeProperties<"string"> & {
	optional: boolean;
	max_length: number;
	default_value?: string;
};
export type NumberDescription = CommonNodeProperties<"int" | "float"> & {
	optional: boolean;
	min: number;
	max: number;
	default_value?: number;
};
export type DeviceTreeNodeDescription =
	CommonNodeProperties<"device_tree_node"> & {
		optional: boolean;
	};
export type ReferenceDescription = CommonNodeProperties<"ref"> & {
	optional: boolean;
	default_value?: string;
	target_type_identifier: string;
	target_type: "subtree";
	ref_perm: "mutating" | "non-mutating";
	refined_to?: SysName;
};
export type EnumDescription = CommonNodeProperties<"enum"> & {
	optional: boolean;
	default_value?: string;
	enum_values: string[];
};
export type BoolDescription = CommonNodeProperties<"bool"> & {
	optional: boolean;
	default_value?: boolean;
};
export type DurationDescription = CommonNodeProperties<
	"int duration" | "float duration"
> & {
	min: number;
	max: number;
	optional: boolean;
	default_value?: number;
};
export type TimecodeDescription = CommonNodeProperties<"timecode"> & {
	optional: boolean;
	default_value?: number;
};
export type TimestampDescription = CommonNodeProperties<"timestamp"> & {
	min?: number;
	max?: number;
	optional: boolean;
	default_value?: string;
};
export type IPAddressDescription = CommonNodeProperties<"ipaddress"> & {
	optional: boolean;
	default_value?: string;
};
export type ComponentDescription<Stage extends "raw"> =
	SubtreeDescription<Stage> & {
		ua_name: string;
		owning_module: string;
		bound_to?: string[];
	} & (Stage extends "annotated"
			? {
					exists: boolean;
				}
			: {});
export type AtomicFieldDescription<Stage extends "raw"> = (
	| TimestampDescription
	| IPAddressDescription
	| BoolDescription
	| EnumDescription
	| StringDescription
	| NumberDescription
	| DeviceTreeNodeDescription
	| ReferenceDescription
	| DurationDescription
	| TimecodeDescription
	| AtomicSubtreeDescription<Stage>
) &
	(Stage extends "raw"
		? {}
		: {
				has_index: boolean;
				local_multiplicity: number;
			}) &
	ScalarMultiplicityProperties<Stage>;
export type SubtreeChildDescription<Stage extends "raw"> =
	SubtreeDescription<Stage> & SubtreeMultiplicityProperties<Stage>;
export type ChildDescription<Stage extends "raw"> =
	| SubtreeChildDescription<Stage>
	| KeywordDescription<Stage>;
export interface ErrorFeedbackChannel {
	kwl: string;
	owner: string;
}
export type SubtreeTypedef<Stage extends "raw"> = Omit<
	SubtreeDescription<Stage>,
	"starting_index" | "stride"
>;
export type Typedef<Stage extends "raw"> = (
	| SubtreeTypedef<Stage>
	| AtomicFieldDescription<Stage>
) & {
	common: boolean;
};
export interface Schema<Stage extends "raw"> {
	constants: ConstantsDictionary;
	error_feedback_channels: ErrorFeedbackChannel[];
	typedef_identifiers: string[];
	typedefs: {
		[typedef_name: string]: Typedef<Stage>;
	};
	keywords: ComponentDescription<Stage>[];
}
export declare function children_of_raw_subtree(
	schema: Schema<"raw">,
	st: SubtreeDescription<"raw">,
): ChildDescription<"raw">[];
export declare function children_of_raw_atomic_subtree(
	schema: Schema<"raw">,
	st: AtomicSubtreeDescription<"raw">,
): AtomicFieldDescription<"raw">[];
