import { enforce } from "./utilities.js";
export function children_of_raw_subtree(schema, st) {
	if ("children" in st) {
		return st.children;
	} else {
		enforce(st.type_identifier !== undefined);
		const td = schema.typedefs[st.type_identifier];
		enforce(td.data_type === "subtree");
		if ("children" in td) {
			return td.children;
		} else {
			enforce(false);
			return [];
		}
	}
}
export function children_of_raw_atomic_subtree(schema, st) {
	if ("children" in st) {
		return st.children;
	} else {
		enforce(st.type_identifier !== undefined);
		const td = schema.typedefs[st.type_identifier];
		if (td.data_type === "atomic subtree" && "children" in td) {
			return td.children;
		} else {
			enforce(false);
			return [];
		}
	}
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZW1hX3YxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vbGliL3NjaGVtYV92MS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFPQSxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUErS3pDLE1BQU0sVUFBVSx1QkFBdUIsQ0FDckMsTUFBcUIsRUFDckIsRUFBNkI7SUFFN0IsSUFBSSxVQUFVLElBQUksRUFBRSxFQUFFLENBQUM7UUFDckIsT0FBTyxFQUFFLENBQUMsUUFBUyxDQUFDO0lBQ3RCLENBQUM7U0FBTSxDQUFDO1FBQ04sT0FBTyxDQUFDLEVBQUUsQ0FBQyxlQUFlLEtBQUssU0FBUyxDQUFDLENBQUM7UUFDMUMsTUFBTSxFQUFFLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsZUFBZ0IsQ0FBOEIsQ0FBQztRQUM3RSxPQUFPLENBQUMsRUFBRSxDQUFDLFNBQVMsS0FBSyxTQUFTLENBQUMsQ0FBQztRQUNwQyxJQUFJLFVBQVUsSUFBSSxFQUFFLEVBQUUsQ0FBQztZQUNyQixPQUFPLEVBQUUsQ0FBQyxRQUFTLENBQUM7UUFDdEIsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDZixPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQUVELE1BQU0sVUFBVSw4QkFBOEIsQ0FDNUMsTUFBcUIsRUFDckIsRUFBbUM7SUFFbkMsSUFBSSxVQUFVLElBQUksRUFBRSxFQUFFLENBQUM7UUFDckIsT0FBTyxFQUFFLENBQUMsUUFBUyxDQUFDO0lBQ3RCLENBQUM7U0FBTSxDQUFDO1FBQ04sT0FBTyxDQUFDLEVBQUUsQ0FBQyxlQUFlLEtBQUssU0FBUyxDQUFDLENBQUM7UUFDMUMsTUFBTSxFQUFFLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsZUFBZ0IsQ0FBQyxDQUFDO1FBQ2hELElBQUksRUFBRSxDQUFDLFNBQVMsS0FBSyxnQkFBZ0IsSUFBSSxVQUFVLElBQUksRUFBRSxFQUFFLENBQUM7WUFDMUQsT0FBTyxFQUFFLENBQUMsUUFBUyxDQUFDO1FBQ3RCLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2YsT0FBTyxFQUFFLENBQUM7UUFDWixDQUFDO0lBQ0gsQ0FBQztBQUNILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBDb21tb25LZXl3b3JkUHJvcGVydGllcyxcbiAgQ29uc3RhbnRzRGljdGlvbmFyeSxcbiAgRWxlbWVudENvdW50LFxuICBTdWJ0cmVlTXVsdGlwbGljaXR5UHJvcGVydGllcyxcbiAgU3lzTmFtZSxcbn0gZnJvbSBcIi4vcGVydmFzaXZlcy5qc1wiO1xuaW1wb3J0IHsgZW5mb3JjZSB9IGZyb20gXCIuL3V0aWxpdGllcy5qc1wiO1xuXG5leHBvcnQgdHlwZSBPdGhlck5vZGVQcm9wZXJ0aWVzID0ge1xuICBmb3JtYXR0ZXI/OiBzdHJpbmc7XG4gIGZpbHRlcj86IHN0cmluZztcbiAgdmlzaWJpbGl0eT86IFwiYmFzaWNcIiB8IFwiYWR2YW5jZWRcIiB8IFwiZGV2ZWxvcGVyXCI7XG59O1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbW1vbk5vZGVQcm9wZXJ0aWVzPERhdGFUeXBlPiB7XG4gIGRhdGFfdHlwZTogRGF0YVR5cGU7XG4gIHN5c19uYW1lOiBTeXNOYW1lO1xuICBicmllZj86IHN0cmluZztcbiAgZGVzYz86IHN0cmluZztcbiAgb3RoZXJfcHJvcGVydGllczogT3RoZXJOb2RlUHJvcGVydGllcztcbiAgdHlwZV9pZGVudGlmaWVyPzogc3RyaW5nO1xufVxuXG5leHBvcnQgdHlwZSBLZXl3b3JkRGVzY3JpcHRpb248U3RhZ2UgZXh0ZW5kcyBcInJhd1wiPiA9IEF0b21pY0ZpZWxkRGVzY3JpcHRpb248U3RhZ2U+ICZcbiAgQ29tbW9uS2V5d29yZFByb3BlcnRpZXM8U3RhZ2U+O1xuXG5leHBvcnQgdHlwZSBTY2FsYXJNdWx0aXBsaWNpdHlQcm9wZXJ0aWVzPFN0YWdlIGV4dGVuZHMgXCJyYXdcIj4gPVxuICB8IHt9XG4gIHwgeyBhcnJheV9zaXplOiBFbGVtZW50Q291bnQ8U3RhZ2U+IH1cbiAgfCB7IHZlY3Rvcl9zaXplOiBFbGVtZW50Q291bnQ8U3RhZ2U+IH07XG5cbmV4cG9ydCB0eXBlIFN1YnRyZWVEZXNjcmlwdGlvbjxTdGFnZSBleHRlbmRzIFwicmF3XCI+ID0gQ29tbW9uTm9kZVByb3BlcnRpZXM8XCJzdWJ0cmVlXCI+ICZcbiAgKFN0YWdlIGV4dGVuZHMgXCJyYXdcIlxuICAgID8ge1xuICAgICAgICBjaGlsZHJlbj86IEFycmF5PENoaWxkRGVzY3JpcHRpb248U3RhZ2U+PjtcbiAgICAgIH1cbiAgICA6IHtcbiAgICAgICAgY2hpbGRyZW46IEFycmF5PENoaWxkRGVzY3JpcHRpb248U3RhZ2U+PjtcbiAgICAgICAgLy8gaW5kZXggZGlmZmVyZW5jZSBiZXR3ZWVuIGFkamFjZW50IHN1YnRyZWUgbWVtYmVycyAoaS5lLiwgdG90YWwgYnJhbmNoIG11bHRpcGxpY2l0eSlcbiAgICAgICAgc3RyaWRlOiBudW1iZXI7XG4gICAgICAgIC8vIGR1cGxleCBrZXl3b3JkcyBhcmUgdW5yb2xsZWQgdG8gX2NvbW1hbmQsIF9zdGF0dXMgKGluIHRoYXQgb3JkZXIpXG4gICAgICAgIHN0YXJ0aW5nX2luZGV4OiB7IFtjaGlsZF9uYW1lOiBzdHJpbmddOiBudW1iZXIgfTtcbiAgICAgICAgdHlwZV9pZGVudGlmaWVyPzogc3RyaW5nO1xuICAgICAgfSkgJlxuICBTdWJ0cmVlTXVsdGlwbGljaXR5UHJvcGVydGllczxTdGFnZT47XG5cbmV4cG9ydCB0eXBlIEF0b21pY1N1YnRyZWVEZXNjcmlwdGlvbjxTdGFnZSBleHRlbmRzIFwicmF3XCI+ID1cbiAgQ29tbW9uTm9kZVByb3BlcnRpZXM8XCJhdG9taWMgc3VidHJlZVwiPiAmIHtcbiAgICBvcHRpb25hbDogYm9vbGVhbjtcbiAgfSAmIChTdGFnZSBleHRlbmRzIFwicmF3XCJcbiAgICAgID8ge1xuICAgICAgICAgIGNoaWxkcmVuPzogQXRvbWljRmllbGREZXNjcmlwdGlvbjxTdGFnZT5bXTtcbiAgICAgICAgfVxuICAgICAgOiB7XG4gICAgICAgICAgY2hpbGRyZW46IEF0b21pY0ZpZWxkRGVzY3JpcHRpb248U3RhZ2U+W107XG4gICAgICAgIH0pO1xuXG5leHBvcnQgdHlwZSBTdHJpbmdEZXNjcmlwdGlvbiA9IENvbW1vbk5vZGVQcm9wZXJ0aWVzPFwic3RyaW5nXCI+ICYge1xuICBvcHRpb25hbDogYm9vbGVhbjtcbiAgbWF4X2xlbmd0aDogbnVtYmVyO1xuICBkZWZhdWx0X3ZhbHVlPzogc3RyaW5nO1xufTtcblxuZXhwb3J0IHR5cGUgTnVtYmVyRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcImludFwiIHwgXCJmbG9hdFwiPiAmIHtcbiAgb3B0aW9uYWw6IGJvb2xlYW47XG4gIG1pbjogbnVtYmVyO1xuICBtYXg6IG51bWJlcjtcbiAgZGVmYXVsdF92YWx1ZT86IG51bWJlcjtcbn07XG5cbmV4cG9ydCB0eXBlIERldmljZVRyZWVOb2RlRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcImRldmljZV90cmVlX25vZGVcIj4gJiB7XG4gIG9wdGlvbmFsOiBib29sZWFuO1xufTtcblxuZXhwb3J0IHR5cGUgUmVmZXJlbmNlRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcInJlZlwiPiAmIHtcbiAgb3B0aW9uYWw6IGJvb2xlYW47XG4gIGRlZmF1bHRfdmFsdWU/OiBzdHJpbmc7XG4gIHRhcmdldF90eXBlX2lkZW50aWZpZXI6IHN0cmluZztcbiAgdGFyZ2V0X3R5cGU6IFwic3VidHJlZVwiO1xuICByZWZfcGVybTogXCJtdXRhdGluZ1wiIHwgXCJub24tbXV0YXRpbmdcIjtcbiAgcmVmaW5lZF90bz86IFN5c05hbWU7XG59O1xuXG5leHBvcnQgdHlwZSBFbnVtRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcImVudW1cIj4gJiB7XG4gIG9wdGlvbmFsOiBib29sZWFuO1xuICBkZWZhdWx0X3ZhbHVlPzogc3RyaW5nO1xuICBlbnVtX3ZhbHVlczogc3RyaW5nW107XG59O1xuXG5leHBvcnQgdHlwZSBCb29sRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcImJvb2xcIj4gJiB7XG4gIG9wdGlvbmFsOiBib29sZWFuO1xuICBkZWZhdWx0X3ZhbHVlPzogYm9vbGVhbjtcbn07XG5cbmV4cG9ydCB0eXBlIER1cmF0aW9uRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcImludCBkdXJhdGlvblwiIHwgXCJmbG9hdCBkdXJhdGlvblwiPiAmIHtcbiAgbWluOiBudW1iZXI7XG4gIG1heDogbnVtYmVyO1xuICBvcHRpb25hbDogYm9vbGVhbjtcbiAgZGVmYXVsdF92YWx1ZT86IG51bWJlcjtcbn07XG5cbmV4cG9ydCB0eXBlIFRpbWVjb2RlRGVzY3JpcHRpb24gPSBDb21tb25Ob2RlUHJvcGVydGllczxcInRpbWVjb2RlXCI+ICYge1xuICBvcHRpb25hbDogYm9vbGVhbjtcbiAgZGVmYXVsdF92YWx1ZT86IG51bWJlcjtcbn07XG5cbmV4cG9ydCB0eXBlIFRpbWVzdGFtcERlc2NyaXB0aW9uID0gQ29tbW9uTm9kZVByb3BlcnRpZXM8XCJ0aW1lc3RhbXBcIj4gJiB7XG4gIG1pbj86IG51bWJlcjtcbiAgbWF4PzogbnVtYmVyO1xuICBvcHRpb25hbDogYm9vbGVhbjtcbiAgZGVmYXVsdF92YWx1ZT86IHN0cmluZztcbn07XG5cbmV4cG9ydCB0eXBlIElQQWRkcmVzc0Rlc2NyaXB0aW9uID0gQ29tbW9uTm9kZVByb3BlcnRpZXM8XCJpcGFkZHJlc3NcIj4gJiB7XG4gIG9wdGlvbmFsOiBib29sZWFuO1xuICBkZWZhdWx0X3ZhbHVlPzogc3RyaW5nO1xufTtcblxuZXhwb3J0IHR5cGUgQ29tcG9uZW50RGVzY3JpcHRpb248U3RhZ2UgZXh0ZW5kcyBcInJhd1wiPiA9IFN1YnRyZWVEZXNjcmlwdGlvbjxTdGFnZT4gJiB7XG4gIHVhX25hbWU6IHN0cmluZztcbiAgb3duaW5nX21vZHVsZTogc3RyaW5nO1xuICBib3VuZF90bz86IHN0cmluZ1tdO1xufSAmIChTdGFnZSBleHRlbmRzIFwiYW5ub3RhdGVkXCIgPyB7IGV4aXN0czogYm9vbGVhbiB9IDoge30pO1xuXG4vLyBGSVhNRTogc2hvdWxkIGJldHRlciBiZSBjYWxsZWQgc2NhbGFyIGRlc2NyaXB0aW9uP1xuXG5leHBvcnQgdHlwZSBBdG9taWNGaWVsZERlc2NyaXB0aW9uPFN0YWdlIGV4dGVuZHMgXCJyYXdcIj4gPSAoXG4gIHwgVGltZXN0YW1wRGVzY3JpcHRpb25cbiAgfCBJUEFkZHJlc3NEZXNjcmlwdGlvblxuICB8IEJvb2xEZXNjcmlwdGlvblxuICB8IEVudW1EZXNjcmlwdGlvblxuICB8IFN0cmluZ0Rlc2NyaXB0aW9uXG4gIHwgTnVtYmVyRGVzY3JpcHRpb25cbiAgfCBEZXZpY2VUcmVlTm9kZURlc2NyaXB0aW9uXG4gIHwgUmVmZXJlbmNlRGVzY3JpcHRpb25cbiAgfCBEdXJhdGlvbkRlc2NyaXB0aW9uXG4gIHwgVGltZWNvZGVEZXNjcmlwdGlvblxuICB8IEF0b21pY1N1YnRyZWVEZXNjcmlwdGlvbjxTdGFnZT5cbikgJlxuICAoU3RhZ2UgZXh0ZW5kcyBcInJhd1wiXG4gICAgPyB7fVxuICAgIDoge1xuICAgICAgICBoYXNfaW5kZXg6IGJvb2xlYW47XG4gICAgICAgIGxvY2FsX211bHRpcGxpY2l0eTogbnVtYmVyO1xuICAgICAgfSkgJlxuICBTY2FsYXJNdWx0aXBsaWNpdHlQcm9wZXJ0aWVzPFN0YWdlPjtcblxuZXhwb3J0IHR5cGUgU3VidHJlZUNoaWxkRGVzY3JpcHRpb248U3RhZ2UgZXh0ZW5kcyBcInJhd1wiPiA9IFN1YnRyZWVEZXNjcmlwdGlvbjxTdGFnZT4gJlxuICBTdWJ0cmVlTXVsdGlwbGljaXR5UHJvcGVydGllczxTdGFnZT47XG5cbmV4cG9ydCB0eXBlIENoaWxkRGVzY3JpcHRpb248U3RhZ2UgZXh0ZW5kcyBcInJhd1wiPiA9XG4gIHwgU3VidHJlZUNoaWxkRGVzY3JpcHRpb248U3RhZ2U+XG4gIHwgS2V5d29yZERlc2NyaXB0aW9uPFN0YWdlPjtcblxuZXhwb3J0IGludGVyZmFjZSBFcnJvckZlZWRiYWNrQ2hhbm5lbCB7XG4gIGt3bDogc3RyaW5nO1xuICBvd25lcjogc3RyaW5nO1xufVxuXG5leHBvcnQgdHlwZSBTdWJ0cmVlVHlwZWRlZjxTdGFnZSBleHRlbmRzIFwicmF3XCI+ID0gT21pdDxcbiAgU3VidHJlZURlc2NyaXB0aW9uPFN0YWdlPixcbiAgXCJzdGFydGluZ19pbmRleFwiIHwgXCJzdHJpZGVcIlxuPjtcblxuZXhwb3J0IHR5cGUgVHlwZWRlZjxTdGFnZSBleHRlbmRzIFwicmF3XCI+ID0gKFxuICB8IFN1YnRyZWVUeXBlZGVmPFN0YWdlPlxuICB8IEF0b21pY0ZpZWxkRGVzY3JpcHRpb248U3RhZ2U+XG4pICYge1xuICBjb21tb246IGJvb2xlYW47XG59O1xuXG5leHBvcnQgaW50ZXJmYWNlIFNjaGVtYTxTdGFnZSBleHRlbmRzIFwicmF3XCI+IHtcbiAgY29uc3RhbnRzOiBDb25zdGFudHNEaWN0aW9uYXJ5O1xuICBlcnJvcl9mZWVkYmFja19jaGFubmVsczogRXJyb3JGZWVkYmFja0NoYW5uZWxbXTtcbiAgdHlwZWRlZl9pZGVudGlmaWVyczogc3RyaW5nW107XG4gIHR5cGVkZWZzOiB7XG4gICAgW3R5cGVkZWZfbmFtZTogc3RyaW5nXTogVHlwZWRlZjxTdGFnZT47XG4gIH07XG4gIGtleXdvcmRzOiBDb21wb25lbnREZXNjcmlwdGlvbjxTdGFnZT5bXTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNoaWxkcmVuX29mX3Jhd19zdWJ0cmVlKFxuICBzY2hlbWE6IFNjaGVtYTxcInJhd1wiPixcbiAgc3Q6IFN1YnRyZWVEZXNjcmlwdGlvbjxcInJhd1wiPlxuKTogQ2hpbGREZXNjcmlwdGlvbjxcInJhd1wiPltdIHtcbiAgaWYgKFwiY2hpbGRyZW5cIiBpbiBzdCkge1xuICAgIHJldHVybiBzdC5jaGlsZHJlbiE7XG4gIH0gZWxzZSB7XG4gICAgZW5mb3JjZShzdC50eXBlX2lkZW50aWZpZXIgIT09IHVuZGVmaW5lZCk7XG4gICAgY29uc3QgdGQgPSBzY2hlbWEudHlwZWRlZnNbc3QudHlwZV9pZGVudGlmaWVyIV0gYXMgU3VidHJlZURlc2NyaXB0aW9uPFwicmF3XCI+O1xuICAgIGVuZm9yY2UodGQuZGF0YV90eXBlID09PSBcInN1YnRyZWVcIik7XG4gICAgaWYgKFwiY2hpbGRyZW5cIiBpbiB0ZCkge1xuICAgICAgcmV0dXJuIHRkLmNoaWxkcmVuITtcbiAgICB9IGVsc2Uge1xuICAgICAgZW5mb3JjZShmYWxzZSk7XG4gICAgICByZXR1cm4gW107XG4gICAgfVxuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjaGlsZHJlbl9vZl9yYXdfYXRvbWljX3N1YnRyZWUoXG4gIHNjaGVtYTogU2NoZW1hPFwicmF3XCI+LFxuICBzdDogQXRvbWljU3VidHJlZURlc2NyaXB0aW9uPFwicmF3XCI+XG4pOiBBdG9taWNGaWVsZERlc2NyaXB0aW9uPFwicmF3XCI+W10ge1xuICBpZiAoXCJjaGlsZHJlblwiIGluIHN0KSB7XG4gICAgcmV0dXJuIHN0LmNoaWxkcmVuITtcbiAgfSBlbHNlIHtcbiAgICBlbmZvcmNlKHN0LnR5cGVfaWRlbnRpZmllciAhPT0gdW5kZWZpbmVkKTtcbiAgICBjb25zdCB0ZCA9IHNjaGVtYS50eXBlZGVmc1tzdC50eXBlX2lkZW50aWZpZXIhXTtcbiAgICBpZiAodGQuZGF0YV90eXBlID09PSBcImF0b21pYyBzdWJ0cmVlXCIgJiYgXCJjaGlsZHJlblwiIGluIHRkKSB7XG4gICAgICByZXR1cm4gdGQuY2hpbGRyZW4hO1xuICAgIH0gZWxzZSB7XG4gICAgICBlbmZvcmNlKGZhbHNlKTtcbiAgICAgIHJldHVybiBbXTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==
