import {
	BranchName,
	CommonKeywordProperties,
	ConstantsDictionary,
	ElementCount,
	KeywordPayload,
	KWLName,
	SubtreeMultiplicityProperties,
	SysName,
} from "./pervasives.js";
export type OtherNodeProperties = {
	formatter?: string;
	filter?: string;
	visibility?: "basic" | "advanced" | "developer";
	unit?: string;
};
export interface CommonNodeProperties<DataType> {
	data_type: DataType;
	sys_name: SysName;
	brief?: string;
	desc?: string;
	other_properties?: OtherNodeProperties;
	type_identifier?: string;
}
export type KeywordDescription<Stage extends "raw" | "annotated"> =
	Stage extends "raw"
		? AtomicFieldDescription<"raw"> & CommonKeywordProperties<"raw">
		: {
				container_type: ContainerType.Keyword;
				contents: AtomicFieldDescription<"annotated">;
				parent: SubtreeDescription<"annotated">;
			} & CommonKeywordProperties<"annotated">;
export type AtomicMultiplicityLayer =
	| {
			type: "optional";
	  }
	| {
			type: "vector";
			capacity: ElementCount<"raw">;
	  }
	| {
			type: "array";
			capacity: ElementCount<"raw">;
	  };
export type AtomicMultiplicity = AtomicMultiplicityLayer[];
export declare const enum ContainerType {
	None = 0,
	Table = 1,
	Array = 2,
	Vector = 3,
	Keyword = 4,
	Component = 5,
}
export interface TableContainer {
	container_type: ContainerType.Table;
	named_tables: boolean;
	capacity: number;
	contents: SubtreeDescription<"annotated">;
	parent: ComponentDescription<"annotated"> | SubtreeDescription<"annotated">;
}
export interface AtomicArrayContainer {
	container_type: ContainerType.Array;
	capacity: number;
	contents: AtomicFieldDescription<"annotated">;
	parent: ParentOfAtomic;
	optional: boolean;
}
export interface SubtreeArrayContainer {
	container_type: ContainerType.Array;
	capacity: number;
	contents: SubtreeDescription<"annotated">;
	parent: SubtreeDescription<"annotated">;
}
export interface VectorContainer<ContentType> {
	container_type: ContainerType.Vector;
	capacity: number;
	contents: ContentType;
	parent: ParentOfAtomic;
	optional: boolean;
}
type ParentOfSubtree =
	| SubtreeArrayContainer
	| ComponentDescription<"annotated">
	| SubtreeDescription<"annotated">
	| TableContainer;
export type SubtreeDescription<Stage extends "raw" | "annotated"> =
	CommonNodeProperties<"subtree"> &
		(Stage extends "raw"
			? {
					children?: Array<ChildDescription<Stage>>;
				} & SubtreeMultiplicityProperties<Stage>
			: {
					container_type: ContainerType.None;
					children: Array<ChildDescription<Stage>>;
					type_identifier?: string;
					parent: ParentOfSubtree;
				});
export type AtomicSubtreeDescription<Stage extends "raw" | "annotated"> =
	CommonNodeProperties<"atomic subtree"> &
		(Stage extends "raw"
			? {
					children?: AtomicFieldDescription<Stage>[];
				}
			: {
					container_type: ContainerType.None;
					optional: boolean;
					children: AtomicFieldDescription<Stage>[];
					parent: ParentOfAtomic;
				});
export type StringDescription = CommonNodeProperties<"string"> & {
	max_length: number;
	default_value?: string;
};
export type NumberDescription<Stage extends "raw" | "annotated"> =
	CommonNodeProperties<"int" | "float"> & {
		min: number;
		max: number;
		default_value?: number;
	} & (Stage extends "raw"
			? {}
			: {
					unit: null | UnitDefinition<"annotated">;
				});
export type DeviceTreeNodeDescription =
	CommonNodeProperties<"device_tree_node">;
export type ReferenceDescription<Stage extends "raw" | "annotated"> =
	CommonNodeProperties<"ref"> & {
		default_value?: string;
		target_type_identifier: string;
		target_type: "subtree";
		ref_perm: "mutating" | "non-mutating";
		refined_to?: SysName;
	} & (Stage extends "raw"
			? {}
			: {
					container_type: ContainerType.None;
					optional: boolean;
					parent: ParentOfAtomic;
				});
export type VariantDescription<Stage extends "raw" | "annotated"> =
	CommonNodeProperties<"variant"> & {
		default_value?: [constructor_index: number, payload: KeywordPayload];
		target_type_identifier: string;
	} & (Stage extends "raw"
			? {
					variants?: Array<
						[constructor_name: string, desc: AtomicFieldDescription<Stage>]
					>;
				}
			: {
					container_type: ContainerType.None;
					optional: boolean;
					variants: Array<
						[constructor_name: string, desc: AtomicFieldDescription<Stage>]
					>;
					parent: ParentOfAtomic;
				});
export type EnumDescription = CommonNodeProperties<"enum"> & {
	default_value?: string;
	enum_values: string[];
};
export type Severity =
	| "Emergency"
	| "Alert"
	| "Critical"
	| "Error"
	| "Warning"
	| "Notice"
	| "Info"
	| "Debug";
export interface AlertDescription {
	name: string;
	severity: Severity;
	brief?: string;
	desc?: string;
}
export type AlertsDescription = CommonNodeProperties<"alerts"> & {
	alerts: AlertDescription[];
};
export type BoolDescription = CommonNodeProperties<"bool"> & {
	default_value?: boolean;
};
export type DurationDescription = CommonNodeProperties<
	"int duration" | "float duration"
> & {
	min: number;
	max: number;
	default_value?: number;
};
export type TimecodeDescription = CommonNodeProperties<"timecode"> & {
	default_value?: number;
};
export type TimestampDescription = CommonNodeProperties<"timestamp"> & {
	min?: number;
	max?: number;
	default_value?: string;
};
export type IPAddressDescription = CommonNodeProperties<"ipaddress"> & {
	default_value?: string;
};
export type ComponentDescription<Stage extends "raw" | "annotated"> =
	Stage extends "raw"
		? SubtreeDescription<"raw"> & {
				ua_name: string;
				owning_module: string;
				bound_to?: string[];
			}
		: {
				container_type: ContainerType.Component;
				bound_to: string[];
				contents: SubtreeDescription<"annotated">;
				enabled: boolean;
				owning_module: string;
				ua_name: string;
			};
export type SimpleAtomicDescription<Stage extends "raw" | "annotated"> = (
	| TimestampDescription
	| IPAddressDescription
	| BoolDescription
	| EnumDescription
	| StringDescription
	| NumberDescription<Stage>
	| DeviceTreeNodeDescription
	| DurationDescription
	| TimecodeDescription
	| AlertsDescription
) &
	(Stage extends "raw"
		? {}
		: {
				container_type: ContainerType.None;
				optional: boolean;
				parent: ParentOfAtomic;
			});
type ParentOfAtomic =
	| AtomicArrayContainer
	| VectorContainer<AtomicFieldDescription<"annotated">>
	| AtomicSubtreeDescription<"annotated">
	| VariantDescription<"annotated">
	| KeywordDescription<"annotated">;
export type AtomicFieldKernel<Stage extends "raw" | "annotated"> =
	| SimpleAtomicDescription<Stage>
	| AtomicSubtreeDescription<Stage>
	| VariantDescription<Stage>
	| ReferenceDescription<Stage>;
export type AtomicFieldDescription<Stage extends "raw" | "annotated"> =
	Stage extends "raw"
		? {
				atomic_multiplicity: AtomicMultiplicity;
			} & AtomicFieldKernel<"raw">
		:
				| AtomicArrayContainer
				| VectorContainer<AtomicFieldDescription<"annotated">>
				| AtomicFieldKernel<"annotated">;
export type ContainerizedSubtreeDescription<Stage extends "raw" | "annotated"> =
	Stage extends "raw"
		? SubtreeDescription<"raw"> & SubtreeMultiplicityProperties<"raw">
		: TableContainer | SubtreeArrayContainer | SubtreeDescription<"annotated">;
export type ChildDescription<Stage extends "raw" | "annotated"> =
	| ContainerizedSubtreeDescription<Stage>
	| KeywordDescription<Stage>;
export interface ErrorFeedbackChannel {
	kwl: KWLName<"full">;
	owner: string;
}
export type Typedef<Stage extends "raw" | "annotated"> = (
	| Omit<ContainerizedSubtreeDescription<Stage>, "parent">
	| Omit<AtomicFieldDescription<Stage>, "parent">
) & {
	common: boolean;
};
export type UnitDefinition<Stage extends "raw" | "annotated"> = {
	scale: Array<[number, string]>;
	exceptions: Array<[number, string]>;
} & (Stage extends "raw"
	? {}
	: {
			exceptions_map: Map<number, string>;
		});
type Units<Stage extends "raw" | "annotated"> = Record<
	string,
	UnitDefinition<Stage>
>;
export interface Schema<Stage extends "raw" | "annotated"> {
	versions: {
		format: 2;
	};
	constants: ConstantsDictionary;
	error_feedback_channels: ErrorFeedbackChannel[];
	typedef_identifiers: string[];
	typedefs: {
		[typedef_name: string]: Typedef<Stage>;
	};
	keywords: ComponentDescription<Stage>[];
	units?: Units<Stage>;
}
export declare function children_of_raw_subtree(
	schema: Schema<"raw">,
	st: SubtreeDescription<"raw">,
): ChildDescription<"raw">[];
export declare function children_of_raw_atomic_subtree(
	schema: Schema<"raw">,
	st: AtomicSubtreeDescription<"raw">,
): AtomicFieldDescription<"raw">[];
export declare function annotate(
	schema: Schema<"raw">,
	disabledComponents: Set<SysName>,
	constants_resolver: (constant_name: string) => number | boolean,
): Schema<"annotated">;
export declare function kernel_of_child(
	c: ChildDescription<"annotated">,
): SubtreeDescription<"annotated"> | AtomicFieldKernel<"annotated">;
export declare function kernel_of_field(
	f: AtomicFieldDescription<"annotated">,
): AtomicFieldKernel<"annotated">;
export declare function find_branch(
	annotated_schema: Schema<"annotated">,
	branch_name: BranchName,
): ChildDescription<"annotated">;
export declare function find_keyword(
	annotated_schema: Schema<"annotated">,
	branch_name: BranchName,
	kw_name: string,
): KeywordDescription<"annotated">;
export declare function find_subtree_within(
	desc: SubtreeDescription<"annotated">,
	relative_kwl: KWLName<"relative">,
): ContainerizedSubtreeDescription<"annotated"> | undefined;
export {};
