export class SoftwareVersion {
	major;
	minor;
	patch;
	branch;
	commit;
	constructor(major, minor, patch, branch, commit) {
		this.major = major;
		this.minor = minor;
		this.patch = patch;
		this.branch = branch;
		this.commit = commit;
	}
	static from_string(swv) {
		const m = swv.match(/^([0-9]+)\.([0-9]+)(\.([^_]+))?$/);
		if (m !== null) {
			return new SoftwareVersion(
				parseInt(m[1]),
				parseInt(m[2]),
				m.length > 4 ? parseInt(m[4]) : 0,
				"stable",
			);
		} else {
			const m = swv.match(/^([0-9]+)\.([0-9]+)\.([0-9]+)_([^_]+)/);
			if (m === null) {
				throw new Error(
					`Unable to interpret ${swv} as a software version string`,
				);
			}
			return new SoftwareVersion(
				parseInt(m[1]),
				parseInt(m[2]),
				parseInt(m[3]),
				m[4],
			);
		}
	}
	to_string() {
		const prefix = `${this.major}.${this.minor}.${this.patch}`;
		if (this.branch === "stable") {
			return prefix;
		}
		return `${prefix}_${this.branch}`;
	}
	is_atleast(other) {
		const res = this.compare(
			typeof other === "string" ? SoftwareVersion.from_string(other) : other,
		);
		return res >= 0;
	}
	compare(other) {
		if (this.major > other.major) {
			return 1;
		} else if (this.major < other.major) {
			return -1;
		}
		if (this.minor > other.minor) {
			return 1;
		} else if (this.minor < other.minor) {
			return -1;
		}
		if (this.patch > other.patch) {
			return 1;
		} else if (this.patch < other.patch) {
			return -1;
		}
		if (other.commit === undefined) {
			if (this.commit === undefined) {
				return 0;
			}
			return 1;
		}
		if (this.commit === undefined) {
			return -1;
		}
		if (this.commit > other.commit) {
			return 1;
		} else if (this.commit < other.commit) {
			return -1;
		}
		return 0;
	}
}
//# sourceMappingURL=data:application/json;base64,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
