import { BranchName } from "./pervasives.js";
import { UnitDefinition } from "./schema_v2.js";
import { Duration } from "./time.js";
export * from "./asserts.js";
/**
 * pauses for <seconds> seconds. Example: await pause(2)
 */
export declare function pause(t: Duration): Promise<void>;
export declare function path_hd<S extends string>(path: S): S;
export declare function path_tl<S extends string>(path: S): S;
export declare function path_to_branch<S extends string>(path: S): BranchName;
export declare function path_strip_trailing_index<S extends string>(path: S): S;
export declare function path_index(path: string): number | undefined;
export declare function path_compare(a: string, b: string): number;
export declare function snake_case(s: string): string;
export declare class WorkQueue {
	private num_workers;
	private num_running;
	private todo;
	private finalizers;
	private thrown_exceptions;
	private m_waiting;
	constructor(pars: {
		num_workers: number;
		start_immediately?: boolean;
	});
	get size(): number;
	get stats(): {
		waiting: number;
		running: number;
	};
	private tick;
	start(): void;
	idle(): boolean;
	push(f: () => Promise<void>): void;
	clear(): void;
	drain(): Promise<void>;
}
export type Tagged<T, _Tag extends string> = T;
export declare function poll(
	criterion: () => Promise<boolean>,
	pars?: {
		timeout?: Duration;
		interval?: Duration;
	},
): Promise<void>;
export declare function asyncFilter<Ts extends any[]>(
	xs: Ts,
	f: (el: Ts[0]) => Promise<boolean>,
	pars?: {
		num_workers?: number;
	},
): Promise<Ts>;
export declare function asyncFilterMap<Ts extends any[], S>(
	xs: Ts,
	f: (el: Ts[0]) => Promise<S | undefined>,
	pars?: {
		num_workers?: number;
	},
): Promise<S[]>;
export declare function asyncMap<Ts extends any[], S>(
	xs: Ts,
	f: (x: Ts[0], index: number) => Promise<S>,
	pars?: {
		num_workers?: number;
	},
): Promise<S[]>;
export declare function poll_until<T = undefined>(
	f: () => Promise<
		| {
				satisfied: true;
				result?: T;
		  }
		| {
				satisfied: false;
		  }
	>,
	pars: {
		timeout: Duration;
		pollInterval?: Duration;
	},
): Promise<T | undefined>;
export declare function asyncFind<Ts extends any[]>(
	xs: Ts,
	criterion: (x: Ts[0]) => Promise<boolean>,
): Promise<Ts[0] | undefined>;
export declare function asyncGet<Ts extends any[]>(
	xs: Ts,
	criterion: (x: Ts[0]) => Promise<boolean>,
): Promise<Ts[0]>;
export declare function asyncFindMap<Ts extends any[], S>(
	xs: Ts,
	f: (x: Ts[0]) => Promise<S | undefined>,
): Promise<S | undefined>;
export declare function asyncGetMap<Ts extends any[], S>(
	xs: Ts,
	f: (x: Ts[0]) => Promise<S | undefined>,
): Promise<S>;
export declare function asyncIter<Ts extends any[]>(
	things: Ts,
	f: (x: Ts[0], i: number) => Promise<void>,
	opts?: {
		num_workers: number;
	},
): Promise<void>;
export declare function asyncZip<Lefts extends any[], Rights extends any[]>(
	left_things: Lefts,
	right_things: Rights,
	f: (lhs: Lefts[0], rhs: Rights[0], i: number) => Promise<void>,
	opts?: {
		num_workers: number;
	},
): Promise<void>;
export interface MachineAddress {
	ip: string;
	protocol: "ws" | "wss";
}
export declare function parse_machine_address(str: string): MachineAddress;
export declare function numstring_with_precision(
	payload: number,
	precision: number,
	force_precise: boolean,
): string;
export declare function scale_format(
	payload: number,
	scale: Array<[number, string]>,
	precision: number,
): string;
export declare function format_with_unit(
	payload: number,
	unit: UnitDefinition<"annotated">,
	precision: number,
): string;
export declare function addrs_equal_up_to_port(pars: {
	command: string | null;
	status: string | null;
}): boolean;
